use inc::Module::Install;
use File::Spec;

{
    my $file = File::Spec->catfile('xs', 'const-xs.inc');
    write_constants_file( $file ) if ! -f $file;
}

{
    my $file = File::Spec->catfile('xs', 'typemap');
    write_typemap( $file ) if ! -f $file;
}

name 'ZeroMQ';
all_from 'lib/ZeroMQ.pm';

test_requires 'Test::Requires';
recommends 'JSON' => '2.00';

use_ppport;
cc_warnings;
cc_libs 'zmq';
cc_assert_lib 'zmq';
cc_src_paths 'xs';

author_tests 'xt';
WriteAll;

sub write_constants_file {
    my $file = shift;

    my $header = $ENV{ZMQ_H} || '/usr/local/include/zmq.h';

    open( my $in, '<', $header ) or
        die "Could not open file $header for reading: $!";

    open( my $out, '>', $file ) or
        die "Could not open file $file for writing: $!";
    print $out
        "# Do NOT edit this file! This file was automatically generated\n",
        "# by Makefile.PL on @{[scalar localtime]}. If you want to\n",
        "# regenerate it, remove this file and re-run Makefile.PL\n",
        "\n",
        "IV\n",
        "_constant()\n",
        "    ALIAS:\n",
    ;


    while (my $ln = <$in>) {
        if ($ln =~ /^\#define\s+(ZMQ_\S+)\s+/) {
            print $out "        $1 = $1\n";
        }
    }
    close $in;
    print $out
        "    CODE:\n",
        "        RETVAL = ix;\n",
        "    OUTPUT:\n",
        "        RETVAL\n"
    ;
    close $out;
}

sub write_typemap {
    my $file = shift;

    my @typemap = (
        [ 'T_PERLZMQ_CONTEXT', 'PerlZMQ_Context', 'ZeroMQ::Context' ],
        [ 'T_PERLZMQ_SOCKET', 'PerlZMQ_Socket', 'ZeroMQ::Socket' ],
        [ 'T_PERLZMQ_MESSAGE', 'PerlZMQ_Message', 'ZeroMQ::Message' ],
    );

    open( my $out, '>', $file ) or
        die "Could not open $file for writing: $!";

    my (@decl, @input, @output);
    foreach my $map (@typemap) {
        push @decl, "$map->[1]* $map->[0]";
        push @input, <<EOM;
$map->[0]
    {
        MAGIC *mg;
        \$var = NULL;
        if (sv_isobject(\$arg)) {
            mg = $map->[1]_mg_find(aTHX_ SvRV(\$arg), &$map->[1]_vtbl);
            if (mg) {
                \$var = ($map->[1] *) mg->mg_ptr;
            }
        }

        if (\$var == NULL)
            croak(\\"Invalid $map->[2] object (perhaps you've already closed it?)\\");
    }
EOM
        push @output, <<EOM;
$map->[0]
        if (!\$var)          /* if null */
            SvOK_off(\$arg); /* then return as undef instead of reaf to undef */
        else {
            /* setup \$arg as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = \\"$map->[2]\\";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);

            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }

            sv_setsv(\$arg, sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(\$arg, gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &$map->[1]_vtbl, (char*) \$var, 0);
            mg->mg_flags |= MGf_DUP;
        }
EOM
    }

    print $out
        "# Do NOT edit this file! This file was automatically generated\n",
        "# by Makefile.PL on @{[scalar localtime]}. If you want to\n",
        "# regenerate it, remove this file and re-run Makefile.PL\n",
        "\n"
    ;
    print $out join( "\n",
        "TYPEMAP\n",
        join("\n", @decl), 
        "\n",
        "INPUT\n",
        join("\n", @input),
        "\n",
        "OUTPUT\n",
        join("\n", @output),
        "\n",
    );

    close $out;
}