package Locales::DB::Language::kn;

# Auto generated from CLDR

$Locales::DB::Language::kn::VERSION = '0.07';

$Locales::DB::Language::kn::cldr_version = '2.0';

%Locales::DB::Language::kn::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ ಮತ್ತು\ \{1\}",
            'end'    => "\{0\}\,\ ಮತ್ತು\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "ಇಲ್ಲ\:ಇ",
        'yesstr' => "ಹೌದು\:ಹೌ"
    },
);

%Locales::DB::Language::kn::code_to_name = (
    'aa'    => 'ಅಫಾರ್',
    'ab'    => 'ಅಬ್ಖಾಜಿಯನ್',
    'ace'   => 'ಅಛಿನೀಸ್',
    'ach'   => 'ಅಕೋಲಿ',
    'ada'   => 'ಅಡಂಗ್‌ಮೆ',
    'ady'   => 'ಅಡೈಘೆ',
    'ae'    => 'ಅವೆಸ್ಟನ್',
    'af'    => 'ಆಫ್ರಿಕಾನ್ಸ್',
    'afa'   => "ಆಫ್ರೋ\-ಏಶಿಯಾಟಿಕ್\ ಭಾಷೆ",
    'afh'   => 'ಆಫ್ರಿಹಿಲಿ',
    'agq'   => 'Aghem',
    'ain'   => 'ಐನು',
    'ak'    => 'ಅಕನ್',
    'akk'   => 'ಅಕ್ಕಾಡಿಯನ್',
    'ale'   => 'ಅಲೆಯುಟ್',
    'alg'   => "ಅಲ್ಗೊಂಕ್ವಿಯನ್\ ಭಾಷೆ",
    'alt'   => "ದಕ್ಷಿಣ\ ಅಲ್ಟಾಯ್",
    'am'    => 'ಅಂಹರಿಕ್',
    'an'    => 'ಅರಗೊನೀಸ್',
    'ang'   => "ಪ್ರಾಚೀನ\ ಇಂಗ್ಲೀಷ್",
    'anp'   => 'ಆಂಗಿಕಾ',
    'apa'   => "ಅಪಾಚಿ\ ಭಾಷೆ",
    'ar'    => 'ಅರೇಬಿಕ್',
    'arc'   => 'ಅರಾಮಿಕ್',
    'arn'   => 'ಅರೌಕೇನಿಯನ್',
    'arp'   => 'ಅರಪಾಹೋ',
    'art'   => "ಕೃತಕ\ ಭಾಷೆ",
    'arw'   => 'ಅರಾವಾಕ್',
    'as'    => 'ಅಸ್ಸಾಮೀಸ್',
    'asa'   => 'Asu',
    'ast'   => 'ಆಸ್ಟುರಿಯನ್',
    'ath'   => "ಅಥಪಾಸ್ಕನ್\ ಭಾಷೆ",
    'aus'   => "ಆಸ್ಟ್ರೇಲಿಯನ್\ ಭಾಷೆ",
    'av'    => 'ಅವರಿಕ್',
    'awa'   => 'ಅವಧಿ',
    'ay'    => 'ಅಯ್ಮಾರಾ',
    'az'    => 'ಅಝೆರಿ',
    'ba'    => 'ಬಶ್ಕಿರ್',
    'bad'   => 'ಬಾಂಡಾ',
    'bai'   => "ಬಮಿಲೇಕೆ\ ಭಾಷೆ",
    'bal'   => 'ಬಲೂಚಿ',
    'ban'   => 'ಬಲಿನೀಸ್',
    'bas'   => 'ಬಸಾ',
    'bat'   => "ಬಾಲ್ಟಿಕ್\ ಭಾಷೆ",
    'be'    => 'ಬೆಲರೂಸಿಯನ್',
    'bej'   => 'ಬೇಜಾ',
    'bem'   => 'ಬೆಂಬಾ',
    'ber'   => 'ಬೆರ್ಬರ್',
    'bez'   => 'Bena',
    'bg'    => 'ಬಲ್ಗೇರಿಯನ್',
    'bh'    => 'ಬಿಹಾರಿ',
    'bho'   => 'ಭೋಜಪುರಿ',
    'bi'    => 'ಬಿಸ್ಲಾಮಾ',
    'bik'   => 'ಬಿಕೊಲ್',
    'bin'   => 'ಬಿನಿ',
    'bla'   => 'ಸಿಕ್ಸಿಕಾ',
    'bm'    => 'ಬಂಬಾರಾ',
    'bn'    => 'ಬೆಂಗಾಲಿ',
    'bnt'   => 'ಬಂಟು',
    'bo'    => 'ಟಿಬೇಟಿಯನ್',
    'br'    => 'ಬ್ರೆಟನ್',
    'bra'   => 'ಬ್ರಾಜ್',
    'brx'   => 'Bodo',
    'bs'    => 'ಬೋಸ್ನಿಯನ್',
    'btk'   => 'ಬಟಾಕ್',
    'bua'   => 'ಬುರಿಯಟ್',
    'bug'   => 'ಬುಗಿನೀಸ್',
    'byn'   => 'ಬ್ಲಿನ್',
    'ca'    => 'ಕೆಟಲಾನ್',
    'cad'   => 'ಕ್ಯಾಡ್ಡೋ',
    'cai'   => "ಮಧ್ಯ\ ಅಮೇರಿಕನ್\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'car'   => 'ಕಾರಿಬ್',
    'cau'   => "ಕಕೇಶಿಯನ್\ ಭಾಷೆ",
    'cay'   => 'Cayuga',
    'cch'   => 'ಅಟ್ಸಮ್',
    'ce'    => 'ಚೆಚನ್',
    'ceb'   => 'ಸೆಬುಆನೋ',
    'cel'   => "ಸೆಲ್ಟಿಕ್\ ಭಾಷೆ",
    'cgg'   => 'Chiga',
    'ch'    => 'ಕಮೊರೊ',
    'chb'   => 'ಚಿಬ್ಚಾ',
    'chg'   => 'ಚಗಟಾಯ್',
    'chk'   => 'ಚೂಕಿಸೆ',
    'chm'   => 'ಮಾರಿ',
    'chn'   => "ಚಿನೂಕ್\ ಜಾರ್ಗೋನ್",
    'cho'   => 'ಚೋಕ್ಟಾವ್',
    'chp'   => 'ಚಿಪೆವ್ಯಾನ್',
    'chr'   => 'ಚೀರೋಕೀ',
    'chy'   => 'ಚೀಯೆನ್ನೇ',
    'cmc'   => "ಚಾಮಿಕ್\ ಭಾಷೆ",
    'co'    => 'ಕೊರ್ಸಿಕನ್',
    'cop'   => 'ಕೊಪ್ಟಿಕ್',
    'cpe'   => "ಇಂಗ್ಲೀಷ್\-ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cpf'   => "ಫ್ರೆಂಚ್\-ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cpp'   => "ಪೋರ್ಚುಗೀಸ್\-\ ಮೂಲದ\ ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cr'    => 'ಕ್ರೀ',
    'crh'   => "ಕ್ರಿಮೀಯನ್\ ಟರ್ಕಿಷ್",
    'crp'   => "ಕ್ರಿಯೋಲ್\ ಅಥವಾ\ ಪಿಡ್ಗಿನ್",
    'cs'    => 'ಜೆಕ್',
    'csb'   => 'ಕಶುಬಿಯನ್',
    'cu'    => "ಚರ್ಚ್\ ಸ್ಲಾವಿಕ್",
    'cus'   => "ಕುಷಿಟಿಕ್\ ಭಾಷೆ",
    'cv'    => 'ಚುವಾಶ್',
    'cy'    => 'ವೆಲ್ಶ್',
    'da'    => 'ಡ್ಯಾನಿಶ್',
    'dak'   => 'ಡಕೋಟ',
    'dar'   => 'ದರ್ಗ್ವಾ',
    'dav'   => 'Taita',
    'day'   => 'ದಾಯಕ್',
    'de'    => 'ಜರ್ಮನ್',
    'de_at' => "ಆಸ್ಟ್ರಿಯನ್‌‌ನ\ ಜರ್ಮನ್‌",
    'de_ch' => "ಸ್ವಿಸ್\ ಹೈ\ ಜರ್ಮನ್",
    'del'   => 'ಡೆಲಾವೇರ್',
    'den'   => 'ಸ್ಲೇವ್',
    'dgr'   => 'ಡೋಗ್ರಿಬ್',
    'din'   => 'ಡಿಂಕಾ',
    'dje'   => 'Zarma',
    'doi'   => 'ಡೋಗ್ರಿ',
    'dra'   => "ಡ್ರಾವಿಡಿಯನ್\ ಭಾಷೆ",
    'dsb'   => "ಲೋವರ್\ ಸೋರ್ಬಿಯನ್",
    'dua'   => 'ಡುವಾಲಾ',
    'dum'   => "ಮಧ್ಯ\ ಡಚ್",
    'dv'    => 'ದಿವೆಹಿ',
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'ಡ್ಯೂಲಾ',
    'dz'    => 'ಜೋಂಗ್‌ಖಾ',
    'ebu'   => 'Embu',
    'ee'    => 'ಏವ್',
    'efi'   => 'ಎಫಿಕ್',
    'egy'   => "ಪ್ರಾಚೀನ\ ಈಜಿಪ್ಟಿಯನ್",
    'eka'   => 'ಎಕಾಜುಕ್',
    'el'    => 'ಗ್ರೀಕ್',
    'elx'   => 'ಎಲಾಮೈಟ್',
    'en'    => 'ಇಂಗ್ಲೀಷ್',
    'en_au' => "ಆಸ್ಟ್ರೇಲಿಯನ್\ ಇಂಗ್ಲೀಷ್",
    'en_ca' => "ಕೆನೆಡಿಯನ್\ ಇಂಗ್ಲೀಷ್",
    'en_gb' => "ಬ್ರಿಟಿಷ್\ ಇಂಗ್ಲೀಷ್",
    'en_us' => "ಯು\.ಎಸ್\.\ ಇಂಗ್ಲೀಷ್",
    'enm'   => "ಮಧ್ಯ\ ಇಂಗ್ಲೀಷ್",
    'eo'    => 'ಎಸ್ಪೆರಾಂಟೊ',
    'es'    => 'ಸ್ಪ್ಯಾನಿಷ್',
    'es_es' => "ಐಬೇರಿಯನ್\ ಸ್ಪ್ಯಾನಿಶ್",
    'et'    => 'ಎಸ್ಟೊನಿಯನ್',
    'eu'    => 'ಬಾಸ್ಕ್',
    'ewo'   => 'ಇವಾಂಡೋ',
    'fa'    => 'ಪರ್ಶಿಯನ್',
    'fan'   => 'ಫೆಂಗ್',
    'fat'   => 'ಫಾಂಟಿ',
    'ff'    => 'ಫುಲಾಹ್',
    'fi'    => 'ಫಿನ್ನಿಶ್',
    'fil'   => 'ಫಿಲಿಪಿನೊ',
    'fiu'   => "ಫಿನ್ನೋ\-ಉಗ್ರಿಯನ್\ ಭಾಷೆ",
    'fj'    => 'ಫಿಜಿಯನ್',
    'fo'    => 'ಫರೋಸಿ',
    'fon'   => 'ಫೋನ್',
    'fr'    => 'ಫ್ರೆಂಚ್',
    'fr_ca' => "ಕೆನೆಡಿಯನ್\ ಫ್ರೆಂಚ್",
    'fr_ch' => "ಸ್ವಿಸ್\ ಫ್ರೆಂಚ್",
    'frm'   => "ಮಧ್ಯ\ ಫ್ರೆಂಚ್",
    'fro'   => "ಪ್ರಾಚೀನ\ ಫ್ರೆಂಚ್",
    'frr'   => "ಉತ್ತರ\ ಫ್ರಿಸಿಯನ್",
    'frs'   => "ಪೂರ್ವ\ ಫ್ರಿಸಿಯನ್",
    'fur'   => 'ಫ್ರಿಯುಲಿಯನ್',
    'fy'    => "ಪಶ್ಚಿಮ\ ಫ್ರಿಸಿಯನ್",
    'ga'    => 'ಐರಿಷ್',
    'gaa'   => 'ಗಾ',
    'gay'   => 'ಗಾಯೋ',
    'gba'   => 'ಗ್ಬಾಯಾ',
    'gd'    => "ಸ್ಕಾಟಿಶ್\ ಗ್ಯಾಲಿಕ್",
    'gem'   => "ಜರ್ಮನಿಕ್\ ಭಾಷೆ",
    'gez'   => 'ಗೀಝ್',
    'gil'   => 'ಗಿಲ್ಬರ್ಟೀಸ್',
    'gl'    => 'ಗ್ಯಾಲಿಶಿಯನ್',
    'gmh'   => "ಮಧ್ಯ\ ಹೈ\ ಜರ್ಮನ್",
    'gn'    => 'ಗೌರಾನಿ',
    'goh'   => "ಪ್ರಾಚೀನ\ ಹೈ\ ಜರ್ಮನ್",
    'gon'   => 'ಗೊಂಡಿ',
    'gor'   => 'ಗೊರೊಂಟಾಲೋ',
    'got'   => 'ಗೋಥಿಕ್',
    'grb'   => 'ಗ್ರೇಬೋ',
    'grc'   => "ಪ್ರಾಚೀನ\ ಗ್ರೀಕ್",
    'gsw'   => "ಸ್ವಿಸ್\ ಜರ್ಮನ್",
    'gu'    => 'ಗುಜರಾತಿ',
    'guz'   => 'Gusii',
    'gv'    => 'ಮ್ಯಾಂಕ್ಸ್',
    'gwi'   => 'ಗ್ವಿಚ್‌ಇನ್',
    'ha'    => 'ಹೌಸಾ',
    'hai'   => 'ಹೈಡಾ',
    'haw'   => 'ಹವಾಯಿಯನ್',
    'he'    => 'ಹೀಬ್ರ್ಯೂ',
    'hi'    => 'ಹಿಂದಿ',
    'hil'   => 'ಹಿಲಿಗೇನನ್',
    'him'   => 'ಹಿಮಾಚಲಿ',
    'hit'   => 'ಹಿಟ್ಟಿಟೆ',
    'hmn'   => 'ಮೋಂಗ್',
    'ho'    => "ಹಿರಿ\ ಮೊಟು",
    'hr'    => 'ಕ್ರೊಯೇಶಿಯನ್',
    'hsb'   => "ಅಪ್ಪರ್\ ಸರ್ಬಿಯನ್",
    'ht'    => 'ಹೈತಿಯನ್',
    'hu'    => 'ಹಂಗೇರಿಯನ್',
    'hup'   => 'ಹೂಪಾ',
    'hy'    => 'ಅರ್ಮೇನಿಯನ್',
    'hz'    => 'ಹೆರೆರೊ',
    'ia'    => 'ಇಂಟರ್ಲಿಂಗುವಾ',
    'iba'   => 'ಇಬಾನ್',
    'id'    => 'ಇಂಡೋನೇಶಿಯನ್',
    'ie'    => 'ಇಂಟರ್ಲಿಂಗ್',
    'ig'    => 'ಇಗ್ಬೊ',
    'ii'    => "ಸಿಚುಅನ್\ ಯಿ",
    'ijo'   => 'ಇಜೋ',
    'ik'    => 'ಇನುಪಿಯಾಕ್',
    'ilo'   => 'ಇಲ್ಲಿಕೋ',
    'inc'   => "ಭಾರತೀಯ\ ಭಾಷೆ",
    'ine'   => "ಇಂಡೋ\-ಯೂರೋಪಿಯನ್\ ಭಾಷೆ",
    'inh'   => 'ಇಂಗುಷ್',
    'io'    => 'ಇಡೊ',
    'ira'   => "ಇರಾನಿಯನ್\ ಭಾಷೆ",
    'iro'   => "ಇರೋಕ್ವಿಯನ್\ ಭಾಷೆ",
    'is'    => 'ಐಸ್‌ಲ್ಯಾಂಡಿಕ್',
    'it'    => 'ಇಟಾಲಿಯನ್',
    'iu'    => 'ಇನುಕ್ಟಿಟುಟ್',
    'ja'    => 'ಜಪಾನೀಸ್',
    'jbo'   => 'ಲೊಜ್ಬಾನ್',
    'jmc'   => 'Machame',
    'jpr'   => "ಜೂಡಿಯೋ\-ಪರ್ಶಿಯನ್",
    'jrb'   => "ಜೂಡಿಯೋ\-ಅರೇಬಿಕ್",
    'jv'    => 'ಜವಾನೀಸ್',
    'ka'    => 'ಜಾರ್ಜಿಯನ್',
    'kaa'   => "ಕಾರಾ\-ಕಲ್ಪಾಕ್",
    'kab'   => 'ಕಬೈಲ್',
    'kac'   => 'ಕಚಿನ್',
    'kaj'   => 'ಜ್ಜು',
    'kam'   => 'ಕಂಬಾ',
    'kar'   => 'ಕರೆನ್',
    'kaw'   => 'ಕಾವಿ',
    'kbd'   => 'ಕಬರ್ಡಿಯನ್',
    'kcg'   => 'ಟ್ಯಾಪ್',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'ಕೋರೋ',
    'kg'    => 'ಕಾಂಗೋ',
    'kha'   => 'ಖಾಸಿ',
    'khi'   => "ಖೋಇಸನ್\ ಭಾಷೆ",
    'kho'   => 'ಖೋಟಾನೀಸ್',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'ಕಿಕುಯು',
    'kj'    => 'ಕ್ವಾನ್‌ಯಾಮಾ',
    'kk'    => 'ಕಝಕ್',
    'kl'    => 'ಕಲಾಲ್ಲಿಸುಟ್',
    'kln'   => 'Kalenjin',
    'km'    => 'ಖಮೇರ್',
    'kmb'   => 'ಕಿಂಬುಂಡು',
    'kn'    => 'ಕನ್ನಡ',
    'ko'    => 'ಕೋರಿಯನ್',
    'kok'   => 'ಕೊಂಕಣಿ',
    'kos'   => 'ಕೊಸರಿಯನ್',
    'kpe'   => 'ಕಪೆಲ್ಲೆ',
    'kr'    => 'ಕನುರಿ',
    'krc'   => "ಕರಚಯ್\-ಬಲ್ಕಾರ್",
    'krl'   => 'ಕರೇಲಿಯನ್',
    'kro'   => 'ಕ್ರು',
    'kru'   => 'ಕುರುಖ್',
    'ks'    => 'ಕಾಶ್ಮೀರಿ',
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => 'ಕುರ್ದಿಷ್',
    'kum'   => 'ಕುಮೈಕ್',
    'kut'   => 'ಕುಟೇನಾಯ್',
    'kv'    => 'ಕೋಮಿ',
    'kw'    => 'ಕೋರ್ನಿಷ್',
    'ky'    => 'ಕಿರ್ಜಿಝ್',
    'la'    => 'ಲ್ಯಾಟಿನ್',
    'lad'   => 'ಕಾಡಿನೋ',
    'lag'   => 'Langi',
    'lah'   => 'ಲಹಂಡಾ',
    'lam'   => 'ಲಂಬಾ',
    'lb'    => 'ಲಕ್ಸಂಬರ್ಗ್',
    'lez'   => 'ಲೆಜ್ಘಿಯನ್',
    'lg'    => 'ಗಂಡಾ',
    'li'    => 'ಲಿಂಬರ್ಗಿಶ್',
    'ln'    => 'ಲಿಂಗಾಲ',
    'lo'    => 'ಲಾವೋ',
    'lol'   => 'ಮೊಂಗೋ',
    'loz'   => 'ಲೋಜಿ',
    'lt'    => 'ಲಿಥುವೇನಿಯನ್',
    'lu'    => "ಲೂಬಾ\-ಕಟಾಂಗಾ",
    'lua'   => "ಲೂಬಾ\-ಲುಲುಆ",
    'lui'   => 'ಲೂಯಿಸೆನೋ',
    'lun'   => 'ಲುಂಡಾ',
    'luo'   => 'ಲುವೋ',
    'lus'   => 'ಲುಶಾಯ್',
    'luy'   => 'Luyia',
    'lv'    => 'ಲಟ್ವಿಯನ್',
    'mad'   => 'ಮದುರೀಸ್',
    'mag'   => 'ಮಗಾಹಿ',
    'mai'   => 'ಮೈಥಿಲಿ',
    'mak'   => 'ಮಕಾಸರ್',
    'man'   => 'ಮಂಡಿಂಗೊ',
    'map'   => 'ಆಸ್ಟ್ರೋನೇಷ್ಯನ್',
    'mas'   => 'ಮಸಾಯ್',
    'mdf'   => 'ಮೋಕ್ಷ',
    'mdr'   => 'ಮಂದಾರ್',
    'men'   => 'ಮೆಂಡೆ',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => 'ಮಲಗಾಸಿ',
    'mga'   => "ಮಧ್ಯ\ ಐರಿಷ್",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => 'ಮಾರ್ಶಲ್ಲೀಸ್',
    'mi'    => 'ಮಾವೋರಿ',
    'mic'   => 'ಮಿಕ್‌ಮ್ಯಾಕ್',
    'min'   => 'ಮಿನಂಗ್‌ಕಬಾವು',
    'mis'   => "ಸಮ್ಮಿಶ್ರ\ ಭಾಷೆ",
    'mk'    => 'ಮೆಸಿಡೋನಿಯನ್',
    'mkh'   => "ಮೋನ್\-ಖಮೇರ್\ ಭಾಷೆ",
    'ml'    => 'ಮಲೆಯಾಳಂ',
    'mn'    => 'ಮಂಗೋಲಿಯನ್',
    'mnc'   => 'ಮಂಚು',
    'mni'   => 'ಮಣಿಪುರಿ',
    'mno'   => "ಮನೋಬೋ\ ಭಾಷೆ",
    'mo'    => 'ಮಾಲ್ಡೀವಿಯನ್',
    'moh'   => 'ಮೊಹಾವ್ಕ್',
    'mos'   => 'ಮೊಸ್ಸಿ',
    'mr'    => 'ಮರಾಠಿ',
    'ms'    => 'ಮಲಯ',
    'mt'    => 'ಮಾಲ್ಟೀಸ್',
    'mua'   => 'Mundang',
    'mul'   => "ಬಹುಸಂಖ್ಯೆಯ\ ಭಾಷೆಗಳು",
    'mun'   => "ಮುಂಡಾ\ ಭಾಷೆ",
    'mus'   => 'ಕ್ರೀಕ್',
    'mwl'   => 'ಕಿರಾಂಡೀಸ್',
    'mwr'   => 'ಮಾರ್ವಾಡಿ',
    'my'    => 'ಬರ್ಮೀಸ್',
    'myn'   => "ಮಯನ್\ ಭಾಷೆ",
    'myv'   => 'ಎರ್‌ಝ್ಯಾ',
    'na'    => 'ನೌರು',
    'nah'   => 'ನಹೌಟಿ',
    'nai'   => "ಉತ್ತರ\ ಅಮೇರಿಕದ\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'nap'   => 'ನಿಯಾಪೊಲಿಟನ್',
    'naq'   => 'Nama',
    'nb'    => "ನೋರ್ವೇಜಿಯನ್\ ಬೊಕ್ಮಲ್",
    'nd'    => "ಉತ್ತರ\ ದೆಬೆಲೆ",
    'nds'   => "ಲೋ\ ಜರ್ಮನ್",
    'ne'    => 'ನೇಪಾಳಿ',
    'new'   => 'ನೇವಾರೀ',
    'ng'    => 'ಡೋಂಗಾ',
    'nia'   => 'ನಿಯಾಸ್',
    'nic'   => "ನೈಗರ್\-ಕೊರ್ಡೊಫನಿಯನ್\ ಭಾಷೆ",
    'niu'   => 'ನಿಯುವನ್',
    'nl'    => 'ಡಚ್',
    'nl_be' => 'ಫ್ಲೆಮಿಷ್',
    'nmg'   => 'Kwasio',
    'nn'    => "ನಾರ್ವೇಜಿಯನ್\ ನೂನಾರ್ಸ್ಕ್",
    'no'    => 'ನಾರ್ವೇಜಿಯನ್',
    'nog'   => 'ನೊಗಾಯ್',
    'non'   => "ಪ್ರಾಚೀನ\ ನೋರ್ಸ್",
    'nqo'   => 'ಎನ್‌ಕೋ',
    'nr'    => "ದಕ್ಷಿಣ\ ದೆಬೆಲೆ",
    'nso'   => "ಉತ್ತರ\ ಸೋಥೋ",
    'nub'   => "ನುಬಿಯನ್\ ಭಾಷೆ",
    'nus'   => 'Nuer',
    'nv'    => 'ನವಾಜೊ',
    'nwc'   => "ಶಾಸ್ತ್ರೀಯ\ ನೇವಾರಿ",
    'ny'    => 'ನ್ಯಾಂಜಾ',
    'nym'   => 'ನ್ಯಾಮ್‌ವೆಂಜಿ',
    'nyn'   => 'ನ್ಯಾನ್‌ಕೋಲೆ',
    'nyo'   => 'ನ್ಯೋರೋ',
    'nzi'   => 'ಜೀಮಾ',
    'oc'    => 'ಆಕ್ಸಿಟಾನ್',
    'oj'    => 'ಒಜಿಬ್ವಾ',
    'om'    => 'ಒರೊಮೊ',
    'or'    => 'ಓರಿಯಾ',
    'os'    => 'ಒಸ್ಸೆಟಿಕ್',
    'osa'   => 'ಓಸಾಜ್',
    'ota'   => "ಒಟ್ಟೋಮನ್\ ತುರ್ಕಿಷ್",
    'oto'   => "ಒಟ್ಟೋಮನ್\ ಭಾಷೆ",
    'pa'    => 'ಪಂಜಾಬಿ',
    'paa'   => "ಪಪುವನ್\ ಭಾಷೆ",
    'pag'   => 'ಪಂಗಾಸಿನನ್',
    'pal'   => 'ಪಹ್ಲವಿ',
    'pam'   => 'ಪಂಪಾಂಗಾ',
    'pap'   => 'ಪಾಪಿಯಮೆಂಟೋ',
    'pau'   => 'ಪಲುಆನ್',
    'peo'   => "ಪ್ರಾಚೀನ\ ಪರ್ಶಿಯನ್",
    'phi'   => "ಫಿಲಿಫೈನ್\ ಭಾಷೆ",
    'phn'   => 'ಫೀನಿಷಿಯನ್',
    'pi'    => 'ಪಾಲಿ',
    'pl'    => 'ಪೋಲಿಶ್',
    'pon'   => 'ಪೋನ್‌‌ಪಿಯನ್',
    'pra'   => "ಪ್ರಾಕೃತ್\ ಭಾಷೆ",
    'pro'   => "ಪ್ರಾಚೀನ\ ಪ್ರೊವೆನ್ಶಿಯಲ್",
    'ps'    => 'ಪುಶ್ತೋ',
    'pt'    => 'ಪೋರ್ಚುಗೀಸ್',
    'pt_br' => "ಬ್ರೆಜಿಲಿಯನ್\ ಪೋರ್ಚುಗೀಸ್",
    'pt_pt' => "ಐಬೀರಿಯನ್\ ಪೋರ್ಚುಗೀಸ್",
    'qu'    => 'ಕ್ವೆಚುವಾ',
    'raj'   => 'ರಾಜಾಸ್ಥಾನಿ',
    'rap'   => 'ರಾಪಾನುಯಿ',
    'rar'   => 'ರಾರೋಟೊಂಗನ್',
    'rm'    => "ರಹೇಟೋ\-ರೋಮ್ಯಾನ್ಸ್",
    'rn'    => 'ರುಂಡಿ',
    'ro'    => 'ರೊಮ್ಯಾನಿಯನ್',
    'roa'   => "ರೋಮನ್\ ಭಾಷೆ",
    'rof'   => 'Rombo',
    'rom'   => 'ರೋಮಾನಿ',
    'ru'    => 'ರಶಿಯನ್',
    'rup'   => 'ಅರೋಮಾನಿಯನ್',
    'rw'    => 'ಕೀನ್ಯಾರುವಾಂಡಾ',
    'rwk'   => 'Rwa',
    'sa'    => 'ಸಂಸ್ಕೃತ',
    'sad'   => 'ಸಂಡಾವೇ',
    'sah'   => 'ಯಾಕುಟ್',
    'sai'   => "ದಕ್ಷಿಣ\ ಅಮೇರಿಕದ\ ಇಂಡಿಯನ್\ ಭಾಷೆ",
    'sal'   => "ಸಲಿಷನ್\ ಭಾಷೆ",
    'sam'   => "ಸಮರಿಟನ್\ ಅರಾಮಿಕ್",
    'saq'   => 'Samburu',
    'sas'   => 'ಸಸಾಕ್',
    'sat'   => 'ಸಂತಾಲಿ',
    'sbp'   => 'Sangu',
    'sc'    => 'ಸರ್ಡೀನಿಯನ್',
    'scn'   => 'ಸಿಸಿಲಿಯನ್',
    'sco'   => 'ಸ್ಕೋಟ್ಸ್',
    'sd'    => 'ಸಿಂಧಿ',
    'se'    => "ಉತ್ತರ\ ಸಾಮಿ",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'ಸೆಲ್ಕಪ್',
    'sem'   => "ಸೆಮಿಟಿಕ್\ ಭಾಷೆ",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => 'ಸಾಂಗೋ',
    'sga'   => "ಪ್ರಾಚೀನ\ ಐರಿಷ್",
    'sgn'   => "ಸಂಜ್ಞಾ\ ಭಾಷೆ",
    'sh'    => "ಸರ್ಬೋ\-ಕ್ರೊಯೇಶಿಯನ್",
    'shi'   => 'Tachelhit',
    'shn'   => 'ಶಾನ್',
    'si'    => 'ಸಿಂಹಳ',
    'sid'   => 'ಸಿಡಾಮೋ',
    'sio'   => "ಸಿವುಅನ್\ ಭಾಷೆ",
    'sit'   => "ಸೈನೋ\-ಟಿಬೇಟಿಯನ್\ ಭಾಷೆ",
    'sk'    => 'ಸ್ಲೋವಾಕ್',
    'sl'    => 'ಸ್ಲೋವೇನಿಯನ್',
    'sla'   => "ಸ್ಲಾವಿಕ್\ ಭಾಷೆ",
    'sm'    => 'ಸಮೋವನ್',
    'sma'   => "ದಕ್ಷಿಣ\ ಸಾಮಿ",
    'smi'   => "ಸಾಮಿ\ ಭಾಷೆ",
    'smj'   => "ಲೂಲ್\ ಸಾಮಿ",
    'smn'   => "ಇನರಿ\ ಸಾಮಿ",
    'sms'   => "ಸ್ಕೋಟ್\ ಸಾಮಿ",
    'sn'    => 'ಶೋನಾ',
    'snk'   => 'ಸೋನಿಂಕೆ',
    'so'    => 'ಸೋಮಾಲಿ',
    'sog'   => 'ಸೋಗ್ಡಿಏನ್',
    'son'   => 'ಸೋಂಘಾಯ್',
    'sq'    => 'ಅಲ್ಬೇನಿಯನ್',
    'sr'    => 'ಸರ್ಬಿಯನ್',
    'srn'   => "ಸ್ರಾನನ್\ ಟೋಂಗೋ",
    'srr'   => 'ಸೇರೇರ್',
    'ss'    => 'ಸ್ವಾತಿ',
    'ssa'   => "ನಿಲೋ\-ಸಹಾರನ್\ ಭಾಷೆ",
    'ssy'   => 'Saho',
    'st'    => "ದಕ್ಷಿಣ\ ಸೋಥೋ",
    'su'    => 'ಸುಂಡಾನೀಸ್',
    'suk'   => 'ಸುಕುಮಾ',
    'sus'   => 'ಸುಸು',
    'sux'   => 'ಸುಮೇರಿಯನ್',
    'sv'    => 'ಸ್ವೀಡಿಷ್',
    'sw'    => 'ಸ್ವಹಿಲಿ',
    'swb'   => 'ಕೊಮೊರಿಯನ್',
    'swc'   => "Congo\ Swahili",
    'syc'   => "ಶಾಸ್ತ್ರೀಯ\ ಸಿರಿಯಕ್",
    'syr'   => 'ಸಿರಿಯಕ್',
    'ta'    => 'ತಮಿಳು',
    'tai'   => "ಥಾಯ್\ ಭಾಷೆ",
    'te'    => 'ತೆಲುಗು',
    'tem'   => 'ಟಿಮ್ನೆ',
    'teo'   => 'Teso',
    'ter'   => 'ಟೆರೆನೋ',
    'tet'   => 'ಟೇಟಮ್',
    'tg'    => 'ತಾಜಿಕ್',
    'th'    => 'ಥಾಯಿ',
    'ti'    => 'ಟೈಗ್ರಿನ್ಯಾ',
    'tig'   => 'ಟೈಗ್ರೆ',
    'tiv'   => 'ಟಿವ್',
    'tk'    => 'ಟರ್ಕ್‌ಮೆನ್',
    'tkl'   => 'ಟೊಕೆಲಾವ್',
    'tl'    => 'ಟ್ಯಾಗಲೋಗ್',
    'tlh'   => 'ಕ್ಲಿಂಗೋನ್',
    'tli'   => 'ಟ್ಲಿಂಗಿಟ್',
    'tmh'   => 'ಟಮಾಷೆಕ್',
    'tn'    => 'ಸ್ವಾನಾ',
    'to'    => 'ಟೊಂಗಾ',
    'tog'   => "ನ್ಯಾಸಾ\ ಟೋಂಗಾ",
    'tpi'   => "ಟೋಕ್\ ಪಿಸಿನ್",
    'tr'    => 'ಟರ್ಕಿಶ್',
    'trv'   => 'Taroko',
    'ts'    => 'ಸೋಂಗಾ',
    'tsi'   => 'ಸಿಂಶಿಯನ್',
    'tt'    => 'ಟಾಟರ್',
    'tum'   => 'ಟುಂಬುಕ',
    'tup'   => "ಟೂಪಿ\ ಭಾಷೆ",
    'tut'   => "ಆಲ್ಟಾಯಿಕ್\ ಭಾಷೆ",
    'tvl'   => 'ಟುವಾಲು',
    'tw'    => 'ಟ್ವಿ',
    'twq'   => 'Tasawaq',
    'ty'    => 'ತಹಿತಿಯನ್',
    'tyv'   => 'ಟುವಿನಿಯನ್',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'ಉಡ್‌ಮುರ್ಟ್',
    'ug'    => 'ವಿಗರ್‌',
    'uga'   => 'ಉಗಾರಿಟಿಕ್',
    'uk'    => 'ಉಕ್ರೈನಿಯನ್',
    'umb'   => 'ಉಂಬುಂಡು',
    'und'   => "ಅಪರಿಚಿತ\ ಅಥವಾ\ ಅಮಾನ್ಯ\ ಭಾಷೆ",
    'ur'    => 'ಉರ್ದು',
    'uz'    => 'ಉಜ್ಬೇಕ್',
    'vai'   => 'ವಾಯಿ',
    've'    => 'ವೆಂಡಾ',
    'vi'    => 'ವಿಯೇಟ್ನಾಮೀಸ್',
    'vo'    => 'ವೋಲಾಪುಕ್',
    'vot'   => 'ವೋಟಿಕ್',
    'vun'   => 'Vunjo',
    'wa'    => 'ವಾಲೂನ್',
    'wae'   => 'Walser',
    'wak'   => "ವಾಕಾಷನ್\ ಭಾಷೆ",
    'wal'   => 'ವಲಾಮೋ',
    'war'   => 'ವರಾಯ್',
    'was'   => 'ವಾಷೋ',
    'wen'   => "ಸೋರ್ಬಿಯನ್\ ಭಾಷೆ",
    'wo'    => 'ವೋಲೋಫ್',
    'xal'   => 'ಕಲ್‌ಮೈಕ್',
    'xh'    => 'ಷೋಸಾ',
    'xog'   => 'Soga',
    'yao'   => 'ಯಾಓ',
    'yap'   => 'ಯಪೀಸೆ',
    'yav'   => 'Yangben',
    'yi'    => 'ಯಿಡ್ಡಿಷ್',
    'yo'    => 'ಯೊರುಬಾ',
    'ypk'   => "ಯೂಪಿಕ್\ ಭಾಷೆ",
    'yue'   => 'ಕಾಂಟೊನೀಸ್',
    'za'    => 'ಝೂವಾಂಗ್',
    'zap'   => 'ಝೋಪೊಟೆಕ್',
    'zbl'   => 'ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್',
    'zen'   => 'ಝೆನಾಗಾ',
    'zh'    => 'ಚೈನೀಸ್',
    'znd'   => 'ಝಂಡೇ',
    'zu'    => 'ಜುಲು',
    'zun'   => 'ಝೂನಿ',
    'zxx'   => "ಯಾವುದೇ\ ಭಾಷಾಸಂಬಂಧಿ\ ವಿಷಯವಿಲ್ಲ",
    'zza'   => 'ಜಾಝಾ',
);

%Locales::DB::Language::kn::name_to_code = (
    'aghem'                                                                                                  => 'agq',
    'asu'                                                                                                    => 'asa',
    'bafia'                                                                                                  => 'ksf',
    'bena'                                                                                                   => 'bez',
    'bodo'                                                                                                   => 'brx',
    'cayuga'                                                                                                 => 'cay',
    'centralmoroccotamazight'                                                                                => 'tzm',
    'chiga'                                                                                                  => 'cgg',
    'colognian'                                                                                              => 'ksh',
    'congoswahili'                                                                                           => 'swc',
    'embu'                                                                                                   => 'ebu',
    'gusii'                                                                                                  => 'guz',
    'jolafonyi'                                                                                              => 'dyo',
    'kabuverdianu'                                                                                           => 'kea',
    'kalenjin'                                                                                               => 'kln',
    'koyraborosenni'                                                                                         => 'ses',
    'koyrachiini'                                                                                            => 'khq',
    'kwasio'                                                                                                 => 'nmg',
    'langi'                                                                                                  => 'lag',
    'luyia'                                                                                                  => 'luy',
    'machame'                                                                                                => 'jmc',
    'makhuwameetto'                                                                                          => 'mgh',
    'makonde'                                                                                                => 'kde',
    'meru'                                                                                                   => 'mer',
    'morisyen'                                                                                               => 'mfe',
    'mundang'                                                                                                => 'mua',
    'nama'                                                                                                   => 'naq',
    'nuer'                                                                                                   => 'nus',
    'rombo'                                                                                                  => 'rof',
    'rwa'                                                                                                    => 'rwk',
    'saho'                                                                                                   => 'ssy',
    'samburu'                                                                                                => 'saq',
    'sangu'                                                                                                  => 'sbp',
    'sena'                                                                                                   => 'seh',
    'seneca'                                                                                                 => 'see',
    'shambala'                                                                                               => 'ksb',
    'soga'                                                                                                   => 'xog',
    'tachelhit'                                                                                              => 'shi',
    'taita'                                                                                                  => 'dav',
    'taroko'                                                                                                 => 'trv',
    'tasawaq'                                                                                                => 'twq',
    'teso'                                                                                                   => 'teo',
    'vunjo'                                                                                                  => 'vun',
    'walser'                                                                                                 => 'wae',
    'yangben'                                                                                                => 'yav',
    'zarma'                                                                                                  => 'dje',
    'ಅಂಹರಿಕ್'                                                                                  => 'am',
    'ಅಕನ್'                                                                                           => 'ak',
    'ಅಕೋಲಿ'                                                                                        => 'ach',
    'ಅಕ್ಕಾಡಿಯನ್'                                                                         => 'akk',
    'ಅಛಿನೀಸ್'                                                                                  => 'ace',
    'ಅಝೆರಿ'                                                                                        => 'az',
    'ಅಟ್ಸಮ್'                                                                                     => 'cch',
    'ಅಡಂಗ್‌ಮೆ'                                                                               => 'ada',
    'ಅಡೈಘೆ'                                                                                        => 'ady',
    'ಅಥಪಾಸ್ಕನ್ಭಾಷೆ'                                                                => 'ath',
    'ಅಪರಿಚಿತಅಥವಾಅಮಾನ್ಯಭಾಷೆ'                                        => 'und',
    'ಅಪಾಚಿಭಾಷೆ'                                                                            => 'apa',
    'ಅಪ್ಪರ್ಸರ್ಬಿಯನ್'                                                             => 'hsb',
    'ಅಫಾರ್'                                                                                        => 'aa',
    'ಅಬ್ಖಾಜಿಯನ್'                                                                         => 'ab',
    'ಅಯ್ಮಾರಾ'                                                                                  => 'ay',
    'ಅರಗೊನೀಸ್'                                                                               => 'an',
    'ಅರಪಾಹೋ'                                                                                     => 'arp',
    'ಅರಾಮಿಕ್'                                                                                  => 'arc',
    'ಅರಾವಾಕ್'                                                                                  => 'arw',
    'ಅರೇಬಿಕ್'                                                                                  => 'ar',
    'ಅರೋಮಾನಿಯನ್'                                                                         => 'rup',
    'ಅರೌಕೇನಿಯನ್'                                                                         => 'arn',
    'ಅರ್ಮೇನಿಯನ್'                                                                         => 'hy',
    'ಅಲೆಯುಟ್'                                                                                  => 'ale',
    'ಅಲ್ಗೊಂಕ್ವಿಯನ್ಭಾಷೆ'                                                    => 'alg',
    'ಅಲ್ಬೇನಿಯನ್'                                                                         => 'sq',
    'ಅವಧಿ'                                                                                           => 'awa',
    'ಅವರಿಕ್'                                                                                     => 'av',
    'ಅವೆಸ್ಟನ್'                                                                               => 'ae',
    'ಅಸ್ಸಾಮೀಸ್'                                                                            => 'as',
    'ಆಂಗಿಕಾ'                                                                                     => 'anp',
    'ಆಕ್ಸಿಟಾನ್'                                                                            => 'oc',
    'ಆಫ್ರಿಕಾನ್ಸ್'                                                                      => 'af',
    'ಆಫ್ರಿಹಿಲಿ'                                                                            => 'afh',
    'ಆಫ್ರೋಏಶಿಯಾಟಿಕ್ಭಾಷೆ'                                                 => 'afa',
    'ಆಲ್ಟಾಯಿಕ್ಭಾಷೆ'                                                                => 'tut',
    'ಆಸ್ಟುರಿಯನ್'                                                                         => 'ast',
    'ಆಸ್ಟ್ರಿಯನ್‌‌ನಜರ್ಮನ್‌'                                           => 'de_at',
    'ಆಸ್ಟ್ರೇಲಿಯನ್ಇಂಗ್ಲೀಷ್'                                           => 'en_au',
    'ಆಸ್ಟ್ರೇಲಿಯನ್ಭಾಷೆ'                                                       => 'aus',
    'ಆಸ್ಟ್ರೋನೇಷ್ಯನ್'                                                             => 'map',
    'ಇಂಗುಷ್'                                                                                     => 'inh',
    'ಇಂಗ್ಲೀಷ್'                                                                               => 'en',
    'ಇಂಗ್ಲೀಷ್ಮೂಲದಕ್ರಿಯೋಲ್ಅಥವಾಪಿಡ್ಗಿನ್'       => 'cpe',
    'ಇಂಟರ್ಲಿಂಗುವಾ'                                                                   => 'ia',
    'ಇಂಟರ್ಲಿಂಗ್'                                                                         => 'ie',
    'ಇಂಡೋನೇಶಿಯನ್'                                                                      => 'id',
    'ಇಂಡೋಯೂರೋಪಿಯನ್ಭಾಷೆ'                                                    => 'ine',
    'ಇಗ್ಬೊ'                                                                                        => 'ig',
    'ಇಜೋ'                                                                                              => 'ijo',
    'ಇಟಾಲಿಯನ್'                                                                               => 'it',
    'ಇಡೊ'                                                                                              => 'io',
    'ಇನರಿಸಾಮಿ'                                                                               => 'smn',
    'ಇನುಕ್ಟಿಟುಟ್'                                                                      => 'iu',
    'ಇನುಪಿಯಾಕ್'                                                                            => 'ik',
    'ಇಬಾನ್'                                                                                        => 'iba',
    'ಇರಾನಿಯನ್ಭಾಷೆ'                                                                   => 'ira',
    'ಇರೋಕ್ವಿಯನ್ಭಾಷೆ'                                                             => 'iro',
    'ಇಲ್ಲಿಕೋ'                                                                                  => 'ilo',
    'ಇವಾಂಡೋ'                                                                                     => 'ewo',
    'ಉಂಬುಂಡು'                                                                                  => 'umb',
    'ಉಕ್ರೈನಿಯನ್'                                                                         => 'uk',
    'ಉಗಾರಿಟಿಕ್'                                                                            => 'uga',
    'ಉಜ್ಬೇಕ್'                                                                                  => 'uz',
    'ಉಡ್‌ಮುರ್ಟ್'                                                                         => 'udm',
    'ಉತ್ತರಅಮೇರಿಕದಇಂಡಿಯನ್ಭಾಷೆ'                                  => 'nai',
    'ಉತ್ತರದೆಬೆಲೆ'                                                                      => 'nd',
    'ಉತ್ತರಫ್ರಿಸಿಯನ್'                                                             => 'frr',
    'ಉತ್ತರಸಾಮಿ'                                                                            => 'se',
    'ಉತ್ತರಸೋಥೋ'                                                                            => 'nso',
    'ಉರ್ದು'                                                                                        => 'ur',
    'ಎಕಾಜುಕ್'                                                                                  => 'eka',
    'ಎನ್‌ಕೋ'                                                                                     => 'nqo',
    'ಎಫಿಕ್'                                                                                        => 'efi',
    'ಎರ್‌ಝ್ಯಾ'                                                                               => 'myv',
    'ಎಲಾಮೈಟ್'                                                                                  => 'elx',
    'ಎಸ್ಟೊನಿಯನ್'                                                                         => 'et',
    'ಎಸ್ಪೆರಾಂಟೊ'                                                                         => 'eo',
    'ಏವ್'                                                                                              => 'ee',
    'ಐನು'                                                                                              => 'ain',
    'ಐಬೀರಿಯನ್ಪೋರ್ಚುಗೀಸ್'                                                 => 'pt_pt',
    'ಐಬೇರಿಯನ್ಸ್ಪ್ಯಾನಿಶ್'                                                 => 'es_es',
    'ಐರಿಷ್'                                                                                        => 'ga',
    'ಐಸ್‌ಲ್ಯಾಂಡಿಕ್'                                                                => 'is',
    'ಒಜಿಬ್ವಾ'                                                                                  => 'oj',
    'ಒಟ್ಟೋಮನ್ತುರ್ಕಿಷ್'                                                       => 'ota',
    'ಒಟ್ಟೋಮನ್ಭಾಷೆ'                                                                   => 'oto',
    'ಒರೊಮೊ'                                                                                        => 'om',
    'ಒಸ್ಸೆಟಿಕ್'                                                                            => 'os',
    'ಓರಿಯಾ'                                                                                        => 'or',
    'ಓಸಾಜ್'                                                                                        => 'osa',
    'ಕಂಬಾ'                                                                                           => 'kam',
    'ಕಕೇಶಿಯನ್ಭಾಷೆ'                                                                   => 'cau',
    'ಕಚಿನ್'                                                                                        => 'kac',
    'ಕಝಕ್'                                                                                           => 'kk',
    'ಕನುರಿ'                                                                                        => 'kr',
    'ಕನ್ನಡ'                                                                                        => 'kn',
    'ಕಪೆಲ್ಲೆ'                                                                                  => 'kpe',
    'ಕಬರ್ಡಿಯನ್'                                                                            => 'kbd',
    'ಕಬೈಲ್'                                                                                        => 'kab',
    'ಕಮೊರೊ'                                                                                        => 'ch',
    'ಕರಚಯ್ಬಲ್ಕಾರ್'                                                                   => 'krc',
    'ಕರೆನ್'                                                                                        => 'kar',
    'ಕರೇಲಿಯನ್'                                                                               => 'krl',
    'ಕಲಾಲ್ಲಿಸುಟ್'                                                                      => 'kl',
    'ಕಲ್‌ಮೈಕ್'                                                                               => 'xal',
    'ಕಶುಬಿಯನ್'                                                                               => 'csb',
    'ಕಾಂಗೋ'                                                                                        => 'kg',
    'ಕಾಂಟೊನೀಸ್'                                                                            => 'yue',
    'ಕಾಡಿನೋ'                                                                                     => 'lad',
    'ಕಾರಾಕಲ್ಪಾಕ್'                                                                      => 'kaa',
    'ಕಾರಿಬ್'                                                                                     => 'car',
    'ಕಾವಿ'                                                                                           => 'kaw',
    'ಕಾಶ್ಮೀರಿ'                                                                               => 'ks',
    'ಕಿಂಬುಂಡು'                                                                               => 'kmb',
    'ಕಿಕುಯು'                                                                                     => 'ki',
    'ಕಿರಾಂಡೀಸ್'                                                                            => 'mwl',
    'ಕಿರ್ಜಿಝ್'                                                                               => 'ky',
    'ಕೀನ್ಯಾರುವಾಂಡಾ'                                                                => 'rw',
    'ಕುಟೇನಾಯ್'                                                                               => 'kut',
    'ಕುಮೈಕ್'                                                                                     => 'kum',
    'ಕುರುಖ್'                                                                                     => 'kru',
    'ಕುರ್ದಿಷ್'                                                                               => 'ku',
    'ಕುಷಿಟಿಕ್ಭಾಷೆ'                                                                   => 'cus',
    'ಕೃತಕಭಾಷೆ'                                                                               => 'art',
    'ಕೆಟಲಾನ್'                                                                                  => 'ca',
    'ಕೆನೆಡಿಯನ್ಇಂಗ್ಲೀಷ್'                                                    => 'en_ca',
    'ಕೆನೆಡಿಯನ್ಫ್ರೆಂಚ್'                                                       => 'fr_ca',
    'ಕೊಂಕಣಿ'                                                                                     => 'kok',
    'ಕೊಪ್ಟಿಕ್'                                                                               => 'cop',
    'ಕೊಮೊರಿಯನ್'                                                                            => 'swb',
    'ಕೊರ್ಸಿಕನ್'                                                                            => 'co',
    'ಕೊಸರಿಯನ್'                                                                               => 'kos',
    'ಕೋಮಿ'                                                                                           => 'kv',
    'ಕೋರಿಯನ್'                                                                                  => 'ko',
    'ಕೋರೋ'                                                                                           => 'kfo',
    'ಕೋರ್ನಿಷ್'                                                                               => 'kw',
    'ಕ್ಯಾಡ್ಡೋ'                                                                               => 'cad',
    'ಕ್ರಿಮೀಯನ್ಟರ್ಕಿಷ್'                                                       => 'crh',
    'ಕ್ರಿಯೋಲ್ಅಥವಾಪಿಡ್ಗಿನ್'                                           => 'crp',
    'ಕ್ರೀ'                                                                                           => 'cr',
    'ಕ್ರೀಕ್'                                                                                     => 'mus',
    'ಕ್ರು'                                                                                           => 'kro',
    'ಕ್ರೊಯೇಶಿಯನ್'                                                                      => 'hr',
    'ಕ್ಲಿಂಗೋನ್'                                                                            => 'tlh',
    'ಕ್ವಾನ್‌ಯಾಮಾ'                                                                      => 'kj',
    'ಕ್ವೆಚುವಾ'                                                                               => 'qu',
    'ಖಮೇರ್'                                                                                        => 'km',
    'ಖಾಸಿ'                                                                                           => 'kha',
    'ಖೋಇಸನ್ಭಾಷೆ'                                                                         => 'khi',
    'ಖೋಟಾನೀಸ್'                                                                               => 'kho',
    'ಗಂಡಾ'                                                                                           => 'lg',
    'ಗಾ'                                                                                                 => 'gaa',
    'ಗಾಯೋ'                                                                                           => 'gay',
    'ಗಿಲ್ಬರ್ಟೀಸ್'                                                                      => 'gil',
    'ಗೀಝ್'                                                                                           => 'gez',
    'ಗುಜರಾತಿ'                                                                                  => 'gu',
    'ಗೊಂಡಿ'                                                                                        => 'gon',
    'ಗೊರೊಂಟಾಲೋ'                                                                            => 'gor',
    'ಗೋಥಿಕ್'                                                                                     => 'got',
    'ಗೌರಾನಿ'                                                                                     => 'gn',
    'ಗ್ಬಾಯಾ'                                                                                     => 'gba',
    'ಗ್ಯಾಲಿಶಿಯನ್'                                                                      => 'gl',
    'ಗ್ರೀಕ್'                                                                                     => 'el',
    'ಗ್ರೇಬೋ'                                                                                     => 'grb',
    'ಗ್ವಿಚ್‌ಇನ್'                                                                         => 'gwi',
    'ಚಗಟಾಯ್'                                                                                     => 'chg',
    'ಚರ್ಚ್ಸ್ಲಾವಿಕ್'                                                                => 'cu',
    'ಚಾಮಿಕ್ಭಾಷೆ'                                                                         => 'cmc',
    'ಚಿನೂಕ್ಜಾರ್ಗೋನ್'                                                             => 'chn',
    'ಚಿಪೆವ್ಯಾನ್'                                                                         => 'chp',
    'ಚಿಬ್ಚಾ'                                                                                     => 'chb',
    'ಚೀಯೆನ್ನೇ'                                                                               => 'chy',
    'ಚೀರೋಕೀ'                                                                                     => 'chr',
    'ಚುವಾಶ್'                                                                                     => 'cv',
    'ಚೂಕಿಸೆ'                                                                                     => 'chk',
    'ಚೆಚನ್'                                                                                        => 'ce',
    'ಚೈನೀಸ್'                                                                                     => 'zh',
    'ಚೋಕ್ಟಾವ್'                                                                               => 'cho',
    'ಜಪಾನೀಸ್'                                                                                  => 'ja',
    'ಜರ್ಮನಿಕ್ಭಾಷೆ'                                                                   => 'gem',
    'ಜರ್ಮನ್'                                                                                     => 'de',
    'ಜವಾನೀಸ್'                                                                                  => 'jv',
    'ಜಾಝಾ'                                                                                           => 'zza',
    'ಜಾರ್ಜಿಯನ್'                                                                            => 'ka',
    'ಜೀಮಾ'                                                                                           => 'nzi',
    'ಜುಲು'                                                                                           => 'zu',
    'ಜೂಡಿಯೋಅರೇಬಿಕ್'                                                                => 'jrb',
    'ಜೂಡಿಯೋಪರ್ಶಿಯನ್'                                                             => 'jpr',
    'ಜೆಕ್'                                                                                           => 'cs',
    'ಜೋಂಗ್‌ಖಾ'                                                                               => 'dz',
    'ಜ್ಜು'                                                                                           => 'kaj',
    'ಝಂಡೇ'                                                                                           => 'znd',
    'ಝೂನಿ'                                                                                           => 'zun',
    'ಝೂವಾಂಗ್'                                                                                  => 'za',
    'ಝೆನಾಗಾ'                                                                                     => 'zen',
    'ಝೋಪೊಟೆಕ್'                                                                               => 'zap',
    'ಟಮಾಷೆಕ್'                                                                                  => 'tmh',
    'ಟರ್ಕಿಶ್'                                                                                  => 'tr',
    'ಟರ್ಕ್‌ಮೆನ್'                                                                         => 'tk',
    'ಟಾಟರ್'                                                                                        => 'tt',
    'ಟಿಬೇಟಿಯನ್'                                                                            => 'bo',
    'ಟಿಮ್ನೆ'                                                                                     => 'tem',
    'ಟಿವ್'                                                                                           => 'tiv',
    'ಟುಂಬುಕ'                                                                                     => 'tum',
    'ಟುವಾಲು'                                                                                     => 'tvl',
    'ಟುವಿನಿಯನ್'                                                                            => 'tyv',
    'ಟೂಪಿಭಾಷೆ'                                                                               => 'tup',
    'ಟೆರೆನೋ'                                                                                     => 'ter',
    'ಟೇಟಮ್'                                                                                        => 'tet',
    'ಟೈಗ್ರಿನ್ಯಾ'                                                                         => 'ti',
    'ಟೈಗ್ರೆ'                                                                                     => 'tig',
    'ಟೊಂಗಾ'                                                                                        => 'to',
    'ಟೊಕೆಲಾವ್'                                                                               => 'tkl',
    'ಟೋಕ್ಪಿಸಿನ್'                                                                         => 'tpi',
    'ಟ್ಯಾಗಲೋಗ್'                                                                            => 'tl',
    'ಟ್ಯಾಪ್'                                                                                     => 'kcg',
    'ಟ್ಲಿಂಗಿಟ್'                                                                            => 'tli',
    'ಟ್ವಿ'                                                                                           => 'tw',
    'ಡಕೋಟ'                                                                                           => 'dak',
    'ಡಚ್'                                                                                              => 'nl',
    'ಡಿಂಕಾ'                                                                                        => 'din',
    'ಡುವಾಲಾ'                                                                                     => 'dua',
    'ಡೆಲಾವೇರ್'                                                                               => 'del',
    'ಡೋಂಗಾ'                                                                                        => 'ng',
    'ಡೋಗ್ರಿ'                                                                                     => 'doi',
    'ಡೋಗ್ರಿಬ್'                                                                               => 'dgr',
    'ಡ್ಯಾನಿಶ್'                                                                               => 'da',
    'ಡ್ಯೂಲಾ'                                                                                     => 'dyu',
    'ಡ್ರಾವಿಡಿಯನ್ಭಾಷೆ'                                                          => 'dra',
    'ತಮಿಳು'                                                                                        => 'ta',
    'ತಹಿತಿಯನ್'                                                                               => 'ty',
    'ತಾಜಿಕ್'                                                                                     => 'tg',
    'ತೆಲುಗು'                                                                                     => 'te',
    'ಥಾಯಿ'                                                                                           => 'th',
    'ಥಾಯ್ಭಾಷೆ'                                                                               => 'tai',
    'ದಕ್ಷಿಣಅಮೇರಿಕದಇಂಡಿಯನ್ಭಾಷೆ'                               => 'sai',
    'ದಕ್ಷಿಣಅಲ್ಟಾಯ್'                                                                => 'alt',
    'ದಕ್ಷಿಣದೆಬೆಲೆ'                                                                   => 'nr',
    'ದಕ್ಷಿಣಸಾಮಿ'                                                                         => 'sma',
    'ದಕ್ಷಿಣಸೋಥೋ'                                                                         => 'st',
    'ದರ್ಗ್ವಾ'                                                                                  => 'dar',
    'ದಾಯಕ್'                                                                                        => 'day',
    'ದಿವೆಹಿ'                                                                                     => 'dv',
    'ನವಾಜೊ'                                                                                        => 'nv',
    'ನಹೌಟಿ'                                                                                        => 'nah',
    'ನಾರ್ವೇಜಿಯನ್'                                                                      => 'no',
    'ನಾರ್ವೇಜಿಯನ್ನೂನಾರ್ಸ್ಕ್'                                        => 'nn',
    'ನಿಯಾಪೊಲಿಟನ್'                                                                      => 'nap',
    'ನಿಯಾಸ್'                                                                                     => 'nia',
    'ನಿಯುವನ್'                                                                                  => 'niu',
    'ನಿಲೋಸಹಾರನ್ಭಾಷೆ'                                                             => 'ssa',
    'ನುಬಿಯನ್ಭಾಷೆ'                                                                      => 'nub',
    'ನೇಪಾಳಿ'                                                                                     => 'ne',
    'ನೇವಾರೀ'                                                                                     => 'new',
    'ನೈಗರ್ಕೊರ್ಡೊಫನಿಯನ್ಭಾಷೆ'                                        => 'nic',
    'ನೊಗಾಯ್'                                                                                     => 'nog',
    'ನೋರ್ವೇಜಿಯನ್ಬೊಕ್ಮಲ್'                                                 => 'nb',
    'ನೌರು'                                                                                           => 'na',
    'ನ್ಯಾಂಜಾ'                                                                                  => 'ny',
    'ನ್ಯಾನ್‌ಕೋಲೆ'                                                                      => 'nyn',
    'ನ್ಯಾಮ್‌ವೆಂಜಿ'                                                                   => 'nym',
    'ನ್ಯಾಸಾಟೋಂಗಾ'                                                                      => 'tog',
    'ನ್ಯೋರೋ'                                                                                     => 'nyo',
    'ಪಂಗಾಸಿನನ್'                                                                            => 'pag',
    'ಪಂಜಾಬಿ'                                                                                     => 'pa',
    'ಪಂಪಾಂಗಾ'                                                                                  => 'pam',
    'ಪಪುವನ್ಭಾಷೆ'                                                                         => 'paa',
    'ಪರ್ಶಿಯನ್'                                                                               => 'fa',
    'ಪಲುಆನ್'                                                                                     => 'pau',
    'ಪಶ್ಚಿಮಫ್ರಿಸಿಯನ್'                                                          => 'fy',
    'ಪಹ್ಲವಿ'                                                                                     => 'pal',
    'ಪಾಪಿಯಮೆಂಟೋ'                                                                         => 'pap',
    'ಪಾಲಿ'                                                                                           => 'pi',
    'ಪುಶ್ತೋ'                                                                                     => 'ps',
    'ಪೂರ್ವಫ್ರಿಸಿಯನ್'                                                             => 'frs',
    'ಪೋನ್‌‌ಪಿಯನ್'                                                                      => 'pon',
    'ಪೋರ್ಚುಗೀಸ್'                                                                         => 'pt',
    'ಪೋರ್ಚುಗೀಸ್ಮೂಲದಕ್ರಿಯೋಲ್ಅಥವಾಪಿಡ್ಗಿನ್' => 'cpp',
    'ಪೋಲಿಶ್'                                                                                     => 'pl',
    'ಪ್ರಾಕೃತ್ಭಾಷೆ'                                                                   => 'pra',
    'ಪ್ರಾಚೀನಇಂಗ್ಲೀಷ್'                                                          => 'ang',
    'ಪ್ರಾಚೀನಈಜಿಪ್ಟಿಯನ್'                                                    => 'egy',
    'ಪ್ರಾಚೀನಐರಿಷ್'                                                                   => 'sga',
    'ಪ್ರಾಚೀನಗ್ರೀಕ್'                                                                => 'grc',
    'ಪ್ರಾಚೀನನೋರ್ಸ್'                                                                => 'non',
    'ಪ್ರಾಚೀನಪರ್ಶಿಯನ್'                                                          => 'peo',
    'ಪ್ರಾಚೀನಪ್ರೊವೆನ್ಶಿಯಲ್'                                           => 'pro',
    'ಪ್ರಾಚೀನಫ್ರೆಂಚ್'                                                             => 'fro',
    'ಪ್ರಾಚೀನಹೈಜರ್ಮನ್'                                                          => 'goh',
    'ಫರೋಸಿ'                                                                                        => 'fo',
    'ಫಾಂಟಿ'                                                                                        => 'fat',
    'ಫಿಜಿಯನ್'                                                                                  => 'fj',
    'ಫಿನ್ನಿಶ್'                                                                               => 'fi',
    'ಫಿನ್ನೋಉಗ್ರಿಯನ್ಭಾಷೆ'                                                 => 'fiu',
    'ಫಿಲಿಪಿನೊ'                                                                               => 'fil',
    'ಫಿಲಿಫೈನ್ಭಾಷೆ'                                                                   => 'phi',
    'ಫೀನಿಷಿಯನ್'                                                                            => 'phn',
    'ಫುಲಾಹ್'                                                                                     => 'ff',
    'ಫೆಂಗ್'                                                                                        => 'fan',
    'ಫೋನ್'                                                                                           => 'fon',
    'ಫ್ರಿಯುಲಿಯನ್'                                                                      => 'fur',
    'ಫ್ರೆಂಚ್'                                                                                  => 'fr',
    'ಫ್ರೆಂಚ್ಮೂಲದಕ್ರಿಯೋಲ್ಅಥವಾಪಿಡ್ಗಿನ್'          => 'cpf',
    'ಫ್ಲೆಮಿಷ್'                                                                               => 'nl_be',
    'ಬಂಟು'                                                                                           => 'bnt',
    'ಬಂಬಾರಾ'                                                                                     => 'bm',
    'ಬಟಾಕ್'                                                                                        => 'btk',
    'ಬಮಿಲೇಕೆಭಾಷೆ'                                                                      => 'bai',
    'ಬರ್ಮೀಸ್'                                                                                  => 'my',
    'ಬಲಿನೀಸ್'                                                                                  => 'ban',
    'ಬಲೂಚಿ'                                                                                        => 'bal',
    'ಬಲ್ಗೇರಿಯನ್'                                                                         => 'bg',
    'ಬಶ್ಕಿರ್'                                                                                  => 'ba',
    'ಬಸಾ'                                                                                              => 'bas',
    'ಬಹುಸಂಖ್ಯೆಯಭಾಷೆಗಳು'                                                    => 'mul',
    'ಬಾಂಡಾ'                                                                                        => 'bad',
    'ಬಾಲ್ಟಿಕ್ಭಾಷೆ'                                                                   => 'bat',
    'ಬಾಸ್ಕ್'                                                                                     => 'eu',
    'ಬಿಕೊಲ್'                                                                                     => 'bik',
    'ಬಿನಿ'                                                                                           => 'bin',
    'ಬಿಸ್ಲಾಮಾ'                                                                               => 'bi',
    'ಬಿಹಾರಿ'                                                                                     => 'bh',
    'ಬುಗಿನೀಸ್'                                                                               => 'bug',
    'ಬುರಿಯಟ್'                                                                                  => 'bua',
    'ಬೆಂಗಾಲಿ'                                                                                  => 'bn',
    'ಬೆಂಬಾ'                                                                                        => 'bem',
    'ಬೆರ್ಬರ್'                                                                                  => 'ber',
    'ಬೆಲರೂಸಿಯನ್'                                                                         => 'be',
    'ಬೇಜಾ'                                                                                           => 'bej',
    'ಬೋಸ್ನಿಯನ್'                                                                            => 'bs',
    'ಬ್ರಾಜ್'                                                                                     => 'bra',
    'ಬ್ರಿಟಿಷ್ಇಂಗ್ಲೀಷ್'                                                       => 'en_gb',
    'ಬ್ರೆಜಿಲಿಯನ್ಪೋರ್ಚುಗೀಸ್'                                        => 'pt_br',
    'ಬ್ರೆಟನ್'                                                                                  => 'br',
    'ಬ್ಲಿನ್'                                                                                     => 'byn',
    'ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್'                                                          => 'zbl',
    'ಭಾರತೀಯಭಾಷೆ'                                                                         => 'inc',
    'ಭೋಜಪುರಿ'                                                                                  => 'bho',
    'ಮಂಗೋಲಿಯನ್'                                                                            => 'mn',
    'ಮಂಚು'                                                                                           => 'mnc',
    'ಮಂಡಿಂಗೊ'                                                                                  => 'man',
    'ಮಂದಾರ್'                                                                                     => 'mdr',
    'ಮಕಾಸರ್'                                                                                     => 'mak',
    'ಮಗಾಹಿ'                                                                                        => 'mag',
    'ಮಣಿಪುರಿ'                                                                                  => 'mni',
    'ಮದುರೀಸ್'                                                                                  => 'mad',
    'ಮಧ್ಯಅಮೇರಿಕನ್ಇಂಡಿಯನ್ಭಾಷೆ'                                  => 'cai',
    'ಮಧ್ಯಇಂಗ್ಲೀಷ್'                                                                   => 'enm',
    'ಮಧ್ಯಐರಿಷ್'                                                                            => 'mga',
    'ಮಧ್ಯಡಚ್'                                                                                  => 'dum',
    'ಮಧ್ಯಫ್ರೆಂಚ್'                                                                      => 'frm',
    'ಮಧ್ಯಹೈಜರ್ಮನ್'                                                                   => 'gmh',
    'ಮನೋಬೋಭಾಷೆ'                                                                            => 'mno',
    'ಮಯನ್ಭಾಷೆ'                                                                               => 'myn',
    'ಮರಾಠಿ'                                                                                        => 'mr',
    'ಮಲಗಾಸಿ'                                                                                     => 'mg',
    'ಮಲಯ'                                                                                              => 'ms',
    'ಮಲೆಯಾಳಂ'                                                                                  => 'ml',
    'ಮಸಾಯ್'                                                                                        => 'mas',
    'ಮಾರಿ'                                                                                           => 'chm',
    'ಮಾರ್ವಾಡಿ'                                                                               => 'mwr',
    'ಮಾರ್ಶಲ್ಲೀಸ್'                                                                      => 'mh',
    'ಮಾಲ್ಟೀಸ್'                                                                               => 'mt',
    'ಮಾಲ್ಡೀವಿಯನ್'                                                                      => 'mo',
    'ಮಾವೋರಿ'                                                                                     => 'mi',
    'ಮಿಕ್‌ಮ್ಯಾಕ್'                                                                      => 'mic',
    'ಮಿನಂಗ್‌ಕಬಾವು'                                                                   => 'min',
    'ಮುಂಡಾಭಾಷೆ'                                                                            => 'mun',
    'ಮೆಂಡೆ'                                                                                        => 'men',
    'ಮೆಸಿಡೋನಿಯನ್'                                                                      => 'mk',
    'ಮೈಥಿಲಿ'                                                                                     => 'mai',
    'ಮೊಂಗೋ'                                                                                        => 'lol',
    'ಮೊಸ್ಸಿ'                                                                                     => 'mos',
    'ಮೊಹಾವ್ಕ್'                                                                               => 'moh',
    'ಮೋಂಗ್'                                                                                        => 'hmn',
    'ಮೋಕ್ಷ'                                                                                        => 'mdf',
    'ಮೋನ್ಖಮೇರ್ಭಾಷೆ'                                                                => 'mkh',
    'ಮ್ಯಾಂಕ್ಸ್'                                                                            => 'gv',
    'ಯಪೀಸೆ'                                                                                        => 'yap',
    'ಯಾಓ'                                                                                              => 'yao',
    'ಯಾಕುಟ್'                                                                                     => 'sah',
    'ಯಾವುದೇಭಾಷಾಸಂಬಂಧಿವಿಷಯವಿಲ್ಲ'                            => 'zxx',
    'ಯಿಡ್ಡಿಷ್'                                                                               => 'yi',
    "ಯು\.ಎಸ್\.ಇಂಗ್ಲೀಷ್"                                                            => 'en_us',
    'ಯೂಪಿಕ್ಭಾಷೆ'                                                                         => 'ypk',
    'ಯೊರುಬಾ'                                                                                     => 'yo',
    'ರಶಿಯನ್'                                                                                     => 'ru',
    'ರಹೇಟೋರೋಮ್ಯಾನ್ಸ್'                                                          => 'rm',
    'ರಾಜಾಸ್ಥಾನಿ'                                                                         => 'raj',
    'ರಾಪಾನುಯಿ'                                                                               => 'rap',
    'ರಾರೋಟೊಂಗನ್'                                                                         => 'rar',
    'ರುಂಡಿ'                                                                                        => 'rn',
    'ರೊಮ್ಯಾನಿಯನ್'                                                                      => 'ro',
    'ರೋಮನ್ಭಾಷೆ'                                                                            => 'roa',
    'ರೋಮಾನಿ'                                                                                     => 'rom',
    'ಲಂಬಾ'                                                                                           => 'lam',
    'ಲಕ್ಸಂಬರ್ಗ್'                                                                         => 'lb',
    'ಲಟ್ವಿಯನ್'                                                                               => 'lv',
    'ಲಹಂಡಾ'                                                                                        => 'lah',
    'ಲಾವೋ'                                                                                           => 'lo',
    'ಲಿಂಗಾಲ'                                                                                     => 'ln',
    'ಲಿಂಬರ್ಗಿಶ್'                                                                         => 'li',
    'ಲಿಥುವೇನಿಯನ್'                                                                      => 'lt',
    'ಲುಂಡಾ'                                                                                        => 'lun',
    'ಲುವೋ'                                                                                           => 'luo',
    'ಲುಶಾಯ್'                                                                                     => 'lus',
    'ಲೂಬಾಕಟಾಂಗಾ'                                                                         => 'lu',
    'ಲೂಬಾಲುಲುಆ'                                                                            => 'lua',
    'ಲೂಯಿಸೆನೋ'                                                                               => 'lui',
    'ಲೂಲ್ಸಾಮಿ'                                                                               => 'smj',
    'ಲೆಜ್ಘಿಯನ್'                                                                            => 'lez',
    'ಲೊಜ್ಬಾನ್'                                                                               => 'jbo',
    'ಲೋಜರ್ಮನ್'                                                                               => 'nds',
    'ಲೋಜಿ'                                                                                           => 'loz',
    'ಲೋವರ್ಸೋರ್ಬಿಯನ್'                                                             => 'dsb',
    'ಲ್ಯಾಟಿನ್'                                                                               => 'la',
    'ವರಾಯ್'                                                                                        => 'war',
    'ವಲಾಮೋ'                                                                                        => 'wal',
    'ವಾಕಾಷನ್ಭಾಷೆ'                                                                      => 'wak',
    'ವಾಯಿ'                                                                                           => 'vai',
    'ವಾಲೂನ್'                                                                                     => 'wa',
    'ವಾಷೋ'                                                                                           => 'was',
    'ವಿಗರ್‌'                                                                                     => 'ug',
    'ವಿಯೇಟ್ನಾಮೀಸ್'                                                                   => 'vi',
    'ವೆಂಡಾ'                                                                                        => 've',
    'ವೆಲ್ಶ್'                                                                                     => 'cy',
    'ವೋಟಿಕ್'                                                                                     => 'vot',
    'ವೋಲಾಪುಕ್'                                                                               => 'vo',
    'ವೋಲೋಫ್'                                                                                     => 'wo',
    'ಶಾನ್'                                                                                           => 'shn',
    'ಶಾಸ್ತ್ರೀಯನೇವಾರಿ'                                                          => 'nwc',
    'ಶಾಸ್ತ್ರೀಯಸಿರಿಯಕ್'                                                       => 'syc',
    'ಶೋನಾ'                                                                                           => 'sn',
    'ಷೋಸಾ'                                                                                           => 'xh',
    'ಸಂಜ್ಞಾಭಾಷೆ'                                                                         => 'sgn',
    'ಸಂಡಾವೇ'                                                                                     => 'sad',
    'ಸಂತಾಲಿ'                                                                                     => 'sat',
    'ಸಂಸ್ಕೃತ'                                                                                  => 'sa',
    'ಸಮರಿಟನ್ಅರಾಮಿಕ್'                                                             => 'sam',
    'ಸಮೋವನ್'                                                                                     => 'sm',
    'ಸಮ್ಮಿಶ್ರಭಾಷೆ'                                                                   => 'mis',
    'ಸರ್ಡೀನಿಯನ್'                                                                         => 'sc',
    'ಸರ್ಬಿಯನ್'                                                                               => 'sr',
    'ಸರ್ಬೋಕ್ರೊಯೇಶಿಯನ್'                                                       => 'sh',
    'ಸಲಿಷನ್ಭಾಷೆ'                                                                         => 'sal',
    'ಸಸಾಕ್'                                                                                        => 'sas',
    'ಸಾಂಗೋ'                                                                                        => 'sg',
    'ಸಾಮಿಭಾಷೆ'                                                                               => 'smi',
    'ಸಿಂಧಿ'                                                                                        => 'sd',
    'ಸಿಂಶಿಯನ್'                                                                               => 'tsi',
    'ಸಿಂಹಳ'                                                                                        => 'si',
    'ಸಿಕ್ಸಿಕಾ'                                                                               => 'bla',
    'ಸಿಚುಅನ್ಯಿ'                                                                            => 'ii',
    'ಸಿಡಾಮೋ'                                                                                     => 'sid',
    'ಸಿರಿಯಕ್'                                                                                  => 'syr',
    'ಸಿವುಅನ್ಭಾಷೆ'                                                                      => 'sio',
    'ಸಿಸಿಲಿಯನ್'                                                                            => 'scn',
    'ಸುಂಡಾನೀಸ್'                                                                            => 'su',
    'ಸುಕುಮಾ'                                                                                     => 'suk',
    'ಸುಮೇರಿಯನ್'                                                                            => 'sux',
    'ಸುಸು'                                                                                           => 'sus',
    'ಸೆಬುಆನೋ'                                                                                  => 'ceb',
    'ಸೆಮಿಟಿಕ್ಭಾಷೆ'                                                                   => 'sem',
    'ಸೆಲ್ಕಪ್'                                                                                  => 'sel',
    'ಸೆಲ್ಟಿಕ್ಭಾಷೆ'                                                                   => 'cel',
    'ಸೇರೇರ್'                                                                                     => 'srr',
    'ಸೈನೋಟಿಬೇಟಿಯನ್ಭಾಷೆ'                                                    => 'sit',
    'ಸೋಂಗಾ'                                                                                        => 'ts',
    'ಸೋಂಘಾಯ್'                                                                                  => 'son',
    'ಸೋಗ್ಡಿಏನ್'                                                                            => 'sog',
    'ಸೋನಿಂಕೆ'                                                                                  => 'snk',
    'ಸೋಮಾಲಿ'                                                                                     => 'so',
    'ಸೋರ್ಬಿಯನ್ಭಾಷೆ'                                                                => 'wen',
    'ಸ್ಕಾಟಿಶ್ಗ್ಯಾಲಿಕ್'                                                       => 'gd',
    'ಸ್ಕೋಟ್ಸಾಮಿ'                                                                         => 'sms',
    'ಸ್ಕೋಟ್ಸ್'                                                                               => 'sco',
    'ಸ್ಪ್ಯಾನಿಷ್'                                                                         => 'es',
    'ಸ್ರಾನನ್ಟೋಂಗೋ'                                                                   => 'srn',
    'ಸ್ಲಾವಿಕ್ಭಾಷೆ'                                                                   => 'sla',
    'ಸ್ಲೇವ್'                                                                                     => 'den',
    'ಸ್ಲೋವಾಕ್'                                                                               => 'sk',
    'ಸ್ಲೋವೇನಿಯನ್'                                                                      => 'sl',
    'ಸ್ವಹಿಲಿ'                                                                                  => 'sw',
    'ಸ್ವಾತಿ'                                                                                     => 'ss',
    'ಸ್ವಾನಾ'                                                                                     => 'tn',
    'ಸ್ವಿಸ್ಜರ್ಮನ್'                                                                   => 'gsw',
    'ಸ್ವಿಸ್ಫ್ರೆಂಚ್'                                                                => 'fr_ch',
    'ಸ್ವಿಸ್ಹೈಜರ್ಮನ್'                                                             => 'de_ch',
    'ಸ್ವೀಡಿಷ್'                                                                               => 'sv',
    'ಹಂಗೇರಿಯನ್'                                                                            => 'hu',
    'ಹವಾಯಿಯನ್'                                                                               => 'haw',
    'ಹಿಂದಿ'                                                                                        => 'hi',
    'ಹಿಟ್ಟಿಟೆ'                                                                               => 'hit',
    'ಹಿಮಾಚಲಿ'                                                                                  => 'him',
    'ಹಿರಿಮೊಟು'                                                                               => 'ho',
    'ಹಿಲಿಗೇನನ್'                                                                            => 'hil',
    'ಹೀಬ್ರ್ಯೂ'                                                                               => 'he',
    'ಹೂಪಾ'                                                                                           => 'hup',
    'ಹೆರೆರೊ'                                                                                     => 'hz',
    'ಹೈಡಾ'                                                                                           => 'hai',
    'ಹೈತಿಯನ್'                                                                                  => 'ht',
    'ಹೌಸಾ'                                                                                           => 'ha',
);

1;
