#!perl

BEGIN {
  unless ($ENV{RELEASE_TESTING}) {
    require Test::More;
    Test::More::plan(skip_all => 'these tests are for release candidate testing');
  }
}

# This file was automatically generated by Dist::Zilla::Plugin::Test::Pod::Coverage::Configurable.

use Test::Pod::Coverage 1.08;
use Test::More 0.88;

BEGIN {
    if ( $] <= 5.008008 ) {
        plan skip_all => 'These tests require Pod::Coverage::TrustPod, which only works with Perl 5.8.9+';
    }
}
use Pod::Coverage::TrustPod;

my %skip = map { $_ => 1 } qw( DateTime::Helpers DateTime::PP DateTime::PPExtra );

my @modules;
for my $module ( all_modules() ) {
    next if $skip{$module};

    push @modules, $module;
}

plan skip_all => 'All the modules we found were excluded from POD coverage test.'
    unless @modules;

plan tests => scalar @modules;

my %trustme = (
             'DateTime' => [
                           qr/0$/,
                           qr/^STORABLE/,
                           qr/^utc_year$/,
                           qr/^timegm$/,
                           qr/^day_of_month$/,
                           qr/^doq$/,
                           qr/^dow$/,
                           qr/^doy$/,
                           qr/^iso8601$/,
                           qr/^local_rd_as_seconds$/,
                           qr/^mday$/,
                           qr/^min$/,
                           qr/^mon$/,
                           qr/^sec$/,
                           qr/^wday$/,
                           qr/^DefaultLanguage$/,
                           qr/^era$/,
                           qr/^language$/
                         ],
             'DateTime::Infinite' => [
                                     qr/^.+$/
                                   ]
           );

my @also_private;

for my $module ( sort @modules ) {
    pod_coverage_ok(
        $module,
        {
            coverage_class => 'Pod::Coverage::TrustPod',
            also_private   => \@also_private,
            trustme        => $trustme{$module} || [],
        },
        "pod coverage for $module"
    );
}

done_testing();
