#!/usr/bin/env perl

use strictures 1;
use SiteSpy;
use Test::More;

my $olde = <<OLDE;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div id='hello'>
        <p>
            hello!
            </p>
        </div>
    </body>
</html>
OLDE

my $new = <<NEW;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <div id='hello'>
        <p>
            world
        </p>
        </div>
    </body>
</html>
NEW

my $ss = SiteSpy->new({
        old_HTML  => $olde,
        new_HTML  => $new,
        args      =>
            {
                id => 'hello',
            },
    });

is_deeply $ss->find_diffs->added, ['world'];
$new = <<NEW;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <p>Something that should not matter</p>
        <div id='hello'>
        <p>
            hello!
        </p>
        </div>
    </body>
</html>
NEW

$ss = SiteSpy->new({
        old_HTML  => $olde,
        new_HTML  => $new,
        args      =>
            {
                id => 'hello',
            },
    });

ok !$ss->find_diffs->count;


$new = <<NEW;
<html>
    <head>
        <title></title>
    </head>
    <body>
        <p>Something that should not matter</p>
        <div id='hello'>
        <p>
            hello!
            <span>world!</span>
        </p>
        </div>
    </body>
</html>
NEW

$ss = SiteSpy->new({
        old_HTML  => $olde,
        new_HTML  => $new,
        args      =>
            {
                id => 'hello',
            },
    });

is_deeply $ss->find_diffs->added, ['hello! world!'];


done_testing;
