use strict;
use Test::More 0.98;

use_ok 'GraphQL::Plugin::Convert::OpenAPI';

my $expected = join '', <DATA>;
my $converted = GraphQL::Plugin::Convert::OpenAPI->to_graphql(
  't/petstore-expanded.json'
);
my $got = $converted->{schema}->to_doc;
#open my $fh, '>', 'tf'; print $fh $got; # uncomment to regenerate
is $got, $expected;

done_testing;

__DATA__
type Error {
  code: Int!
  message: String!
}

type Mutation {
  # Creates a new pet in the store.  Duplicates are allowed
  addPet(pet: NewPetInput!): Pet
  # deletes a single pet based on the ID supplied
  deletePet(id: Int!): String
}

type NewPet {
  name: String!
  tag: String
}

input NewPetInput {
  name: String!
  tag: String
}

type Pet {
  id: Int!
  name: String!
  tag: String
}

type Query {
  # Returns all pets from the system that the user has access to
  # Nam sed condimentum est. Maecenas tempor sagittis sapien, nec rhoncus sem sagittis sit amet. Aenean at gravida augue, ac iaculis sem. Curabitur odio lorem, ornare eget elementum nec, cursus id lectus. Duis mi turpis, pulvinar ac eros ac, tincidunt varius justo. In hac habitasse platea dictumst. Integer at adipiscing ante, a sagittis ligula. Aenean pharetra tempor ante molestie imperdiet. Vivamus id aliquam diam. Cras quis velit non tortor eleifend sagittis. Praesent at enim pharetra urna volutpat venenatis eget eget mauris. In eleifend fermentum facilisis. Praesent enim enim, gravida ac sodales sed, placerat id erat. Suspendisse lacus dolor, consectetur non augue vel, vehicula interdum libero. Morbi euismod sagittis libero sed lacinia.
  #
  # Sed tempus felis lobortis leo pulvinar rutrum. Nam mattis velit nisl, eu condimentum ligula luctus nec. Phasellus semper velit eget aliquet faucibus. In a mattis elit. Phasellus vel urna viverra, condimentum lorem id, rhoncus nibh. Ut pellentesque posuere elementum. Sed a varius odio. Morbi rhoncus ligula libero, vel eleifend nunc tristique vitae. Fusce et sem dui. Aenean nec scelerisque tortor. Fusce malesuada accumsan magna vel tempus. Quisque mollis felis eu dolor tristique, sit amet auctor felis gravida. Sed libero lorem, molestie sed nisl in, accumsan tempor nisi. Fusce sollicitudin massa ut lacinia mattis. Sed vel eleifend lorem. Pellentesque vitae felis pretium, pulvinar elit eu, euismod sapien.
  findPets(limit: Int, tags: [String]): [Pet]
  # Returns a user based on a single ID, if the user does not have access to the pet
  findpetbyid(id: Int!): Pet
}
