#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 118 => 'absPeakAudioFilePath' },
	'actionadvised' => { 43 => 0x2a },
	'activearea' => { 39 => 0xc68d },
	'addoriginaldecisiondata' => { 20 => 0x11, 21 => 0x13, 24 => 0x14 },
	'address' => { 56 => 'Address' },
	'adjustmentmode' => { 105 => 0x15 },
	'advancedraw' => { 83 => 0x76a43203 },
	'advisory' => { 116 => 'Advisory' },
	'aebbracketvalue' => { 17 => 0x11 },
	'aebsequence' => { 18 => 0x9, 19 => 0x9, 20 => 0x8, 21 => 0x9, 24 => 0x9, 25 => 0x7 },
	'aelock' => { 89 => 0x201 },
	'aesetting' => { 1 => 0x21 },
	'afareas' => { 89 => 0x304 },
	'afassist' => { 18 => 0x5, 25 => 0x5 },
	'afassistbeam' => { 20 => 0x4, 21 => 0x5, 22 => 0x4, 23 => 0x4, 24 => 0x5 },
	'afmode' => { 70 => 0x0, 105 => 0x5 },
	'afpoint' => { 1 => 0x13, 36 => 0x18, 70 => 0x1 },
	'afpointactivationarea' => { 19 => 0x11, 24 => 0x11 },
	'afpointillumination' => { 19 => 0xa },
	'afpointregistration' => { 18 => 0x7 },
	'afpoints' => { 65 => 0x10 },
	'afpointselection' => { 19 => 0xb },
	'afpointselectionmethod' => { 20 => 0xc, 21 => 0xd, 24 => 0xd },
	'afpointspotmetering' => { 19 => 0xd },
	'afpointsused' => { 14 => [0x16,0x1a], 70 => 0x2 },
	'afpointsused2' => { 17 => 0xe },
	'afpointsused5d' => { 0 => 0x38 },
	'afresponse' => { 75 => 0xad },
	'afsearch' => { 89 => 0x303 },
	'aiservotrackingsensitivity' => { 19 => 0x14 },
	'album' => { 118 => 'album' },
	'alttapename' => { 118 => 'altTapeName' },
	'alttimecodetimeformat' => { 118 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 118 => 'altTimecodeTimeValue' },
	'analogzoom' => { 49 => 0x1e, 52 => 'AnalogZoom' },
	'antialiasstrength' => { 39 => 0xc632 },
	'aperturevalue' => { 39 => 0x9202, 93 => 0x1002, 111 => 'ApertureValue' },
	'applicationrecordversion' => { 43 => 0x0 },
	'armidentifier' => { 44 => 0x78 },
	'armversion' => { 44 => 0x7a },
	'artist' => { 39 => 0x13b, 95 => 'Artist', 115 => 'Artist', 118 => 'artist' },
	'asshotwhitexy' => { 39 => 0xc629 },
	'assistbuttonfunction' => { 18 => 0xd },
	'audio' => { 96 => 0x20 },
	'audiochanneltype' => { 118 => 'audioChannelType' },
	'audiocompression' => { 51 => 'Compression' },
	'audiocompressor' => { 118 => 'audioCompressor' },
	'audioduration' => { 43 => 0x99 },
	'audiomoddate' => { 118 => 'audioModDate' },
	'audiooutcue' => { 43 => 0x9a },
	'audiosamplerate' => { 118 => 'audioSampleRate' },
	'audiosampletype' => { 118 => 'audioSampleType' },
	'audiosamplingrate' => { 43 => 0x97 },
	'audiosamplingresolution' => { 43 => 0x98 },
	'audiotype' => { 43 => 0x96 },
	'author' => { 53 => 'Author', 95 => 'Author', 101 => 'Author', 113 => 'Author' },
	'authorsposition' => { 114 => 'AuthorsPosition' },
	'autoafpoint' => { 97 => 0xf },
	'autobracket' => { 105 => 0x19 },
	'autobracketing' => { 41 => 0x1100 },
	'autobracketrelease' => { 75 => 0x8a },
	'autobrightness' => { 108 => 'AutoBrightness' },
	'autocontrast' => { 108 => 'AutoContrast' },
	'autoexposure' => { 108 => 'AutoExposure' },
	'autoexposurebracketing' => { 17 => 0x10 },
	'autofocus' => { 91 => 0x209 },
	'autoiso' => { 17 => 0x1, 37 => 0x3008 },
	'autorotate' => { 17 => 0x1b },
	'autoshadows' => { 108 => 'AutoShadows' },
	'auxiliarylens' => { 75 => 0x82 },
	'avvalue' => { 28 => 0x2 },
	'baseiso' => { 17 => 0x2, 32 => 0x101c },
	'baselineexposure' => { 39 => 0xc62a },
	'baselinenoise' => { 39 => 0xc62b },
	'baselinesharpness' => { 39 => 0xc62c },
	'baseurl' => { 116 => 'BaseURL' },
	'bayergreensplit' => { 39 => 0xc62d },
	'bayerpattern' => { 67 => 0x17 },
	'beatspliceparamsriseindecibel' => { 118 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 118 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 118 => 'beatSpliceParamsUseFileBeatsMarker' },
	'bestqualityscale' => { 39 => 0xc65c },
	'bestshotmode' => { 37 => 0x3007 },
	'bitdepth' => { 57 => 'BitDepth', 67 => 0x11 },
	'bitspercomponent' => { 45 => 0x87 },
	'bitspersample' => { 39 => 0x102, 115 => 'BitsPerSample' },
	'blacklevel' => { 93 => 0x1012 },
	'blackpoint' => { 97 => 0x200 },
	'bluebalance' => { 52 => 'BlueBalance', 93 => 0x1018, 97 => 0x1b },
	'bluehue' => { 108 => 'BlueHue' },
	'bluesaturation' => { 108 => 'BlueSaturation' },
	'blurwarning' => { 41 => 0x1300 },
	'bodyfirmwareversion' => { 90 => 0x104 },
	'bracketmode' => { 8 => 0x3 },
	'bracketsequence' => { 37 => 0x301d },
	'bracketshotnumber' => { 8 => 0x5 },
	'bracketstep' => { 63 => 0xe },
	'bracketvalue' => { 8 => 0x4 },
	'brightness' => { 39 => 0xfe53, 52 => 'Brightness', 63 => 0x2c, 108 => 'Brightness' },
	'brightnessadj' => { 78 => 0x0 },
	'brightnessvalue' => { 39 => 0x9203, 93 => 0x1003, 111 => 'BrightnessValue' },
	'bulbduration' => { 17 => 0x18 },
	'burstmode' => { 47 => 0xa, 96 => 0x2a },
	'burstmode2' => { 47 => 0x18 },
	'bwfilter' => { 63 => 0x2a, 68 => 0x39 },
	'bwmode' => { 93 => 0x203 },
	'by-line' => { 43 => 0x50 },
	'by-linetitle' => { 43 => 0x55 },
	'calibrationilluminant1' => { 39 => 0xc65a },
	'calibrationilluminant2' => { 39 => 0xc65b },
	'cameraid' => { 93 => 0x209, 104 => 0x209 },
	'cameraiso' => { 1 => 0x10 },
	'cameraprofile' => { 108 => 'CameraProfile' },
	'cameraserialnumber' => { 39 => 0xc62f },
	'camerasettingsversion' => { 89 => 0x0 },
	'cameratype' => { 17 => 0x1a, 93 => 0x207 },
	'cameratype2' => { 90 => 0x100 },
	'canonexposuremode' => { 1 => 0x14 },
	'canonfiledescription' => { 32 => 0x805 },
	'canonfilelength' => { 11 => 0xe },
	'canonfirmwareversion' => { 11 => 0x7, 32 => 0x80b },
	'canonflashinfo' => { 32 => 0x1028 },
	'canonflashmode' => { 1 => 0x4 },
	'canonimageheight' => { 14 => 0x3 },
	'canonimageheightasshot' => { 14 => 0x5 },
	'canonimagesize' => { 1 => 0xa },
	'canonimagetype' => { 11 => 0x6, 32 => 0x815 },
	'canonimagewidth' => { 14 => 0x2 },
	'canonimagewidthasshot' => { 14 => 0x4 },
	'canonmodelid' => { 11 => 0x10 },
	'caption-abstract' => { 43 => 0x78 },
	'captionwriter' => { 114 => 'CaptionWriter' },
	'casioimagesize' => { 37 => 0x9 },
	'category' => { 43 => 0xf, 114 => 'Category' },
	'ccdisosensitivity' => { 37 => 0x3014 },
	'ccdscanmode' => { 93 => 0x1039 },
	'ccdsensitivity' => { 36 => 0x14, 77 => 0x6 },
	'celllength' => { 39 => 0x109 },
	'cellwidth' => { 39 => 0x108 },
	'certificate' => { 121 => 'Certificate' },
	'cfapattern' => { 39 => 0xa302 },
	'cfapatterncolumns' => { 111 => 'CFAPatternColumns' },
	'cfapatternrows' => { 111 => 'CFAPatternRows' },
	'cfapatternvalues' => { 111 => 'CFAPatternValues' },
	'channels' => { 51 => 'Channels' },
	'chromablurradius' => { 39 => 0xc631 },
	'chromaticaberrationb' => { 108 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 108 => 'ChromaticAberrationR' },
	'city' => { 43 => 0x5a, 56 => 'City', 114 => 'City' },
	'classifystate' => { 43 => 0xe1 },
	'codec' => { 62 => 'Codec' },
	'codedcharacterset' => { 44 => 0x5a },
	'coloraberrationcontrol' => { 83 => 0xc89224b },
	'coloradjustment' => { 105 => 0x14 },
	'coloradjustmentmode' => { 104 => 0x210 },
	'colorantsa' => { 122 => 'ColorantsA' },
	'colorantsb' => { 122 => 'ColorantsB' },
	'colorantsblack' => { 122 => 'ColorantsBlack' },
	'colorantsblue' => { 122 => 'ColorantsBlue' },
	'colorantscyan' => { 122 => 'ColorantsCyan' },
	'colorantsgreen' => { 122 => 'ColorantsGreen' },
	'colorantsl' => { 122 => 'ColorantsL' },
	'colorantsmagenta' => { 122 => 'ColorantsMagenta' },
	'colorantsmode' => { 122 => 'ColorantsMode' },
	'colorantsred' => { 122 => 'ColorantsRed' },
	'colorantsswatchname' => { 122 => 'ColorantsSwatchName' },
	'colorantstype' => { 122 => 'ColorantsType' },
	'colorantsyellow' => { 122 => 'ColorantsYellow' },
	'colorbalance1' => { 75 => 0xc },
	'colorbalanceadj' => { 83 => 0x76a43202 },
	'colorbalanceblue' => { 63 => 0x1e },
	'colorbalancegreen' => { 63 => 0x1d },
	'colorbalancered' => { 63 => 0x1c },
	'colorbooster' => { 83 => 0x5f0e7d23 },
	'colorboostlevel' => { 79 => 0x1 },
	'colorboosttype' => { 79 => 0x0 },
	'colorcontrol' => { 93 => 0x102b },
	'coloreffect' => { 96 => 0x28 },
	'colorfilter' => { 63 => 0x29, 68 => 0x38 },
	'colorhue' => { 6 => 0x2, 75 => 0x8d },
	'colormatrix' => { 7 => 0xa, 92 => 0x200, 93 => 0x1011 },
	'colormode' => { 37 => 0x3015, 41 => 0x1210, 47 => 0x66, 63 => 0x28, 66 => 0x101, 68 => 0x7, 75 => 0x3, 77 => 0x4, 93 => 0x101, 96 => 0x32 },
	'colormoirereduction' => { 84 => 0x5 },
	'colornoisereduction' => { 108 => 'ColorNoiseReduction' },
	'colorprofile' => { 63 => 0x33 },
	'colorrepresentation' => { 45 => 0x3c },
	'colorsequence' => { 45 => 0x41 },
	'colorspace' => { 6 => 0x3, 11 => 0xb4, 32 => 0x10b4, 39 => 0xa001, 57 => 'ColorSpace', 65 => 0x25, 75 => 0x1e, 89 => 0x507, 97 => 0x37, 105 => 0xb, 111 => 'ColorSpace' },
	'colortempasshot' => { 3 => 0x1d, 4 => 0x1c, 5 => 0x43 },
	'colortempauto' => { 3 => 0x22, 4 => 0x26, 5 => 0x48 },
	'colortempcloudy' => { 3 => 0x31, 4 => 0x35, 5 => 0x5c },
	'colortempcustom' => { 5 => 0x84 },
	'colortempcustom1' => { 3 => 0x45 },
	'colortempcustom2' => { 3 => 0x4a },
	'colortempdaylight' => { 3 => 0x27, 4 => 0x2b, 5 => 0x52 },
	'colortemperature' => { 7 => 0x9, 11 => 0xae, 16 => 0x9, 32 => 0x10ae, 52 => 'ColorTemperature', 64 => [0x6e,0x49], 65 => 0x3f, 66 => 0x10b, 68 => 0x3c },
	'colortempflash' => { 3 => 0x40, 4 => 0x49, 5 => 0x70 },
	'colortempfluorescent' => { 3 => 0x3b, 4 => 0x3f, 5 => 0x66 },
	'colortempkelvin' => { 4 => 0x44, 5 => 0x6b },
	'colortempmeasured' => { 5 => 0x4d },
	'colortemppc1' => { 4 => 0x94, 5 => 0x75 },
	'colortemppc2' => { 4 => 0x99, 5 => 0x7a },
	'colortemppc3' => { 4 => 0x9e, 5 => 0x7f },
	'colortempshade' => { 3 => 0x2c, 4 => 0x30, 5 => 0x57 },
	'colortemptungsten' => { 3 => 0x36, 4 => 0x3a, 5 => 0x61 },
	'colortempunknown' => { 4 => 0x21 },
	'colortempunknown10' => { 4 => 0x76 },
	'colortempunknown11' => { 4 => 0x7b },
	'colortempunknown12' => { 4 => 0x80 },
	'colortempunknown13' => { 4 => 0x85 },
	'colortempunknown14' => { 4 => 0x8a },
	'colortempunknown15' => { 4 => 0x8f },
	'colortempunknown16' => { 4 => 0xa3 },
	'colortempunknown2' => { 4 => 0x4e },
	'colortempunknown3' => { 4 => 0x53 },
	'colortempunknown4' => { 4 => 0x58 },
	'colortempunknown5' => { 4 => 0x5d },
	'colortempunknown6' => { 4 => 0x62 },
	'colortempunknown7' => { 4 => 0x67 },
	'colortempunknown8' => { 4 => 0x6c },
	'colortempunknown9' => { 4 => 0x71 },
	'colortone' => { 1 => 0x2a },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 40 => 'Comment', 53 => 'Comment', 95 => 'Comment' },
	'componentsconfiguration' => { 39 => 0x9101, 57 => 'Components', 111 => 'ComponentsConfiguration' },
	'componentversion' => { 32 => 0x80c },
	'composer' => { 118 => 'composer' },
	'compressedbitsperpixel' => { 39 => 0x9102, 111 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 66 => 0x40, 93 => 0x40 },
	'compression' => { 39 => 0x103, 115 => 'Compression' },
	'compressionfactor' => { 89 => 0x50d },
	'compressionratio' => { 57 => 'Compression', 93 => 0x1034 },
	'contact' => { 43 => 0x76 },
	'contentlocationcode' => { 43 => 0x1a },
	'contentlocationname' => { 43 => 0x1b },
	'continuousdrive' => { 1 => 0x5 },
	'contrast' => { 1 => 0xd, 36 => 0xc, 37 => [0x3012,0x20], 39 => [0xa408,0xfe54], 41 => 0x1004, 52 => 'Contrast', 63 => 0x20, 64 => 0x31, 65 => 0x27, 68 => 0x2, 93 => 0x1029, 96 => 0x2c, 97 => 0x20, 105 => 0xd, 108 => 'Contrast', 111 => 'Contrast' },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 89 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributedmediaduration' => { 118 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 118 => 'contributedMediaManaged' },
	'contributedmediapath' => { 118 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 118 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 118 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 118 => 'contributedMediaWebStatement' },
	'contributor' => { 109 => 'contributor' },
	'contributors' => { 53 => 'Contributors' },
	'converter' => { 39 => 0xfe4d, 77 => 0xb },
	'copyright' => { 39 => 0x8298, 53 => 'Copyright', 95 => 'Copyright', 101 => 'Copyright', 115 => 'Copyright', 118 => 'copyright' },
	'copyrightflag' => { 99 => 0x40a },
	'copyrightnotice' => { 43 => 0x74 },
	'coringfilter' => { 93 => 0x102d },
	'country' => { 56 => 'Country', 114 => 'Country' },
	'country-primarylocationcode' => { 43 => 0x64 },
	'country-primarylocationname' => { 43 => 0x65 },
	'countrycode' => { 112 => 'CountryCode' },
	'coverage' => { 109 => 'coverage' },
	'crc32' => { 110 => 'crc32' },
	'createdate' => { 39 => 0x9004, 53 => 'CreateDate', 101 => 'CreationDate', 116 => 'CreateDate' },
	'creationdate' => { 113 => 'CreationDate' },
	'creationtime' => { 95 => 'Creation Time' },
	'creator' => { 101 => 'Creator', 109 => 'creator', 113 => 'Creator' },
	'creatorcontactinfociadrcity' => { 112 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 112 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 112 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 112 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 112 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 112 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 112 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 112 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 116 => 'CreatorTool' },
	'credit' => { 43 => 0x6e, 114 => 'Credit' },
	'creditlinereq' => { 120 => 'CreditLineReq' },
	'cropangle' => { 108 => 'CropAngle' },
	'cropbottom' => { 80 => 0x36, 108 => 'CropBottom' },
	'cropheight' => { 108 => 'CropHeight' },
	'crophispeed' => { 75 => 0x1b },
	'cropleft' => { 80 => 0x1e, 108 => 'CropLeft' },
	'cropoutputscale' => { 80 => 0xbe },
	'cropright' => { 80 => 0x2e, 108 => 'CropRight' },
	'croptop' => { 80 => 0x26, 108 => 'CropTop' },
	'cropunits' => { 108 => 'CropUnits' },
	'cropwidth' => { 108 => 'CropWidth' },
	'curves' => { 83 => 0x76a43201 },
	'customrendered' => { 39 => 0xa401, 111 => 'CustomRendered' },
	'customsaturation' => { 89 => 0x503 },
	'd-lightinghq' => { 83 => 0x2175eb78 },
	'd-lightinghqselected' => { 83 => 0x6a6e36b6 },
	'd-lightinghs' => { 83 => 0xce5554aa },
	'd-lightinghsadjustment' => { 82 => 0x0 },
	'd-lightinghscolorboost' => { 81 => 0x2, 82 => 0x1 },
	'd-lightinghshighlight' => { 81 => 0x1 },
	'd-lightinghsshadow' => { 81 => 0x0 },
	'datacompressionmethod' => { 45 => 0x6e },
	'dataimprint' => { 63 => 0x34 },
	'date' => { 97 => 0x6, 109 => 'date' },
	'datecreated' => { 43 => 0x37, 114 => 'DateCreated' },
	'datesent' => { 44 => 0x46 },
	'datetime' => { 115 => 'DateTime' },
	'datetimedigitized' => { 111 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 35 => 0x0, 39 => 0x9003, 53 => 'OriginalDate', 111 => 'DateTimeOriginal' },
	'datetimestamp' => { 47 => 0x64 },
	'decposition' => { 63 => 0x32 },
	'defaultcroporigin' => { 39 => 0xc61f },
	'defaultcropsize' => { 39 => 0xc620 },
	'defaultscale' => { 39 => 0xc61e },
	'deletedimagecount' => { 75 => 0xa6 },
	'derivedfromdocumentid' => { 119 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 119 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 119 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 119 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 119 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 119 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 119 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 119 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 119 => 'DerivedFromVersionID' },
	'description' => { 95 => 'Description', 109 => 'description' },
	'destination' => { 44 => 0x5 },
	'destinationcity' => { 97 => 0x24 },
	'destinationcitycode' => { 97 => 0x1001 },
	'destinationdst' => { 97 => 0x26 },
	'developmentdynamicrange' => { 41 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 111 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 111 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 111 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 43 => 0x3e },
	'digitalcreationtime' => { 43 => 0x3f },
	'digitalgain' => { 16 => 0xb },
	'digitalzoom' => { 1 => 0xc, 36 => 0xa, 47 => 0x68, 52 => 'DigitalZoom', 63 => 0xc, 75 => 0x86, 77 => 0xa, 93 => 0x204, 97 => 0x1e, 104 => 0x204 },
	'digitalzoomon' => { 104 => 0x21b },
	'digitalzoomratio' => { 39 => 0xa404, 111 => 'DigitalZoomRatio' },
	'directory' => { 40 => 'Directory' },
	'disclaimer' => { 95 => 'Disclaimer' },
	'displayaperture' => { 1 => 0x23 },
	'displayedunitsx' => { 100 => 0x2 },
	'displayedunitsy' => { 100 => 0x6 },
	'distance1' => { 47 => 0x28 },
	'distance2' => { 47 => 0x2c },
	'distance3' => { 47 => 0x30 },
	'distance4' => { 47 => 0x34 },
	'distortioncorrection' => { 89 => 0x50b },
	'distortioncorrection2' => { 92 => 0x1011 },
	'dngbackwardversion' => { 39 => 0xc613 },
	'dnglensinfo' => { 39 => 0xc630 },
	'dngversion' => { 39 => 0xc612 },
	'document' => { 95 => 'Document' },
	'documenthistory' => { 43 => 0xe7 },
	'documentid' => { 119 => 'DocumentID' },
	'documentname' => { 39 => 0x10d },
	'documentnotes' => { 43 => 0xe6 },
	'dotrange' => { 39 => 0x150 },
	'drivemode' => { 63 => 0x6, 105 => 0x3 },
	'duration' => { 51 => 'Duration', 62 => 'Duration', 118 => 'duration' },
	'dynamicrange' => { 41 => 0x1400 },
	'dynamicrangesetting' => { 41 => 0x1402 },
	'easymode' => { 1 => 0xb },
	'edgenoisereduction' => { 84 => 0x4 },
	'editorialupdate' => { 43 => 0x8 },
	'editstatus' => { 43 => 0x7 },
	'elevation' => { 56 => 'Elevation' },
	'engineer' => { 118 => 'engineer' },
	'enhancedarktones' => { 78 => 0x8 },
	'enhancement' => { 36 => 0x16, 37 => 0x3016 },
	'envelopenumber' => { 44 => 0x28 },
	'envelopepriority' => { 44 => 0x3c },
	'enveloperecordversion' => { 44 => 0x0 },
	'epsonimageheight' => { 93 => 0x20c },
	'epsonimagewidth' => { 93 => 0x20b },
	'epsonsoftware' => { 93 => 0x20d },
	'equipmentversion' => { 90 => 0x0 },
	'ettlii' => { 20 => 0xd, 21 => 0xe, 22 => 0x7, 23 => 0x7, 24 => 0xe },
	'excursiontolerance' => { 45 => 0x82 },
	'exifcamerainfo' => { 43 => 0xe8 },
	'exifimageheight' => { 111 => 'PixelYDimension' },
	'exifimagelength' => { 39 => 0xa003 },
	'exifimagewidth' => { 39 => 0xa002, 111 => 'PixelXDimension' },
	'exifversion' => { 39 => 0x9000, 111 => 'ExifVersion' },
	'expirationdate' => { 43 => 0x25 },
	'expirationtime' => { 43 => 0x26 },
	'exposure' => { 39 => 0xfe51, 108 => 'Exposure' },
	'exposurebracketvalue' => { 75 => 0x19 },
	'exposurecompensation' => { 17 => 0x6, 28 => 0x0, 39 => 0x9204, 47 => 0x24, 52 => 'ExposureComp', 63 => 0xd, 64 => 0x53, 65 => 0x1e, 93 => 0x1006, 97 => 0x16, 105 => 0xc, 111 => 'ExposureBiasValue' },
	'exposuredifference' => { 75 => 0xe },
	'exposureindex' => { 39 => 0xa215, 111 => 'ExposureIndex' },
	'exposurelevelincrements' => { 18 => 0x6, 19 => 0x6, 20 => 0x5, 21 => 0x6, 22 => 0x5, 23 => 0x5, 24 => 0x6, 25 => 0x4 },
	'exposuremode' => { 39 => 0xa402, 52 => 'ExposureMode', 63 => 0x1, 64 => 0xa, 65 => 0x0, 89 => 0x200, 105 => 0x8, 111 => 'ExposureMode' },
	'exposureprogram' => { 39 => 0x8822, 111 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 17 => 0x16, 39 => 0x829a, 47 => 0x20, 49 => 0x38, 52 => 'ExposureTime', 63 => 0x9, 64 => 0x35, 65 => 0x48, 97 => 0x12, 111 => 'ExposureTime' },
	'exposurewarning' => { 41 => 0x1302 },
	'extender' => { 90 => 0x301 },
	'extenderfirmwareversion' => { 90 => 0x304 },
	'extendermake' => { 54 => 'Make' },
	'extendermodel' => { 54 => 'Model', 90 => 0x303 },
	'extenderserialnumber' => { 54 => 'SerialNumber', 90 => 0x302 },
	'externalflash' => { 91 => 0x1201 },
	'externalflashbounce' => { 93 => 0x1026 },
	'externalflashmode' => { 93 => 0x1028 },
	'externalflashzoom' => { 93 => 0x1027 },
	'ffid' => { 110 => 'ffid' },
	'filedatarate' => { 118 => 'fileDataRate' },
	'fileformat' => { 30 => 0x0, 44 => 0x14 },
	'filemodifydate' => { 40 => 'FileModifyDate' },
	'filename' => { 40 => 'FileName' },
	'filenumber' => { 8 => 0x1, 11 => 0x8, 32 => 0x1817 },
	'filenumbermemory' => { 63 => 0x1a },
	'filesource' => { 39 => 0xa300, 41 => 0x8000, 111 => 'FileSource' },
	'fileversion' => { 44 => 0x16 },
	'fillflashautoreduction' => { 18 => 0xe, 19 => 0xe, 25 => 0xa },
	'fillorder' => { 39 => 0x10a },
	'filmmode' => { 41 => 0x1401 },
	'filter' => { 36 => 0x17, 37 => 0x3017 },
	'filtereffect' => { 8 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 19 => 0x1 },
	'firmware' => { 105 => 0x17, 106 => 'Firmware' },
	'firmwareid' => { 67 => 0x0 },
	'firmwarerevision' => { 0 => 0xa4 },
	'firmwareversion' => { 52 => 'FirmwareVersion', 75 => 0x1, 96 => 0x2 },
	'fixtureidentifier' => { 43 => 0x16 },
	'flash' => { 39 => 0x9209, 64 => 0x1f, 65 => 0x15 },
	'flashactivity' => { 1 => 0x1c },
	'flashbias' => { 96 => 0x24 },
	'flashbits' => { 1 => 0x1d },
	'flashchargelevel' => { 93 => 0x1010 },
	'flashcompensation' => { 106 => 'FlashCompensation' },
	'flashdevice' => { 93 => 0x1005 },
	'flashdistance' => { 37 => 0x2034 },
	'flashenergy' => { 39 => 0xa20b, 111 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 75 => 0x18 },
	'flashexposurecomp' => { 17 => 0xf, 55 => 'ExposureComp', 63 => 0x23, 75 => 0x12, 93 => 0x1023 },
	'flashexposurecompensation' => { 89 => 0x401 },
	'flashfired' => { 47 => 0x5d, 55 => 'Fired', 63 => 0x14, 111 => 'FlashFired' },
	'flashfiring' => { 20 => 0x6, 21 => 0x7, 24 => 0x7 },
	'flashfirmwareversion' => { 90 => 0x1002 },
	'flashfunction' => { 111 => 'FlashFunction' },
	'flashguidenumber' => { 17 => 0xd, 29 => 0x0, 55 => 'GuideNumber' },
	'flashintensity' => { 36 => [0x19,0x5] },
	'flashmake' => { 55 => 'Make' },
	'flashmetering' => { 63 => 0x3f },
	'flashmode' => { 36 => 0x4, 47 => 0x5c, 55 => 'Mode', 63 => 0x2, 75 => 0x87, 89 => 0x400, 93 => 0x1004, 97 => 0xc, 102 => 0x20, 104 => 0x225, 111 => 'FlashMode' },
	'flashmodel' => { 55 => 'Model', 90 => 0x1001 },
	'flashpixversion' => { 39 => 0xa000, 111 => 'FlashpixVersion' },
	'flashredeyemode' => { 111 => 'FlashRedEyeMode' },
	'flashreturn' => { 111 => 'FlashReturn' },
	'flashserialnumber' => { 55 => 'SerialNumber', 90 => 0x1003 },
	'flashsetting' => { 75 => 0x8 },
	'flashstrength' => { 41 => 0x1011 },
	'flashsyncspeedav' => { 18 => 0x3, 20 => 0x2, 21 => 0x3, 22 => 0x2, 23 => 0x2, 24 => 0x3, 25 => 0x6 },
	'flashthreshold' => { 29 => 0x1 },
	'flashtype' => { 55 => 'Type', 75 => 0x9, 90 => 0x1000 },
	'flickerreduce' => { 104 => 0x218 },
	'fliphorizontal' => { 83 => 0x76a43206 },
	'fnumber' => { 17 => 0x15, 39 => 0x829d, 47 => 0x1e, 49 => 0x3c, 52 => 'FNumber', 63 => 0xa, 64 => 0x36, 65 => 0x47, 97 => 0x13, 111 => 'FNumber' },
	'focallength' => { 0 => 0xa, 10 => 0x1, 37 => 0x1d, 39 => 0x920a, 52 => 'FocalLength', 63 => 0x12, 97 => 0x1d, 111 => 'FocalLength' },
	'focallengthin35mmformat' => { 39 => 0xa405, 111 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 90 => 0x103, 93 => 0x205 },
	'focalplaneresolutionunit' => { 39 => 0xa210, 111 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 39 => 0xa20e, 111 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 10 => 0x2 },
	'focalplaneyresolution' => { 39 => 0xa20f, 111 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 10 => 0x3 },
	'focaltype' => { 0 => 0x2d, 10 => 0x0 },
	'focalunits' => { 1 => 0x19 },
	'focus' => { 77 => 0x8 },
	'focusarea' => { 63 => 0x31 },
	'focuscontinuous' => { 1 => 0x20 },
	'focusdistance' => { 52 => 'FocusDistance', 63 => 0x13, 91 => 0x305 },
	'focusdistancelower' => { 17 => 0x14 },
	'focusdistanceupper' => { 17 => 0x13 },
	'focusinfoversion' => { 91 => 0x0 },
	'focusingscreen' => { 19 => 0x0, 24 => 0x0 },
	'focusmode' => { 1 => 0x7, 36 => 0x3, 37 => [0x3003,0xd], 41 => 0x1021, 47 => 0x38, 52 => 'FocusMode', 63 => 0x30, 65 => 0xe, 75 => 0x7, 89 => 0x301, 93 => 0x100b, 96 => 0x7, 97 => 0xd },
	'focuspixel' => { 41 => 0x1023 },
	'focusposition' => { 97 => 0x10 },
	'focusprocess' => { 89 => 0x302 },
	'focusrange' => { 1 => 0x12 },
	'focussetting' => { 105 => 0x6 },
	'focusstepcount' => { 93 => 0x100e },
	'focuswarning' => { 41 => 0x1301 },
	'foldername' => { 63 => 0x27 },
	'fontschildfontfiles' => { 122 => 'FontsChildFontFiles' },
	'fontscomposite' => { 122 => 'FontsComposite' },
	'fontsfontface' => { 122 => 'FontsFontFace' },
	'fontsfontfamily' => { 122 => 'FontsFontFamily' },
	'fontsfontfilename' => { 122 => 'FontsFontFileName' },
	'fontsfontname' => { 122 => 'FontsFontName' },
	'fontsfonttype' => { 122 => 'FontsFontType' },
	'fontsversionstring' => { 122 => 'FontsVersionString' },
	'for' => { 101 => 'For' },
	'format' => { 109 => 'format' },
	'framenumber' => { 41 => 0x8003, 97 => 0x29 },
	'freebytes' => { 32 => 0x1 },
	'freememorycardimages' => { 64 => [0x37,0x54], 65 => [0x2d,0x4a] },
	'fujiflashmode' => { 41 => 0x1010 },
	'fullsizeimage' => { 57 => 'data' },
	'fullsizeimagename' => { 57 => '1Name' },
	'fullsizeimagetype' => { 57 => '0Type' },
	'gaincontrol' => { 39 => 0xa407, 111 => 'GainControl' },
	'gamma' => { 39 => 0xa500 },
	'gammacompensatedvalue' => { 45 => 0x91 },
	'genre' => { 118 => 'genre' },
	'globalaltitude' => { 99 => 0x419 },
	'globalangle' => { 99 => 0x40d },
	'gpsaltitude' => { 42 => 0x6, 111 => 'GPSAltitude' },
	'gpsaltituderef' => { 42 => 0x5, 111 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 42 => 0x1c, 111 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 42 => 0x1d },
	'gpsdestbearing' => { 42 => 0x18, 111 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 42 => 0x17, 111 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 42 => 0x1a, 111 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 42 => 0x19, 111 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 42 => 0x14, 111 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 42 => 0x13 },
	'gpsdestlongitude' => { 42 => 0x16, 111 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 42 => 0x15 },
	'gpsdifferential' => { 42 => 0x1e, 111 => 'GPSDifferential' },
	'gpsdop' => { 42 => 0xb, 111 => 'GPSDOP' },
	'gpsimgdirection' => { 42 => 0x11, 111 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 42 => 0x10, 111 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 42 => 0x2, 111 => 'GPSLatitude' },
	'gpslatituderef' => { 42 => 0x1 },
	'gpslongitude' => { 42 => 0x4, 111 => 'GPSLongitude' },
	'gpslongituderef' => { 42 => 0x3 },
	'gpsmapdatum' => { 42 => 0x12, 111 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 42 => 0xa, 111 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 42 => 0x1b, 111 => 'GPSProcessingMethod' },
	'gpssatellites' => { 42 => 0x8, 111 => 'GPSSatellites' },
	'gpsspeed' => { 42 => 0xd, 111 => 'GPSSpeed' },
	'gpsspeedref' => { 42 => 0xc, 111 => 'GPSSpeedRef' },
	'gpsstatus' => { 42 => 0x9, 111 => 'GPSStatus' },
	'gpstimestamp' => { 42 => 0x7, 111 => 'GPSTimeStamp' },
	'gpstrack' => { 42 => 0xf, 111 => 'GPSTrack' },
	'gpstrackref' => { 42 => 0xe, 111 => 'GPSTrackRef' },
	'gpsversionid' => { 42 => 0x0, 111 => 'GPSVersionID' },
	'gradation' => { 89 => 0x50f },
	'grayresponseunit' => { 39 => 0x122 },
	'greenhue' => { 108 => 'GreenHue' },
	'greensaturation' => { 108 => 'GreenSaturation' },
	'halftonehints' => { 39 => 0x141 },
	'hascrop' => { 108 => 'HasCrop' },
	'hassettings' => { 108 => 'HasSettings' },
	'headline' => { 43 => 0x69, 114 => 'Headline' },
	'highisonoisereduction' => { 75 => 0xb1 },
	'highlight' => { 105 => 0xf },
	'historyaction' => { 119 => 'HistoryAction' },
	'historyinstanceid' => { 119 => 'HistoryInstanceID' },
	'historyparameters' => { 119 => 'HistoryParameters' },
	'historysoftwareagent' => { 119 => 'HistorySoftwareAgent' },
	'historywhen' => { 119 => 'HistoryWhen' },
	'hometowncity' => { 97 => 0x23 },
	'hometowncitycode' => { 97 => 0x1000 },
	'hometowndst' => { 97 => 0x25 },
	'hostcomputer' => { 39 => 0x13c },
	'hue' => { 68 => 0x3b },
	'hueadjustment' => { 75 => 0x92 },
	'icc_profile' => { 40 => 'ICC_Profile' },
	'identifier' => { 109 => 'identifier', 116 => 'Identifier' },
	'imageadjustment' => { 75 => 0x80, 77 => 0x5 },
	'imageboundary' => { 75 => 0x16 },
	'imagecount' => { 75 => 0xa5 },
	'imagedatasize' => { 75 => 0xa2 },
	'imagedescription' => { 39 => 0x10e, 115 => 'ImageDescription' },
	'imagedustoff' => { 83 => 0xfe443a45 },
	'imageheight' => { 39 => 0x101, 67 => 0xc, 115 => 'ImageLength' },
	'imagehistory' => { 39 => 0x9213 },
	'imagenumber' => { 0 => 0xd0, 39 => 0x9211, 52 => 'ImageNumber', 64 => 0xae, 65 => 0x5e, 106 => 'ImageNumber' },
	'imagenumber2' => { 65 => 0x62 },
	'imageoptimization' => { 75 => 0xa9 },
	'imageorientation' => { 43 => 0x83 },
	'imageprocessing' => { 75 => 0x1a },
	'imageprocessingversion' => { 92 => 0x0 },
	'imagequality' => { 52 => 'ImageQuality', 96 => 0x1 },
	'imagequality2' => { 89 => 0x603 },
	'imagesize' => { 57 => 'ImageSize' },
	'imagestabilization' => { 1 => 0x22, 37 => 0x3020, 52 => 'ImageStabilization', 64 => 0xbd, 65 => 0x71, 66 => [0x18,0x107], 75 => 0xac },
	'imagestabilizer' => { 96 => 0x1a },
	'imagetype' => { 43 => 0x82 },
	'imageuniqueid' => { 39 => 0xa420, 111 => 'ImageUniqueID' },
	'imagewidth' => { 39 => 0x100, 67 => 0xe, 115 => 'ImageWidth' },
	'infinitylensstep' => { 93 => 0x103b },
	'inkset' => { 39 => 0x14c },
	'instructions' => { 114 => 'Instructions' },
	'instrument' => { 118 => 'instrument' },
	'intellectualgenre' => { 112 => 'IntellectualGenre' },
	'interchangecolorspace' => { 45 => 0x40 },
	'internalflash' => { 63 => 0x2b, 91 => 0x1208 },
	'internalserialnumber' => { 90 => 0x102, 96 => 0x25 },
	'interopindex' => { 39 => 0x1 },
	'interopversion' => { 39 => 0x2 },
	'intervallength' => { 63 => 0x10 },
	'intervalmode' => { 63 => 0x26 },
	'intervalnumber' => { 63 => 0x11 },
	'introtime' => { 118 => 'introTime' },
	'iptc-naa' => { 39 => 0x83bb },
	'iptcbitspersample' => { 45 => 0x56 },
	'iptcimageheight' => { 45 => 0x1e },
	'iptcimagerotation' => { 45 => 0x66 },
	'iptcimagewidth' => { 45 => 0x14 },
	'iptcpicturenumber' => { 45 => 0xa },
	'iptcpixelheight' => { 45 => 0x32 },
	'iptcpixelwidth' => { 45 => 0x28 },
	'iso' => { 37 => 0x14, 39 => 0x8827, 47 => 0x60, 49 => 0x4e, 52 => 'ISO', 63 => 0x8, 75 => 0x2, 97 => 0x14, 111 => 'ISOSpeedRatings' },
	'isoexpansion' => { 20 => 0x7, 21 => 0x8, 24 => 0x8 },
	'isoselection' => { 75 => 0xf },
	'isosetting' => { 47 => 0x5e, 52 => 'ISOSetting', 63 => 0x24, 64 => 0x26, 65 => 0x1c, 68 => 0x6, 75 => 0x13, 102 => 0x27 },
	'isospeedexpansion' => { 19 => 0x3 },
	'isovalue' => { 93 => 0x1001 },
	'jobid' => { 43 => 0xb8 },
	'jobrefid' => { 117 => 'JobRefId' },
	'jobrefname' => { 117 => 'JobRefName' },
	'jobrefurl' => { 117 => 'JobRefUrl' },
	'jpgfromraw' => { 32 => 0x2007, 38 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 39 => [0x117,0x202] },
	'jpgfromrawstart' => { 39 => [0x111,0x201] },
	'key' => { 118 => 'key' },
	'keywords' => { 43 => 0x19, 53 => 'Keywords', 101 => 'Keywords', 113 => 'Keywords' },
	'kodakimageheight' => { 47 => 0xe, 48 => 0x70 },
	'kodakimagewidth' => { 47 => 0xc, 48 => 0x6c },
	'kodakmaker' => { 48 => 0x8 },
	'kodakmodel' => { 47 => 0x0, 48 => 0x28 },
	'label' => { 95 => 'Label', 116 => 'Label' },
	'language' => { 109 => 'language' },
	'languageidentifier' => { 43 => 0x87 },
	'lastfilenumber' => { 63 => 0x1b },
	'lasturl' => { 119 => 'LastURL' },
	'latitude' => { 56 => 'Latitude' },
	'lcddisplayatpoweron' => { 23 => 0xa },
	'lcddisplayreturntoshoot' => { 24 => 0x12 },
	'lcdpanels' => { 19 => 0x8 },
	'lcheditor' => { 83 => 0x8ae85e },
	'lens' => { 39 => 0xfdea, 75 => 0x84, 105 => 0xa, 106 => 'Lens' },
	'lensafstopbutton' => { 18 => 0x11, 19 => 0x13, 20 => 0x10, 21 => 0x12, 24 => 0x13, 25 => 0x9 },
	'lensdataversion' => { 74 => 0x0 },
	'lensdistortionparams' => { 93 => 0x206 },
	'lensfirmwareversion' => { 90 => 0x204 },
	'lensfstops' => { 74 => 0x7, 75 => 0x8b },
	'lensid' => { 66 => 0x10c },
	'lensidnumber' => { 74 => 0x6 },
	'lensinfo' => { 106 => 'LensInfo' },
	'lensmake' => { 58 => 'Make' },
	'lensmodel' => { 58 => 'Model' },
	'lensserialnumber' => { 58 => 'SerialNumber', 90 => 0x202 },
	'lenstemperature' => { 93 => 0x1008 },
	'lenstype' => { 0 => 0xd, 1 => 0x16, 11 => 0x95, 75 => 0x83, 90 => 0x201, 97 => 0x3f },
	'license' => { 107 => 'license' },
	'licensetype' => { 110 => 'licensetype' },
	'lightsource' => { 39 => 0x9208, 75 => 0x90, 111 => 'LightSource' },
	'lightsourcespecial' => { 104 => 0x21d },
	'linearresponselimit' => { 39 => 0xc62e },
	'localcaption' => { 43 => 0x79 },
	'localizedcameramodel' => { 39 => 0xc615 },
	'location' => { 112 => 'Location' },
	'logcomment' => { 118 => 'logComment' },
	'longexposurenoisereduction' => { 20 => 0x1, 21 => 0x2, 22 => 0x1, 23 => 0x1, 24 => 0x2, 25 => 0x1 },
	'longfocal' => { 0 => 0x14, 1 => 0x17 },
	'longitude' => { 56 => 'Longitude' },
	'loop' => { 118 => 'loop' },
	'luminancesmoothing' => { 108 => 'LuminanceSmoothing' },
	'macro' => { 41 => 0x1020, 93 => 0x202, 102 => 0x21, 104 => 0x202 },
	'macromode' => { 1 => 0x1, 63 => 0xb, 89 => 0x300, 96 => 0x1c },
	'magnification' => { 54 => 'Magnification' },
	'magnifiedview' => { 21 => 0x11, 23 => 0x9 },
	'make' => { 33 => 0x0, 39 => 0x10f, 52 => 'Make', 95 => 'Make', 115 => 'Make' },
	'makernote' => { 111 => 'MakerNote' },
	'makernotecanon' => { 39 => 0x927c },
	'makernotecasio' => { 39 => 0x927c },
	'makernotecasio2' => { 39 => 0x927c },
	'makernotefujifilm' => { 39 => 0x927c },
	'makernotejvc' => { 39 => 0x927c },
	'makernotejvctext' => { 39 => 0x927c },
	'makernotekodak1a' => { 39 => 0x927c },
	'makernotekodak1b' => { 39 => 0x927c },
	'makernotekodak2' => { 39 => 0x927c },
	'makernotekodak3' => { 39 => 0x927c },
	'makernotekodak4' => { 39 => 0x927c },
	'makernotekodak5' => { 39 => 0x927c },
	'makernotekodak6a' => { 39 => 0x927c },
	'makernotekodak6b' => { 39 => 0x927c },
	'makernotekodakunknown' => { 39 => 0x927c },
	'makernotekyocera' => { 39 => 0x927c },
	'makernoteleica' => { 39 => 0x927c },
	'makernoteminolta' => { 39 => 0x927c },
	'makernoteminolta2' => { 39 => 0x927c },
	'makernoteminolta3' => { 39 => 0x927c },
	'makernoteminolta4' => { 39 => 0x927c },
	'makernotenikon' => { 39 => 0x927c },
	'makernotenikon2' => { 39 => 0x927c },
	'makernotenikon3' => { 39 => 0x927c },
	'makernoteoffset' => { 104 => 0xff },
	'makernoteolympus' => { 39 => 0x927c },
	'makernotepanasonic' => { 39 => 0x927c },
	'makernotepanasonic2' => { 39 => 0x927c },
	'makernotepentax' => { 39 => 0x927c },
	'makernotericoh' => { 39 => 0x927c },
	'makernotericohtext' => { 39 => 0x927c },
	'makernotesafety' => { 39 => 0xc635 },
	'makernotesanyo' => { 39 => 0x927c },
	'makernotesigma' => { 39 => 0x927c },
	'makernotesony' => { 39 => 0x927c },
	'makernotesonysr2' => { 39 => 0x927c },
	'makernotesonysrf' => { 39 => 0x927c },
	'makernotetype' => { 103 => 0x1 },
	'makernoteunknown' => { 39 => 0x927c },
	'makernoteversion' => { 66 => 0x0, 93 => 0x0, 103 => 0x2 },
	'managedfromdocumentid' => { 119 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 119 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 119 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 119 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 119 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 119 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 119 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 119 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 119 => 'ManagedFromVersionID' },
	'manager' => { 119 => 'Manager' },
	'managervariant' => { 119 => 'ManagerVariant' },
	'manageto' => { 119 => 'ManageTo' },
	'manageui' => { 119 => 'ManageUI' },
	'manualflash' => { 91 => 0x1209 },
	'manualfocusdistance' => { 75 => 0x85, 93 => 0x100c, 104 => 0x223 },
	'manualtv' => { 19 => 0x5 },
	'marked' => { 121 => 'Marked' },
	'markerscomment' => { 118 => 'markersComment' },
	'markersduration' => { 118 => 'markersDuration' },
	'markerslocation' => { 118 => 'markersLocation' },
	'markersname' => { 118 => 'markersName' },
	'markersstarttime' => { 118 => 'markersStartTime' },
	'markerstarget' => { 118 => 'markersTarget' },
	'markerstype' => { 118 => 'markersType' },
	'maskedareas' => { 39 => 0xc68e },
	'masterdocumentid' => { 43 => 0xb9 },
	'maxaperture' => { 1 => 0x1a, 52 => 'MaxAperture', 63 => 0x17 },
	'maxapertureatcurrentfocal' => { 90 => 0x20a },
	'maxapertureatmaxfocal' => { 41 => 0x1407, 52 => 'MaxApertureAtMaxFocal', 74 => 0xb, 90 => 0x206 },
	'maxapertureatminfocal' => { 41 => 0x1406, 74 => 0xa },
	'maxaperturevalue' => { 39 => 0x9205, 111 => 'MaxApertureValue' },
	'maxfocallength' => { 41 => 0x1405, 52 => 'MaxFocalLength', 74 => 0x9, 90 => 0x208 },
	'maximumdensityrange' => { 45 => 0x8c },
	'maxpagesizeh' => { 122 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 122 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 122 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 39 => 0x119 },
	'mcuversion' => { 74 => 0xc },
	'measuredev' => { 17 => 0x3, 32 => 0x1814, 52 => 'MeasuredEV' },
	'menubuttondisplayposition' => { 18 => 0xb, 20 => 0xa, 21 => 0xb, 24 => 0xb },
	'menubuttonreturn' => { 25 => 0xb },
	'metadatadate' => { 116 => 'MetadataDate' },
	'metadatamoddate' => { 118 => 'metadataModDate' },
	'meteringmode' => { 1 => 0x11, 39 => 0x9207, 47 => 0x1c, 63 => 0x7, 64 => 0x25, 89 => 0x202, 97 => 0x17, 105 => 0x9, 111 => 'MeteringMode' },
	'minaperture' => { 1 => 0x1b, 52 => 'MinAperture' },
	'minfocallength' => { 41 => 0x1404, 52 => 'MinFocalLength', 74 => 0x8, 90 => 0x207 },
	'minoltadate' => { 63 => 0x15 },
	'minoltaimagesize' => { 63 => 0x4, 64 => 0xc, 65 => 0x2, 66 => 0x103 },
	'minoltamodelid' => { 63 => 0x25 },
	'minoltaquality' => { 63 => 0x5, 64 => 0xd, 65 => 0x3, 66 => [0x102,0x103], 93 => [0x102,0x103] },
	'minoltatime' => { 63 => 0x16 },
	'minsamplevalue' => { 39 => 0x118 },
	'mirrorlockup' => { 18 => 0xc, 19 => 0xc, 20 => 0xb, 21 => 0xc, 22 => 0x6, 23 => 0x6, 24 => 0xc, 25 => 0x3 },
	'moddate' => { 113 => 'ModDate' },
	'model' => { 33 => 0x6, 39 => 0x110, 52 => 'Model', 95 => 'Model', 115 => 'Model' },
	'modifiedcolortemp' => { 12 => 0x9 },
	'modifieddigitalgain' => { 12 => 0xb },
	'modifiedparamflag' => { 9 => 0x1 },
	'modifiedpicturestyle' => { 12 => 0xa },
	'modifiedsaturation' => { 89 => 0x504 },
	'modifiedsensorbluelevel' => { 12 => 0x5 },
	'modifiedsensorredlevel' => { 12 => 0x4 },
	'modifiedsharpness' => { 12 => 0x2 },
	'modifiedsharpnessfreq' => { 12 => 0x3 },
	'modifiedtonecurve' => { 12 => 0x1 },
	'modifiedwhitebalance' => { 12 => 0x8 },
	'modifiedwhitebalanceblue' => { 12 => 0x7 },
	'modifiedwhitebalancered' => { 12 => 0x6 },
	'modifydate' => { 39 => 0x132, 53 => 'ModifyDate', 101 => 'ModDate', 116 => 'ModifyDate' },
	'moirefilter' => { 39 => 0xfe58 },
	'monthdaycreated' => { 47 => 0x12, 49 => 0xe },
	'ndfilter' => { 17 => 0x1c },
	'nearlensstep' => { 93 => 0x103c },
	'newsphotoversion' => { 45 => 0x0 },
	'nickname' => { 116 => 'Nickname' },
	'nikoncaptureversion' => { 75 => 0xe09 },
	'noisereduction' => { 8 => 0x8, 64 => 0xb0, 65 => 0x60, 75 => 0x95, 83 => 0x753dcbc0, 89 => 0x50a, 93 => 0x103a, 96 => 0x2d, 97 => 0x49 },
	'noisereduction2' => { 92 => 0x1010 },
	'noisereductionintensity' => { 84 => 0x9 },
	'noisereductionmethod' => { 84 => 0x11 },
	'noisereductionsharpness' => { 84 => 0xd },
	'npages' => { 122 => 'NPages' },
	'nullrecord' => { 32 => 0x0 },
	'numafpoints' => { 14 => 0x1 },
	'numberofbeats' => { 118 => 'numberOfBeats' },
	'numindexentries' => { 45 => 0x54 },
	'objectattributereference' => { 43 => 0x4 },
	'objectcycle' => { 43 => 0x4b },
	'objectdistance' => { 36 => 0x6, 37 => 0x2022 },
	'objectname' => { 43 => 0x5 },
	'objectpreviewdata' => { 43 => 0xca },
	'objectpreviewfileformat' => { 43 => 0xc8 },
	'objectpreviewfileversion' => { 43 => 0xc9 },
	'objecttypereference' => { 43 => 0x3 },
	'oecfcolumns' => { 111 => 'OECFColumns' },
	'oecfnames' => { 111 => 'OECFNames' },
	'oecfrows' => { 111 => 'OECFRows' },
	'oecfvalues' => { 111 => 'OECFValues' },
	'oldsubfiletype' => { 39 => 0xff },
	'olympusimageheight' => { 93 => 0x102f },
	'olympusimageheight2' => { 92 => 0x615 },
	'olympusimagewidth' => { 93 => 0x102e },
	'olympusimagewidth2' => { 92 => 0x614 },
	'onetouchwb' => { 93 => 0x302 },
	'opticalzoomon' => { 104 => 0x219 },
	'ordernumber' => { 41 => 0x8002 },
	'orientation' => { 39 => 0x112, 52 => 'Orientation', 115 => 'Orientation' },
	'originalfilename' => { 32 => 0x816, 50 => 0x20 },
	'originalrawfiledata' => { 39 => 0xc68c },
	'originalrawfilename' => { 39 => 0xc68b },
	'originaltransmissionreference' => { 43 => 0x67 },
	'originatingprogram' => { 43 => 0x41 },
	'os' => { 110 => 'os' },
	'outcue' => { 118 => 'outCue' },
	'outputheight' => { 80 => 0xce },
	'outputheightinches' => { 80 => 0x96 },
	'outputpixels' => { 80 => 0xd6 },
	'outputresolution' => { 80 => 0xb6 },
	'outputwidth' => { 80 => 0xc6 },
	'outputwidthinches' => { 80 => 0x8e },
	'owner' => { 121 => 'Owner' },
	'ownerid' => { 43 => 0xbc },
	'ownername' => { 11 => 0x9, 32 => 0x810, 39 => 0xfde8, 52 => 'OwnerName', 106 => 'OwnerName' },
	'pagename' => { 39 => 0x11d },
	'pagenumber' => { 39 => 0x129 },
	'panoramadirection' => { 13 => 0x5 },
	'panoramaframe' => { 13 => 0x2 },
	'panoramamode' => { 47 => 0x3c, 89 => 0x601 },
	'pdfversion' => { 113 => 'PDFVersion' },
	'pentaximagesize' => { 97 => 0x9 },
	'pentaxmode' => { 97 => 0x1 },
	'pentaxmodelid' => { 97 => 0x5 },
	'pf0customfuncregistration' => { 27 => 0x1 },
	'pf10retainprogramshift' => { 27 => 0xb },
	'pf13drivepriority' => { 27 => 0xe },
	'pf14disablefocussearch' => { 27 => 0xf },
	'pf15disableafassistbeam' => { 27 => 0x10 },
	'pf16autofocuspointshoot' => { 27 => 0x11 },
	'pf17disableafpointsel' => { 27 => 0x12 },
	'pf18enableautoafpointsel' => { 27 => 0x13 },
	'pf19continuousshootspeed' => { 27 => 0x14 },
	'pf19shootingspeedhigh' => { 26 => 0xa },
	'pf19shootingspeedlow' => { 26 => 0x9 },
	'pf1disableshootingmodes' => { 27 => 0x2 },
	'pf1value' => { 26 => 0x1 },
	'pf20limitcontinousshots' => { 27 => 0x15 },
	'pf20maxcontinousshots' => { 26 => 0xb },
	'pf21enablequietoperation' => { 27 => 0x16 },
	'pf23felocktime' => { 26 => 0xd },
	'pf23postreleasetime' => { 26 => 0xe },
	'pf23settimerlengths' => { 27 => 0x18 },
	'pf23shutterbuttontime' => { 26 => 0xc },
	'pf24lightlcdduringbulb' => { 27 => 0x19 },
	'pf25aemode' => { 26 => 0xf },
	'pf25afmode' => { 26 => 0x12 },
	'pf25afpointsel' => { 26 => 0x13 },
	'pf25colormatrix' => { 26 => 0x17 },
	'pf25defaultclearsettings' => { 27 => 0x1a },
	'pf25drivemode' => { 26 => 0x11 },
	'pf25imagesize' => { 26 => 0x14 },
	'pf25meteringmode' => { 26 => 0x10 },
	'pf25parameters' => { 26 => 0x16 },
	'pf25wbmode' => { 26 => 0x15 },
	'pf26shortenreleaselag' => { 27 => 0x1b },
	'pf27reversedialrotation' => { 27 => 0x1c },
	'pf27value' => { 26 => 0x18 },
	'pf28noquickdialexpcomp' => { 27 => 0x1d },
	'pf29quickdialswitchoff' => { 27 => 0x1e },
	'pf2disablemeteringmodes' => { 27 => 0x3 },
	'pf2value' => { 26 => 0x2 },
	'pf30enlargementmode' => { 27 => 0x1f },
	'pf31originaldecisiondata' => { 27 => 0x20 },
	'pf3manualexposuremetering' => { 27 => 0x4 },
	'pf3value' => { 26 => 0x3 },
	'pf4exposuretimelimits' => { 27 => 0x5 },
	'pf4exposuretimemax' => { 26 => 0x5 },
	'pf4exposuretimemin' => { 26 => 0x4 },
	'pf5aperturelimits' => { 27 => 0x6 },
	'pf5aperturemax' => { 26 => 0x7 },
	'pf5aperturemin' => { 26 => 0x6 },
	'pf6presetshootingmodes' => { 27 => 0x7 },
	'pf7bracketcontinuousshoot' => { 27 => 0x8 },
	'pf8bracketshots' => { 26 => 0x8 },
	'pf8setbracketshots' => { 27 => 0x9 },
	'pf9changebracketsequence' => { 27 => 0xa },
	'photoeffect' => { 1 => 0x28 },
	'photoeffects' => { 83 => 0xab5eca5e },
	'photoeffectsblue' => { 85 => 0x8 },
	'photoeffectsgreen' => { 85 => 0x6 },
	'photoeffectsred' => { 85 => 0x4 },
	'photoeffectstype' => { 85 => 0x0 },
	'photometricinterpretation' => { 39 => 0x106, 115 => 'PhotometricInterpretation' },
	'photoshopquality' => { 98 => 0x0 },
	'pictinfo' => { 104 => 0x208 },
	'picturemode' => { 41 => 0x1031, 89 => 0x520, 97 => 0xb },
	'picturemodebwfilter' => { 89 => 0x525 },
	'picturemodecontrast' => { 89 => 0x523 },
	'picturemodehue' => { 89 => 0x522 },
	'picturemodesaturation' => { 89 => 0x521 },
	'picturemodesharpness' => { 89 => 0x524 },
	'picturemodetone' => { 89 => 0x526 },
	'picturestyle' => { 0 => 0x6c, 16 => 0xa },
	'planarconfiguration' => { 39 => 0x11c, 115 => 'PlanarConfiguration' },
	'platenames' => { 122 => 'PlateNames' },
	'pngwarning' => { 95 => 'Warning' },
	'precaptureframes' => { 93 => 0x300 },
	'predictor' => { 39 => 0x13d },
	'preservedfilename' => { 119 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 15 => 0x6 },
	'previewfocalplaneyresolution' => { 15 => 0x8 },
	'previewimage' => { 37 => 0x2000, 38 => 'PreviewImage', 39 => 0x927c, 60 => 'data', 66 => 0x81, 93 => 0x280 },
	'previewimagedata' => { 97 => 0x2000 },
	'previewimageheight' => { 15 => 0x4 },
	'previewimagelength' => { 15 => 0x2, 37 => 0x3, 39 => [0x117,0x202], 66 => 0x89, 76 => 0x202, 89 => 0x102, 93 => 0x1037, 97 => 0x3, 102 => 0x1e },
	'previewimagename' => { 60 => '1Name' },
	'previewimagesize' => { 37 => 0x2, 60 => 'ImageSize', 97 => 0x2 },
	'previewimagestart' => { 15 => 0x5, 37 => 0x4, 39 => [0x111,0x201], 66 => 0x88, 76 => 0x201, 89 => 0x101, 93 => 0x1036, 97 => 0x4, 102 => 0x1c },
	'previewimagetype' => { 60 => '0Type' },
	'previewimagevalid' => { 89 => 0x100, 93 => 0x1035 },
	'previewimagewidth' => { 15 => 0x3 },
	'previewquality' => { 15 => 0x1 },
	'primarychromaticities' => { 39 => 0x13f, 115 => 'PrimaryChromaticities' },
	'printim' => { 39 => 0xc4a5 },
	'producer' => { 113 => 'Producer' },
	'productid' => { 44 => 0x32 },
	'programmode' => { 68 => 0x5 },
	'programshift' => { 75 => 0xd },
	'programversion' => { 43 => 0x46 },
	'projectrefpath' => { 118 => 'projectRefPath' },
	'projectreftype' => { 118 => 'projectRefType' },
	'province-state' => { 43 => 0x5f },
	'publisher' => { 109 => 'publisher' },
	'pulldown' => { 118 => 'pullDown' },
	'quality' => { 1 => 0x3, 36 => 0x2, 37 => 0x3002, 41 => 0x1000, 47 => 0x9, 75 => 0x4, 77 => 0x3, 93 => 0x201, 97 => 0x8, 105 => 0x16 },
	'qualitymode' => { 37 => 0x8 },
	'quantizationmethod' => { 45 => 0x78 },
	'quickshot' => { 104 => 0x213 },
	'rasterizedcaption' => { 43 => 0x7d },
	'rating' => { 110 => 'rating', 116 => 'Rating' },
	'rawandjpgrecording' => { 18 => 0x8 },
	'rawdatauniqueid' => { 39 => 0xc65d },
	'rawdepth' => { 67 => 0x10 },
	'rawdevcolorspace' => { 94 => 0x108 },
	'rawdevcontrastvalue' => { 94 => 0x106 },
	'rawdeveditstatus' => { 94 => 0x10b },
	'rawdevengine' => { 94 => 0x109 },
	'rawdevexposurebiasvalue' => { 94 => 0x100 },
	'rawdevgraypoint' => { 94 => 0x103 },
	'rawdevmemorycoloremphasis' => { 94 => 0x105 },
	'rawdevnoisereduction' => { 94 => 0x10a },
	'rawdevsaturationemphasis' => { 94 => 0x104 },
	'rawdevsettings' => { 94 => 0x10c },
	'rawdevsharpnessvalue' => { 94 => 0x107 },
	'rawdevversion' => { 94 => 0x0 },
	'rawdevwbfineadjustment' => { 94 => 0x102 },
	'rawdevwhitebalancevalue' => { 94 => 0x101 },
	'rawfile' => { 39 => 0xfe4c },
	'rawfilename' => { 108 => 'RawFileName' },
	'rawimagecenter' => { 75 => 0x99 },
	'rawimagesize' => { 97 => 0x39 },
	'rawjpgheight' => { 34 => 0x4 },
	'rawjpgquality' => { 8 => 0x6, 34 => 0x1 },
	'rawjpgsize' => { 8 => 0x7, 34 => 0x2 },
	'rawjpgwidth' => { 34 => 0x3 },
	'recordid' => { 32 => 0x1804 },
	'recordingmode' => { 36 => 0x1 },
	'recordmode' => { 37 => 0x3000 },
	'recordshutterrelease' => { 104 => 0x217 },
	'redbalance' => { 52 => 'RedBalance', 93 => 0x1017, 97 => 0x1c },
	'redeyecorrection' => { 86 => 0x0 },
	'redhue' => { 108 => 'RedHue' },
	'redsaturation' => { 108 => 'RedSaturation' },
	'referenceblackwhite' => { 39 => 0x214, 115 => 'ReferenceBlackWhite' },
	'referencedate' => { 43 => 0x2f },
	'referencenumber' => { 43 => 0x32 },
	'references' => { 53 => 'References' },
	'referenceservice' => { 43 => 0x2d },
	'relatedaudiofile' => { 51 => 'data' },
	'relatedaudiofilename' => { 51 => '1Name' },
	'relatedaudiofiletype' => { 51 => '0Type' },
	'relatedimagelength' => { 39 => 0x1002 },
	'relatedimagewidth' => { 39 => 0x1001 },
	'relatedsoundfile' => { 39 => 0xa004, 111 => 'RelatedSoundFile' },
	'relatedvideofile' => { 62 => 'data' },
	'relatedvideofilename' => { 62 => '1Name' },
	'relatedvideofiletype' => { 62 => '0Type' },
	'relation' => { 109 => 'relation' },
	'relativepeakaudiofilepath' => { 118 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 118 => 'relativeTimestamp' },
	'releasedate' => { 43 => 0x1e, 118 => 'releaseDate' },
	'releasesetting' => { 32 => 0x1016 },
	'releasetime' => { 43 => 0x23 },
	'renditionclass' => { 119 => 'RenditionClass' },
	'renditionofdocumentid' => { 119 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 119 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 119 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 119 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 119 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 119 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 119 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 119 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 119 => 'RenditionOfVersionID' },
	'renditionparams' => { 119 => 'RenditionParams' },
	'resampleparamsquality' => { 118 => 'resampleParamsQuality' },
	'resaved' => { 104 => 0x21e },
	'resolution' => { 57 => 'Resolution' },
	'resolutionmode' => { 105 => 0x4 },
	'resolutionunit' => { 39 => 0x128, 46 => 0x2, 115 => 'ResolutionUnit' },
	'resolutionunits' => { 57 => 'ResolutionUnits' },
	'reuseallowed' => { 120 => 'ReuseAllowed' },
	'revision' => { 110 => 'revision' },
	'ricohdate' => { 102 => 0x6 },
	'ricohimageheight' => { 102 => 0x2 },
	'ricohimagewidth' => { 102 => 0x0 },
	'rights' => { 109 => 'rights' },
	'romoperationmode' => { 32 => 0x80d },
	'rotation' => { 31 => 0x3, 64 => 0x50, 65 => 0x46, 83 => 0x76a43207, 96 => 0x30 },
	'routing' => { 101 => 'Routing' },
	'rowsperstrip' => { 39 => 0x116 },
	'safetyshiftinavortv' => { 18 => 0x10, 19 => 0x10, 20 => 0xf, 21 => 0x10, 24 => 0x10 },
	'samplebits' => { 51 => 'SampleBits' },
	'samplerate' => { 51 => 'SampleRate' },
	'samplesperpixel' => { 39 => 0x115, 115 => 'SamplesPerPixel' },
	'samplestructure' => { 45 => 0x5a },
	'sanyoquality' => { 104 => 0x201 },
	'sanyothumbnail' => { 104 => 0x100 },
	'saturation' => { 1 => 0xe, 6 => 0x1, 36 => 0xd, 37 => [0x3013,0x1f], 39 => [0xa409,0xfe55], 41 => 0x1003, 52 => 'Saturation', 63 => 0x1f, 64 => 0x32, 65 => 0x28, 68 => 0x1, 75 => [0x94,0xaa], 97 => 0x1f, 102 => 0x28, 105 => 0x10, 108 => 'Saturation', 111 => 'Saturation' },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 119 => 'SaveID' },
	'scaledfocallength' => { 10 => 0x1 },
	'scaledresolution' => { 80 => 0x9e },
	'scaletype' => { 118 => 'scaleType' },
	'scanningdirection' => { 45 => 0x64 },
	'scene' => { 112 => 'Scene', 118 => 'scene' },
	'scenecapturetype' => { 39 => 0xa406, 111 => 'SceneCaptureType' },
	'scenemode' => { 75 => 0x8f, 89 => 0x509 },
	'sceneselect' => { 104 => 0x21f },
	'scenetype' => { 39 => 0xa301, 111 => 'SceneType' },
	'securityclassification' => { 39 => 0x9212 },
	'self-timer' => { 1 => 0x2 },
	'self-timer2' => { 17 => 0x1d },
	'selftimer' => { 37 => 0x3001, 96 => 0x2e, 104 => 0x214 },
	'selftimermode' => { 39 => 0x882b },
	'selftimertime' => { 32 => 0x1806 },
	'seminfo' => { 39 => 0x8546 },
	'sensingmethod' => { 39 => 0xa217, 111 => 'SensingMethod' },
	'sensorbluelevel' => { 16 => 0x5 },
	'sensorcleaning' => { 25 => 0xd },
	'sensorheight' => { 67 => 0x8 },
	'sensorpixelsize' => { 75 => 0x9a },
	'sensorredlevel' => { 16 => 0x4 },
	'sensorsize' => { 52 => 'SensorSize' },
	'sensortemperature' => { 91 => 0x1500, 93 => 0x1007 },
	'sensorwidth' => { 67 => 0xa },
	'sequence' => { 89 => 0x600 },
	'sequencenumber' => { 17 => 0x9, 37 => 0x301c, 41 => 0x1101, 47 => 0x1d, 96 => 0x2b },
	'sequenceshotinterval' => { 104 => 0x224 },
	'sequentialshot' => { 104 => 0x20e },
	'serialnumber' => { 11 => 0xc, 32 => 0x180b, 39 => 0xfde9, 52 => 'SerialNumber', 75 => 0xa0, 90 => 0x101, 93 => [0x404,0x101a], 105 => 0x2, 106 => 'SerialNumber' },
	'serialnumberformat' => { 11 => 0x15, 32 => 0x183b },
	'serviceidentifier' => { 44 => 0x1e },
	'setbuttoncrosskeysfunc' => { 22 => 0x0, 23 => 0x0 },
	'setbuttonfunction' => { 18 => 0x1, 25 => 0xc },
	'setfunctionwhenshooting' => { 20 => 0x0, 21 => 0x1, 24 => 0x1 },
	'shadingcompensation' => { 89 => 0x50c },
	'shadingcompensation2' => { 92 => 0x1012 },
	'shadow' => { 105 => 0xe },
	'shadows' => { 39 => 0xfe52, 108 => 'Shadows' },
	'shadowscale' => { 39 => 0xc633 },
	'shadowtint' => { 108 => 'ShadowTint' },
	'sharpness' => { 1 => 0xf, 16 => 0x2, 36 => 0xb, 37 => [0x3011,0x21], 39 => [0xa40a,0xfe56], 41 => 0x1001, 47 => 0x6b, 49 => 0x37, 52 => 'Sharpness', 63 => 0x21, 64 => 0x30, 65 => 0x26, 68 => 0x3, 75 => 0x6, 93 => 0x100f, 97 => 0x21, 102 => 0x22, 103 => 0x1003, 105 => 0x11, 108 => 'Sharpness', 111 => 'Sharpness' },
	'sharpnessfactor' => { 93 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 16 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 89 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 52 => 'ShootingMode', 75 => 0x89, 96 => 0x1f },
	'shortdescription' => { 110 => 'shortdescription' },
	'shortdocumentid' => { 43 => 0xba },
	'shortfocal' => { 0 => 0x12, 1 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shotdate' => { 118 => 'shotDate' },
	'shotlocation' => { 118 => 'shotLocation' },
	'shotname' => { 118 => 'shotName' },
	'shutter-aelock' => { 18 => 0x4, 20 => 0x3, 21 => 0x4, 22 => 0x3, 23 => 0x3, 24 => 0x4, 25 => 0x2 },
	'shutteraelbutton' => { 19 => 0x4 },
	'shuttercount' => { 8 => 0x1 },
	'shuttercurtainsync' => { 18 => 0xf, 19 => 0xf, 20 => 0xe, 21 => 0xf, 22 => 0x8, 23 => 0x8, 24 => 0xf, 25 => 0x8 },
	'shuttermode' => { 47 => 0x1b },
	'shutterreleasemethod' => { 32 => 0x1010 },
	'shutterreleasenocfcard' => { 18 => 0x2, 19 => 0x2, 25 => 0xf },
	'shutterreleasetiming' => { 32 => 0x1011 },
	'shutterspeedvalue' => { 39 => 0x9201, 93 => 0x1000, 111 => 'ShutterSpeedValue' },
	'similarityindex' => { 43 => 0xe4 },
	'slowshutter' => { 17 => 0x8 },
	'slowsync' => { 41 => 0x1030 },
	'smoothingparameter1' => { 92 => 0x300 },
	'smoothingparameter2' => { 92 => 0x310 },
	'smoothingthreshold2' => { 92 => 0x610 },
	'smoothingthresholds' => { 92 => 0x600 },
	'smoothness' => { 39 => 0xfe57 },
	'software' => { 39 => 0x131, 53 => 'Software', 95 => 'Software', 105 => 0x18, 115 => 'Software' },
	'softwareversion' => { 104 => 0x207 },
	'source' => { 43 => 0x73, 95 => 'Source', 109 => 'source', 110 => 'source', 114 => 'Source' },
	'sourceresolution' => { 80 => 0xae },
	'spatialfrequencyresponsecolumns' => { 111 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 111 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 111 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 111 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 118 => 'speakerPlacement' },
	'specialinstructions' => { 43 => 0x28 },
	'specialmode' => { 93 => 0x200, 104 => 0x200 },
	'spectralsensitivity' => { 39 => 0x8824, 111 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 63 => 0x2d },
	'spotfocuspointy' => { 63 => 0x2e },
	'spotmode' => { 96 => 0xf },
	'starttimecodetimeformat' => { 118 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 118 => 'startTimecodeTimeValue' },
	'state' => { 56 => 'State', 114 => 'State' },
	'storagemethod' => { 67 => 0x12 },
	'straightenangle' => { 83 => 0x2fc08431 },
	'stretchmode' => { 118 => 'stretchMode' },
	'sub-location' => { 43 => 0x5c },
	'subfile' => { 59 => 'data' },
	'subfiledirectory' => { 59 => '1Directory' },
	'subfilemimetype' => { 59 => '2MIME' },
	'subfilename' => { 59 => '1Name' },
	'subfileresource' => { 59 => 'resource' },
	'subfiletype' => { 39 => 0xfe, 59 => '0Type' },
	'subject' => { 101 => 'Subject', 109 => 'subject', 113 => 'Subject' },
	'subjectarea' => { 111 => 'SubjectArea' },
	'subjectcode' => { 112 => 'SubjectCode' },
	'subjectdistance' => { 39 => 0x9206, 47 => 0x3e, 111 => 'SubjectDistance' },
	'subjectdistancerange' => { 39 => 0xa40c, 111 => 'SubjectDistanceRange' },
	'subjectlocation' => { 39 => [0x9214,0xa214], 111 => 'SubjectLocation' },
	'subjectprogram' => { 63 => 0x22 },
	'subjectreference' => { 43 => 0xc },
	'subsectime' => { 39 => 0x9290 },
	'subsectimedigitized' => { 39 => 0x9292 },
	'subsectimeoriginal' => { 39 => 0x9291 },
	'superimposeddisplay' => { 18 => 0xa, 20 => 0x9, 21 => 0xa, 24 => 0xa, 25 => 0xe },
	'supplementalcategories' => { 43 => 0x14, 114 => 'SupplementalCategories' },
	'supplementaltype' => { 45 => 0x37 },
	'switchtoregisteredafpoint' => { 19 => 0x12 },
	'tapename' => { 118 => 'tapeName' },
	'targetaperture' => { 17 => 0x4 },
	'targetcompressionratio' => { 30 => 0x1 },
	'targetdistancesetting' => { 32 => 0x1807 },
	'targetexposuretime' => { 17 => 0x5 },
	'targetimagetype' => { 32 => 0x100a },
	'temperature' => { 108 => 'Temperature' },
	'tempo' => { 118 => 'tempo' },
	'thresholding' => { 39 => 0x107 },
	'thumbnailfilename' => { 32 => 0x817 },
	'thumbnailimage' => { 32 => 0x2008, 38 => 'ThumbnailImage', 61 => 'data', 93 => 0x100 },
	'thumbnailimagename' => { 61 => '1Name' },
	'thumbnailimagesize' => { 61 => 'ImageSize' },
	'thumbnailimagetype' => { 61 => '0Type' },
	'thumbnaillength' => { 39 => 0x202 },
	'thumbnailoffset' => { 39 => 0x201 },
	'thumbnailsformat' => { 116 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 116 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 116 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 116 => 'ThumbnailsWidth' },
	'tilelength' => { 39 => 0x143 },
	'tilewidth' => { 39 => 0x142 },
	'time' => { 97 => 0x7 },
	'timecreated' => { 43 => 0x3c, 47 => 0x14, 49 => 0x10 },
	'timescaleparamsframeoverlappingpercentage' => { 118 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 118 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 118 => 'timeScaleParamsQuality' },
	'timesent' => { 44 => 0x50 },
	'timesignature' => { 118 => 'timeSignature' },
	'timestamp' => { 0 => 0x11c, 95 => 'TimeStamp' },
	'timezone' => { 37 => 0x3006 },
	'timezonecode' => { 35 => 0x1 },
	'timezoneinfo' => { 35 => 0x2 },
	'timezoneoffset' => { 39 => 0x882a },
	'tint' => { 108 => 'Tint' },
	'title' => { 53 => 'Title', 95 => 'Title', 101 => 'Title', 109 => 'title', 113 => 'Title' },
	'tonecomp' => { 75 => 0x81 },
	'tonecurve' => { 16 => 0x1, 97 => 0x402, 108 => 'ToneCurve' },
	'tonecurvename' => { 108 => 'ToneCurveName' },
	'tonecurves' => { 97 => 0x403 },
	'toningeffect' => { 8 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 47 => 0x62 },
	'tracknumber' => { 118 => 'trackNumber' },
	'transferfunction' => { 115 => 'TransferFunction' },
	'transmissionreference' => { 114 => 'TransmissionReference' },
	'tvvalue' => { 28 => 0x1 },
	'type' => { 109 => 'type' },
	'uniquecameramodel' => { 39 => 0xc614 },
	'uniquedocumentid' => { 43 => 0xbb },
	'uniqueobjectname' => { 44 => 0x64 },
	'unsharp1color' => { 87 => 0x13 },
	'unsharp1halowidth' => { 87 => 0x19 },
	'unsharp1intensity' => { 87 => 0x17 },
	'unsharp1threshold' => { 87 => 0x1b },
	'unsharp2color' => { 87 => 0x2e },
	'unsharp2halowidth' => { 87 => 0x34 },
	'unsharp2intensity' => { 87 => 0x32 },
	'unsharp2threshold' => { 87 => 0x36 },
	'unsharp3color' => { 87 => 0x49 },
	'unsharp3halowidth' => { 87 => 0x4f },
	'unsharp3intensity' => { 87 => 0x4d },
	'unsharp3threshold' => { 87 => 0x51 },
	'unsharp4color' => { 87 => 0x64 },
	'unsharp4halowidth' => { 87 => 0x6a },
	'unsharp4intensity' => { 87 => 0x68 },
	'unsharp4threshold' => { 87 => 0x6c },
	'unsharpcount' => { 87 => 0x0 },
	'unsharpmask' => { 83 => 0x76a43200 },
	'urgency' => { 43 => 0xa, 114 => 'Urgency' },
	'url' => { 53 => 'URL', 95 => 'URL', 99 => 0x40b },
	'usageterms' => { 121 => 'UsageTerms' },
	'usercomment' => { 32 => 0x805, 39 => 0x9286, 111 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 19 => 0x7 },
	'validbits' => { 92 => 0x611, 93 => 0x102c },
	'variousmodes' => { 47 => 0x26 },
	'variousmodes2' => { 47 => 0x3a },
	'variprogram' => { 75 => 0xab },
	'version' => { 41 => 0x0, 101 => 'Version', 108 => 'Version' },
	'versionid' => { 119 => 'VersionID' },
	'versionscomments' => { 119 => 'VersionsComments' },
	'versionseventaction' => { 119 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 119 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 119 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 119 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 119 => 'VersionsEventWhen' },
	'versionsmodifier' => { 119 => 'VersionsModifier' },
	'versionsmodifydate' => { 119 => 'VersionsModifyDate' },
	'versionsversion' => { 119 => 'VersionsVersion' },
	'videoalphamode' => { 118 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 118 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 118 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 118 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 118 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 118 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 118 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 118 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 118 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 118 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 118 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 118 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 118 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 118 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 118 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 118 => 'videoColorSpace' },
	'videocompressor' => { 118 => 'videoCompressor' },
	'videofieldorder' => { 118 => 'videoFieldOrder' },
	'videoframerate' => { 118 => 'videoFrameRate' },
	'videoframesizeh' => { 118 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 118 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 118 => 'videoFrameSizeW' },
	'videomoddate' => { 118 => 'videoModDate' },
	'videopixelaspectratio' => { 118 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 118 => 'videoPixelDepth' },
	'vignetteamount' => { 108 => 'VignetteAmount' },
	'vignettecontrol' => { 83 => 0x76a43205 },
	'vignettecontrolintensity' => { 83 => 0xac6bd5c0 },
	'vignettemidpoint' => { 108 => 'VignetteMidpoint' },
	'voicememo' => { 104 => 0x216 },
	'wb_rbgglevels' => { 71 => 0x0 },
	'wb_rblevels' => { 92 => 0x100 },
	'wb_rgbglevels' => { 73 => 0x0 },
	'wb_rggblevels' => { 72 => 0x0 },
	'wb_rggblevelsasshot' => { 3 => 0x19, 4 => 0x18, 5 => 0x3f },
	'wb_rggblevelsauto' => { 2 => 0x0, 3 => 0x1e, 4 => 0x22, 5 => 0x44 },
	'wb_rggblevelscloudy' => { 2 => 0xc, 3 => 0x2d, 4 => 0x31, 5 => 0x58 },
	'wb_rggblevelscustom' => { 2 => 0x1c, 5 => 0x80 },
	'wb_rggblevelscustom1' => { 3 => 0x41 },
	'wb_rggblevelscustom2' => { 3 => 0x46 },
	'wb_rggblevelsdaylight' => { 2 => 0x4, 3 => 0x23, 4 => 0x27, 5 => 0x4e },
	'wb_rggblevelsflash' => { 2 => 0x18, 3 => 0x3c, 4 => 0x45, 5 => 0x6c },
	'wb_rggblevelsfluorescent' => { 2 => 0x14, 3 => 0x37, 4 => 0x3b, 5 => 0x62 },
	'wb_rggblevelskelvin' => { 2 => 0x20, 4 => 0x40, 5 => 0x67 },
	'wb_rggblevelsmeasured' => { 5 => 0x49 },
	'wb_rggblevelspc1' => { 4 => 0x90, 5 => 0x71 },
	'wb_rggblevelspc2' => { 4 => 0x95, 5 => 0x76 },
	'wb_rggblevelspc3' => { 4 => 0x9a, 5 => 0x7b },
	'wb_rggblevelsshade' => { 2 => 0x8, 3 => 0x28, 4 => 0x2c, 5 => 0x53 },
	'wb_rggblevelstungsten' => { 2 => 0x10, 3 => 0x32, 4 => 0x36, 5 => 0x5d },
	'wb_rggblevelsunknown' => { 4 => 0x1d },
	'wb_rggblevelsunknown10' => { 4 => 0x72 },
	'wb_rggblevelsunknown11' => { 4 => 0x77 },
	'wb_rggblevelsunknown12' => { 4 => 0x7c },
	'wb_rggblevelsunknown13' => { 4 => 0x81 },
	'wb_rggblevelsunknown14' => { 4 => 0x86 },
	'wb_rggblevelsunknown15' => { 4 => 0x8b },
	'wb_rggblevelsunknown16' => { 4 => 0x9f },
	'wb_rggblevelsunknown2' => { 4 => 0x4a },
	'wb_rggblevelsunknown3' => { 4 => 0x4f },
	'wb_rggblevelsunknown4' => { 4 => 0x54 },
	'wb_rggblevelsunknown5' => { 4 => 0x59 },
	'wb_rggblevelsunknown6' => { 4 => 0x5e },
	'wb_rggblevelsunknown7' => { 4 => 0x63 },
	'wb_rggblevelsunknown8' => { 4 => 0x68 },
	'wb_rggblevelsunknown9' => { 4 => 0x6d },
	'wbadjbluebalance' => { 88 => 0x8 },
	'wbadjlighting' => { 88 => 0x15 },
	'wbadjmode' => { 88 => 0x10 },
	'wbadjredbalance' => { 88 => 0x0 },
	'wbadjtemperature' => { 88 => 0x18 },
	'wbbracketmode' => { 8 => 0x9 },
	'wbbracketvalueab' => { 8 => 0xc },
	'wbbracketvaluegm' => { 8 => 0xd },
	'wblevels' => { 69 => 0x4 },
	'wbmode' => { 68 => 0x4, 93 => 0x1015 },
	'wbscale' => { 69 => 0x0 },
	'wbshiftab' => { 16 => 0xc },
	'wbshiftgm' => { 16 => 0xd },
	'webstatement' => { 121 => 'WebStatement' },
	'whitebalance' => { 16 => 0x8, 17 => 0x7, 36 => 0x7, 37 => [0x19,0x2012], 39 => [0xa403,0xfe4e], 41 => 0x1002, 47 => 0x40, 63 => 0x3, 64 => 0xe, 65 => 0x4, 75 => 0x5, 77 => 0x7, 96 => 0x3, 97 => 0x19, 102 => 0x26, 105 => 0x7, 108 => 'WhiteBalance', 111 => 'WhiteBalance' },
	'whitebalance2' => { 89 => 0x500 },
	'whitebalanceadj' => { 83 => 0x76a43204 },
	'whitebalancebias' => { 37 => 0x2011, 96 => 0x23 },
	'whitebalanceblue' => { 16 => 0x7 },
	'whitebalancebracket' => { 89 => 0x502 },
	'whitebalancefinetune' => { 75 => 0xb },
	'whitebalancemode' => { 97 => 0x1a },
	'whitebalancered' => { 16 => 0x6 },
	'whitebalancetemperature' => { 89 => 0x501 },
	'whitepoint' => { 39 => 0x13e, 97 => 0x201, 115 => 'WhitePoint' },
	'widefocuszone' => { 63 => 0x2f },
	'widerange' => { 104 => 0x20f },
	'worldtimelocation' => { 97 => 0x22 },
	'writer-editor' => { 43 => 0x7a },
	'x3filllight' => { 105 => 0x12 },
	'xmp' => { 40 => 'XMP' },
	'xpauthor' => { 39 => 0x9c9d },
	'xpcomment' => { 39 => 0x9c9c },
	'xpkeywords' => { 39 => 0x9c9e },
	'xposition' => { 39 => 0x11e },
	'xpsubject' => { 39 => 0x9c9f },
	'xptitle' => { 39 => 0x9c9b },
	'xresolution' => { 39 => 0x11a, 46 => 0x3, 100 => 0x0, 115 => 'XResolution' },
	'ycbcrcoefficients' => { 39 => 0x211, 115 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 39 => 0x213, 115 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 39 => 0x212, 115 => 'YCbCrSubSampling' },
	'yearcreated' => { 47 => 0x10, 49 => 0xc },
	'yposition' => { 39 => 0x11f },
	'yresolution' => { 39 => 0x11b, 46 => 0x5, 100 => 0x4, 115 => 'YResolution' },
	'zonematching' => { 66 => 0x10a, 68 => 0x3a },
	'zonematchingon' => { 65 => 0x75 },
	'zoomsourcewidth' => { 1 => 0x24 },
	'zoomstepcount' => { 91 => 0x300, 93 => 0x100d },
	'zoomtargetwidth' => { 1 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'adobephotoshop' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'afaperture' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afpointsused1d' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applicationnotes' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blacklevel2' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytesperminute' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canoncamerainfo' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canoncustomfunctions10d' => 1,
	'canoncustomfunctions20d' => 1,
	'canoncustomfunctionsd30' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmcontrast' => 1,
	'cmexposurecompensation' => 1,
	'cmhue' => 1,
	'cmmflags' => 1,
	'cmsaturation' => 1,
	'cmsharpness' => 1,
	'cmwhitebalance' => 1,
	'cmwhitebalancecomp' => 1,
	'cmwhitebalancegraypoint' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colormodesetting' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compressedtext' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentrating' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringvalues' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'dngmakernotes' => 1,
	'dngprivatedata' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodersettings' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'ev' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalimageheight' => 1,
	'finalimagewidth' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focuspos' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'gpsdatetime' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'heightresolution' => 1,
	'highlightendpoints' => 1,
	'huesetting' => 1,
	'hyperfocaldistance' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourcedata' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'jfifversion' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'konicaminolta' => 1,
	'languagelist' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'linearizationtable' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotebyteorder' => 1,
	'makernotelength' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'msstereo' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'opacity' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalzoom' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmakernoteoffset' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pages' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'panasonicrawversion' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'people' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picture' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdevelopment' => 1,
	'rawimagemode' => 1,
	'rawinfo' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'relatedimagefile' => 1,
	'relatedimagefileformat' => 1,
	'renderingintent' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resultaspectratio' => 1,
	'revisionnumber' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saturationsetting' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serviceorganizationname' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimageheader' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailresource' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titlesortorder' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transfomation' => 1,
	'transform' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validpixeldepth' => 1,
	'vbrpeak' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_bluelevel' => 1,
	'wb_grbglevels' => 1,
	'wb_greenlevel' => 1,
	'wb_rblevelsauto' => 1,
	'wb_rblevelscloudy' => 1,
	'wb_rblevelscoolwhitefluor' => 1,
	'wb_rblevelsdaylightfluor' => 1,
	'wb_rblevelsdaywhitefluor' => 1,
	'wb_rblevelseveningsunlight' => 1,
	'wb_rblevelsfineweather' => 1,
	'wb_rblevelsshade' => 1,
	'wb_rblevelstungsten' => 1,
	'wb_rblevelsused' => 1,
	'wb_rblevelswhitefluorescent' => 1,
	'wb_redlevel' => 1,
	'wbadjdata' => 1,
	'whitebalancecomp' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2006, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
