#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 191 => 'absPeakAudioFilePath' },
	'accessorytype' => { 149 => 0x53 },
	'actionadvised' => { 59 => 0x2a },
	'activearea' => { 53 => 0xc68d },
	'actived-lighting' => { 111 => 0x22 },
	'addaspectratioinfo' => { 30 => 0x80e },
	'addoriginaldecisiondata' => { 30 => 0x80f, 31 => 0x11, 32 => 0x13, 35 => 0x14 },
	'address' => { 81 => 'Address' },
	'adjustmentmode' => { 173 => [0x15,0x22] },
	'advancedraw' => { 129 => 0x76a43203 },
	'advisory' => { 189 => 'Advisory' },
	'ae_iso' => { 151 => 0x2 },
	'aeaperture' => { 151 => 0x1 },
	'aebautocancel' => { 30 => 0x104 },
	'aebbracketvalue' => { 27 => 0x11 },
	'aebsequence' => { 28 => 0x9, 29 => 0x9, 30 => 0x105, 31 => 0x8, 32 => 0x9, 35 => 0x9, 36 => 0x7 },
	'aebshotcount' => { 30 => 0x106 },
	'aebxv' => { 151 => 0x4 },
	'aeexposuretime' => { 151 => 0x0 },
	'aeextra' => { 151 => 0x7 },
	'aeflashtv' => { 151 => 0x5 },
	'aelock' => { 119 => '733.3', 120 => '752.2', 135 => 0x201, 161 => 0x48 },
	'aelockbutton' => { 119 => '733.2', 120 => '752.1' },
	'aemeteringmode' => { 151 => 0xc },
	'aemeteringsegments' => { 161 => 0x209 },
	'aeprogrammode' => { 151 => 0x6 },
	'aesetting' => { 8 => 0x21 },
	'aexv' => { 151 => 0x3 },
	'af-cpriorityselection' => { 118 => '791.1' },
	'af-onformb-d10' => { 118 => '793.1' },
	'af-spriorityselection' => { 118 => '791.2' },
	'afactivation' => { 118 => '792.1' },
	'afadjustment' => { 161 => 0x72 },
	'afaperture' => { 110 => 0x5 },
	'afareaillumination' => { 120 => '763.3' },
	'afareamode' => { 98 => 0x0, 120 => 0x2fc },
	'afareamodesetting' => { 119 => 0x2e4 },
	'afareas' => { 135 => 0x304 },
	'afassist' => { 28 => 0x5, 36 => 0x5, 119 => '729.2', 120 => '748.2' },
	'afassistbeam' => { 30 => 0x50e, 31 => 0x4, 32 => 0x5, 33 => 0x4, 34 => 0x4, 35 => 0x5 },
	'afassistilluminator' => { 118 => '792.4' },
	'afdefocus' => { 152 => 0x6 },
	'afduringliveview' => { 30 => 0x511 },
	'afexpansionwithselectedpoint' => { 30 => 0x508 },
	'affinetuneadj' => { 118 => 0x2d1 },
	'afintegrationtime' => { 152 => 0x7 },
	'afmicroadjustment' => { 30 => 0x507 },
	'afmode' => { 149 => 0xf, 173 => 0x5 },
	'afonaelockbuttonswitch' => { 30 => 0x702 },
	'afpoint' => { 8 => 0x13, 49 => 0x18, 98 => 0x1, 138 => 0x308 },
	'afpointactivationarea' => { 29 => 0x11, 35 => 0x11 },
	'afpointautoselection' => { 30 => 0x50b },
	'afpointbrightness' => { 30 => 0x50d },
	'afpointdisplayduringfocus' => { 30 => 0x50c },
	'afpointillumination' => { 29 => 0xa, 118 => '792.3' },
	'afpointmode' => { 155 => 0x3 },
	'afpointposition' => { 50 => 0x2021 },
	'afpointregistration' => { 28 => 0x7 },
	'afpoints' => { 92 => 0x10 },
	'afpointselected' => { 161 => 0xe },
	'afpointselected2' => { 155 => 0x4 },
	'afpointselection' => { 29 => 0xb, 118 => '791.3' },
	'afpointselectionmethod' => { 30 => 0x50f, 31 => 0xc, 32 => 0xd, 35 => 0xd },
	'afpointsinfocus' => { 27 => 0xe, 98 => 0x2, 152 => 0xb, 161 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 6 => 0x38 },
	'afpointspotmetering' => { 29 => 0xd },
	'afpointsunknown1' => { 152 => 0x0 },
	'afpointsunknown2' => { 152 => 0x2 },
	'afpointsused' => { 99 => 0x8 },
	'afpredictor' => { 152 => 0x4 },
	'afresponse' => { 111 => 0xad },
	'afresult' => { 140 => 0x1038 },
	'afsearch' => { 135 => 0x303 },
	'aiservoimagepriority' => { 30 => 0x503 },
	'aiservotrackingmethod' => { 30 => 0x504 },
	'aiservotrackingsensitivity' => { 29 => 0x14, 30 => 0x502 },
	'album' => { 191 => 'album' },
	'alreadyapplied' => { 181 => 'AlreadyApplied' },
	'alttapename' => { 191 => 'altTapeName' },
	'alttimecodetimeformat' => { 191 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 191 => 'altTimecodeTimeValue' },
	'anti-blur' => { 174 => 0xb04b },
	'antialiasstrength' => { 53 => 0xc632 },
	'aperturerange' => { 30 => 0x10d },
	'aperturevalue' => { 53 => 0x9202, 140 => 0x1002, 184 => 'ApertureValue' },
	'applekeywords' => { 144 => 'AAPL:Keywords' },
	'applicationnotes' => { 53 => 0x2bc },
	'applicationrecordversion' => { 59 => 0x0 },
	'applyshootingmeteringmode' => { 30 => 0x10e },
	'approximatefnumber' => { 147 => 0x313 },
	'armidentifier' => { 60 => 0x78 },
	'armversion' => { 60 => 0x7a },
	'artist' => { 53 => 0x13b, 146 => 'Artist', 188 => 'Artist', 191 => 'artist' },
	'asshoticcprofile' => { 53 => 0xc68f },
	'asshotpreprofilematrix' => { 53 => 0xc690 },
	'asshotwhitexy' => { 53 => 0xc629 },
	'assistbuttonfunction' => { 28 => 0xd },
	'audio' => { 149 => 0x20 },
	'audiochanneltype' => { 191 => 'audioChannelType' },
	'audiocompression' => { 75 => 'Compression' },
	'audiocompressor' => { 191 => 'audioCompressor' },
	'audioduration' => { 59 => 0x99 },
	'audiomoddate' => { 191 => 'audioModDate' },
	'audiooutcue' => { 59 => 0x9a },
	'audiosamplerate' => { 191 => 'audioSampleRate' },
	'audiosampletype' => { 191 => 'audioSampleType' },
	'audiosamplingrate' => { 59 => 0x97 },
	'audiosamplingresolution' => { 59 => 0x98 },
	'audiotype' => { 59 => 0x96 },
	'author' => { 77 => 'Author', 144 => 'Author', 146 => 'Author', 169 => 'Author', 186 => 'Author' },
	'authorsposition' => { 187 => 'AuthorsPosition' },
	'autoaperture' => { 158 => '0.1' },
	'autobracket' => { 173 => 0x19 },
	'autobracketing' => { 57 => 0x1100, 161 => 0x18 },
	'autobracketmodem' => { 118 => '811.2' },
	'autobracketorder' => { 118 => '811.3', 120 => '750.2' },
	'autobracketrelease' => { 111 => 0x8a },
	'autobracketset' => { 118 => '811.1', 120 => '750.1' },
	'autobrightness' => { 181 => 'AutoBrightness' },
	'autocontrast' => { 181 => 'AutoContrast' },
	'autoexposure' => { 181 => 'AutoExposure' },
	'autoexposurebracketing' => { 27 => 0x10 },
	'autofocus' => { 138 => 0x209 },
	'autofp' => { 120 => '755.2' },
	'autoiso' => { 27 => 0x1, 50 => 0x3008, 119 => '730.1', 120 => '749.1' },
	'autoisomax' => { 119 => '730.2', 120 => '749.2' },
	'autoisominshutterspeed' => { 119 => '730.3', 120 => '749.3' },
	'autolightingoptimizer' => { 30 => 0x204 },
	'autorotate' => { 27 => 0x1b },
	'autoshadows' => { 181 => 'AutoShadows' },
	'auxiliarylens' => { 111 => 0x82 },
	'avaperturesetting' => { 155 => 0x13 },
	'avsettingwithoutlens' => { 30 => 0x707 },
	'avvalue' => { 39 => 0x2 },
	'azimuth' => { 85 => 'Azimuth' },
	'babyage' => { 149 => [0x8010,0x33] },
	'baseexposurecompensation' => { 155 => 0x15 },
	'baseiso' => { 27 => 0x2, 43 => 0x101c },
	'baselineexposure' => { 53 => 0xc62a },
	'baselinenoise' => { 53 => 0xc62b },
	'baselinesharpness' => { 53 => 0xc62c },
	'baseurl' => { 189 => 'BaseURL' },
	'batteryadbodyload' => { 153 => 0x3 },
	'batteryadbodynoload' => { 153 => 0x2 },
	'batteryadgripload' => { 153 => 0x5 },
	'batteryadgripnoload' => { 153 => 0x4 },
	'batteryorder' => { 118 => '802.3' },
	'batterystates' => { 153 => 0x1 },
	'bayergreensplit' => { 53 => 0xc62d },
	'bayerpattern' => { 63 => 0xf902, 95 => 0x17 },
	'beatspliceparamsriseindecibel' => { 191 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 191 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 191 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 118 => '803.1', 119 => '729.1', 120 => '748.1' },
	'bestqualityscale' => { 53 => 0xc65c },
	'bestshotmode' => { 50 => 0x3007 },
	'bitdepth' => { 82 => 'BitDepth', 95 => 0x11, 116 => 0x41 },
	'bitspercomponent' => { 61 => 0x87 },
	'bitspersample' => { 53 => 0x102, 188 => 'BitsPerSample' },
	'blacklevel' => { 140 => 0x1012 },
	'blacklevel2' => { 139 => 0x600, 143 => 0x600 },
	'blackpoint' => { 161 => 0x200 },
	'bluebalance' => { 140 => 0x1018, 150 => 0x12, 161 => 0x1b },
	'bluecurvelimits' => { 47 => 0x1fe },
	'bluecurvepoints' => { 47 => 0x1d4 },
	'bluehue' => { 181 => 'BlueHue' },
	'bluesaturation' => { 181 => 'BlueSaturation' },
	'blurwarning' => { 57 => 0x1300 },
	'bodyfirmwareversion' => { 136 => 0x104, 137 => 0x100, 140 => 0x104 },
	'bracketmode' => { 17 => 0x3 },
	'bracketsequence' => { 50 => 0x301d },
	'bracketshotnumber' => { 17 => 0x5, 155 => 0x9 },
	'bracketstep' => { 90 => 0xe },
	'bracketvalue' => { 17 => 0x4 },
	'brightness' => { 53 => 0xfe53, 76 => 'Brightness', 90 => 0x2c, 113 => 0x34, 181 => 'Brightness' },
	'brightnessadj' => { 47 => 0x114, 124 => 0x0 },
	'brightnessvalue' => { 53 => 0x9203, 140 => 0x1003, 184 => 'BrightnessValue' },
	'bulbduration' => { 27 => 0x18 },
	'burstmode' => { 65 => 0xa, 149 => 0x2a },
	'burstmode2' => { 65 => 0x18 },
	'buttonfunctioncontroloff' => { 30 => 0x70a },
	'bwfilter' => { 90 => 0x2a, 96 => 0x39 },
	'bwmode' => { 140 => 0x203 },
	'by-line' => { 59 => 0x50 },
	'by-linetitle' => { 59 => 0x55 },
	'calibrationilluminant1' => { 53 => 0xc65a },
	'calibrationilluminant2' => { 53 => 0xc65b },
	'cameraid' => { 140 => 0x209, 172 => 0x209 },
	'cameraiso' => { 8 => 0x10 },
	'cameraparameters' => { 140 => 0x2050 },
	'cameraprofile' => { 181 => 'CameraProfile' },
	'cameraprofiledigest' => { 181 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 53 => 0xc62f, 178 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 135 => 0x0 },
	'cameratemperature' => { 147 => 0x320, 161 => 0x47 },
	'cameratype' => { 27 => 0x1a, 140 => 0x207 },
	'cameratype2' => { 136 => 0x100 },
	'canonexposuremode' => { 8 => 0x14 },
	'canonfiledescription' => { 43 => 0x805 },
	'canonfilelength' => { 20 => 0xe },
	'canonfirmwareversion' => { 20 => 0x7, 43 => 0x80b },
	'canonflashinfo' => { 43 => 0x1028 },
	'canonflashmode' => { 8 => 0x4 },
	'canonimagesize' => { 2 => 0x39, 8 => 0xa },
	'canonimagetype' => { 20 => 0x6, 43 => 0x815 },
	'canonmodelid' => { 20 => 0x10, 43 => 0x1834 },
	'canonvrd' => { 54 => 'CanonVRD' },
	'caption-abstract' => { 59 => 0x78 },
	'captionwriter' => { 187 => 'CaptionWriter' },
	'casioimagesize' => { 50 => 0x9 },
	'catalogsets' => { 177 => 'CatalogSets' },
	'category' => { 59 => 0xf, 187 => 'Category' },
	'ccdboardversion' => { 147 => 0x331 },
	'ccdscanmode' => { 140 => 0x1039 },
	'ccdsensitivity' => { 121 => 0x6 },
	'ccdversion' => { 147 => 0x330 },
	'celllength' => { 53 => 0x109 },
	'cellwidth' => { 53 => 0x108 },
	'centerafarea' => { 120 => '763.1' },
	'centerweightedareasize' => { 118 => '797.1', 120 => '754.3' },
	'certificate' => { 194 => 'Certificate' },
	'cfapattern' => { 53 => 0xa302 },
	'cfapatterncolumns' => { 184 => 'CFAPatternColumns' },
	'cfapatternrows' => { 184 => 'CFAPatternRows' },
	'cfapatternvalues' => { 184 => 'CFAPatternValues' },
	'channels' => { 75 => 'Channels' },
	'checkmark' => { 47 => 0x26a },
	'chromablurradius' => { 53 => 0xc631 },
	'chromaticaberrationb' => { 181 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 181 => 'ChromaticAberrationR' },
	'chrominancenoisereduction' => { 48 => 0xbc },
	'chrominancenr_tiff_jpeg' => { 48 => 0xc0 },
	'city' => { 59 => 0x5a, 81 => 'City', 187 => 'City' },
	'clarity' => { 181 => 'Clarity' },
	'classifystate' => { 59 => 0xe1 },
	'clmodeshootingspeed' => { 118 => '800.2' },
	'cmcontrast' => { 143 => 0x2022 },
	'cmexposurecompensation' => { 143 => 0x2000 },
	'cmhue' => { 143 => 0x2021 },
	'cmsaturation' => { 143 => 0x2020 },
	'cmsharpness' => { 143 => 0x2023 },
	'cmwhitebalance' => { 143 => 0x2001 },
	'cmwhitebalancecomp' => { 143 => 0x2002 },
	'cmwhitebalancegraypoint' => { 143 => 0x2010 },
	'codec' => { 89 => 'Codec' },
	'codedcharacterset' => { 60 => 0x5a },
	'coloraberrationcontrol' => { 129 => 0xc89224b },
	'coloradjustment' => { 173 => 0x14 },
	'coloradjustmentmode' => { 172 => 0x210 },
	'colorantsa' => { 195 => 'ColorantsA' },
	'colorantsb' => { 195 => 'ColorantsB' },
	'colorantsblack' => { 195 => 'ColorantsBlack' },
	'colorantsblue' => { 195 => 'ColorantsBlue' },
	'colorantscyan' => { 195 => 'ColorantsCyan' },
	'colorantsgreen' => { 195 => 'ColorantsGreen' },
	'colorantsl' => { 195 => 'ColorantsL' },
	'colorantsmagenta' => { 195 => 'ColorantsMagenta' },
	'colorantsmode' => { 195 => 'ColorantsMode' },
	'colorantsred' => { 195 => 'ColorantsRed' },
	'colorantsswatchname' => { 195 => 'ColorantsSwatchName' },
	'colorantstype' => { 195 => 'ColorantsType' },
	'colorantsyellow' => { 195 => 'ColorantsYellow' },
	'colorbalance' => { 76 => 'ColorBalance' },
	'colorbalance1' => { 111 => 0xc },
	'colorbalanceadj' => { 129 => 0x76a43202 },
	'colorbalanceblue' => { 90 => 0x1e },
	'colorbalancegreen' => { 90 => 0x1d },
	'colorbalancered' => { 90 => 0x1c },
	'colorbooster' => { 129 => 0x5f0e7d23 },
	'colorboostlevel' => { 125 => 0x1 },
	'colorboosttype' => { 125 => 0x0 },
	'colorclass' => { 164 => 0xde },
	'colorcontrol' => { 140 => 0x102b },
	'coloreffect' => { 149 => 0x28 },
	'colorfilter' => { 49 => 0x17, 90 => 0x29, 96 => 0x38, 163 => 0x17 },
	'colorgain' => { 116 => 0x51 },
	'colorhue' => { 111 => 0x8d },
	'colormatrix' => { 139 => 0x200, 140 => 0x1011 },
	'colormatrix2' => { 143 => 0x200 },
	'colormatrixa' => { 161 => 0x203 },
	'colormatrixb' => { 161 => 0x204 },
	'colormatrixnumber' => { 140 => 0x1019 },
	'colormode' => { 50 => 0x3015, 57 => 0x1210, 65 => 0x66, 90 => 0x28, 93 => 0x16, 94 => 0x101, 96 => 0x7, 111 => 0x3, 121 => 0x4, 140 => 0x101, 149 => 0x32, 174 => 0xb029, 187 => 'ColorMode' },
	'colormoirereduction' => { 130 => 0x5 },
	'colornoisereduction' => { 181 => 'ColorNoiseReduction' },
	'colorplanes' => { 56 => 0x2 },
	'colorprofile' => { 90 => 0x33 },
	'colorrepresentation' => { 61 => 0x3c },
	'colorreproduction' => { 174 => 0xb020 },
	'colorsequence' => { 61 => 0x41 },
	'colorspace' => { 14 => 0x3, 20 => 0xb4, 43 => 0x10b4, 53 => 0xa001, 82 => 'ColorSpace', 91 => 0x2f, 92 => 0x25, 111 => 0x1e, 135 => 0x507, 161 => 0x37, 173 => 0xb, 184 => 'ColorSpace' },
	'colortempasshot' => { 10 => 0x1d, 11 => 0x1c, 12 => 0x43, 13 => 0x43 },
	'colortempauto' => { 10 => 0x22, 11 => 0x26, 12 => 0x48, 13 => 0x48 },
	'colortempcloudy' => { 10 => 0x31, 11 => 0x35, 12 => 0x5c, 13 => 0x61 },
	'colortempcustom' => { 12 => 0x84 },
	'colortempcustom1' => { 10 => 0x45 },
	'colortempcustom2' => { 10 => 0x4a },
	'colortempdaylight' => { 10 => 0x27, 11 => 0x2b, 12 => 0x52, 13 => 0x57 },
	'colortemperature' => { 1 => [0x48,0x4e], 2 => 0x37, 3 => 0x62, 4 => 0x37, 5 => 0x73, 6 => 0x58, 20 => 0xae, 25 => 0x9, 43 => 0x10ae, 57 => 0x1005, 64 => 0x846, 76 => 'ColorTemperature', 91 => [0x6e,0x49], 92 => 0x3f, 93 => 0x5e, 94 => 0x10b, 96 => 0x3c, 147 => 0x321, 161 => 0x50, 174 => 0xb021 },
	'colortemperaturebg' => { 140 => 0x1013 },
	'colortemperaturerg' => { 140 => 0x1014 },
	'colortempflash' => { 10 => 0x40, 11 => 0x49, 12 => 0x70, 13 => 0x75 },
	'colortempfluorescent' => { 10 => 0x3b, 11 => 0x3f, 12 => 0x66, 13 => 0x6b },
	'colortempkelvin' => { 11 => 0x44, 12 => 0x6b, 13 => 0x70 },
	'colortempmeasured' => { 12 => 0x4d, 13 => 0x4d },
	'colortemppc1' => { 11 => 0x94, 12 => 0x75 },
	'colortemppc2' => { 11 => 0x99, 12 => 0x7a },
	'colortemppc3' => { 11 => 0x9e, 12 => 0x7f },
	'colortempshade' => { 10 => 0x2c, 11 => 0x30, 12 => 0x57, 13 => 0x5c },
	'colortemptungsten' => { 10 => 0x36, 11 => 0x3a, 12 => 0x61, 13 => 0x66 },
	'colortempunknown' => { 11 => 0x21 },
	'colortempunknown10' => { 11 => 0x76, 13 => 0xa2 },
	'colortempunknown11' => { 11 => 0x7b, 13 => 0xa7 },
	'colortempunknown12' => { 11 => 0x80 },
	'colortempunknown13' => { 11 => 0x85 },
	'colortempunknown14' => { 11 => 0x8a },
	'colortempunknown15' => { 11 => 0x8f },
	'colortempunknown16' => { 11 => 0xa3 },
	'colortempunknown2' => { 11 => 0x4e, 13 => 0x7a },
	'colortempunknown3' => { 11 => 0x53, 13 => 0x7f },
	'colortempunknown4' => { 11 => 0x58, 13 => 0x84 },
	'colortempunknown5' => { 11 => 0x5d, 13 => 0x89 },
	'colortempunknown6' => { 11 => 0x62, 13 => 0x8e },
	'colortempunknown7' => { 11 => 0x67, 13 => 0x93 },
	'colortempunknown8' => { 11 => 0x6c, 13 => 0x98 },
	'colortempunknown9' => { 11 => 0x71, 13 => 0x9d },
	'colortone' => { 2 => 0x6f, 4 => 0x77, 8 => 0x2a, 14 => 0x2 },
	'colortoneadj' => { 47 => 0x11e },
	'colortonefaithful' => { 6 => 0x107 },
	'colortonelandscape' => { 6 => 0x105 },
	'colortoneneutral' => { 6 => 0x106 },
	'colortoneportrait' => { 6 => 0x104 },
	'colortonestandard' => { 6 => 0x103 },
	'colortoneuserdef1' => { 6 => 0x109 },
	'colortoneuserdef2' => { 6 => 0x10a },
	'colortoneuserdef3' => { 6 => 0x10b },
	'commanddials' => { 120 => '753.1' },
	'commanddialsaperturesetting' => { 118 => '807.3' },
	'commanddialschangemainsub' => { 118 => '807.2' },
	'commanddialsmenuandplayback' => { 118 => '807.4' },
	'commanddialsreverserotation' => { 118 => '807.1' },
	'commanderchannel' => { 120 => '758.2' },
	'commandergroupa_manualoutput' => { 120 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 120 => '761.1' },
	'commandergroupamode' => { 120 => '759.2' },
	'commandergroupb_manualoutput' => { 120 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 120 => '762.1' },
	'commandergroupbmode' => { 120 => '759.3' },
	'commanderinternalflash' => { 120 => '759.1' },
	'commanderinternalmanualoutput' => { 120 => '760.2' },
	'commanderinternalttlcomp' => { 120 => '760.1' },
	'comment' => { 0 => 0x2, 54 => 'Comment', 77 => 'Comment', 146 => 'Comment' },
	'componentsconfiguration' => { 53 => 0x9101, 82 => 'Components', 184 => 'ComponentsConfiguration' },
	'componentversion' => { 43 => 0x80c },
	'composer' => { 191 => 'composer' },
	'compressedbitsperpixel' => { 53 => 0x9102, 184 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 94 => 0x40, 140 => 0x40 },
	'compression' => { 53 => 0x103, 188 => 'Compression' },
	'compressionfactor' => { 135 => 0x50d },
	'compressionratio' => { 82 => 'Compression', 140 => 0x1034 },
	'constrainedcropheight' => { 47 => 0x266, 164 => 0xd6 },
	'constrainedcropwidth' => { 47 => 0x262, 164 => 0xd5 },
	'contact' => { 59 => 0x76 },
	'contentlocationcode' => { 59 => 0x1a },
	'contentlocationname' => { 59 => 0x1b },
	'continuousdrive' => { 8 => 0x5 },
	'continuousshootingspeed' => { 30 => 0x610 },
	'continuousshotlimit' => { 30 => 0x611 },
	'contrast' => { 2 => 0x73, 4 => 0x75, 8 => 0xd, 49 => 0xc, 50 => [0x3012,0x20], 53 => [0xa408,0xfe54], 57 => [0x1004,0x1006], 76 => 'Contrast', 90 => 0x20, 91 => 0x31, 92 => 0x27, 93 => 0x19, 96 => 0x2, 113 => 0x33, 140 => 0x1029, 149 => [0x2c,0x39], 161 => 0x20, 163 => 0xc, 173 => 0xd, 181 => 'Contrast', 184 => 'Contrast' },
	'contrastadj' => { 47 => 0x115 },
	'contrastfaithful' => { 6 => 0xec },
	'contrastlandscape' => { 6 => 0xea },
	'contrastmonochrome' => { 6 => 0xed },
	'contrastneutral' => { 6 => 0xeb },
	'contrastportrait' => { 6 => 0xe9 },
	'contrastsetting' => { 135 => 0x505, 143 => 0x1012 },
	'contraststandard' => { 6 => 0xe8 },
	'contrastuserdef1' => { 6 => 0xee },
	'contrastuserdef2' => { 6 => 0xef },
	'contrastuserdef3' => { 6 => 0xf0 },
	'contributedmediaduration' => { 191 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 191 => 'contributedMediaManaged' },
	'contributedmediapath' => { 191 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 191 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 191 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 191 => 'contributedMediaWebStatement' },
	'contributor' => { 182 => 'contributor' },
	'contributors' => { 77 => 'Contributors' },
	'controllerboardversion' => { 147 => 0x332 },
	'controlmode' => { 27 => 0x12 },
	'conversionlens' => { 149 => 0x35 },
	'converter' => { 53 => 0xfe4d, 121 => 0xb },
	'converttograyscale' => { 181 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 53 => 0x8298, 77 => 'Copyright', 146 => 'Copyright', 169 => 'Copyright', 188 => 'Copyright', 191 => 'copyright' },
	'copyrightflag' => { 167 => 0x40a },
	'copyrightnotice' => { 59 => 0x74 },
	'coringfilter' => { 139 => 0x310, 140 => 0x102d, 143 => 0x310 },
	'coringvalues' => { 139 => 0x311, 143 => 0x311 },
	'country' => { 81 => 'Country', 187 => 'Country' },
	'country-primarylocationcode' => { 59 => 0x64 },
	'country-primarylocationname' => { 59 => 0x65 },
	'countrycode' => { 165 => 'CountryCode', 185 => 'CountryCode' },
	'coverage' => { 182 => 'coverage' },
	'cpufirmwareversion' => { 161 => 0x28 },
	'crc32' => { 183 => 'crc32' },
	'createdate' => { 53 => 0x9004, 77 => 'CreateDate', 144 => 'CreationDate', 169 => 'CreationDate', 189 => 'CreateDate' },
	'creationdate' => { 186 => 'CreationDate' },
	'creationtime' => { 146 => 'Creation Time' },
	'creator' => { 144 => 'Creator', 169 => 'Creator', 182 => 'creator', 186 => 'Creator' },
	'creatorcontactinfociadrcity' => { 185 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 185 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 185 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 185 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 185 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 185 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 185 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 185 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 189 => 'CreatorTool' },
	'credit' => { 59 => 0x6e, 187 => 'Credit' },
	'creditlinereq' => { 193 => 'CreditLineReq' },
	'cropactive' => { 47 => 0x244 },
	'cropangle' => { 181 => 'CropAngle' },
	'cropaspectratio' => { 47 => 0x260 },
	'cropbottom' => { 56 => 0x9, 126 => 0x36, 164 => 0xdc, 181 => 'CropBottom' },
	'cropheight' => { 47 => 0x24c, 139 => 0x615, 143 => 0x615, 181 => 'CropHeight' },
	'crophispeed' => { 111 => 0x1b },
	'cropleft' => { 47 => 0x246, 56 => 0x6, 126 => 0x1e, 139 => 0x612, 143 => 0x612, 164 => 0xd9, 181 => 'CropLeft' },
	'cropoutputscale' => { 126 => 0xbe },
	'cropright' => { 56 => 0x8, 126 => 0x2e, 164 => 0xdb, 181 => 'CropRight' },
	'croprotation' => { 56 => 0xb },
	'croptop' => { 47 => 0x248, 56 => 0x7, 126 => 0x26, 139 => 0x613, 143 => 0x613, 164 => 0xda, 181 => 'CropTop' },
	'cropunits' => { 181 => 'CropUnits' },
	'cropwidth' => { 47 => 0x24a, 139 => 0x614, 143 => 0x614, 181 => 'CropWidth' },
	'currenticcprofile' => { 53 => 0xc691 },
	'currentpreprofilematrix' => { 53 => 0xc692 },
	'curves' => { 129 => 0x76a43201 },
	'customrendered' => { 53 => 0xa401, 184 => 'CustomRendered' },
	'customsaturation' => { 135 => 0x503 },
	'd-lightinghq' => { 129 => 0x2175eb78 },
	'd-lightinghqselected' => { 129 => 0x6a6e36b6 },
	'd-lightinghs' => { 129 => 0xce5554aa },
	'd-lightinghsadjustment' => { 128 => 0x0 },
	'd-lightinghscolorboost' => { 127 => 0x2, 128 => 0x1 },
	'd-lightinghshighlight' => { 127 => 0x1 },
	'd-lightinghsshadow' => { 127 => 0x0 },
	'datacompressionmethod' => { 61 => 0x6e },
	'dataimprint' => { 90 => 0x34 },
	'date' => { 161 => 0x6, 182 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired' },
	'datecreated' => { 59 => 0x37, 187 => 'DateCreated' },
	'dateformat' => { 123 => 0x3 },
	'datesent' => { 60 => 0x46 },
	'datestampmode' => { 20 => 0x1c },
	'datetime' => { 188 => 'DateTime' },
	'datetimedigitized' => { 184 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 46 => 0x0, 53 => 0x9003, 77 => 'OriginalDate', 184 => 'DateTimeOriginal' },
	'datetimestamp' => { 65 => 0x64 },
	'daylightsavings' => { 123 => 0x2 },
	'declination' => { 85 => 'Declination' },
	'decposition' => { 90 => 0x32 },
	'defaultcroporigin' => { 53 => 0xc61f },
	'defaultcropsize' => { 53 => 0xc620 },
	'defaultscale' => { 53 => 0xc61e },
	'defringe' => { 181 => 'Defringe' },
	'deletedimagecount' => { 111 => 0xa6, 117 => 0x6e },
	'derivedfromdocumentid' => { 192 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 192 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 192 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 192 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 192 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 192 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 192 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 192 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 192 => 'DerivedFromVersionID' },
	'description' => { 146 => 'Description', 182 => 'description' },
	'destination' => { 60 => 0x5 },
	'destinationcity' => { 161 => 0x24 },
	'destinationcitycode' => { 163 => 0x1001 },
	'destinationdst' => { 161 => 0x26 },
	'developmentdynamicrange' => { 57 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 184 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 184 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 184 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 30 => 0x706 },
	'digitalcreationdate' => { 59 => 0x3e },
	'digitalcreationtime' => { 59 => 0x3f },
	'digitalgain' => { 25 => 0xb },
	'digitalgem' => { 107 => 0x0 },
	'digitalice' => { 116 => 0x100 },
	'digitalroc' => { 115 => 0x0 },
	'digitalzoom' => { 8 => 0xc, 49 => 0xa, 65 => 0x68, 76 => 'DigitalZoom', 90 => 0xc, 111 => 0x86, 121 => 0xa, 140 => 0x204, 161 => 0x1e, 163 => 0xa, 172 => 0x204 },
	'digitalzoomon' => { 172 => 0x21b },
	'digitalzoomratio' => { 53 => 0xa404, 184 => 'DigitalZoomRatio' },
	'directory' => { 54 => 'Directory' },
	'directoryindex' => { 3 => 0x17e, 5 => 0x13f },
	'directorynumber' => { 104 => 0x6 },
	'disclaimer' => { 146 => 'Disclaimer' },
	'displayaperture' => { 8 => 0x23 },
	'displayedunitsx' => { 168 => 0x2 },
	'displayedunitsy' => { 168 => 0x6 },
	'distance1' => { 65 => 0x28 },
	'distance2' => { 65 => 0x2c },
	'distance3' => { 65 => 0x30 },
	'distance4' => { 65 => 0x34 },
	'distortioncorrection' => { 135 => 0x50b },
	'distortioncorrection2' => { 139 => 0x1011 },
	'dngbackwardversion' => { 53 => 0xc613 },
	'dnglensinfo' => { 53 => 0xc630 },
	'dngversion' => { 53 => 0xc612 },
	'document' => { 146 => 'Document' },
	'documenthistory' => { 59 => 0xe7 },
	'documentid' => { 192 => 'DocumentID' },
	'documentname' => { 53 => 0x10d },
	'documentnotes' => { 59 => 0xe6 },
	'dotrange' => { 53 => 0x150 },
	'drivemode' => { 90 => 0x6, 93 => 0x1e, 135 => 0x600, 161 => 0x34, 173 => 0x3 },
	'drivemode2' => { 155 => 0x7 },
	'dspfirmwareversion' => { 161 => 0x27 },
	'duration' => { 75 => 'Duration', 89 => 'Duration', 191 => 'duration' },
	'dynamicafarea' => { 118 => '791.4' },
	'dynamicrange' => { 57 => 0x1400 },
	'dynamicrangeexpansion' => { 161 => 0x69 },
	'dynamicrangemax' => { 47 => 0x7c },
	'dynamicrangemin' => { 47 => 0x7a },
	'dynamicrangeoptimizer' => { 174 => 0xb025 },
	'dynamicrangesetting' => { 57 => 0x1402 },
	'e-dialinprogram' => { 155 => '1.3' },
	'easyexposurecompensation' => { 118 => '796.4' },
	'easymode' => { 8 => 0xb },
	'edgenoisereduction' => { 130 => 0x4 },
	'editorialupdate' => { 59 => 0x8 },
	'editstatus' => { 59 => 0x7, 165 => 'EditStatus' },
	'effectivelv' => { 161 => 0x2d },
	'effectivemaxaperture' => { 110 => 0x12 },
	'elevation' => { 85 => 'Elevation' },
	'email' => { 77 => 'EMail' },
	'engineer' => { 191 => 'engineer' },
	'enhancedarktones' => { 124 => 0x8 },
	'enhancement' => { 49 => 0x16, 50 => 0x3016 },
	'enhancer' => { 139 => 0x300 },
	'enhancervalues' => { 139 => 0x301 },
	'envelopenumber' => { 60 => 0x28 },
	'envelopepriority' => { 60 => 0x3c },
	'enveloperecordversion' => { 60 => 0x0 },
	'epsonimageheight' => { 140 => 0x20c },
	'epsonimagewidth' => { 140 => 0x20b },
	'epsonsoftware' => { 140 => 0x20d },
	'equipmentinstitution' => { 175 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 175 => 'EquipmentManufacturer' },
	'equipmentversion' => { 136 => 0x0 },
	'ettlii' => { 30 => 0x304, 31 => 0xd, 32 => 0xe, 33 => 0x7, 34 => 0x7, 35 => 0xe },
	'event' => { 177 => 'Event' },
	'evsteps' => { 155 => '1.2' },
	'evstepsize' => { 120 => '748.7' },
	'excursiontolerance' => { 61 => 0x82 },
	'exifbyteorder' => { 54 => 'ExifByteOrder' },
	'exifcamerainfo' => { 59 => 0xe8 },
	'exifimageheight' => { 53 => 0xa003, 184 => 'PixelYDimension' },
	'exifimagewidth' => { 53 => 0xa002, 184 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 54 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 53 => 0x9000, 184 => 'ExifVersion' },
	'exitpupilposition' => { 110 => 0x4 },
	'expirationdate' => { 59 => 0x25 },
	'expirationtime' => { 59 => 0x26 },
	'exposure' => { 53 => 0xfe51, 181 => 'Exposure' },
	'exposurebracketstepsize' => { 155 => 0x8 },
	'exposurebracketvalue' => { 111 => 0x19 },
	'exposurecompensation' => { 27 => 0x6, 39 => 0x0, 53 => 0x9204, 65 => 0x24, 76 => 'ExposureComp', 90 => 0xd, 91 => 0x53, 92 => 0x1e, 93 => 0x1, 140 => 0x1006, 161 => 0x16, 173 => [0xc,0x35], 184 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 118 => '796.2' },
	'exposuredelaymode' => { 118 => '800.1', 120 => '754.4' },
	'exposuredifference' => { 111 => 0xe },
	'exposureindex' => { 53 => 0xa215, 184 => 'ExposureIndex' },
	'exposurelevelincrements' => { 28 => 0x6, 29 => 0x6, 30 => 0x101, 31 => 0x5, 32 => 0x6, 33 => 0x5, 34 => 0x5, 35 => 0x6, 36 => 0x4 },
	'exposuremode' => { 53 => 0xa402, 76 => 'ExposureMode', 90 => 0x1, 91 => 0xa, 92 => 0x0, 93 => 0x0, 135 => 0x200, 173 => 0x8, 174 => 0xb041, 184 => 'ExposureMode' },
	'exposuremodeinmanual' => { 30 => 0x10b },
	'exposureprogram' => { 53 => 0x8822, 184 => 'ExposureProgram' },
	'exposuretime' => { 1 => 0x4, 2 => 0x4, 3 => 0x4, 4 => 0x4, 6 => 0x4, 7 => 0x6, 27 => 0x16, 53 => 0x829a, 63 => 0xfd05, 65 => 0x20, 66 => 0xfa24, 68 => 0xf104, 72 => 0x38, 76 => 'ExposureTime', 90 => 0x9, 91 => 0x35, 92 => 0x48, 161 => 0x12, 173 => 0x32, 184 => 'ExposureTime' },
	'exposuretime2' => { 173 => 0x33 },
	'exposurevalue' => { 64 => 0x3 },
	'exposurewarning' => { 57 => 0x1302 },
	'extendedwbdetect' => { 135 => 0x902 },
	'extender' => { 136 => 0x301 },
	'extenderfirmwareversion' => { 136 => 0x304 },
	'extendermagnification' => { 78 => 'Magnification' },
	'extendermake' => { 78 => 'Make' },
	'extendermodel' => { 78 => 'Model', 136 => 0x303 },
	'extenderserialnumber' => { 78 => 'SerialNumber', 136 => 0x302 },
	'externalflash' => { 138 => 0x1201 },
	'externalflashae1' => { 140 => 0x101f },
	'externalflashae1_0' => { 140 => 0x101b },
	'externalflashae2' => { 140 => 0x1020 },
	'externalflashae2_0' => { 140 => 0x101c },
	'externalflashbounce' => { 138 => 0x1204, 140 => 0x1026 },
	'externalflashflags' => { 105 => 0x8, 106 => 0x8 },
	'externalflashguidenumber' => { 138 => 0x1203 },
	'externalflashgvalue' => { 140 => 0x1025 },
	'externalflashmode' => { 140 => 0x1028, 157 => 0x2 },
	'externalflashzoom' => { 138 => 0x1205, 140 => 0x1027 },
	'externalsensorbrightnessvalue' => { 147 => 0x311 },
	'face0position' => { 15 => 0x8 },
	'face1position' => { 15 => 0xa },
	'face2position' => { 15 => 0xc },
	'face3position' => { 15 => 0xe },
	'face4position' => { 15 => 0x10 },
	'face5position' => { 15 => 0x12 },
	'face6position' => { 15 => 0x14 },
	'face7position' => { 15 => 0x16 },
	'face8position' => { 15 => 0x18 },
	'facedetect' => { 139 => 0x1200 },
	'facedetectarea' => { 139 => 0x1201 },
	'facedetectframeheight' => { 15 => 0x4 },
	'facedetectframewidth' => { 15 => 0x3 },
	'facesdetected' => { 15 => 0x2, 16 => 0x2 },
	'ffid' => { 183 => 'ffid' },
	'fieldcount' => { 140 => 0x103f },
	'filedatarate' => { 191 => 'fileDataRate' },
	'fileformat' => { 41 => 0x0, 60 => 0x14 },
	'fileindex' => { 3 => 0x172, 5 => 0x133 },
	'filemodifydate' => { 54 => 'FileModifyDate' },
	'filename' => { 54 => 'FileName' },
	'filenumber' => { 17 => 0x1, 20 => 0x8, 43 => 0x1817, 104 => 0x8 },
	'filenumbermemory' => { 90 => 0x1a },
	'filenumbersequence' => { 118 => '802.2' },
	'filesource' => { 53 => 0xa300, 57 => 0x8000, 184 => 'FileSource' },
	'fileversion' => { 60 => 0x16 },
	'fillflashautoreduction' => { 28 => 0xe, 29 => 0xe, 36 => 0xa },
	'filllight' => { 181 => 'FillLight' },
	'fillorder' => { 53 => 0x10a },
	'filmmode' => { 57 => 0x1401, 149 => 0x42 },
	'filmtype' => { 116 => 0x2 },
	'filter' => { 50 => 0x3017 },
	'filtereffect' => { 17 => 0xe, 113 => 0x37 },
	'filtereffectmonochrome' => { 6 => 0xff },
	'finderdisplayduringexposure' => { 29 => 0x1 },
	'finetuneoptcenterweighted' => { 118 => '797.2' },
	'finetuneoptmatrixmetering' => { 118 => '798.1' },
	'finetuneoptspotmetering' => { 118 => '798.2' },
	'finetunestepsize' => { 118 => '796.3' },
	'firmware' => { 140 => 0x405, 173 => [0x17,0x3b], 179 => 'Firmware' },
	'firmwaredate' => { 49 => 0x15, 50 => 0x2001 },
	'firmwareid' => { 95 => 0x0 },
	'firmwarerevision' => { 6 => 0xa4, 20 => 0x1e },
	'firmwareversion' => { 3 => 0x136, 5 => 0xff, 64 => 0xce5, 76 => 'FirmwareVersion', 149 => 0x2 },
	'fixtureidentifier' => { 59 => 0x16 },
	'flash' => { 53 => 0x9209, 91 => 0x1f, 92 => 0x15 },
	'flashactivity' => { 8 => 0x1c },
	'flashbias' => { 149 => 0x24 },
	'flashbits' => { 8 => 0x1d },
	'flashchargelevel' => { 140 => 0x1010 },
	'flashcommandermode' => { 105 => '9.1', 106 => '9.1' },
	'flashcompensation' => { 179 => 'FlashCompensation' },
	'flashcontrolmode' => { 105 => '9.2', 106 => '9.2' },
	'flashdevice' => { 140 => 0x1005 },
	'flashdistance' => { 50 => 0x2034 },
	'flashenergy' => { 53 => 0xa20b, 184 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 111 => 0x18 },
	'flashexposurecomp' => { 27 => 0xf, 57 => 0x1011, 79 => 'ExposureComp', 90 => 0x23, 94 => 0x104, 105 => 0xa, 106 => 0xa, 111 => 0x12, 135 => 0x401, 140 => 0x1023, 161 => 0x4d, 173 => 0x3a },
	'flashexposurecompset' => { 151 => 0xe },
	'flashfired' => { 65 => 0x5d, 79 => 'Fired', 90 => 0x14, 120 => '590.3', 184 => 'FlashFired' },
	'flashfiring' => { 30 => 0x306, 31 => 0x6, 32 => 0x7, 35 => 0x7 },
	'flashfirmwareversion' => { 136 => 0x1002 },
	'flashfocallength' => { 105 => 0xb, 106 => 0xc },
	'flashfunction' => { 184 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 105 => 0xf, 106 => 0x10 },
	'flashgroupaexposurecomp' => { 105 => 0x11, 106 => 0x12 },
	'flashgroupaoutput' => { 105 => 0x11, 106 => 0x12 },
	'flashgroupbcontrolmode' => { 105 => 0x10, 106 => 0x11 },
	'flashgroupbexposurecomp' => { 105 => 0x12, 106 => 0x13 },
	'flashgroupboutput' => { 105 => 0x12, 106 => 0x13 },
	'flashguidenumber' => { 27 => 0xd, 40 => 0x0, 79 => 'GuideNumber' },
	'flashintensity' => { 49 => [0x19,0x5] },
	'flashlevel' => { 119 => 0x2e2 },
	'flashmake' => { 79 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmetering' => { 90 => 0x3f },
	'flashmeteringsegments' => { 161 => 0x20a },
	'flashmode' => { 49 => 0x4, 65 => 0x5c, 79 => 'Mode', 90 => 0x2, 91 => 0x20, 92 => 0x16, 111 => 0x87, 135 => 0x400, 140 => 0x1004, 161 => 0xc, 163 => 0x4, 170 => 0x20, 172 => 0x225, 184 => 'FlashMode' },
	'flashmodel' => { 79 => 'Model', 136 => 0x1001, 178 => 'FlashModel' },
	'flashoptions' => { 155 => 0x2 },
	'flashoptions2' => { 155 => 0x10 },
	'flashoutput' => { 27 => 0x21, 105 => 0xa, 106 => 0xa },
	'flashpixversion' => { 53 => 0xa000, 184 => 'FlashpixVersion' },
	'flashredeyemode' => { 184 => 'FlashRedEyeMode' },
	'flashreturn' => { 184 => 'FlashReturn' },
	'flashserialnumber' => { 79 => 'SerialNumber', 136 => 0x1003 },
	'flashsetting' => { 111 => 0x8 },
	'flashshutterspeed' => { 118 => '810.2', 120 => '755.1' },
	'flashstatus' => { 157 => 0x0 },
	'flashsyncspeed' => { 118 => '810.1' },
	'flashsyncspeedav' => { 28 => 0x3, 30 => 0x10f, 31 => 0x2, 32 => 0x3, 33 => 0x2, 34 => 0x2, 35 => 0x3, 36 => 0x6 },
	'flashthreshold' => { 40 => 0x1 },
	'flashtype' => { 79 => 'Type', 111 => 0x9, 136 => 0x1000 },
	'flickerreduce' => { 172 => 0x218 },
	'fliphorizontal' => { 129 => 0x76a43206 },
	'fnumber' => { 3 => 0x3, 6 => 0x3, 7 => 0x5, 27 => 0x15, 53 => 0x829d, 63 => 0xfd04, 65 => 0x1e, 66 => 0xfa23, 68 => 0xf103, 72 => 0x3c, 83 => 'FNumber', 90 => 0xa, 91 => 0x36, 92 => 0x47, 161 => 0x13, 173 => 0x31, 184 => 'FNumber' },
	'focallength' => { 1 => 0xa, 2 => 0x9, 3 => 0x1d, 4 => 0x9, 5 => 0x1d, 6 => 0x28, 19 => 0x1, 50 => 0x1d, 53 => 0x920a, 83 => 'FocalLength', 90 => 0x12, 110 => 0xa, 158 => 0x9, 161 => 0x1d, 184 => 'FocalLength' },
	'focallengthin35mmformat' => { 53 => 0xa405, 184 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 136 => 0x103, 140 => 0x205 },
	'focalplaneresolutionunit' => { 53 => 0xa210, 184 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 53 => 0xa20e, 184 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 19 => 0x2 },
	'focalplanexunknown' => { 19 => 0x2 },
	'focalplaneyresolution' => { 53 => 0xa20f, 184 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 19 => 0x3 },
	'focalplaneyunknown' => { 19 => 0x3 },
	'focaltype' => { 2 => 0x2d, 19 => 0x0 },
	'focalunits' => { 8 => 0x19 },
	'focus' => { 121 => 0x8 },
	'focusarea' => { 90 => 0x31 },
	'focusareaselection' => { 120 => '763.2' },
	'focuscontinuous' => { 8 => 0x20 },
	'focusdistance' => { 83 => 'FocusDistance', 90 => 0x13, 110 => 0x9, 138 => 0x305 },
	'focusdistancelower' => { 3 => 0x45, 5 => 0x45, 27 => 0x14 },
	'focusdistanceupper' => { 3 => 0x43, 5 => 0x43, 27 => 0x13 },
	'focusinfoversion' => { 138 => 0x0 },
	'focusingscreen' => { 29 => 0x0, 30 => 0x80b, 35 => 0x0 },
	'focusmode' => { 8 => 0x7, 49 => 0x3, 50 => [0x3003,0xd], 57 => 0x1021, 65 => 0x38, 76 => 'FocusMode', 90 => 0x30, 92 => 0xe, 111 => 0x7, 135 => 0x301, 140 => 0x100b, 149 => 0x7, 161 => 0xd, 163 => 0x3 },
	'focusmode2' => { 155 => '3.1' },
	'focusmodesetting' => { 119 => 0x2e3 },
	'focuspixel' => { 57 => 0x1023 },
	'focuspointwrap' => { 118 => '792.2' },
	'focusposition' => { 110 => 0x8, 161 => 0x10 },
	'focusprocess' => { 135 => 0x302 },
	'focusrange' => { 8 => 0x12, 140 => 0x100a },
	'focussetting' => { 173 => 0x6 },
	'focusstepcount' => { 138 => 0x301, 140 => 0x100e },
	'focusstepinfinity' => { 138 => 0x303 },
	'focusstepnear' => { 138 => 0x304 },
	'focustrackinglockon' => { 118 => '791.5' },
	'focuswarning' => { 57 => 0x1301 },
	'foldername' => { 90 => 0x27 },
	'fontschildfontfiles' => { 195 => 'FontsChildFontFiles' },
	'fontscomposite' => { 195 => 'FontsComposite' },
	'fontsfontface' => { 195 => 'FontsFontFace' },
	'fontsfontfamily' => { 195 => 'FontsFontFamily' },
	'fontsfontfilename' => { 195 => 'FontsFontFileName' },
	'fontsfontname' => { 195 => 'FontsFontName' },
	'fontsfonttype' => { 195 => 'FontsFontType' },
	'fontsversionstring' => { 195 => 'FontsVersionString' },
	'for' => { 169 => 'For' },
	'format' => { 182 => 'format' },
	'framenum' => { 164 => 0xd7 },
	'framenumber' => { 57 => 0x8003, 161 => 0x29 },
	'freebytes' => { 43 => 0x1 },
	'freememorycardimages' => { 91 => [0x37,0x54], 92 => [0x2d,0x4a] },
	'fujiflashmode' => { 57 => 0x1010 },
	'fullsizeimage' => { 82 => 'data' },
	'fullsizeimagename' => { 82 => '1Name' },
	'fullsizeimagetype' => { 82 => '0Type' },
	'functionbutton' => { 120 => '753.2' },
	'gainbase' => { 139 => 0x610 },
	'gaincontrol' => { 53 => 0xa407, 184 => 'GainControl' },
	'gamma' => { 53 => 0xa500 },
	'gammacompensatedvalue' => { 61 => 0x91 },
	'genre' => { 191 => 'genre' },
	'globalaltitude' => { 167 => 0x419 },
	'globalangle' => { 167 => 0x40d },
	'gpsaltitude' => { 58 => 0x6, 80 => 'Altitude', 184 => 'GPSAltitude' },
	'gpsaltituderef' => { 58 => 0x5, 184 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 58 => 0x1c, 184 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 58 => 0x1d },
	'gpsdatetime' => { 80 => 'DateTime', 184 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 58 => 0x18, 80 => 'Bearing', 184 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 58 => 0x17, 184 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 58 => 0x1a, 80 => 'Distance', 184 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 58 => 0x19, 184 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 58 => 0x14, 184 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 58 => 0x13 },
	'gpsdestlongitude' => { 58 => 0x16, 184 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 58 => 0x15 },
	'gpsdifferential' => { 58 => 0x1e, 80 => 'Differential', 184 => 'GPSDifferential' },
	'gpsdop' => { 58 => 0xb, 184 => 'GPSDOP' },
	'gpsimgdirection' => { 58 => 0x11, 184 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 58 => 0x10, 184 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 58 => 0x2, 80 => 'Latitude', 184 => 'GPSLatitude' },
	'gpslatituderef' => { 58 => 0x1 },
	'gpslongitude' => { 58 => 0x4, 80 => 'Longitude', 184 => 'GPSLongitude' },
	'gpslongituderef' => { 58 => 0x3 },
	'gpsmapdatum' => { 58 => 0x12, 80 => 'Datum', 184 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 58 => 0xa, 80 => 'MeasureMode', 184 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 58 => 0x1b, 184 => 'GPSProcessingMethod' },
	'gpssatellites' => { 58 => 0x8, 80 => 'Satellites', 184 => 'GPSSatellites' },
	'gpsspeed' => { 58 => 0xd, 80 => 'Speed', 184 => 'GPSSpeed' },
	'gpsspeedref' => { 58 => 0xc, 184 => 'GPSSpeedRef' },
	'gpsstatus' => { 58 => 0x9, 184 => 'GPSStatus' },
	'gpstimestamp' => { 58 => 0x7 },
	'gpstrack' => { 58 => 0xf, 80 => 'Heading', 184 => 'GPSTrack' },
	'gpstrackref' => { 58 => 0xe, 184 => 'GPSTrackRef' },
	'gpsversionid' => { 58 => 0x0, 184 => 'GPSVersionID' },
	'gradation' => { 135 => 0x50f },
	'grayresponseunit' => { 53 => 0x122 },
	'greencurvelimits' => { 47 => 0x1c4 },
	'greencurvepoints' => { 47 => 0x19a },
	'greenhue' => { 181 => 'GreenHue' },
	'greensaturation' => { 181 => 'GreenSaturation' },
	'griddisplay' => { 118 => '803.3', 120 => '754.1' },
	'halftonehints' => { 53 => 0x141 },
	'hascrop' => { 181 => 'HasCrop' },
	'hassettings' => { 181 => 'HasSettings' },
	'headline' => { 59 => 0x69, 187 => 'Headline' },
	'hierarchicalsubject' => { 176 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 30 => 0x202, 111 => 0xb1, 161 => 0x71 },
	'highlight' => { 173 => 0xf },
	'highlightrecovery' => { 181 => 'HighlightRecovery' },
	'highlighttonepriority' => { 30 => 0x203 },
	'history' => { 187 => 'History' },
	'historyaction' => { 192 => 'HistoryAction' },
	'historyinstanceid' => { 192 => 'HistoryInstanceID' },
	'historyparameters' => { 192 => 'HistoryParameters' },
	'historysoftwareagent' => { 192 => 'HistorySoftwareAgent' },
	'historywhen' => { 192 => 'HistoryWhen' },
	'hometowncity' => { 50 => 0x3006, 161 => 0x23 },
	'hometowncitycode' => { 163 => 0x1000 },
	'hometowndst' => { 161 => 0x25 },
	'hostcomputer' => { 53 => 0x13c },
	'hue' => { 96 => 0x3b },
	'hueadjustment' => { 91 => 0x4a, 92 => 0x40, 111 => 0x92, 113 => 0x36 },
	'hueadjustmentaqua' => { 181 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 181 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 181 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 181 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 181 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 181 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 181 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 181 => 'HueAdjustmentYellow' },
	'huesetting' => { 143 => 0x1011 },
	'icc_profile' => { 54 => 'ICC_Profile' },
	'iccprofilename' => { 187 => 'ICCProfile' },
	'identifier' => { 182 => 'identifier', 189 => 'Identifier' },
	'illumination' => { 120 => '748.5' },
	'imageadjustment' => { 111 => 0x80, 121 => 0x5 },
	'imageareaoffset' => { 161 => 0x38 },
	'imageauthentication' => { 111 => 0x20 },
	'imageboundary' => { 111 => 0x16 },
	'imagecount' => { 111 => 0xa5 },
	'imagedatasize' => { 111 => 0xa2 },
	'imagedescription' => { 53 => 0x10e, 188 => 'ImageDescription' },
	'imagedustoff' => { 129 => 0xfe443a45 },
	'imageheight' => { 53 => 0x101, 95 => 0xc, 188 => 'ImageLength' },
	'imagehistory' => { 53 => 0x9213 },
	'imageidnumber' => { 147 => 0x340 },
	'imagenumber' => { 6 => 0xd0, 53 => 0x9211, 76 => 'ImageNumber', 91 => 0xae, 92 => 0x5e, 179 => 'ImageNumber' },
	'imagenumber2' => { 92 => 0x62 },
	'imageoptimization' => { 111 => 0xa9 },
	'imageorientation' => { 59 => 0x83 },
	'imageprocessing' => { 111 => 0x1a, 161 => 0x32 },
	'imageprocessingcount' => { 161 => 0x41 },
	'imageprocessingversion' => { 139 => 0x0 },
	'imagequality' => { 76 => 'ImageQuality', 149 => 0x1 },
	'imagequality2' => { 135 => 0x603 },
	'imagereview' => { 119 => '729.4', 120 => '748.4' },
	'imagereviewtime' => { 119 => 0x2db },
	'imagesize' => { 82 => 'ImageSize' },
	'imagesourcedata' => { 53 => 0x935c },
	'imagestabilization' => { 8 => 0x22, 50 => 0x3020, 76 => 'ImageStabilization', 91 => 0xbd, 92 => 0x71, 93 => 0x87, 94 => [0x18,0x107,0x113], 111 => 0xac, 138 => 0x1600, 149 => 0x1a, 174 => 0xb026 },
	'imagetone' => { 161 => 0x4f },
	'imagetype' => { 59 => 0x82 },
	'imageuniqueid' => { 53 => 0xa420, 184 => 'ImageUniqueID' },
	'imagewidth' => { 53 => 0x100, 95 => 0xe, 188 => 'ImageWidth' },
	'incrementaltemperature' => { 181 => 'IncrementalTemperature' },
	'incrementaltint' => { 181 => 'IncrementalTint' },
	'infinitylensstep' => { 140 => 0x103b },
	'infobuttonwhenshooting' => { 30 => 0x409 },
	'initialzoomsetting' => { 118 => '799.3' },
	'inkset' => { 53 => 0x14c },
	'instanceid' => { 192 => 'InstanceID' },
	'instructions' => { 187 => 'Instructions' },
	'instrument' => { 191 => 'instrument' },
	'intellectualgenre' => { 185 => 'IntellectualGenre' },
	'interchangecolorspace' => { 61 => 0x40 },
	'internalflash' => { 90 => 0x2b, 118 => '813.1', 119 => '737.1', 120 => '756.1', 138 => 0x1208 },
	'internalflashae1' => { 140 => 0x1021 },
	'internalflashae1_0' => { 140 => 0x101d },
	'internalflashae2' => { 140 => 0x1022 },
	'internalflashae2_0' => { 140 => 0x101e },
	'internalflashmode' => { 157 => 0x1 },
	'internalflashstrength' => { 157 => 0x3 },
	'internalflashtable' => { 140 => 0x1024 },
	'internalserialnumber' => { 20 => 0x96, 26 => 0x9, 57 => 0x10, 136 => 0x102, 149 => 0x25, 154 => 0x4 },
	'interopindex' => { 53 => 0x1 },
	'interopversion' => { 53 => 0x2 },
	'intervallength' => { 90 => 0x10 },
	'intervalmode' => { 90 => 0x26 },
	'intervalnumber' => { 90 => 0x11 },
	'introtime' => { 191 => 'introTime' },
	'iptc-naa' => { 53 => 0x83bb },
	'iptcbitspersample' => { 61 => 0x56 },
	'iptcimageheight' => { 61 => 0x1e },
	'iptcimagerotation' => { 61 => 0x66 },
	'iptcimagewidth' => { 61 => 0x14 },
	'iptcpicturenumber' => { 61 => 0xa },
	'iptcpixelheight' => { 61 => 0x32 },
	'iptcpixelwidth' => { 61 => 0x28 },
	'iso' => { 2 => 0x75, 3 => 0x6, 4 => 0x79, 6 => 0x6, 7 => 0x0, 49 => 0x14, 50 => [0x3014,0x14], 53 => 0x8827, 63 => 0xfd06, 64 => 0x1784, 65 => 0x60, 66 => [0xfa2e,0xfa46], 67 => [0x27,0x28], 68 => 0xf105, 72 => 0x4e, 76 => 'ISO', 90 => 0x8, 108 => 0x0, 111 => 0x2, 150 => 0x17, 161 => 0x14, 163 => 0x14, 184 => 'ISOSpeedRatings' },
	'iso2' => { 108 => 0x6, 117 => 0x256, 118 => 0x25c },
	'isoexpansion' => { 30 => 0x103, 31 => 0x7, 32 => 0x8, 35 => 0x8, 108 => 0x4 },
	'isoexpansion2' => { 108 => 0xa },
	'isofloor' => { 155 => 0x6 },
	'isoselection' => { 111 => 0xf },
	'isosetting' => { 65 => 0x5e, 76 => 'ISOSetting', 90 => 0x24, 91 => 0x26, 92 => 0x1c, 96 => 0x6, 111 => 0x13, 170 => 0x27 },
	'isospeedexpansion' => { 29 => 0x3 },
	'isospeedincrements' => { 30 => 0x102 },
	'isospeedrange' => { 30 => 0x103 },
	'isostepsize' => { 118 => '796.1' },
	'isovalue' => { 140 => 0x1001 },
	'jobid' => { 59 => 0xb8 },
	'jobrefid' => { 190 => 'JobRefId' },
	'jobrefname' => { 190 => 'JobRefName' },
	'jobrefurl' => { 190 => 'JobRefUrl' },
	'jpegquality' => { 2 => 0x66 },
	'jpgfromraw' => { 43 => 0x2007, 51 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 53 => [0x117,0x202] },
	'jpgfromrawstart' => { 53 => [0x111,0x201] },
	'jpgrecordedpixels' => { 155 => 0xe },
	'key' => { 191 => 'key' },
	'keywords' => { 59 => 0x19, 77 => 'Keywords', 144 => 'Keywords', 169 => 'Keywords', 186 => 'Keywords' },
	'kodakimageheight' => { 63 => 0xf908, 65 => 0xe, 66 => [0xfa1e,0xfa52], 71 => 0x70 },
	'kodakimagewidth' => { 63 => 0xf907, 65 => 0xc, 66 => [0xfa1d,0xfa51], 71 => 0x6c },
	'kodakinfotype' => { 63 => 0xfa00 },
	'kodakmaker' => { 71 => 0x8 },
	'kodakmodel' => { 65 => 0x0, 71 => 0x28 },
	'label' => { 146 => 'Label', 189 => 'Label' },
	'language' => { 182 => 'language' },
	'languageidentifier' => { 59 => 0x87 },
	'lastfilenumber' => { 90 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lasturl' => { 192 => 'LastURL' },
	'lc1' => { 158 => 0x2 },
	'lc10' => { 158 => 0xb },
	'lc11' => { 158 => 0xc },
	'lc12' => { 158 => 0xd },
	'lc14' => { 158 => 0xf },
	'lc15' => { 158 => 0x10 },
	'lc2' => { 158 => 0x3 },
	'lc3' => { 158 => 0x4 },
	'lc4' => { 158 => 0x5 },
	'lc5' => { 158 => 0x6 },
	'lc6' => { 158 => 0x7 },
	'lc7' => { 158 => 0x8 },
	'lcddisplayatpoweron' => { 30 => 0x811, 34 => 0xa },
	'lcddisplayreturntoshoot' => { 35 => 0x12 },
	'lcdillumination' => { 118 => '807.5' },
	'lcdilluminationduringbulb' => { 30 => 0x408 },
	'lcdpanels' => { 29 => 0x8 },
	'lcheditor' => { 129 => 0x8ae85e },
	'legacyiptcdigest' => { 187 => 'LegacyIPTCDigest' },
	'lens' => { 53 => 0xfdea, 111 => 0x84, 173 => 0xa, 179 => 'Lens' },
	'lensafstopbutton' => { 28 => 0x11, 29 => 0x13, 30 => 0x506, 31 => 0x10, 32 => 0x12, 35 => 0x13, 36 => 0x9 },
	'lensaperturerange' => { 173 => 0x30 },
	'lensdistortionparams' => { 140 => 0x206 },
	'lensdrivenoaf' => { 30 => 0x505 },
	'lensfirmwareversion' => { 136 => 0x204 },
	'lensfstops' => { 109 => 0x7, 110 => 0xc, 111 => 0x8b, 158 => '0.3' },
	'lensid' => { 94 => 0x10c, 174 => 0xb027 },
	'lensidnumber' => { 109 => 0x6, 110 => 0xb },
	'lensinfo' => { 179 => 'LensInfo' },
	'lenskind' => { 158 => 0x1 },
	'lensmake' => { 83 => 'Make' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmodel' => { 83 => 'Model', 178 => 'LensModel' },
	'lensproperties' => { 136 => 0x20b },
	'lensserialnumber' => { 83 => 'SerialNumber', 136 => 0x202, 149 => 0x52 },
	'lenstemperature' => { 140 => 0x1008 },
	'lenstype' => { 1 => 0xd, 2 => 0xd, 3 => 0x112, 4 => 0xd, 5 => 0xd7, 6 => [0xd,0x98], 8 => 0x16, 20 => 0x95, 111 => 0x83, 136 => 0x201, 147 => 0x310, 149 => 0x51, 159 => 0x0, 160 => 0x0, 161 => 0x3f },
	'license' => { 180 => 'license' },
	'licensetype' => { 183 => 'licensetype' },
	'lightcondition' => { 140 => 0x1009 },
	'lightreading' => { 161 => 0x15 },
	'lightsource' => { 53 => 0x9208, 111 => 0x90, 143 => 0x1000, 184 => 'LightSource' },
	'lightsourcespecial' => { 172 => 0x21d },
	'lightvaluecenter' => { 140 => 0x103d },
	'lightvalueperiphery' => { 140 => 0x103e },
	'linearresponselimit' => { 53 => 0xc62e },
	'liveviewexposuresimulation' => { 30 => 0x810 },
	'localcaption' => { 59 => 0x79 },
	'localizedcameramodel' => { 53 => 0xc615 },
	'location' => { 177 => 'Location', 185 => 'Location' },
	'lockmicrophonebutton' => { 30 => 0x709 },
	'logcomment' => { 191 => 'logComment' },
	'longexposurenoisereduction' => { 30 => 0x201, 31 => 0x1, 32 => 0x2, 33 => 0x1, 34 => 0x1, 35 => 0x2, 36 => 0x1, 174 => 0xb04e },
	'longfocal' => { 1 => 0x10, 2 => 0x13, 3 => 0x115, 4 => 0x13, 5 => 0xda, 6 => 0x95, 8 => 0x17 },
	'loop' => { 191 => 'loop' },
	'luminanceadjustmentaqua' => { 181 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 181 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 181 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 181 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 181 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 181 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 181 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 181 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 48 => 0xbe },
	'luminancesmoothing' => { 181 => 'LuminanceSmoothing' },
	'm16cversion' => { 147 => 0x333 },
	'macro' => { 57 => 0x1020, 140 => 0x202, 170 => 0x21, 172 => 0x202, 174 => 0xb040 },
	'macromode' => { 8 => 0x1, 90 => 0xb, 135 => 0x300, 149 => 0x1c },
	'magnifiedview' => { 32 => 0x11, 34 => 0x9 },
	'maindialexposurecomp' => { 120 => '748.6' },
	'make' => { 44 => 0x0, 53 => 0x10f, 76 => 'Make', 146 => 'Make', 150 => 0x10f, 188 => 'Make' },
	'makernote' => { 184 => 'MakerNote' },
	'makernotecanon' => { 52 => 'MakN', 53 => 0x927c },
	'makernotecasio' => { 52 => 'MakN', 53 => 0x927c },
	'makernotecasio2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotefujifilm' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotehp6' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteisl' => { 52 => 'MakN', 53 => 0x927c },
	'makernotejvc' => { 52 => 'MakN', 53 => 0x927c },
	'makernotejvctext' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak1a' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak1b' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak5' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak6a' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak6b' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak7' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodak8' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekodakunknown' => { 52 => 'MakN', 53 => 0x927c },
	'makernotekyocera' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteleica' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteleica2' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteleica3' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta2' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteminolta3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotenikon3' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteoffset' => { 172 => 0xff },
	'makernoteolympus' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteolympus2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepanasonic' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepanasonic2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotepentax4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotericoh' => { 52 => 'MakN', 53 => 0x927c },
	'makernotericohtext' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesafety' => { 53 => 0xc635 },
	'makernotesanyo' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesanyoc4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesanyopatch' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesigma' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony2' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony3' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesony4' => { 52 => 'MakN', 53 => 0x927c },
	'makernotesonysrf' => { 52 => 'MakN', 53 => 0x927c },
	'makernotetype' => { 171 => 0x1 },
	'makernoteunknown' => { 52 => 'MakN', 53 => 0x927c },
	'makernoteversion' => { 94 => 0x0, 111 => 0x1, 140 => 0x0, 149 => 0x8000, 171 => 0x2, 173 => 0x1d },
	'managedfromdocumentid' => { 192 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 192 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 192 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 192 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 192 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 192 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 192 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 192 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 192 => 'ManagedFromVersionID' },
	'manager' => { 192 => 'Manager' },
	'managervariant' => { 192 => 'ManagerVariant' },
	'manageto' => { 192 => 'ManageTo' },
	'manageui' => { 192 => 'ManageUI' },
	'manometerpressure' => { 135 => 0x900 },
	'manometerreading' => { 135 => 0x901 },
	'manualflash' => { 138 => 0x1209 },
	'manualflashoutput' => { 8 => 0x29, 119 => '737.2', 120 => '756.2' },
	'manualfocusdistance' => { 111 => 0x85, 140 => 0x100c, 172 => 0x223 },
	'manualtv' => { 29 => 0x5, 30 => 0x705 },
	'manufacturedate' => { 154 => 0x1 },
	'marked' => { 194 => 'Marked' },
	'markerscomment' => { 191 => 'markersComment' },
	'markersduration' => { 191 => 'markersDuration' },
	'markerslocation' => { 191 => 'markersLocation' },
	'markersname' => { 191 => 'markersName' },
	'markersstarttime' => { 191 => 'markersStartTime' },
	'markerstarget' => { 191 => 'markersTarget' },
	'markerstype' => { 191 => 'markersType' },
	'maskedareas' => { 53 => 0xc68e },
	'masterdocumentid' => { 59 => 0xb9 },
	'mastergain' => { 116 => 0x50 },
	'maxaperture' => { 8 => 0x1a, 68 => 0x6103, 83 => 'MaxAperture', 90 => 0x17, 158 => '14.1' },
	'maxapertureatcurrentfocal' => { 136 => 0x20a },
	'maxapertureatmaxfocal' => { 57 => 0x1407, 83 => 'MaxApertureAtMaxFocal', 109 => 0xb, 110 => 0x10, 136 => 0x206 },
	'maxapertureatminfocal' => { 57 => 0x1406, 109 => 0xa, 110 => 0xf, 136 => 0x205 },
	'maxaperturevalue' => { 53 => 0x9205, 184 => 'MaxApertureValue' },
	'maxcontinuousrelease' => { 118 => '801.1' },
	'maxfocallength' => { 57 => 0x1405, 83 => 'MaxFocalLength', 109 => 0x9, 110 => 0xe, 136 => 0x208 },
	'maximumdensityrange' => { 61 => 0x8c },
	'maxpagesizeh' => { 195 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 195 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 195 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 53 => 0x119 },
	'mb-d10batteries' => { 118 => '802.4' },
	'mb-d80batteries' => { 120 => '754.5' },
	'mcuversion' => { 109 => 0xc, 110 => 0x11 },
	'md5digest' => { 84 => 'zmd5' },
	'measuredev' => { 27 => 0x3, 43 => 0x1814, 76 => 'MeasuredEV' },
	'measuredlv' => { 147 => 0x312 },
	'menubuttondisplayposition' => { 28 => 0xb, 31 => 0xa, 32 => 0xb, 35 => 0xb },
	'menubuttonreturn' => { 36 => 0xb },
	'metadatadate' => { 189 => 'MetadataDate' },
	'metadatamoddate' => { 191 => 'metadataModDate' },
	'metering' => { 119 => 0x2df },
	'meteringmode' => { 8 => 0x11, 53 => 0x9207, 65 => 0x1c, 90 => 0x7, 91 => 0x25, 135 => 0x202, 161 => 0x17, 173 => 0x9, 184 => 'MeteringMode' },
	'meteringmode2' => { 155 => '2.1' },
	'meteringmode3' => { 155 => '16.1' },
	'meteringtime' => { 118 => '812.2', 119 => '732.2', 120 => '751.2' },
	'mieversion' => { 84 => '0Vers' },
	'minaperture' => { 8 => 0x1b, 83 => 'MinAperture', 158 => '0.2' },
	'minfocallength' => { 57 => 0x1404, 83 => 'MinFocalLength', 109 => 0x8, 110 => 0xd, 136 => 0x207 },
	'minoltadate' => { 90 => 0x15 },
	'minoltaimagesize' => { 90 => 0x4, 91 => 0xc, 92 => 0x2, 94 => 0x103 },
	'minoltamodelid' => { 90 => 0x25 },
	'minoltaquality' => { 90 => 0x5, 91 => 0xd, 92 => 0x3, 94 => [0x102,0x103], 140 => [0x102,0x103] },
	'minoltatime' => { 90 => 0x16 },
	'minsamplevalue' => { 53 => 0x118 },
	'mirrorlockup' => { 28 => 0xc, 29 => 0xc, 30 => 0x60f, 31 => 0xb, 32 => 0xc, 33 => 0x6, 34 => 0x6, 35 => 0xc, 36 => 0x3 },
	'moddate' => { 186 => 'ModDate' },
	'model' => { 44 => 0x6, 53 => 0x110, 76 => 'Model', 146 => 'Model', 150 => 0x110, 188 => 'Model' },
	'modelingflash' => { 118 => '811.4', 120 => '755.3' },
	'modelrevision' => { 154 => 0x2 },
	'modifiedcolortemp' => { 21 => 0x9 },
	'modifieddigitalgain' => { 21 => 0xb },
	'modifiedparamflag' => { 18 => 0x1 },
	'modifiedpicturestyle' => { 21 => 0xa },
	'modifiedsaturation' => { 135 => 0x504 },
	'modifiedsensorbluelevel' => { 21 => 0x5 },
	'modifiedsensorredlevel' => { 21 => 0x4 },
	'modifiedsharpness' => { 21 => 0x2 },
	'modifiedsharpnessfreq' => { 21 => 0x3 },
	'modifiedtonecurve' => { 21 => 0x1 },
	'modifiedwhitebalance' => { 21 => 0x8 },
	'modifiedwhitebalanceblue' => { 21 => 0x7 },
	'modifiedwhitebalancered' => { 21 => 0x6 },
	'modifydate' => { 53 => 0x132, 77 => 'ModifyDate', 144 => 'ModDate', 145 => 'tIME', 169 => 'ModDate', 189 => 'ModifyDate' },
	'moirefilter' => { 53 => 0xfe58 },
	'monitorofftime' => { 118 => '808.2', 119 => '732.1', 120 => '751.1' },
	'monochromecontrast' => { 48 => 0x78 },
	'monochromefiltereffect' => { 48 => 0x74 },
	'monochromelinear' => { 48 => 0x7a },
	'monochromesharpness' => { 48 => 0x7c },
	'monochrometoningeffect' => { 48 => 0x76 },
	'monthdaycreated' => { 65 => 0x12, 72 => 0xe },
	'multiexposureautogain' => { 112 => 0x3 },
	'multiexposuremode' => { 112 => 0x1 },
	'multiexposureshots' => { 112 => 0x2 },
	'multisample' => { 116 => 0x40 },
	'multiselector' => { 118 => '799.4' },
	'multiselectorplaybackmode' => { 118 => '799.2' },
	'multiselectorshootmode' => { 118 => '799.1' },
	'mycolormode' => { 22 => 0x2 },
	'nativedigest' => { 184 => 'NativeDigest', 188 => 'NativeDigest' },
	'ncdfileinfo' => { 64 => 0x414 },
	'ndfilter' => { 27 => 0x1c },
	'nearlensstep' => { 140 => 0x103c },
	'nefcompression' => { 111 => 0x93 },
	'newsphotoversion' => { 61 => 0x0 },
	'nickname' => { 189 => 'Nickname' },
	'nikon_0x00b9' => { 111 => 0xb9 },
	'nikoncaptureversion' => { 111 => 0xe09 },
	'noisefilter' => { 135 => 0x527 },
	'noisereduction' => { 17 => 0x8, 57 => 0x100b, 91 => 0xb0, 92 => 0x60, 93 => 0x3f, 111 => 0x95, 129 => 0x753dcbc0, 135 => 0x50a, 140 => 0x103a, 149 => 0x2d, 161 => 0x49 },
	'noisereduction2' => { 139 => 0x1010 },
	'noisereductionintensity' => { 130 => 0x9 },
	'noisereductionmethod' => { 130 => 0x11 },
	'noisereductionsharpness' => { 130 => 0xd },
	'nomemorycard' => { 118 => '812.1', 119 => '729.3', 120 => '748.3' },
	'nominalmaxaperture' => { 158 => 0xa },
	'nominalminaperture' => { 158 => '10.1' },
	'npages' => { 195 => 'NPages' },
	'nullrecord' => { 43 => 0x0 },
	'numberofbeats' => { 191 => 'numberOfBeats' },
	'numindexentries' => { 61 => 0x54 },
	'objectattributereference' => { 59 => 0x4 },
	'objectcycle' => { 59 => 0x4b },
	'objectdistance' => { 49 => 0x6, 50 => 0x2022 },
	'objectname' => { 59 => 0x5 },
	'objectpreviewdata' => { 59 => 0xca },
	'objectpreviewfileformat' => { 59 => 0xc8 },
	'objectpreviewfileversion' => { 59 => 0xc9 },
	'objecttypereference' => { 59 => 0x3 },
	'oecfcolumns' => { 184 => 'OECFColumns' },
	'oecfnames' => { 184 => 'OECFNames' },
	'oecfrows' => { 184 => 'OECFRows' },
	'oecfvalues' => { 184 => 'OECFValues' },
	'offsetschema' => { 53 => 0xea1d },
	'oldsubfiletype' => { 53 => 0xff },
	'olympusimageheight' => { 140 => 0x102f },
	'olympusimagewidth' => { 140 => 0x102e },
	'onetouchwb' => { 140 => 0x302 },
	'opticalzoom' => { 66 => 0xfa3d, 68 => [0x6006,0xf006], 69 => 0x1000, 70 => 0xf, 72 => 0x1e, 83 => 'OpticalZoom' },
	'opticalzoomcode' => { 27 => 0xa },
	'opticalzoommode' => { 149 => 0x34 },
	'opticalzoomon' => { 172 => 0x219 },
	'ordernumber' => { 57 => 0x8002 },
	'orientation' => { 53 => 0x112, 150 => 0x112, 188 => 'Orientation' },
	'originaldecisiondata' => { 51 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 20 => 0x83 },
	'originalfilename' => { 43 => 0x816, 64 => 0x3e9, 73 => 0x20 },
	'originalimageheight' => { 56 => 0x1 },
	'originalimagewidth' => { 56 => 0x0 },
	'originalrawfiledata' => { 53 => 0xc68c },
	'originalrawfilename' => { 53 => 0xc68b },
	'originaltransmissionreference' => { 59 => 0x67 },
	'originatingprogram' => { 59 => 0x41 },
	'os' => { 183 => 'os' },
	'outcue' => { 191 => 'outCue' },
	'outputheight' => { 126 => 0xce },
	'outputheightinches' => { 126 => 0x96 },
	'outputpixels' => { 126 => 0xd6 },
	'outputresolution' => { 126 => 0xb6 },
	'outputwidth' => { 126 => 0xc6 },
	'outputwidthinches' => { 126 => 0x8e },
	'owner' => { 194 => 'Owner' },
	'ownerid' => { 59 => 0xbc },
	'ownername' => { 20 => 0x9, 43 => 0x810, 53 => 0xfde8, 76 => 'OwnerName', 179 => 'OwnerName' },
	'padding' => { 53 => 0xea1c },
	'pagename' => { 53 => 0x11d },
	'pagenumber' => { 53 => 0x129 },
	'panasonicexifversion' => { 149 => 0x26 },
	'panasonicrawversion' => { 150 => 0x1 },
	'panoramadirection' => { 23 => 0x5 },
	'panoramaframe' => { 23 => 0x2 },
	'panoramamode' => { 65 => 0x3c, 135 => 0x601 },
	'parametricdarks' => { 181 => 'ParametricDarks' },
	'parametrichighlights' => { 181 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 181 => 'ParametricHighlightSplit' },
	'parametriclights' => { 181 => 'ParametricLights' },
	'parametricmidtonesplit' => { 181 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 181 => 'ParametricShadows' },
	'parametricshadowsplit' => { 181 => 'ParametricShadowSplit' },
	'patientid' => { 175 => 'PatientID' },
	'patientsbirthdate' => { 175 => 'PatientDOB' },
	'patientsname' => { 175 => 'PatientName' },
	'patientssex' => { 175 => 'PatientSex' },
	'pdfversion' => { 186 => 'PDFVersion' },
	'pentaximagesize' => { 161 => 0x9 },
	'pentaxmodelid' => { 154 => 0x0, 161 => 0x5 },
	'pentaxmodeltype' => { 161 => 0x1 },
	'pentaxversion' => { 161 => 0x0 },
	'people' => { 177 => 'People' },
	'pf0customfuncregistration' => { 38 => 0x1 },
	'pf10retainprogramshift' => { 38 => 0xb },
	'pf13drivepriority' => { 38 => 0xe },
	'pf14disablefocussearch' => { 38 => 0xf },
	'pf15disableafassistbeam' => { 38 => 0x10 },
	'pf16autofocuspointshoot' => { 38 => 0x11 },
	'pf17disableafpointsel' => { 38 => 0x12 },
	'pf18enableautoafpointsel' => { 38 => 0x13 },
	'pf19continuousshootspeed' => { 38 => 0x14 },
	'pf19shootingspeedhigh' => { 37 => 0xa },
	'pf19shootingspeedlow' => { 37 => 0x9 },
	'pf1disableshootingmodes' => { 38 => 0x2 },
	'pf1value' => { 37 => 0x1 },
	'pf20limitcontinousshots' => { 38 => 0x15 },
	'pf20maxcontinousshots' => { 37 => 0xb },
	'pf21enablequietoperation' => { 38 => 0x16 },
	'pf23felocktime' => { 37 => 0xd },
	'pf23postreleasetime' => { 37 => 0xe },
	'pf23settimerlengths' => { 38 => 0x18 },
	'pf23shutterbuttontime' => { 37 => 0xc },
	'pf24lightlcdduringbulb' => { 38 => 0x19 },
	'pf25aemode' => { 37 => 0xf },
	'pf25afmode' => { 37 => 0x12 },
	'pf25afpointsel' => { 37 => 0x13 },
	'pf25colormatrix' => { 37 => 0x17 },
	'pf25defaultclearsettings' => { 38 => 0x1a },
	'pf25drivemode' => { 37 => 0x11 },
	'pf25imagesize' => { 37 => 0x14 },
	'pf25meteringmode' => { 37 => 0x10 },
	'pf25parameters' => { 37 => 0x16 },
	'pf25wbmode' => { 37 => 0x15 },
	'pf26shortenreleaselag' => { 38 => 0x1b },
	'pf27reversedialrotation' => { 38 => 0x1c },
	'pf27value' => { 37 => 0x18 },
	'pf28noquickdialexpcomp' => { 38 => 0x1d },
	'pf29quickdialswitchoff' => { 38 => 0x1e },
	'pf2disablemeteringmodes' => { 38 => 0x3 },
	'pf2value' => { 37 => 0x2 },
	'pf30enlargementmode' => { 38 => 0x1f },
	'pf31originaldecisiondata' => { 38 => 0x20 },
	'pf3manualexposuremetering' => { 38 => 0x4 },
	'pf3value' => { 37 => 0x3 },
	'pf4exposuretimelimits' => { 38 => 0x5 },
	'pf4exposuretimemax' => { 37 => 0x5 },
	'pf4exposuretimemin' => { 37 => 0x4 },
	'pf5aperturelimits' => { 38 => 0x6 },
	'pf5aperturemax' => { 37 => 0x7 },
	'pf5aperturemin' => { 37 => 0x6 },
	'pf6presetshootingmodes' => { 38 => 0x7 },
	'pf7bracketcontinuousshoot' => { 38 => 0x8 },
	'pf8bracketshots' => { 37 => 0x8 },
	'pf8setbracketshots' => { 38 => 0x9 },
	'pf9changebracketsequence' => { 38 => 0xa },
	'phonenumber' => { 77 => 'Phone' },
	'photoeffect' => { 8 => 0x28 },
	'photoeffects' => { 129 => 0xab5eca5e },
	'photoeffectsblue' => { 131 => 0x8 },
	'photoeffectsgreen' => { 131 => 0x6 },
	'photoeffectsred' => { 131 => 0x4 },
	'photoeffectstype' => { 131 => 0x0 },
	'photoinfoplayback' => { 118 => '807.6' },
	'photometricinterpretation' => { 53 => 0x106, 188 => 'PhotometricInterpretation' },
	'photoshopquality' => { 166 => 0x0 },
	'pictinfo' => { 172 => 0x208 },
	'picturecontroladjust' => { 113 => 0x30 },
	'picturecontrolbase' => { 113 => 0x18 },
	'picturecontrolname' => { 113 => 0x4 },
	'picturecontrolquickadjust' => { 113 => 0x31 },
	'picturefinish' => { 91 => 0x71 },
	'picturemode' => { 57 => 0x1031, 135 => 0x520, 161 => [0xb,0x33] },
	'picturemode2' => { 155 => 0x0 },
	'picturemodebwfilter' => { 135 => 0x525 },
	'picturemodecontrast' => { 135 => 0x523 },
	'picturemodehue' => { 135 => 0x522 },
	'picturemodesaturation' => { 135 => 0x521 },
	'picturemodesharpness' => { 135 => 0x524 },
	'picturemodetone' => { 135 => 0x526 },
	'picturestyle' => { 1 => [0x4b,0x51], 2 => 0x6c, 3 => 0x86, 4 => 0x73, 6 => 0x6c, 25 => 0xa, 48 => 0x4 },
	'planarconfiguration' => { 53 => 0x11c, 188 => 'PlanarConfiguration' },
	'platenames' => { 195 => 'PlateNames' },
	'pngwarning' => { 146 => 'Warning' },
	'postalcode' => { 81 => 'PostalCode' },
	'powersource' => { 153 => 0x0 },
	'precaptureframes' => { 140 => 0x300 },
	'predictor' => { 53 => 0x13d },
	'prefs' => { 59 => 0xdd, 165 => 'Prefs' },
	'preservedfilename' => { 192 => 'PreservedFileName' },
	'previewfocalplanexresolution' => { 24 => 0x6 },
	'previewfocalplaneyresolution' => { 24 => 0x8 },
	'previewheight' => { 66 => 0xfa58 },
	'previewimage' => { 50 => 0x2000, 51 => 'PreviewImage', 52 => 'MakN', 53 => 0x927c, 55 => 0x4, 86 => 'data', 94 => 0x81, 140 => 0x280, 150 => 0x2e, 174 => 0x2001 },
	'previewimageborders' => { 161 => 0x3e },
	'previewimageheight' => { 24 => 0x4 },
	'previewimagelength' => { 24 => 0x2, 50 => 0x3, 53 => [0x117,0x202], 94 => 0x89, 114 => 0x202, 135 => 0x102, 140 => 0x1037, 161 => 0x3, 170 => 0x1e, 173 => 0x1b },
	'previewimagename' => { 86 => '1Name' },
	'previewimagesize' => { 50 => 0x2, 86 => 'ImageSize', 161 => 0x2, 173 => 0x1c },
	'previewimagestart' => { 24 => 0x5, 50 => 0x4, 53 => [0x111,0x201], 94 => 0x88, 114 => 0x201, 135 => 0x101, 140 => 0x1036, 161 => 0x4, 170 => 0x1c, 173 => 0x1a },
	'previewimagetype' => { 86 => '0Type' },
	'previewimagevalid' => { 135 => 0x100, 140 => 0x1035 },
	'previewimagewidth' => { 24 => 0x3 },
	'previewquality' => { 24 => 0x1 },
	'previewwidth' => { 66 => 0xfa57 },
	'primarychromaticities' => { 53 => 0x13f, 188 => 'PrimaryChromaticities' },
	'printim' => { 53 => 0xc4a5 },
	'privatertkinfo' => { 176 => 'privateRTKInfo' },
	'processingsoftware' => { 53 => 0xb },
	'producer' => { 144 => 'Producer', 186 => 'Producer' },
	'productid' => { 60 => 0x32 },
	'programiso' => { 149 => 0x3c },
	'programline' => { 155 => '1.1' },
	'programmode' => { 96 => 0x5 },
	'programshift' => { 111 => 0xd },
	'programversion' => { 59 => 0x46 },
	'projectrefpath' => { 191 => 'projectRefPath' },
	'projectreftype' => { 191 => 'projectRefType' },
	'province-state' => { 59 => 0x5f },
	'publisher' => { 182 => 'publisher' },
	'pulldown' => { 191 => 'pullDown' },
	'quality' => { 0 => 0x1, 8 => 0x3, 49 => 0x2, 50 => 0x3002, 57 => 0x1000, 65 => 0x9, 111 => 0x4, 121 => 0x3, 140 => 0x201, 147 => 0x300, 161 => 0x8, 163 => 0x2, 173 => 0x16, 174 => 0xb047 },
	'qualitymode' => { 50 => 0x8 },
	'quantizationmethod' => { 61 => 0x78 },
	'quickcontroldialinmeter' => { 30 => 0x703 },
	'quickshot' => { 172 => 0x213 },
	'rasterizedcaption' => { 59 => 0x7d },
	'rating' => { 53 => 0x4746, 164 => 0xdf, 183 => 'rating', 189 => 'Rating' },
	'ratingpercent' => { 53 => 0x4749, 178 => 'Rating' },
	'rawandjpgrecording' => { 28 => 0x8, 155 => 0xd },
	'rawbrightnessadj' => { 47 => 0x38 },
	'rawcoloradj' => { 47 => 0x2e },
	'rawcolortoneadj' => { 48 => 0x1a },
	'rawcontrastadj' => { 48 => 0x1e },
	'rawcropbottom' => { 164 => 0xd4 },
	'rawcropleft' => { 164 => 0xd1 },
	'rawcropright' => { 164 => 0xd3 },
	'rawcroptop' => { 164 => 0xd2 },
	'rawcustomsaturation' => { 47 => 0x30 },
	'rawcustomtone' => { 47 => 0x34 },
	'rawdatauniqueid' => { 53 => 0xc65d },
	'rawdepth' => { 95 => 0x10 },
	'rawdevautogradation' => { 142 => 0x119 },
	'rawdevcolorspace' => { 141 => 0x108, 142 => 0x109 },
	'rawdevcontrastvalue' => { 141 => 0x106, 142 => 0x105 },
	'rawdeveditstatus' => { 141 => 0x10b },
	'rawdevengine' => { 141 => 0x109, 142 => 0x10b },
	'rawdevexposurebiasvalue' => { 141 => 0x100, 142 => 0x100 },
	'rawdevgradation' => { 142 => 0x112 },
	'rawdevgraypoint' => { 141 => 0x103, 142 => 0x104 },
	'rawdevmemorycoloremphasis' => { 141 => 0x105, 142 => 0x108 },
	'rawdevnoisereduction' => { 141 => 0x10a, 142 => 0x10a },
	'rawdevpicturemode' => { 142 => 0x10c },
	'rawdevpm_bwfilter' => { 142 => 0x110 },
	'rawdevpmcontrast' => { 142 => 0x10e },
	'rawdevpmnoisefilter' => { 142 => 0x120 },
	'rawdevpmpicturetone' => { 142 => 0x111 },
	'rawdevpmsaturation' => { 142 => 0x10d },
	'rawdevpmsharpness' => { 142 => 0x10f },
	'rawdevsaturation3' => { 142 => 0x113 },
	'rawdevsaturationemphasis' => { 141 => 0x104, 142 => 0x107 },
	'rawdevsettings' => { 141 => 0x10c },
	'rawdevsharpnessvalue' => { 141 => 0x107, 142 => 0x106 },
	'rawdevversion' => { 141 => 0x0, 142 => 0x0 },
	'rawdevwbfineadjustment' => { 141 => 0x102, 142 => 0x103 },
	'rawdevwhitebalance' => { 142 => 0x101 },
	'rawdevwhitebalancevalue' => { 141 => 0x101, 142 => 0x102 },
	'rawfile' => { 53 => 0xfe4c },
	'rawfilename' => { 181 => 'RawFileName' },
	'rawhighlightpoint' => { 48 => 0x24 },
	'rawimagecenter' => { 111 => 0x99 },
	'rawimagesize' => { 161 => 0x39 },
	'rawinfoversion' => { 143 => 0x0 },
	'rawjpgheight' => { 45 => 0x4 },
	'rawjpgquality' => { 17 => 0x6, 45 => 0x1 },
	'rawjpgsize' => { 17 => 0x7, 45 => 0x2 },
	'rawjpgwidth' => { 45 => 0x3 },
	'rawlinear' => { 48 => 0x20 },
	'rawsaturationadj' => { 48 => 0x1c },
	'rawshadowpoint' => { 48 => 0x26 },
	'rawsharpnessadj' => { 48 => 0x22 },
	'recordid' => { 43 => 0x1804 },
	'recordingmode' => { 49 => 0x1, 163 => 0x1 },
	'recordmode' => { 8 => 0x9, 50 => 0x3000 },
	'recordshutterrelease' => { 172 => 0x217 },
	'redbalance' => { 140 => 0x1017, 150 => 0x11, 161 => 0x1c },
	'redcurvelimits' => { 47 => 0x18a },
	'redcurvepoints' => { 47 => 0x160 },
	'redeyecorrection' => { 132 => 0x0 },
	'redhue' => { 181 => 'RedHue' },
	'redsaturation' => { 181 => 'RedSaturation' },
	'referenceblackwhite' => { 53 => 0x214, 188 => 'ReferenceBlackWhite' },
	'referencedate' => { 59 => 0x2f },
	'referencenumber' => { 59 => 0x32 },
	'references' => { 77 => 'References' },
	'referenceservice' => { 59 => 0x2d },
	'relatedaudiofile' => { 75 => 'data' },
	'relatedaudiofilename' => { 75 => '1Name' },
	'relatedaudiofiletype' => { 75 => '0Type' },
	'relatedimagefileformat' => { 53 => 0x1000 },
	'relatedimageheight' => { 53 => 0x1002 },
	'relatedimagewidth' => { 53 => 0x1001 },
	'relatedsoundfile' => { 53 => 0xa004, 184 => 'RelatedSoundFile' },
	'relatedvideofile' => { 89 => 'data' },
	'relatedvideofilename' => { 89 => '1Name' },
	'relatedvideofiletype' => { 89 => '0Type' },
	'relation' => { 182 => 'relation' },
	'relativepeakaudiofilepath' => { 191 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 191 => 'relativeTimestamp' },
	'releasebuttontousedial' => { 118 => '807.8' },
	'releasedate' => { 59 => 0x1e, 191 => 'releaseDate' },
	'releasesetting' => { 43 => 0x1016 },
	'releasetime' => { 59 => 0x23 },
	'remoteonduration' => { 119 => '733.1', 120 => '752.3' },
	'renditionclass' => { 192 => 'RenditionClass' },
	'renditionofdocumentid' => { 192 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 192 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 192 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 192 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 192 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 192 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 192 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 192 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 192 => 'RenditionOfVersionID' },
	'renditionparams' => { 192 => 'RenditionParams' },
	'repeatingflashcount' => { 105 => 0xd, 106 => 0xe, 120 => '757.2' },
	'repeatingflashoutput' => { 120 => '757.1' },
	'repeatingflashrate' => { 105 => 0xc, 106 => 0xd, 120 => '758.1' },
	'resampleparamsquality' => { 191 => 'resampleParamsQuality' },
	'resaved' => { 172 => 0x21e },
	'resolution' => { 82 => 'Resolution' },
	'resolutionmode' => { 173 => 0x4 },
	'resolutionunit' => { 53 => 0x128, 62 => 0x2, 188 => 'ResolutionUnit' },
	'retouchhistory' => { 111 => 0x9e },
	'reuseallowed' => { 193 => 'ReuseAllowed' },
	'reverseindicators' => { 118 => '802.1' },
	'revision' => { 183 => 'revision' },
	'rgbcurvelimits' => { 47 => 0x238 },
	'rgbcurvepoints' => { 47 => 0x20e },
	'ricohdate' => { 170 => 0x6 },
	'ricohimageheight' => { 170 => 0x2 },
	'ricohimagewidth' => { 170 => 0x0 },
	'rightascension' => { 85 => 'RightAscension' },
	'rights' => { 182 => 'rights' },
	'romoperationmode' => { 43 => 0x80d },
	'rotation' => { 7 => 0x17, 42 => 0x3, 47 => 0x26e, 56 => 0x4, 85 => 'Rotation', 91 => [0x65,0x50], 92 => 0x46, 93 => 0x5a, 120 => '590.1', 129 => 0x76a43207, 149 => 0x30, 164 => 0xd8 },
	'routing' => { 169 => 'Routing' },
	'rowsperstrip' => { 53 => 0x116 },
	'safetyshift' => { 30 => 0x108 },
	'safetyshiftinavortv' => { 28 => 0x10, 29 => 0x10, 31 => 0xf, 32 => 0x10, 35 => 0x10 },
	'samplebits' => { 75 => 'SampleBits' },
	'samplerate' => { 75 => 'SampleRate' },
	'samplesperpixel' => { 53 => 0x115, 188 => 'SamplesPerPixel' },
	'samplestructure' => { 61 => 0x5a },
	'sanyoquality' => { 172 => 0x201 },
	'sanyothumbnail' => { 172 => 0x100 },
	'saturation' => { 2 => 0x6e, 4 => 0x76, 8 => 0xe, 14 => 0x1, 49 => 0xd, 50 => [0x3013,0x1f], 53 => [0xa409,0xfe55], 57 => 0x1003, 76 => 'Saturation', 90 => 0x1f, 91 => 0x32, 92 => 0x28, 93 => 0x1a, 96 => 0x1, 111 => [0x94,0xaa], 113 => 0x35, 149 => 0x40, 161 => 0x1f, 163 => 0xd, 170 => 0x28, 173 => 0x10, 181 => 'Saturation', 184 => 'Saturation' },
	'saturationadj' => { 47 => 0x116 },
	'saturationadjustmentaqua' => { 181 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 181 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 181 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 181 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 181 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 181 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 181 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 181 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 6 => 0xfe },
	'saturationlandscape' => { 6 => 0xfc },
	'saturationneutral' => { 6 => 0xfd },
	'saturationportrait' => { 6 => 0xfb },
	'saturationsetting' => { 143 => 0x1010 },
	'saturationstandard' => { 6 => 0xfa },
	'saturationuserdef1' => { 6 => 0x100 },
	'saturationuserdef2' => { 6 => 0x101 },
	'saturationuserdef3' => { 6 => 0x102 },
	'saveid' => { 192 => 'SaveID' },
	'scaledresolution' => { 126 => 0x9e },
	'scaletype' => { 191 => 'scaleType' },
	'scanningdirection' => { 61 => 0x64 },
	'scene' => { 185 => 'Scene', 191 => 'scene' },
	'scenearea' => { 138 => 0x211, 140 => 0x1031 },
	'sceneassist' => { 111 => 0x9c },
	'scenecapturetype' => { 53 => 0xa406, 184 => 'SceneCaptureType' },
	'scenedetect' => { 138 => 0x210, 140 => 0x1030 },
	'scenedetectdata' => { 138 => 0x212, 140 => 0x1033 },
	'scenemode' => { 66 => 0xfa02, 94 => 0x100, 111 => 0x8f, 135 => 0x509, 140 => 0x403, 149 => 0x8001, 174 => 0xb023 },
	'scenemodeused' => { 68 => [0x6002,0xf002] },
	'sceneselect' => { 172 => 0x21f },
	'scenetype' => { 53 => 0xa301, 184 => 'SceneType' },
	'securityclassification' => { 53 => 0x9212 },
	'selectableafpoint' => { 30 => 0x509 },
	'selftimer' => { 8 => 0x2, 50 => 0x3001, 149 => 0x2e, 172 => 0x214 },
	'selftimer2' => { 27 => 0x1d },
	'selftimermode' => { 53 => 0x882b },
	'selftimertime' => { 43 => 0x1806, 118 => '808.1', 119 => '732.3', 120 => '751.3' },
	'seminfo' => { 53 => 0x8546 },
	'sensingmethod' => { 53 => 0xa217, 184 => 'SensingMethod' },
	'sensitivityadjust' => { 161 => 0x40 },
	'sensorbluelevel' => { 25 => 0x5 },
	'sensorcleaning' => { 36 => 0xd },
	'sensorfullheight' => { 63 => 0xf904 },
	'sensorfullwidth' => { 63 => 0xf903 },
	'sensorheight' => { 63 => 0xf901, 66 => 0xfa21, 95 => 0x8 },
	'sensorpixelsize' => { 111 => 0x9a },
	'sensorredlevel' => { 25 => 0x4 },
	'sensorsize' => { 76 => 'SensorSize' },
	'sensortemperature' => { 138 => 0x1500, 140 => 0x1007 },
	'sensorwidth' => { 63 => 0xf900, 66 => 0xfa20, 95 => 0xa },
	'sequencenumber' => { 27 => 0x9, 50 => 0x301c, 57 => 0x1101, 65 => 0x1d, 149 => 0x2b },
	'sequenceshotinterval' => { 172 => 0x224 },
	'sequentialshot' => { 172 => 0x20e },
	'serialnumber' => { 20 => 0xc, 43 => 0x180b, 53 => 0xfde9, 63 => 0xfa04, 66 => 0xfa19, 74 => 0x0, 76 => 'SerialNumber', 111 => 0xa0, 136 => 0x101, 140 => [0x404,0x101a], 147 => 0x303, 173 => 0x2, 179 => 'SerialNumber' },
	'serialnumberformat' => { 20 => 0x15, 43 => 0x183b },
	'seriesdatetime' => { 175 => 'SeriesDateTime' },
	'seriesdescription' => { 175 => 'SeriesDescription' },
	'seriesmodality' => { 175 => 'SeriesModality' },
	'seriesnumber' => { 175 => 'SeriesNumber' },
	'serviceidentifier' => { 60 => 0x1e },
	'setbuttoncrosskeysfunc' => { 33 => 0x0, 34 => 0x0 },
	'setbuttonfunction' => { 28 => 0x1, 36 => 0xc },
	'setbuttonwhenshooting' => { 30 => 0x704 },
	'setfunctionwhenshooting' => { 31 => 0x0, 32 => 0x1, 35 => 0x1 },
	'shadingcompensation' => { 135 => 0x50c },
	'shadingcompensation2' => { 139 => 0x1012 },
	'shadow' => { 173 => 0xe },
	'shadows' => { 53 => 0xfe52, 181 => 'Shadows' },
	'shadowscale' => { 53 => 0xc633 },
	'shadowtint' => { 181 => 'ShadowTint' },
	'shakereduction' => { 162 => 0x1 },
	'sharpendetail' => { 181 => 'SharpenDetail' },
	'sharpenedgemasking' => { 181 => 'SharpenEdgeMasking' },
	'sharpenradius' => { 181 => 'SharpenRadius' },
	'sharpness' => { 1 => [0x42,0x48], 2 => 0x72, 4 => 0x74, 8 => 0xf, 25 => 0x2, 49 => 0xb, 50 => [0x3011,0x21], 53 => [0xa40a,0xfe56], 57 => 0x1001, 65 => 0x6b, 72 => 0x37, 76 => 'Sharpness', 90 => 0x21, 91 => 0x30, 92 => 0x26, 93 => 0x18, 96 => 0x3, 111 => 0x6, 113 => 0x32, 140 => 0x100f, 149 => 0x41, 161 => 0x21, 163 => 0xb, 170 => 0x22, 171 => 0x1003, 173 => 0x11, 181 => 'Sharpness', 184 => 'Sharpness' },
	'sharpnessfactor' => { 140 => 0x102a },
	'sharpnessfaithful' => { 6 => 0xf5 },
	'sharpnessfrequency' => { 1 => [0x41,0x47], 25 => 0x3 },
	'sharpnesslandscape' => { 6 => 0xf3 },
	'sharpnessmonochrome' => { 6 => 0xf6 },
	'sharpnessneutral' => { 6 => 0xf4 },
	'sharpnessportrait' => { 6 => 0xf2 },
	'sharpnesssetting' => { 135 => 0x506, 143 => 0x1013 },
	'sharpnessstandard' => { 6 => 0xf1 },
	'sharpnessuserdef1' => { 6 => 0xf7 },
	'sharpnessuserdef2' => { 6 => 0xf8 },
	'sharpnessuserdef3' => { 6 => 0xf9 },
	'shootinginfodisplay' => { 118 => '803.2' },
	'shootingmode' => { 76 => 'ShootingMode', 111 => 0x89, 149 => 0x1f },
	'shootingmodesetting' => { 119 => '734.1' },
	'shortdescription' => { 183 => 'shortdescription' },
	'shortdocumentid' => { 59 => 0xba },
	'shortfocal' => { 1 => 0xe, 2 => 0x11, 3 => 0x113, 4 => 0x11, 5 => 0xd8, 6 => 0x93, 8 => 0x18 },
	'shortownername' => { 6 => 0xac },
	'shortreleasetimelag' => { 30 => 0x80d },
	'shotdate' => { 191 => 'shotDate' },
	'shotlocation' => { 191 => 'shotLocation' },
	'shotname' => { 191 => 'shotName' },
	'shutter-aelock' => { 28 => 0x4, 31 => 0x3, 32 => 0x4, 33 => 0x3, 34 => 0x3, 35 => 0x4, 36 => 0x2 },
	'shutteraelbutton' => { 29 => 0x4 },
	'shutterbuttonafonbutton' => { 30 => 0x701 },
	'shuttercount' => { 3 => 0x176, 17 => 0x1, 117 => [0x6a,0x157,0x276], 118 => 0x279, 119 => 0x246, 120 => 0x24a, 161 => 0x5d },
	'shuttercurtainsync' => { 28 => 0xf, 29 => 0xf, 30 => 0x305, 31 => 0xe, 32 => 0xf, 33 => 0x8, 34 => 0x8, 35 => 0xf, 36 => 0x8 },
	'shuttermode' => { 65 => 0x1b },
	'shutterreleasebuttonae-l' => { 118 => '807.7' },
	'shutterreleasemethod' => { 43 => 0x1010 },
	'shutterreleasenocfcard' => { 28 => 0x2, 29 => 0x2, 36 => 0xf },
	'shutterreleasetiming' => { 43 => 0x1011 },
	'shutterspeedrange' => { 30 => 0x10c },
	'shutterspeedvalue' => { 53 => 0x9201, 140 => 0x1000, 184 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 187 => 'SidecarForExtension' },
	'similarityindex' => { 59 => 0xe4 },
	'slaveflashmeteringsegments' => { 161 => 0x20b },
	'slowshutter' => { 27 => 0x8 },
	'slowsync' => { 57 => 0x1030 },
	'smoothness' => { 53 => 0xfe57 },
	'software' => { 53 => 0x131, 77 => 'Software', 146 => 'Software', 173 => 0x18, 188 => 'Software' },
	'softwareversion' => { 172 => 0x207 },
	'source' => { 59 => 0x73, 146 => 'Source', 182 => 'source', 183 => 'source', 187 => 'Source' },
	'sourceresolution' => { 126 => 0xae },
	'spatialfrequencyresponsecolumns' => { 184 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 184 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 184 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 184 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 191 => 'speakerPlacement' },
	'specialinstructions' => { 59 => 0x28 },
	'specialmode' => { 140 => 0x200, 172 => 0x200 },
	'spectralsensitivity' => { 53 => 0x8824, 184 => 'SpectralSensitivity' },
	'splittoningbalance' => { 181 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 181 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 181 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 181 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 181 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 90 => 0x2d },
	'spotfocuspointy' => { 90 => 0x2e },
	'spotmeteringmode' => { 8 => 0x27 },
	'spotmeterlinktoafpoint' => { 30 => 0x107 },
	'srfocallength' => { 162 => 0x3 },
	'srhalfpresstime' => { 162 => 0x2 },
	'srresult' => { 162 => 0x0 },
	'starttimecodetimeformat' => { 191 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 191 => 'startTimecodeTimeValue' },
	'state' => { 81 => 'State', 187 => 'State' },
	'status' => { 177 => 'Status' },
	'storagemethod' => { 95 => 0x12 },
	'straightenangle' => { 129 => 0x2fc08431 },
	'stretchmode' => { 191 => 'stretchMode' },
	'studydatetime' => { 175 => 'StudyDateTime' },
	'studydescription' => { 175 => 'StudyDescription' },
	'studyid' => { 175 => 'StudyID' },
	'studyphysician' => { 175 => 'StudyPhysician' },
	'sub-location' => { 59 => 0x5c },
	'subfiledata' => { 84 => 'data' },
	'subfiledirectory' => { 84 => '1Directory' },
	'subfilemimetype' => { 84 => '2MIME' },
	'subfilename' => { 84 => '1Name' },
	'subfileresource' => { 84 => 'rsrc' },
	'subfiletype' => { 53 => 0xfe, 84 => '0Type' },
	'subject' => { 144 => 'Subject', 169 => 'Subject', 182 => 'subject', 186 => 'Subject' },
	'subjectarea' => { 184 => 'SubjectArea' },
	'subjectcode' => { 185 => 'SubjectCode' },
	'subjectdistance' => { 53 => 0x9206, 65 => 0x3e, 184 => 'SubjectDistance' },
	'subjectdistancerange' => { 53 => 0xa40c, 184 => 'SubjectDistanceRange' },
	'subjectlocation' => { 53 => [0x9214,0xa214], 184 => 'SubjectLocation' },
	'subjectprogram' => { 90 => 0x22 },
	'subjectreference' => { 59 => 0xc },
	'subsectime' => { 53 => 0x9290, 64 => 0x401 },
	'subsectimedigitized' => { 53 => 0x9292 },
	'subsectimeoriginal' => { 53 => 0x9291 },
	'superimposeddisplay' => { 28 => 0xa, 30 => 0x510, 31 => 0x9, 32 => 0xa, 35 => 0xa, 36 => 0xe },
	'supplementalcategories' => { 59 => 0x14, 187 => 'SupplementalCategories' },
	'supplementaltype' => { 61 => 0x37 },
	'svisosetting' => { 155 => 0x14 },
	'switchtoregisteredafpoint' => { 29 => 0x12, 30 => 0x50a },
	'tagged' => { 164 => 0xdd },
	'tapename' => { 191 => 'tapeName' },
	'targetaperture' => { 27 => 0x4 },
	'targetcompressionratio' => { 41 => 0x1 },
	'targetdistancesetting' => { 43 => 0x1807 },
	'targetexposuretime' => { 27 => 0x5 },
	'targetimagetype' => { 43 => 0x100a },
	'teleconverter' => { 94 => 0x105 },
	'temperature' => { 181 => 'Temperature' },
	'tempo' => { 191 => 'tempo' },
	'thresholding' => { 53 => 0x107 },
	'thumbnailfilename' => { 43 => 0x817 },
	'thumbnailheight' => { 66 => 0xfa55 },
	'thumbnailimage' => { 43 => 0x2008, 51 => 'ThumbnailImage', 55 => 0x3, 87 => 'data', 140 => 0x100 },
	'thumbnailimagename' => { 87 => '1Name' },
	'thumbnailimagesize' => { 87 => 'ImageSize' },
	'thumbnailimagetype' => { 87 => '0Type' },
	'thumbnailimagevalidarea' => { 20 => 0x13 },
	'thumbnaillength' => { 53 => 0x202 },
	'thumbnailoffset' => { 53 => 0x201 },
	'thumbnailsformat' => { 189 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 189 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 189 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 189 => 'ThumbnailsWidth' },
	'thumbnailwidth' => { 66 => 0xfa54 },
	'tilelength' => { 53 => 0x143 },
	'tilewidth' => { 53 => 0x142 },
	'time' => { 161 => 0x7 },
	'timecreated' => { 59 => 0x3c, 65 => 0x14, 72 => 0x10, 165 => 'TimeCreated' },
	'timerfunctionbutton' => { 119 => '734.2' },
	'timerlength' => { 30 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 191 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 191 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 191 => 'timeScaleParamsQuality' },
	'timesent' => { 60 => 0x50 },
	'timesignature' => { 191 => 'timeSignature' },
	'timesincepoweron' => { 149 => 0x29 },
	'timestamp' => { 3 => 0x45e, 6 => 0x11c, 146 => 'TimeStamp' },
	'timezone' => { 123 => 0x0 },
	'timezonecode' => { 46 => 0x1 },
	'timezoneinfo' => { 46 => 0x2 },
	'timezoneoffset' => { 53 => 0x882a },
	'tint' => { 181 => 'Tint' },
	'title' => { 77 => 'Title', 144 => 'Title', 146 => 'Title', 169 => 'Title', 182 => 'title', 186 => 'Title' },
	'tonecomp' => { 111 => 0x81 },
	'tonecurve' => { 25 => 0x1, 161 => 0x402, 181 => 'ToneCurve' },
	'tonecurveactive' => { 47 => 0x110 },
	'tonecurvefilename' => { 64 => 0x1391 },
	'tonecurvename' => { 181 => 'ToneCurveName' },
	'tonecurveproperty' => { 47 => 0x3c },
	'tonecurves' => { 161 => 0x403 },
	'toningeffect' => { 17 => 0xf, 111 => 0xb3, 113 => 0x38 },
	'toningeffectmonochrome' => { 6 => 0x108 },
	'toningsaturation' => { 113 => 0x39 },
	'totalzoom' => { 65 => 0x62 },
	'tracknumber' => { 191 => 'trackNumber' },
	'trailersignature' => { 84 => 'zmie' },
	'transferfunction' => { 188 => 'TransferFunction' },
	'transmissionreference' => { 187 => 'TransmissionReference' },
	'travelday' => { 149 => 0x36 },
	'ttl_da_adown' => { 157 => 0x5 },
	'ttl_da_aup' => { 157 => 0x4 },
	'ttl_da_bdown' => { 157 => 0x7 },
	'ttl_da_bup' => { 157 => 0x6 },
	'tvexposuretimesetting' => { 155 => 0x12 },
	'tvvalue' => { 39 => 0x1 },
	'type' => { 182 => 'type' },
	'uniquecameramodel' => { 53 => 0xc614 },
	'uniquedocumentid' => { 59 => 0xbb },
	'uniqueobjectname' => { 60 => 0x64 },
	'unknownblock' => { 139 => 0x1103 },
	'unknowncompensation' => { 173 => 0xc },
	'unknownev' => { 64 => 0x1 },
	'unknownnumber' => { 43 => 0x180b },
	'unsharp1color' => { 133 => 0x13 },
	'unsharp1halowidth' => { 133 => 0x19 },
	'unsharp1intensity' => { 133 => 0x17 },
	'unsharp1threshold' => { 133 => 0x1b },
	'unsharp2color' => { 133 => 0x2e },
	'unsharp2halowidth' => { 133 => 0x34 },
	'unsharp2intensity' => { 133 => 0x32 },
	'unsharp2threshold' => { 133 => 0x36 },
	'unsharp3color' => { 133 => 0x49 },
	'unsharp3halowidth' => { 133 => 0x4f },
	'unsharp3intensity' => { 133 => 0x4d },
	'unsharp3threshold' => { 133 => 0x51 },
	'unsharp4color' => { 133 => 0x64 },
	'unsharp4halowidth' => { 133 => 0x6a },
	'unsharp4intensity' => { 133 => 0x68 },
	'unsharp4threshold' => { 133 => 0x6c },
	'unsharpcount' => { 133 => 0x0 },
	'unsharpmask' => { 129 => 0x76a43200 },
	'urgency' => { 59 => 0xa, 187 => 'Urgency' },
	'url' => { 77 => 'URL', 146 => 'URL', 167 => 0x40b },
	'usablemeteringmodes' => { 30 => 0x10a },
	'usableshootingmodes' => { 30 => 0x109 },
	'usageterms' => { 194 => 'UsageTerms' },
	'usercomment' => { 43 => 0x805, 53 => 0x9286, 184 => 'UserComment' },
	'userdef1picturestyle' => { 6 => 0x10c },
	'userdef2picturestyle' => { 6 => 0x10e },
	'userdef3picturestyle' => { 6 => 0x110 },
	'userfields' => { 177 => 'UserFields' },
	'userprofile' => { 147 => 0x302 },
	'usmlenselectronicmf' => { 29 => 0x7, 30 => 0x501 },
	'utmeasting' => { 88 => 'Easting' },
	'utmmapdatum' => { 88 => 'Datum' },
	'utmnorthing' => { 88 => 'Northing' },
	'utmzone' => { 88 => 'Zone' },
	'uv-irfiltercorrection' => { 147 => 0x325 },
	'validbits' => { 139 => 0x611, 140 => 0x102c },
	'validpixeldepth' => { 143 => 0x611 },
	'variousmodes' => { 65 => 0x26 },
	'variousmodes2' => { 65 => 0x3a },
	'variprogram' => { 111 => 0xab },
	'version' => { 57 => 0x0, 169 => 'Version', 181 => 'Version' },
	'versionid' => { 192 => 'VersionID' },
	'versionscomments' => { 192 => 'VersionsComments' },
	'versionseventaction' => { 192 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 192 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 192 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 192 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 192 => 'VersionsEventWhen' },
	'versionsmodifier' => { 192 => 'VersionsModifier' },
	'versionsmodifydate' => { 192 => 'VersionsModifyDate' },
	'versionsversion' => { 192 => 'VersionsVersion' },
	'vibrance' => { 181 => 'Vibrance' },
	'vibrationreduction' => { 117 => [0x75,0x82,0x1ae], 119 => '586.1', 120 => '590.2', 122 => 0x4 },
	'videoalphamode' => { 191 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 191 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 191 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 191 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 191 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 191 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 191 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 191 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 191 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 191 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 191 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 191 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 191 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 191 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 191 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 191 => 'videoColorSpace' },
	'videocompressor' => { 191 => 'videoCompressor' },
	'videofieldorder' => { 191 => 'videoFieldOrder' },
	'videoframerate' => { 191 => 'videoFrameRate' },
	'videoframesizeh' => { 191 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 191 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 191 => 'videoFrameSizeW' },
	'videomoddate' => { 191 => 'videoModDate' },
	'videopixelaspectratio' => { 191 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 191 => 'videoPixelDepth' },
	'viewfinderwarning' => { 118 => '803.4', 120 => '754.2' },
	'viewinfoduringexposure' => { 30 => 0x407 },
	'vignetteamount' => { 181 => 'VignetteAmount' },
	'vignettecontrol' => { 111 => 0x2a, 129 => 0x76a43205 },
	'vignettecontrolintensity' => { 129 => 0xac6bd5c0 },
	'vignettemidpoint' => { 181 => 'VignetteMidpoint' },
	'voicememo' => { 172 => 0x216 },
	'vr_0x66' => { 117 => 0x66 },
	'vrdoffset' => { 20 => 0xd0 },
	'wb_glevel' => { 139 => 0x11f },
	'wb_glevel3000k' => { 139 => 0x113 },
	'wb_glevel3300k' => { 139 => 0x114 },
	'wb_glevel3600k' => { 139 => 0x115 },
	'wb_glevel3900k' => { 139 => 0x116 },
	'wb_glevel4000k' => { 139 => 0x117 },
	'wb_glevel4300k' => { 139 => 0x118 },
	'wb_glevel4500k' => { 139 => 0x119 },
	'wb_glevel4800k' => { 139 => 0x11a },
	'wb_glevel5300k' => { 139 => 0x11b },
	'wb_glevel6000k' => { 139 => 0x11c },
	'wb_glevel6600k' => { 139 => 0x11d },
	'wb_glevel7500k' => { 139 => 0x11e },
	'wb_grbglevels' => { 103 => 0x0 },
	'wb_rbgglevels' => { 100 => 0x0 },
	'wb_rblevels' => { 139 => 0x100 },
	'wb_rblevels3000k' => { 139 => 0x102 },
	'wb_rblevels3300k' => { 139 => 0x103 },
	'wb_rblevels3600k' => { 139 => 0x104 },
	'wb_rblevels3900k' => { 139 => 0x105 },
	'wb_rblevels4000k' => { 139 => 0x106 },
	'wb_rblevels4300k' => { 139 => 0x107 },
	'wb_rblevels4500k' => { 139 => 0x108 },
	'wb_rblevels4800k' => { 139 => 0x109 },
	'wb_rblevels5300k' => { 139 => 0x10a },
	'wb_rblevels6000k' => { 139 => 0x10b },
	'wb_rblevels6600k' => { 139 => 0x10c },
	'wb_rblevels7500k' => { 139 => 0x10d },
	'wb_rblevelsauto' => { 143 => 0x110 },
	'wb_rblevelscloudy' => { 143 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 143 => 0x132 },
	'wb_rblevelscwb1' => { 139 => 0x10e },
	'wb_rblevelscwb2' => { 139 => 0x10f },
	'wb_rblevelscwb3' => { 139 => 0x110 },
	'wb_rblevelscwb4' => { 139 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 143 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 143 => 0x131 },
	'wb_rblevelseveningsunlight' => { 143 => 0x124 },
	'wb_rblevelsfineweather' => { 143 => 0x122 },
	'wb_rblevelsshade' => { 143 => 0x120 },
	'wb_rblevelstungsten' => { 143 => 0x123 },
	'wb_rblevelsused' => { 143 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 143 => 0x133 },
	'wb_rgbglevels' => { 102 => 0x0 },
	'wb_rgblevels' => { 148 => 0xd },
	'wb_rggblevels' => { 101 => 0x0 },
	'wb_rggblevelsasshot' => { 10 => 0x19, 11 => 0x18, 12 => 0x3f, 13 => 0x3f },
	'wb_rggblevelsauto' => { 9 => 0x0, 10 => 0x1e, 11 => 0x22, 12 => 0x44, 13 => 0x44 },
	'wb_rggblevelscloudy' => { 9 => 0xc, 10 => 0x2d, 11 => 0x31, 12 => 0x58, 13 => 0x5d, 161 => 0x20f },
	'wb_rggblevelscustom' => { 9 => 0x1c, 12 => 0x80 },
	'wb_rggblevelscustom1' => { 10 => 0x41 },
	'wb_rggblevelscustom2' => { 10 => 0x46 },
	'wb_rggblevelsdaylight' => { 9 => 0x4, 10 => 0x23, 11 => 0x27, 12 => 0x4e, 13 => 0x53, 161 => 0x20d },
	'wb_rggblevelsflash' => { 9 => 0x18, 10 => 0x3c, 11 => 0x45, 12 => 0x6c, 13 => 0x71, 161 => 0x214 },
	'wb_rggblevelsfluorescent' => { 9 => 0x14, 10 => 0x37, 11 => 0x3b, 12 => 0x62, 13 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 161 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 161 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 161 => 0x213 },
	'wb_rggblevelskelvin' => { 9 => 0x20, 11 => 0x40, 12 => 0x67, 13 => 0x6c },
	'wb_rggblevelsmeasured' => { 12 => 0x49, 13 => 0x49 },
	'wb_rggblevelspc1' => { 11 => 0x90, 12 => 0x71 },
	'wb_rggblevelspc2' => { 11 => 0x95, 12 => 0x76 },
	'wb_rggblevelspc3' => { 11 => 0x9a, 12 => 0x7b },
	'wb_rggblevelsshade' => { 9 => 0x8, 10 => 0x28, 11 => 0x2c, 12 => 0x53, 13 => 0x58, 161 => 0x20e },
	'wb_rggblevelstungsten' => { 9 => 0x10, 10 => 0x32, 11 => 0x36, 12 => 0x5d, 13 => 0x62, 161 => 0x210 },
	'wb_rggblevelsunknown' => { 11 => 0x1d },
	'wb_rggblevelsunknown10' => { 11 => 0x72, 13 => 0x9e },
	'wb_rggblevelsunknown11' => { 11 => 0x77, 13 => 0xa3 },
	'wb_rggblevelsunknown12' => { 11 => 0x7c },
	'wb_rggblevelsunknown13' => { 11 => 0x81 },
	'wb_rggblevelsunknown14' => { 11 => 0x86 },
	'wb_rggblevelsunknown15' => { 11 => 0x8b },
	'wb_rggblevelsunknown16' => { 11 => 0x9f },
	'wb_rggblevelsunknown2' => { 11 => 0x4a, 13 => 0x76 },
	'wb_rggblevelsunknown3' => { 11 => 0x4f, 13 => 0x7b },
	'wb_rggblevelsunknown4' => { 11 => 0x54, 13 => 0x80 },
	'wb_rggblevelsunknown5' => { 11 => 0x59, 13 => 0x85 },
	'wb_rggblevelsunknown6' => { 11 => 0x5e, 13 => 0x8a },
	'wb_rggblevelsunknown7' => { 11 => 0x63, 13 => 0x8f },
	'wb_rggblevelsunknown8' => { 11 => 0x68, 13 => 0x94 },
	'wb_rggblevelsunknown9' => { 11 => 0x6d, 13 => 0x99 },
	'wbadjbluebalance' => { 134 => 0x8 },
	'wbadjcolortemp' => { 47 => 0x1a },
	'wbadjlighting' => { 134 => 0x15 },
	'wbadjmode' => { 134 => 0x10 },
	'wbadjredbalance' => { 134 => 0x0 },
	'wbadjrgblevels' => { 47 => 0x8 },
	'wbadjtemperature' => { 134 => 0x18 },
	'wbadjustab' => { 149 => 0x46 },
	'wbadjustgm' => { 149 => 0x47 },
	'wbbluelevel' => { 147 => 0x324, 149 => 0x8006, 150 => 0x26 },
	'wbbracketmode' => { 17 => 0x9 },
	'wbbracketvalueab' => { 17 => 0xc },
	'wbbracketvaluegm' => { 17 => 0xd },
	'wbfinetuneactive' => { 47 => 0x24 },
	'wbfinetunesaturation' => { 47 => 0x28 },
	'wbfinetunetone' => { 47 => 0x2c },
	'wbgreenlevel' => { 147 => 0x323, 149 => 0x8005, 150 => 0x25 },
	'wblevels' => { 97 => 0x4 },
	'wbmediaimagesizesetting' => { 30 => 0x708 },
	'wbmode' => { 96 => 0x4, 140 => 0x1015 },
	'wbredlevel' => { 147 => 0x322, 149 => 0x8004, 150 => 0x24 },
	'wbscale' => { 97 => 0x0 },
	'wbshiftab' => { 25 => 0xc, 156 => 0x10 },
	'wbshiftgm' => { 25 => 0xd },
	'wbshiftmg' => { 156 => 0x11 },
	'webstatement' => { 194 => 'WebStatement' },
	'whitebalance' => { 1 => [0x44,0x4a], 2 => 0x36, 3 => 0x5e, 4 => 0x36, 5 => 0x6f, 6 => 0x54, 25 => 0x8, 27 => 0x7, 49 => 0x7, 50 => [0x19,0x2012], 53 => [0xa403,0xfe4e], 57 => 0x1002, 65 => 0x40, 90 => 0x3, 91 => 0xe, 92 => 0x4, 93 => 0xb, 111 => 0x5, 121 => 0x7, 147 => 0x304, 149 => 0x3, 161 => 0x19, 163 => 0x7, 170 => 0x26, 173 => [0x3c,0x7], 181 => 'WhiteBalance', 184 => 'WhiteBalance' },
	'whitebalance2' => { 135 => 0x500 },
	'whitebalanceadj' => { 47 => 0x18, 129 => 0x76a43204 },
	'whitebalancebias' => { 50 => 0x2011, 140 => 0x304, 149 => 0x23 },
	'whitebalanceblue' => { 25 => 0x7 },
	'whitebalancebracket' => { 135 => 0x502, 140 => 0x303 },
	'whitebalancecomp' => { 143 => 0x1001 },
	'whitebalancefinetune' => { 57 => 0x100a, 111 => 0xb },
	'whitebalancemode' => { 161 => 0x1a },
	'whitebalancered' => { 25 => 0x6 },
	'whitebalancetemperature' => { 135 => 0x501 },
	'whiteboard' => { 140 => 0x301 },
	'whitepoint' => { 53 => 0x13e, 161 => 0x201, 188 => 'WhitePoint' },
	'widefocuszone' => { 90 => 0x2f },
	'widerange' => { 172 => 0x20f },
	'workcolorspace' => { 47 => 0x270 },
	'worldtimelocation' => { 149 => 0x3a, 161 => 0x22 },
	'writer-editor' => { 59 => 0x7a },
	'x3filllight' => { 173 => 0x12 },
	'xmp' => { 54 => 'XMP' },
	'xpauthor' => { 53 => 0x9c9d },
	'xpcomment' => { 53 => 0x9c9c },
	'xpkeywords' => { 53 => 0x9c9e },
	'xposition' => { 53 => 0x11e },
	'xpsubject' => { 53 => 0x9c9f },
	'xptitle' => { 53 => 0x9c9b },
	'xresolution' => { 53 => 0x11a, 62 => 0x3, 168 => 0x0, 188 => 'XResolution' },
	'xyresolution' => { 56 => 0x3 },
	'ycbcrcoefficients' => { 53 => 0x211, 188 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 53 => 0x213, 188 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 53 => 0x212, 188 => 'YCbCrSubSampling' },
	'yearcreated' => { 65 => 0x10, 72 => 0xc },
	'yposition' => { 53 => 0x11f },
	'yresolution' => { 53 => 0x11b, 62 => 0x5, 168 => 0x4, 188 => 'YResolution' },
	'zonematching' => { 94 => 0x10a, 96 => 0x3a, 174 => 0xb024 },
	'zonematchingon' => { 92 => 0x75 },
	'zoomsourcewidth' => { 8 => 0x24 },
	'zoomstepcount' => { 138 => 0x300, 140 => 0x100d },
	'zoomtargetwidth' => { 8 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshotneutral' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintsampledesc' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'keyword' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagelist' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrol' => 1,
	'picturecontrolversion' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	'svgversion' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trapped' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrpeak' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2008, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
