use strict;
use warnings;
use Test::More tests => 68;
use Digest::CubeHash qw(cubehash_384 cubehash_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::CubeHash->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            cubehash_384_hex($data), $digest,
            "cubehash_384_hex: $len bits of $msg"
        );
        ok(
            cubehash_384($data) eq pack('H*', $digest),
            "cubehash_384: $len bits of $msg"
        );
    }

    my $md = Digest::CubeHash->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|98AE93EBF4E58958497F610A22C8CF60F2292319283CA6459DAED1707BE06E7591C5F2D84BD3339E66C770E485BFA1FB
00|927FB6780023CAB5A8386215A6FBB90E98654C59C88188DB471CC93ECA0C9E2E7052058D58139D7C0464001E3F87C62C
C0|CCF3E51DD9B712D8EC9FBF8964602DECB91FAE6AC395D191761A6871C3A0B023CCBEA81A924C1677B6F542D731D67FA6
C0|44FC3F8E5E5E36E8225996345D99095EF0A07AE6243E692006DA97524BB91414BC7A24E7DF5C43013E68D22285243E89
80|4D0A6F675F4AAC7FB63826E8D28E343A6E80ED791DE1B66B3E4A05A4998E24EFCCDAD3A11BA16FF859F60245FF1937CA
48|9A82A35CEE4E5CA77A74F3560F278D49C0F24DD9912CCC958895A908FA7060F848F62001FD14E8050752C476416E0984
50|3E9D88C325F334CDBA98CC62F490155E3FFBDCF43FC4AB5804ED765762A8C9BE71D205C3ACC1362720063D10D3EA867B
98|6AC592200D8CF89C5A6ED0C5D591E8FEEF0E4D7CE2DC3F0DACDF8464FB68138CAA4D3CCBCFF1D7C6373CF9A92910110A
CC|5BFC77C26D6BEB90B40A48C9A9EB7652916A8EDB68AC368FF3E8C8B7F5AD7BA8FE15CA3874C4986CA8702C4AFFE5B18E
9800|DE5CCDD4E589FDB9E730BB5CB032C9B8BC5CC6DDB50893AAE5595E2EFB74B7FB9BFC5800DDCE0A3ED0D1B12326384D8F
9D40|5A219CBEAADB0972D1B0C098A8D4E0B0A75E38F5B650332A6BA82AF21E07C640A56A82B305650841B932B6119AA4A31E
AA80|87B958A99C6838A7DB1458C9070A2E46A9F0756706B0D8B4F3B0DAA680C2D8FBB8861D262E6A0334DC3E5DE545921575
9830|D61EEA4164B545A161B22D6205C068B9B8005C6B178FEE7CA9E35FAB5622A2BCDF28F03EF5917DFB6A5B9F7E46718DB6
5030|F705B9C4C0C959862D0BFDF4249F2B61EFE712A600E39160C33267A16C90D628B381B5BAC64E065CFD4FD777A09558F9
4D24|A49D6908E73E389370912268A5231E14687B18990D71FD8D73D8697FAD9B4612F42CC306361272E228689399D9A62898
CBDE|AD07FFA5BD60DC58C15F6F697DC8A68FEAB4973782DD62F8550100BE879CA4502451917C320A92EEDC42D898756035CE
41FB|D121BDA5A84F45D8E9724E5318C38D4D545BFC333242C4BF7FD68FCDEF14FBFEB1540FB7A7E12305DD9D413AF9F96543
4FF400|A31EBBC3E457DBC5530953A20F7FDD97F4873F8DE742ACD6E22DEFF35FBB5799192A7C6A95204E6AA5CEF137F4166F5D
FD0440|63BB32EAA9AE11C53630A76AC6DDBCD80CAA155E63F53875874CD2DE12D1C4B9D74FE6A7FBB99190C0B8879E50C7DAD0
424D00|CF65C1F8419E975DE70D5A4924D120FEC71D2E417F4ECA8E1D7465F82550E322B055ABD09DF967C37615DDA48F0FCF36
3FDEE0|D5BAB17D5A7BD311D43EAB25F33FC29F66664FE11406802AB740319CC1C836726EE233626D8DA0A429901039FC6FD16D
335768|43238CC39E6CD1C13A13715FFB3E5B2D0EFD750E1D1A3662CC029D7FAAD1678B988DA20483B4DCCB7941E90A19A8E5DB
051E7C|BD20053275A7913C19CB014C6F7982CB112BB9C7C22F8FE350D44429EF5BBCC3D52B03293F501D800C7EA748DE7BB4BC
717F8C|7ADDEA5FB91B0B5E44DE2B3279E4C523C3D8039C7EEEBAF1DBA91651B0FAA17DACC6D6B4B9343255661357FFDDC57F0A
1F877C|886FDF35651034CC0C669F45E29B806251B09AC80DB2F24CD104F6EDBC41E8E074BF66DF783B98908B285C2706C8D396
EB35CF80|731D5EC855ACB2FCBD048E89C8C3EB4E217A639AC062D0E032D824D41EBE989B56E78E8F6C065566A84E7FF37639FD34
B406C480|C254AC27CB130F540C93A4A48FD49F6D573F8565628F14EE3814D69191674A96552452AE388A8F2357DE2F3912E1C745
CEE88040|6CF6A7B4E3CA55837EFCDBF7E50BAB0F80371C2FBA2776AF098084BD450526CC9BA326AE9CF4D0C906B3AB6160683D6B
C584DB70|4F776D0E217912CDBD126FCF78A98CA8A4A8BEA2974EB8D6B43E7FE5E70F2E8F81ECFEE5C6A6E1A36E8AEC01E1E5EE8F
53587BC8|EC7FA32ADDA1551115FB293FEFFE41E32FFC8AB3A0886675082802B954501CD59E697545FE30906AF5EC6322B44A9B78
69A305B0|A863F5CA3B53803796743B744A4BBC85C9FEB1E11C8C2D8F6630D058A4254624393AB43AA4B5684F1B9B0C2CEC94195F
C9375ECE|C92930A3D8F21AF76C34B0E332CEE228CE879EA6106974EE4C8C96FC517279305158716298EA4369126CD8A74C6E9117
C1ECFDFC|EAEB9595A50C8572C0816A90DB27F8260EABB45BFBB8C2A971EA440145FFB94CEDABD333F01F2573093285FE3F45EED0
8D73E8A280|5946885313C6A659F16EDB2230B47AC222A36AE070F04D7E3DD14D94468E3E75218CF6035CE8F22B1DDA42304DA6FF4E
06F2522080|11A6FDFF04A0C05AB2CF72D6CD0E144D72816833049ECAE8476F9F705CFB9F2E9B00859B9B246B736A2B9B3874997154
3EF6C36F20|272C10A93EFC6116980DE81E76BC48964D6E54FE8E981A413245AA2D3933C692D6AC3252D5D7792EB3E7EA98A9B36A22
0127A1D340|DDD788097FF91D3DFC33DBEEB5CE6A2EC12FA1553647022779F689A6422676349F3C3FA985113990D7980956C52B0E6D
6A6AB6C210|28E4E7FDC27DEA0EF04B0C76EA023248CE9095154202132315A7310E742618BDCC2969FED938626921D673947EBEA5AB
AF3175E160|CFD6124323E25340F4099C7B78815E5B2DCD4F74E73D83E3C4CFDA45B009BAA8920AE63A54D63500E5CDD404E5BD538C
B66609ED86|2A7863D94ABD4E41A9BC884AA4AC2AEB52AACA46C0098957ED826600BD14360005A7EADDB49C6C6524B2FA1B1EB9C532
21F134AC57|D52ECF92DF6DE6DAED1E2ED0B10BD4CF035E8C88C658FE498FCF7AD19C1B9B61DA5C6E6A002812D6E6D7629A0D666CC5
3DC2AADFFC80|CA358A3096AE3190152703F4BCE1DDCBAD5386572BF0280CC27EC58D42D58F7B48808F21471B60CFA82FB4D81B81C91A
9202736D2240|76B326A85B48BA2028841B603E662071A5B76E303DAEE57B29AB42252121755B9C3770E8EF8FBDF3AF73E575C4C76D63
F219BD629820|7A967E0CAA4BA8DF2F6E2E733792BE6128F30845359C590ABB8EE04EBA6A2B66FB291CEACB924BF1FD298AC9248EFCE5
F3511EE2C4B0|314CFA0831857437C16D4A1BFDE28FC3945C0EA7B02A492C860D8A5A76BFEAD2695B360F01C25896D98096863CEB7F84
3ECAB6BF7720|8512B9FF00CB187DF4AE4745E8E3E26000C1C223A1015F455C1A5B62E0A75213EDC8218EA15B0E2059086D82B3AD4F5D
CD62F688F498|1CCC609F543B7D8438E6D430F88C511084EAFF61B6EC442A2208B9389D803306B71D81EDD4AE3D0AF32AA24F46B279CE
C2CBAA33A9F8|96BDEE9B5AF7068FB83DDD50E70CD1770963D23CA8D338908306C95FADC57C76ECA5430FC91EE3D6142C735BCF39FB1A
C6F50BB74E29|F473BC6067E7724D9290DAAA05D07ECDA6E06D5010B5E50F8867FBBA3677F58F22D79E1C9EF85DD47E26BA2C710CE3D8
79F1B4CCC62A00|AD8DA4262577583801C26B78EBBE2F46FF222C44C5684480338B18B837B5B4D0D480C8E28DFBBE72BEBBD1EBD31A1005
