use strict;
use warnings;
use Test::More tests => 19;
use Digest::ECHO qw(echo_256 echo_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::ECHO->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            echo_256_hex($data), $digest,
            "echo_256_hex: $len bits of $msg"
        );
        ok(
            echo_256($data) eq pack('H*', $digest),
            "echo_256: $len bits of $msg"
        );
    }
    else {
        TODO:
        eval {
            local $TODO = 'add_bits is not yet implemented';
            my $md = Digest::ECHO->new(256)->add_bits($data, $len)
                ->hexdigest;
            is($md, $digest, "new/add_bits/hexdigest: $msg");
        };
    }
}
continue { $len++ }

__DATA__
00|4496CD09D425999AEFA75189EE7FD3C97362AA9E4CA898328002D20A4B519788
00|FC0217F147CF4B18CDE2C81CADB972AF1FBE55DF5FF529583AA7880D2C181A60
C0|2D73F484CDA83CC97DC644320C38DE17A38FFA5C1614ECE6B1083B9E4C38A3D3
C0|5D1FA63D06F20F95D505FE76B01BEA6554A29429E4B1037C535BB9C78431880B
80|38705F964D4069671B2302078BF017952DA1B09E704ED726848AF98F906C654B
48|30B9878924A0D4D5F36FC373B565866C9F7C3EC1798A4E73C9A71D72EFCBF541
50|833F271C5CA9865BE4399C5BFD1A74D340E7032675E366B3602070140E996F31
98|3ECBF5BD5D5528FB42B77B7F44191CAA4B14E22F94ED61F9FC0449670AD35B34
CC|01C382B5B9D7D10EC36C98785C27EACCFB2F772A7E58B6B97BF62212B8584AE5
9800|20EB7B192E3A53765BF324A38133C593195E0FDA204DB156CB665D7FC750898B
9D40|869D7F3B2382B07629A28396EB6D20713AC213726C8C220D37F7B7BCE43C7C54
AA80|D3A3101E0451507A47A8B93B2437BFA05ADC6E0FE5C9774FAC34E5C865E6CA9C
9830|15527EA5C94875738D3BB83E77B6D2FBA1AA6D360E5C4BDAFC8BFD28507B8133
5030|7F585C0DB32915598B1782C789357B2A5534E5B0B8B1AB68AFF9A24F3875F321
4D24|5D767497E725ABEAEB3043109B6FE5550A174915CEB450D2C0C4BEC339EE5346
CBDE|39B19E74CA5A41BB5C6AC56950656A3D8F549FC68CDD238551A7444B509FB97C
41FB|83FCAA405DA0C6AAD4F690FC4D294D502227B60B9A90A1613ADB7CD241D23997
4FF400|42247885DD00028AF3A14C7FF68B73AE29DA6A230FA185A9247D5BF13728DEA1
FD0440|D7E316C2F5123461C2CA7CE28BB5192CE63534D16826BED4F1537A7A6818109E
424D00|DA1813D0CC09210975801913404C00969D0D4A2DECE9475E4D1226C4A39ABD1B
3FDEE0|679C279A4E026FCE20C1D9BC712D6CC3CEC3656AD70FA0B94BB487AEB748BCB6
335768|CD64D68417D602D0B5A17B551A1BA0EBA155F7EC81D1DAD3DF5CA638A5FEFD1F
051E7C|CA8239AF44CD6EA4A5C64B065DE4C3E4D8BA6BD71ED471C283E11EEB94020201
717F8C|247A88BBC5E71D578242D71750E6DAD5BE155F274621D68F2837B01E6F58FAE0
1F877C|E8CA26C44E8EFBA4F0392B9691853BAAF79C6FFE567E6232520A053310D10888
EB35CF80|51052875D802BC7183BB7411605C32C8787A697F77FC1D63495437FBFE6B7DB9
B406C480|83FF64509134F797F886656781B63C11AF0453259189DC6D0203BB59CE29838B
CEE88040|51AB7F29D89EE316F2DCC283C04CF5D9DEE1D04C1547E412DA1ED92EE72C94F0
C584DB70|AEA5278E4A2010BF64BC1EE4528419C0922C6D9C9F0C7CD6EDE8F83ED835181B
53587BC8|6D6D3AC1FF84E33B064427D936325CCF012ED6E9F9BFDAEFB2295F9379296415
69A305B0|0376E3A453A40E1855617D0F5D51605E3C61EF219D962BAF6DE3439C8A678752
C9375ECE|A045297C80A3CEEE68B27393C4CC1AFE9D58223F52A40F5892F2878445B9D705
C1ECFDFC|E28DED239A401DA2D36227A6134EACE7CA61B775EA45AF853332018CD2903FC9
8D73E8A280|3CE549C1CCE6BB0666317C2DA490E7F61E6F1E9D03C7EA4DF518B704D262CB91
06F2522080|6DAFF9F1A8A621F146F066F70BE7F717FF802CC5ACBB12CB1D008764FE7051B6
3EF6C36F20|855EA61FC0C5021005ABE7A7ABF21D385A43578BA3918352B2C28418BF80CDCE
0127A1D340|FFD5385A66DDC6FDA026BB091A033F9D24037B3283F09C0009038F48E0F32467
6A6AB6C210|493854BE797A1DE21D1EFFB11A97B042B9F08A01814725D0C6CDB9FDF0A1090B
AF3175E160|E768C41FA8673B72A1EDACF3CA29C317F398ACC82C49232840AA3930328983E0
B66609ED86|CAD21C8E8DF0153BFE720FD86EB0D550B46494C434384ECB4268EC2C61EEF999
21F134AC57|8C5C206A91BAC18A7F518F37A7E39D2711497DB5D528948A7362A0B46038439C
3DC2AADFFC80|D479A64DF157369AF14C1835423435A5748E6329D502FAD2AE8ED35A42774608
9202736D2240|E246285B9BE4F54A419B4597D294D8E0A85C1AC2384278D2EB7D2C4899ED67DB
F219BD629820|39109B8E15FFE0B50EB18C6854D5E72DDF16A182BD013A617050E69D5F9EAFC5
F3511EE2C4B0|756CB9ED7E349FFDEADD4CA2740A683224F7699C38DEF370B995684A48F92FAB
3ECAB6BF7720|BD66A5234CC3DA875BA24DA816056A85BD4247FCE207A8F52F1189227F51B645
CD62F688F498|8C93B08F44438F693163F76871E6AAD318B2AE3182443DF2074B6A07E525E5B0
C2CBAA33A9F8|1DB4667E23ADC638F6F9574C78220694DF17A387B394B7FEF23ADE1824885189
C6F50BB74E29|2687958C4938E524A0021D5045BD05B90B26A3F7201A02CB04525F91C4979985
79F1B4CCC62A00|F0242418396718F1AEEFB87832B867D73B765AA05F05D3E045B7E89AE4B2ABEB
