'\"
.so man.macros
.TH HList n 4.0 Tk "Tk Generic Methods"
.BS
.SH NAME
HList \- Create and manipulate Tix Hierarchial List widgets
.SH SYNOPSIS
\fI$hlist\fR = \fI$parent\fR->\fBHList\fR(\fR?\fIoptions\fR?\fR);
.SH "STANDARD OPTIONS"
'
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBforeground\fR
\fBfont\fR	\fBheight\fR	\fBhighlightColor\fR \fBhighlightThickness\fR	
\fBrelief\fR	\fBselectBackground\fR	\fBselectForeground\fR
\fBxScrollCommand\fR	\fByScrollCommand\fR	\fBwidth\fR
.ta 4c 
.fi
.LP
See the ``options'' manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBbrowsecmd\fR
Class:		\fBBrowseCmd\fR
Switch:		\fB\-browsecmd\fR
.fi
.IP
Specifies a TCL command to be executed when the user browses through the
entries in the HList widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBcolumns\fR
Class:		\fBColumns\fR
Switch:		\fB\-columns\fR
.fi
.IP
Specifies the number of columns in this HList widget. This option can
only be set during the creation of the HList widget and cannot be
changed subsequently.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the TCL command to be executed when the user invokes a list
entry in the HList widget. Normally the user invokes a list
entry by double-clicking it or pressing the Return key.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdrawBranch\fR
Class:		\fBDrawBranch\fR
Switch:		\fB\-drawbranch\fR
.fi
.IP
A Boolean value to specify whether branch line should be drawn to
connect list entries to their parents.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBforeground\fR
Class:		\fBForeground\fR
Switch:		\fB\-foreground\fR
Alias:		\fB\-fg\fR
.fi
.IP
\fB[OBSOLETE]\fR Specifies the default foreground color for the list entries.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBgap\fR
Class:		\fBGap\fR
Switch:		\fB\-gap\fR
.fi
.IP
\fB[OBSOLETE]\fR The default distance between the bitmap/image and the
text in list entries.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window in characters.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBindent\fR
Class:		\fBIndent\fR
Switch:		\fB\-indent\fR
.fi
.IP
Specifies the amount of horizontal indentation between a list entry
and its children. Must be a valid screen distance value.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBitemType\fR
Class:		\fBItemType\fR
Switch:		\fB\-itemtype\fR
.fi
.IP
Specifies the default type of display item for this HList widget. When
you call the add and addchild methods, display items of this
type will be created if the \fB\-itemtype\fR option is not specified .
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpadX\fR
Class:		\fBPad\fR
Switch:		\fB\-padx\fR
.fi
.IP
\fB[OBSOLETE]\fR The default horizontal padding for list entries.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpadY\fR
Class:		\fBPad\fR
Switch:		\fB\-padx\fR
.fi
.IP
\fB[OBSOLETE]\fR The default vertical padding for list entries.
'----------END
'----------BEGIN
.LP
.nf
Name:		\fBselectBackground\fR
Class:		\fBSelectBackground\fR
Switch:		\fB\-selectbackground\fR
.fi
.IP
Specifies the background color for the selected list entries.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBselectBorderWidth\fR
Class:		\fBBorderWidth\fR
Switch:		\fB\-selectborderwidth\fR
.fi
.IP
Specifies a non-negative value indicating the width of the 3-D border
to draw around selected items.  The value may have any of the forms
acceptable to \fBTk_GetPixels\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBselectForeground\fR
Class:		\fBSelectForeground\fR
Switch:		\fB\-selectforeground\fR
.fi
.IP
Specifies the foreground color for the selected list entries.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBselectMode\fR
Class:		\fBSelectMode\fR
Switch:		\fB\-selectmode\fR
.fi
.IP
Specifies one of several styles for manipulating the selection.  The
value of the option may be arbitrary, but the default bindings expect
it to be either \fBsingle\fR, \fBbrowse\fR, \fBmultiple\fR, or
\fBextended\fR; the default value is \fBsingle\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBsizeCmd\fR
Class:		\fBSizeCmd\fR
Switch:		\fB\-sizecmd\fR
.fi
.IP
Specifies a TCL script to be called whenever the tixHList widget
changes its size. This command can be useful to implement "user scroll
bars when needed" features.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBseparator\fR
Class:		\fBSeparator\fR
Switch:		\fB\-separator\fR
.fi
.IP
Specifies the character to used as the separator character when
intepreting the path-names of list entries. By default the character
"." is used.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB\-width\fR
.fi
.IP
Specifies the desired width for the window in characters.
'----------END
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixHList\fR command creates a new window (given by the
$widget\fR argument) and makes it into a HList widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
HList widget such as its cursor and relief.
.PP
The HList widget can be used to display any data that have a
hierarchical structure, for example, file system directory trees. The
list entries are indented and connected by branch lines according to
their places in the hierachy.
.PP
Each list entry is identified by a \fBentryPath\fR. The entryPath is a
sequence of \fBentry names\fR separated by the separator charactor
(specified by the \fB\-separator\fR option). An \fBentry name\fR can be
any string that does not contain the separator charactor, or it can be
the a string that contains only one separator charactor.
.PP
For example, when "." is used as the separator charactor,
"one.two.three" is the entryPath for a list entry whose parent is
"one.two", whose parent is "one", which is a toplevel entry (has no
parents).
.PP
Another examples: ".two.three" is the entryPath for a list entry whose
parent is ".two", whose parent is ".", which is a toplevel entry.
'
.SH "DISPLAY ITEMS"
.PP
Each list entry in an HList widget is associated with a \fBdisplay
item\fR.  The display item determines what visual information should
be displayed for this list entry. Please see the \fBDItem(n)\fR manual
page for a list of all display items.

When a list entry is created by the \fBadd\fR or \fBaddchild\fR widget
commands, the type of its display item is determined by the
\fB\-itemtype\fR option passed to these commands. If the
\fB\-itemtype\fR is omitted, then by default the display item type
\fBtext\fR is used.
'----------------------------------------------------------------------
.SH "WIDGET METHODS"
.PP
'
The \fBtixHList\fR command creates a widget object whose name is the
same as the path name of the HList widget's window.  This command
may be used to invoke various operations on the widget.  It has the
following general form:
'
.DS C
'
\fI$hlist\fR->\fBmethod\fR(?\fIarg arg ...\fR?)
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as
the HList widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for HList widgets:
'
.TP
\fI$hlist->\fBadd\fR(\fIentryPath, \fR?\fIoption, value, ...\fR?\fR)
'
Creates a new list entry with the pathname \fIentryPath\fR. A list
entry must be created after its parent is created (unless this entry
is a top-level entry, which has no parent). This command returns the
entryPath of the newly created list entry. The following
configuration options can be given to configure the list entry:
'
.RS
'
.TP
\fB\-at\fI position\fR
'
Insert the new list at the position given by \fIposition\fR.
\fIposition\fR must be a valid integer. the Position \fB0\fR indicates
the first position, \fB1\fR indicates the second position, and so on.
'
.TP
\fB\-after\fI afterWhich\fR
'
Insert the new list entry after the entry identified by
\fIafterWhich\fR. \fIafterWhich\fR must be a valid list entry and it
mush have the same parent as the new list entry
'
.TP
\fB\-before\fI beforeWhich\fR
'
Insert the new list entry before the entry identified by
\fIbeforeWhich\fR. \fIbeforeWhich\fR must be a valid list entry and it
mush have the same parent as the new list entry
'
.TP
\fB\-data\fI string\fR
'
Specifies a string to associate with this list entry. This string can
be queried by the \fBinfo\fR method. The application
programmer can use the \fB\-data\fR option to associate the list entry
with the data it represents.
'
.TP
\fB\-itemtype\fI type\fR
'
Specifies the type of display item to be display for the new list
entry. \fBtype\fR must be a valid display item type. Currently the
available display item types are \fBimagetext\fR, \fBtext\fR, and
\bwindow\fR. If this option is not specified, then by default the
display item type specified by the \fB\-itemtype\fR widget option is
created.
'
.TP
\fB\-state\fR
'
Specifies whether this entry can be selected or invoked by the user.
Must be either \fBnormal\fR or \fBdisabled\fR.
'
.RE
'
The \fBadd\fR method accepts additional configuration options
to configure the display item associated with this list entry. The set
of additional configuration options depends on the type of the display
item given by the \fB\-itemtype\fR option. Please see the
\fBDItem(n)\fR manual page for a list of the configuration options for
each of the display item types.
'
.TP
\fI$hlist->\fBaddchild\fR(\fIparentPath, \fR?\fIoption, value, ..., \fR?\fR)
'
Adds a new child entry to the children list of the list entry
identified by \fIparentPath\fR. Or, if \fIparentPath\fR is set to be
the empty string, then creates a new toplevel entry. The name of the
new list entry will be a unique name automatically generated by the
HList widget. Usually if \fIparentPath\fR is \fBfoo\fR, then the
entryPath of the new entry will be \fBfoo.1\fR, \fBfoo.2\fR, ... etc.
This command returns the entryPath of the newly created list entry.
\fIoption\fR can be any option for the \fBadd\fR method.
'
.TP
\fI$hlist->\fBanchorSet\fR(\fIentryPath\fR)
'
Sets the anchor to the list entry identified by
\fIentryPath\fR.  The anchor is the end of the selection
that is fixed while dragging out a selection with the mouse.
'
.TP
\fI$hlist->\fBanchorClear\fR
'
Remove the anchor, if any, from the this tixHList widget. This only
removes the surrounding highlights of the anchor entry and does not
affect its selection status.
'
.TP
\fI$hlist->\fBcget\fR(\fIoption\fR)
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixHList\fR command.
'
.TP
'
\fI$hlist->\fBcolumn\fR(\fIcol, \fR?\fR)\fI\-char\fR? ?\fIwidth\fR? 
'
Querys or sets the width of a the column \fIcol\fR in the HList
widget. The value of \fIcol\fR is zero-based: 0 stands for the first
column, 1 stands for the second, and so on. If no further parameters
are given, returns the current width of this column (in number of
pixels). Additional parameters can be given to set the width of this
column:
.PP
.RS
.TP
\fI$hlist->\fBcolumn\fR(\fIcol\fR)\fB{}\fR
'
An empty string indicates that the width of the column should be just
wide enough to display the widest element in this column. In this
case, the width of this column may change as a result of the elements
in this column changing their sizes.
'
.TP
\fI$hlist->\fBcolumn\fR(\fIcol, \fR\fIwidth\fR)
'
\fIwidth\fR must be in a form accepted by \fBTk_GetPixels(3)\fR.
'
.TP
\fI$hlist->\fBcolumn\fR(\fIcol, \fR\fB-char, \fR\fInChars\fR)
'
The width is set to be the average width occupied by \fInChars\fR
number of characters of the font specified by the \fB\-font\fR option
of this HList widget.
'
.RE
.TP
'
\fI$hlist->\fBconfigure\fR(?\fIoption\fR?, \fI?value, option, value, ...\fR?\fR)
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for $widget\fR (see \fBconfigure\fR for
information on the format of this list). If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixHList\fR command.
'
.TP
\fI$hlist->\fBdelete\fR(\fIoption, \fR\fIentryPath\fR)
Delete one or more list entries. \fIoption\fR may be one of the
following:
.RS
.TP
\fBall\fR
Delete all entries in the tixHList. In this case the \fIentryPath\fR
does not need to be specified.
'
.TP
\fBentry\fR
Delete the entry specified by \fIentryPath\fR. and all its offsprings,
if any.
'
.TP
\fBoffsprings\fR
Delete all the offsprings, if any, of the entry specified by
\fIentryPath\fR. However, \fIentryPath\fR itself is not deleted.
'
.TP
\fBsiblings\fR
Delete all the list entries that share the same parent with the entry
specified by \fIentryPath\fR. However, \fIentryPath\fR itself is not
deleted.
.RE
'
'
.TP
\fI$hlist->\fBdragsiteSet\fR(\fIentryPath\fR)
'
Sets the dragsite to the list entry identified by
\fIentryPath\fR. The dragsite is used to indicate the source of a
grag-and-drop action. Currently drag-and-drop functionality has not
been implemented in Tix yet.
'
.TP
\fI$hlist->\fBdragsiteClear\fR
Remove the dragsite, if any, from the this tixHList widget. This only
removes the surrounding highlights of the dragsite entry and does not
affect its selection status.
'
'
.TP
\fI$hlist->\fBdropsiteSet\fR(\fIentryPath\fR)
'
Sets the dropsite to the list entry identified by
\fIentryPath\fR. The dropsite is used to indicate the target of a
grag-and-drop action. Currently drag-and-drop functionality has not
been implemented in Tix yet.
'
.TP
\fI$hlist->\fBdropsiteClear\fR
'
Remove the dropsite, if any, from the this tixHList widget. This only
removes the surrounding highlights of the dropsite entry and does not
affect its selection status.
'
.TP
\fI$hlist->\fBentrycget\fR(\fIentryPath, option\fR)
'
Returns the current value of the configuration option given by
\fIoption\fR for the entry indentfied by \fIentryPath\fR. \fIOption\fR
may have any of the values accepted by the \fBtixHList add\fR
command.
'
.TP
\fI$hlist->\fBentryconfigure\fR(\fIentryPath, \fR?\fIoption\fR?, \fI?value, option, value, ...\fR?\fR)
'
Query or modify the configuration options of the list entry indentfied
by \fIentryPath\fR. If no \fIoption\fR is specified, returns a list
describing all of the available options for \fIentryPath\fR (see
\fBTk_ConfigureInfo\fR for information on the format of this list). If
\fIoption\fR is specified with no \fIvalue\fR, then the command
returns a list describing the one named option (this list will be
identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified). If one or more \fIoption\-value\fR pairs
are specified, then the command modifies the given option(s) to have
the given value(s); in this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBadd\fR or
\fBaddchild\fR method. The exact set of options depends on the
value of the \fB\-itemtype\fR option passed to the the \fBadd\fR or
\fBaddchild\fR method when this list entry is created.
'
.TP
\fI$hlist->\fBhide\fR(\fIoption, ?entryPath?\fR)
'
Makes some of entries invisible invisible without deleting them.
\fIoption\fR can be one of the following:
.RS
.TP
\fBentry\fR
Hides the list entry identified by \fIentryPath\fR.
.PP
Currently only the \fBentry\fR option is supported. Other options will
be added in the next release.
.RE
'
.TP
\fI$hlist->\fBinfo\fR(\fIoption, \fR\fIarg, ...\fR)
Query information about the tixHList widget. \fIoption\fR can be one
of the following:
.RS
.TP
\fI$hlist->\fBinfo\fR(\fBanchor, \fR\fIentryPath\fR)
Returns the entryPath of the current anchor, if any, of the HList
widget. If the anchor is not set, returns the empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBchildren, \fR?\fIentryPath\fR?\fR)
If \fIentrpyPath\fR is given, returns a list of the entryPath's of its
children entries. Otherwise returns a list of the toplevel
entryPath's.
'
.TP
\fI$hlist->\fBinfo\fR(\fBdragsite, \fR\fIentryPath\fR)
Returns the entryPath of the current dragsite, if any, of the HList
widget. If the dragsite is not set, returns the empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBdropsite, \fR\fIentryPath\fR)
Returns the entryPath of the current dropsite, if any, of the HList
widget. If the dropsite is not set, returns the empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBexists, \fR\fIentryPath\fR)
Returns a boolean value indicating whether the list entry
\fBentrpyPath\fR exists.
'
.TP
\fI$hlist->\fBinfo\fR(\fBhidden, \fR\fIentryPath\fR)
'
Returns a boolean value indicating whether the list entry
\fBentrpyPath\fR is hidden or not.
'
.TP
\fI$hlist->\fBinfo\fR(\fBnext, \fR\fIentryPath\fR)
Returns the entryPath of the list entry, if any, immediately below
this list entry. If this entry is already at the bottom of the HList
widget, returns an empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBparent, \fR\fIentryPath\fR)
Returns the name of the parent of the list entry indified by
\fBentrpyPath\fR. If \fBentrpyPath\fR is a toplevel list entry,
returns the empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBprev, \fR\fIentryPath\fR)
'
Returns the entryPath of the list entry, if any, immediately above
this list entry. If this entry is already at the top of the HList
widget, returns an empty string.
'
.TP
\fI$hlist->\fBinfo\fR(\fBselection\fR)
'
Returns a list of selected elements in the HList widget. If no entries
are selectd, returns an empty string.
.RE
'
'
.TP
\fI$hlist->\fBitem\fR(\fIoption, \fR?\fIargs, ...\fR?\fR)
'
Creates and configures the display items at individual columns the
entries. The form of additional of arguments depends on the choice of
\fIoption\fR:
'
.RS
'
.TP
\fI$hlist->\fBitem\fR(\fIcget, entryPath, col, option\fR)
'
'
Returns the current value of the configure \fIoption\fR of the display
item at the column designated by \fIcol\fR of the entry specified by
\fIentryPath\fR.
'
.TP
\fI$hlist->\fBitem\fR(\fIconfigure, entryPath, col, \fR?\fIoption\fR?, \fI?value, option, value, ...\fR?\fR)
'
Query or modify the configuration options of the display item at the
column designated by \fIcol\fR of the entry specified by
\fIentryPath\fR. If no \fIoption\fR is specified, returns a list
describing all of the available options for \fIentryPath\fR (see
\fBTk_ConfigureInfo(3)\fR for information on the format of this
list). If \fIoption\fR is specified with no \fIvalue\fR, then the
command returns a list describing the one named option (this list will
be identical to the corresponding sublist of the value returned if no
\fIoption\fR is specified). If one or more \fIoption\-value\fR pairs
are specified, then the command modifies the given option(s) to have
the given value(s); in this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBitem
create\fR method. The exact set of options depends on the
value of the \fB\-itemtype\fR option passed to the the \fBitem
create\fR method when this display item entry was created.
'
.TP
\fI$hlist->\fBitem\fR(\fIcreate, entryPath, col, \fR?\fR)\fI\-itemtype type\fR? ?\fIoption value ...\fR?
'
'
Creates a new display item at the column designated by \fIcol\fR of
the entry specified by \fIentryPath\fR. An optional parameter
\fI\-itemtype\fR can be used to specify what type of display items
should be created. By default a \fBimagetext\fR display item is
created. Additional parameters, in \fIoption-value\fR pairs, can be
passed to configure the appearance of the display item. Each \fIoption-
value\fR pair must be a valid option for this type of display item.
'
.TP
\fI$hlist->\fBitem\fR(\fIdelete, entryPath, col\fR)
'
Deletes the display item at the column designated by \fIcol\fR of
the entry specified by \fIentryPath\fR.
'
.RE
'
.TP
\fI$hlist->\fBnearest\fR(\fIy\fR)
Given a y-coordinate within the tixHList window, this command returns
the entryPath of the (visible) tixHList element nearest to that
y-coordinate.
'
'
.TP
\fI$hlist->\fBsee\fR(\fIentryPath\fR)
Adjust the view in the tixHList so that the element given by index is
visible. If the element is already visible then the command has no
effect; if the element is near one edge of the window then the tixHList
scrolls to bring the element into view at the edge; otherwise the
tixHList scrolls to center the element.
'
.TP
\fI$hlist->\fBselection\fR(\fIoption, \fR\fIarg, ...\fR)
This command is used to adjust the selection within a tixHList widget. It
has several forms, depending on \fIoption\fR:
.RS
'
.TP
\fI$hlist->\fBselectionClear\fR(?\fIfrom\fR?, ?\fIto\fR?\fR)
When no extra arguments are given, deselects all of the list entrie(s)
in this tixHList widget. When only \fIfrom\fR is given, only the list
entry identified by \fIfrom\fR is deselected. When both \fIfrom\fR and
\fIto\fR are given, deselects all of the list entrie(s) between
between \fIfrom\fR and \fIto\fR, inclusive, without affecting the
selection state of elements outside that range.
'
.TP
\fI$hlist->\fBselectionIncludes\fR(\fIentryPath\fR)
Returns 1 if the list entry indicated by \fIentryPath\fR is currently
selected, 0 if it isn't.
'
.TP
\fI$hlist->\fBselectionSet\fR(\fIfrom, \fR?\fIto\fR?\fR)
Selects all of the list entrie(s) between between \fIfrom\fR and
\fIto\fR, inclusive, without affecting the selection state of elements
outside that range. When only \fIfrom\fR is given, only the list entry
identified by \fIfrom\fR is selected.
.RE
'
.TP
\fI$hlist->\fBshow\fR(\fIoption, ?entryPath?\fR)
'
Show the entries that are hidden by the \fBhide\fR command,
\fIoption\fR can be one of the following:
.RS
.TP
\fBentry\fR
Shows the list entry identified by \fIentryPath\fR.
.PP
Currently only the \fBentry\fR option is supported. Other options will
be added in the next release.
.RE
'
.TP
\fI$hlist->\fBxview\fR(\fIargs\fR)
This command is used to query and change the horizontal position of the
information in the widget's window. It can take any of the following
forms:
.RS
.TP
\fI$hlist->\fBxview\fR
'
Returns a list containing two elements.  Each element is a real
fraction between 0 and 1; together they describe the horizontal span
that is visible in the window.  For example, if the first element
is .2 and the second element is .6, 20% of the HList text is
off-screen to the left, the middle 40% is visible in the window, and
40% of the text is off-screen to the right.  These are the same values
passed to scrollbars via the \fB\-xscrollcommand\fR option.
.TP
\fI$hlist->\fBxview\fR(\fIentryPath\fR)
'
Adjusts the view in the window so that the list entry identified by
\fIentryPath\fR is aligned to the left edge of the window.
.TP
\fI$hlist->\fBxview\fR(\fBmoveto\fR => \fIfraction\fR)
'
Adjusts the view in the window so that \fIfraction\fR of the total
width of the HList is off-screen to the left. \fIfraction\fR must be
a fraction between 0 and 1.
'
.TP
\fI$hlist->\fBxview\fR(\fBscroll\fR => \fInumber, what\fR)
'
This command shifts the view in the window left or right according to
\fInumber\fR and \fIwhat\fR. \fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR or an
abbreviation of one of these. If \fIwhat\fR is \fBunits\fR, the view
adjusts left or right by \fInumber\fR character units (the width of
the \fB0\fR character) on the display; if it is \fBpages\fR then the
view adjusts by \fInumber\fR screenfuls. If \fInumber\fR is negative
then characters farther to the left become visible; if it is positive
then characters farther to the right become visible.
'
.RE
'
.TP
\fI$hlist->\fByview\fR(\fI?args\fR?\fR)
'
This command is used to query and change the vertical position of the
text in the widget's window.
It can take any of the following forms:
.RS
.TP
\fI$hlist->\fByview\fR
'
Returns a list containing two elements, both of which are real
fractions between 0 and 1.  The first element gives the position of
the list element at the top of the window, relative to the HList
as a whole (0.5 means it is halfway through the HList, for example).
The second element gives the position of the list entry just
after the last one in the window, relative to the HList as a whole.
These are the same values passed to scrollbars via the
\fB\-yscrollcommand\fR option.
.TP
\fI$hlist->\fByview\fR(\fIentryPath\fR)
'
Adjusts the view in the window so that the list entry given by
\fIentryPath\fR is displayed at the top of the window.
.TP
\fI$hlist->\fByview\fR(\fBmoveto\fR => \fIfraction\fR)
'
Adjusts the view in the window so that the list entry given by
\fIfraction\fR appears at the top of the window. \fIFraction\fR is a
fraction between 0 and 1; 0 indicates the first element in the
HList, 0.33 indicates the element one-third the way through the
HList, and so on.
.TP
\fI$hlist->\fByview\fR(\fBscroll\fR => \fInumber, what\fR)
'
This command adjust the view in the window up or down according to
\fInumber\fR and \fIwhat\fR.  \fINumber\fR must be an integer.
\fIWhat\fR must be either \fBunits\fR or \fBpages\fR.  If \fIwhat\fR
is \fBunits\fR, the view adjusts up or down by \fInumber\fR lines; if
it is \fBpages\fR then the view adjusts by \fInumber\fR screenfuls.
If \fInumber\fR is negative then earlier elements become visible; if
it is positive then later elements become visible.
.RE
'
'----------------------------------------------------------------------
.SH BINDINGS
.PP
.IP [1]
If the \fB\-selectmode\fR is "browse", when the user drags the mouse
pointer over the list entries, the entry under the pointer will be
highlighted and the \fB\-browsecmd\fR procedure will be called with
one parameter, the entryPath of the highlighted entry. Only one entry
can be highlighted at a time.  The \fB\-command\fR procedure will be
called when the user double-clicks on a list entry.
'
.IP [2]
If the \fB\-selectmode\fR is "single", the entries will only be
highlighted by mouse <ButtonRelease-1> events. When a new list entry
is highlighted, the \fB\-browsecmd\fR procedure will be called with
one parameter indicating the highlighted list entry. The
\fB\-command\fR procedure will be called when the user double-clicks
on a list entry.
'
'
.IP [3]
If the \fB\-selectmode\fR is "multiple", when the user drags the mouse
pointer over the list entries, all the entries under the pointer will
be highlighted. However, only a contiguous region of list entries can
be selected. When the highlighted area is changed, the
\fB\-browsecmd\fR procedure will be called with an undefined
parameter. It is the responsibility of the \fB\-browsecmd\fR procedure
to find out the exact highlighted selection in the HList.
'
.IP [4]
'
If the \fB\-selectmode\fR is "extended", when the user drags the mouse
pointer over the list entries, all the entries under the pointer will
be highlighted. The user can also make disjointed selections using
<Control-ButtonPress-1>. When the highlighted area is changed, the
\fB\-browsecmd\fR procedure will be called with an undefined
parameter. It is the responsibility of the \fB\-browsecmd\fR procedure
to find out the exact highlighted selection in the HList.
'
.IP [5]
\fBArrow key bindings:\fR <Up> arrow key moves the anchor point to the
item right on top of the current anchor item. <Down> arrow key moves
the anchor point to the item right below the current anchor item.
<Left> arrow key moves the anchor to the parent item of the current
anchor item. <Right> moves the anchor to the first child of the
current anchor item. If the current anchor item does not have any
children, moves the anchor to the item right below the current anchor
item.
'----------------------------------------------------------------------
.SH EXAMPLE
.PP
This example demonstrates how to use an HList to store a file
directory structure and respond to the user's browse events:
.PP
.nf
 tixHList .h -separator "/" \-browsecmd browse \-selectmode single
 .h add /         \-text /
 .h add /home     \-text /home
 .h add /home/ioi \-text /home/ioi
 .h add /home/foo \-text /home/foo
 .h add /usr      \-text /usr
 .h add /usr/lib  \-text /usr/lib
 pack .h

 proc browse {file} {
     puts "$file browsed"
 }
.fi
'
'
.SH BUGS
'
The fact that the display item at column 0 is implicitly associated
with the whole entry is probably a design bug. This was done for
backward compatibility purposes. The result is that there is a large
overlap between the \fBitem\fR command and the \fBadd\fR,
\fBaddchild\fR, \fBentrycget\fR and \fBentryconfigure\fR
commands. Whenever multiple columns exist, the programmer should use
ONLY the \fBitem\fR command to create and configure the display items
in each column; the \fBadd\fR, \fBaddchild\fR, \fBentrycget\fR and
\fBentryconfigure\fR should be used ONLY to create and configure
entries.
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n), hierarchical listbox
