'\"
'\" Copyright (c) 1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) grid.n 1.3 96/01/30 18:25:56
'\" 
.so man.macros
.TH grid n 4.1 Tk "Tk Geometry Management"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
grid \- Geometry manager that arranges widgets in a grid
.SH SYNOPSIS
\fI$widget\fR->\fBgrid\fR?(\fIarg ...\fR)?
.br
\fI$widget\fR->\fBgrid\fIOption\fR?(\fIarg ...\fR)?
.BE

.SH DESCRIPTION
.PP
The \fBgrid\fR command is used to communicate with the grid
geometry manager that arranges widgets in rows and columns inside
of another window, called the geometry master (or master window).
The \fBgrid\fR command can have any of several forms, depending
on the \fIOption\fR argument:
.TP
\fI$master\fR->\fBgridBbox\fR(\fIcolumn,row\fR)
The bounding box (in pixels) is returned for the space occupied by
the grid position indicated by \fIcolumn\fP and \fIrow\fP.  The
return value consists of 4 integers.  The first two are the pixel offset
from the master window (x then y) of the top-left corner of the grid
cell, and the second two are the width and height of the cell.
.TP
\fI$master\fR->\fBgridColumnconfigure\fR(index\fR?,\fI\-option\fR=>\fIvalue...\fR?)
Query or set the column properties of the \fIindex\fP column of the 
geometry master, \fImaster\fP.
The valid options are \fB\-minsize\fP and \fB\-weight\fP.
The \fB\-minsize\fP option sets the minimum column size, in pixels,
and the \fB\-weight\fP option (a floating point value)
sets the relative weight for apportioning
any extra spaces among
columns.  If no value is specified, the current value is returned.
.TP
\fI$slave\fR->\fBgrid\fR?(?\fIslave ...\fR?,?\fIoptions\fR)?
The arguments consist of the names of additional slave windows
followed by pairs of arguments that specify how
to manage the slaves.
The characters \fB\-\fP,  \fBx\fP and \fB^\fP, 
can be specified instead of a window name to alter the default
location of a \fIslave\fP, as described in the ``RELATIVE PLACEMENT''
section, below.
The following options are supported:
.RS
.TP
\fB\-column\fR => \fIn\fR
Insert the slave so that it occupies the \fIn\fPth column in the grid.
Column numbers start with 0.  If this option is not supplied, then the
slave is arranged just to the right of previous slave specified on this
call to \fIgrid\fP, or column "0" if it is the first slave.  For each
\fBx\fP that immediately precedes the \fIslave\fP, the column position
is incremented by one.  Thus the \fBx\fP represents a blank column
for this row in the grid.
.TP
\fB\-columnspan\fR => \fIn\fR
Insert the slave so that it occupies \fIn\fP columns in the grid.
The default is one column, unless the window name is followed by a
\fB\-\fP, in which case the columnspan is incremented once for each immediately
following \fB\-\fP.
.TP
\fB\-in\fR => \fIother\fR
Insert the slave(s) in the master
window given by \fIother\fR.  The default is the first slave's
parent window.
.TP
\fB\-ipadx\fR => \fIamount\fR
The \fIamount\fR specifies how much horizontal internal padding to
leave on each side of the slave(s).
The \fIamount\fR must be a valid screen distance, such as \fB2\fR or \fB.5c\fR.
It defaults to 0.
.TP
\fB\-ipady\fR => \fIamount\fR
The \fIamount\fR specifies how much vertical internal padding to
leave on on the top and bottom of the slave(s).
The \fIamount\fR  defaults to 0.
.TP
\fB\-padx\fR => \fIamount\fR
The \fIamount\fR specifies how much horizontal external padding to
leave on each side of the slave(s).
The \fIamount\fR defaults to 0.
.TP
\fB\-pady\fR => \fIamount\fR
The \fIamount\fR specifies how much vertical external padding to
leave on the top and bottom of the slave(s).
The \fIamount\fR defaults to 0.
.TP
\fB\-row\fR => \fIn\fR
Insert the slave so that it occupies the \fIn\fPth row in the grid.
Row numbers start with 0.  If this option is not supplied, then the
slave is arranged on the same row as the previous slave specified on this
call to \fBgrid\fP, or the first unoccupied row if this is the first slave.
.TP
\fB\-rowspan\fR => \fIn\fR
Insert the slave so that it occupies \fIn\fP rows in the grid.
The default is one row.  If the next \fBgrid\fP command contains
\fB^\fP characters instead of \fIslaves\fP that line up with the columns
of this \fIslave\fP, then the \fBrowspan\fP of this \fIslave\fP is
extended by one.
.TP
\fB\-sticky\fR => \fIstyle\fR
If a slave's parcel is larger than its requested dimensions, this
option may be used to position (or stretch) the slave within its cavity.
\fIStyle\fR  is a string that contains zero or more of the characters
\fBn\fP, \fBs\fP, \fBe\fP or \fBw\fP.
The string can optionally contains spaces or
commas, but they are ignored.  Each letter refers to a side (north, south,
east, or west) that the slave will "stick" to.  If both \fBn\fP and \fBs\fP (or
\fBe\fP and \fBw\fP) are specified, the slave will be stretched to fill the entire
height (or width) of its cavity.  The \fBsticky\fP option subsumes the
combination of \fB\-anchor\fP and \fB\-fill\fP that is used by \fBpack\fP.
The default is \fB{}\fP, which causes the slave to be centered in its cavity,
at its requested size.
.LP
If any of the slaves are already managed by the geometry manager
then any unspecified options for them retain their previous values rather
than receiving default values.
.RE
.TP
\fI$slave\fR->\fBgridForget\fR?(\fIslave ... \fR)?
Removes each of the \fIslave\fRs from grid for its
master and unmaps their windows.
The slaves will no longer be managed by the grid geometry manager.
.TP
\fI$slave\fR->\fBgridInfo\fR
Returns a list whose elements are the current configuration state of
the slave given by \fIslave\fR in the same option-value form that
might be specified to \fBgrid configure\fR.
The first two elements of the list are ``\fB\-in\fR => \fImaster\fR'' where
\fImaster\fR is the slave's master.
.TP
\fI$master\fR->\fBgridLocation\fR(\fIx,y\fR)
Given  \fIx\fP and \fIy\fP values in screen units relative to the master window, 
the column and row number at that \fIx\fP and \fIy\fP location is returned.
For locations that are above or to the left of the grid, \fB-1\fP is returned.
.TP
\fI$master\fR->\fBgridPropagate\fR?(\fIboolean\fR)?
If \fIboolean\fR has a true boolean value such as \fB1\fR or \fBon\fR
then propagation is enabled for \fImaster\fR, which must be a window
name (see ``GEOMETRY PROPAGATION'' below).
If \fIboolean\fR has a false boolean value then propagation is
disabled for \fImaster\fR.
In either of these cases an empty string is returned.
If \fIboolean\fR is omitted then the command returns \fB0\fR or
\fB1\fR to indicate whether propagation is currently enabled
for \fImaster\fR.
Propagation is enabled by default.
.TP
\fI$master\fR->\fBgridRowconfigure\fR(\fIindex\fR?,\fI\-option value...\fR?)
Query or set the row properties of the \fIindex\fP row of the 
geometry master, \fImaster\fP.
The valid options are \fB\-minsize\fP and \fB\-weight\fP.
\fBMinsize\fP sets the minimum row size, in pixels, and \fBweight\fP
sets the relative weight for apportioning any extra spaces among
rows.  If no value is specified, the current value is returned.
.TP
\fI$master\fR->\fBgridSize\fR
Returns the size of the grid (in columns then rows) for \fImaster\fP.
The size is determined either by the \fIslave\fP occupying the largest
row or column, or the largest column or row with a \fBminsize\fP or
\fBweight\fP.
.TP
\fI$master\fR->\fBgridSlaves\fR?(\fI\-option\fR=>\fIvalue\fR)?
If no options are supplied, a list of all of the slaves in \fImaster\fR
are returned. \fIOption\fP can be either \fB\-row\fP or \fB\-column\fP which
causes only the slaves in the row (or column) specified by \fIvalue\fP
to be returned.
.SH "RELATIVE PLACEMENT"
.PP
The \fBgrid\fP command contains a limited set of capabilities that
permit layouts to be created without specifying the row and column 
information for each slave.  This permits slaves to be rearranged, 
added, or removed without the need to explicitly specify row and
column information.
When no column or row information is specified for a \fIslave\fP, 
default values are chosen for
\fBcolumn\fP, \fBrow\fP, \fPcolumnspan\fP and \fProwspan\fP
at the time the \fIslave\fP is managed. The values are chosen
based upon the current layout of the grid, the position of the \fIslave\fP
relative to other \fIslave\fPs in the same grid command, and the presence
of the characters \fB\-\fP, \fB^\fP, and \fB^\fP in \fBgrid\fP
command where \fIslave\fP names are normally expected.
.RS
.TP
\fB\-\fP
This increases the columnspan of the \fIslave\fP to the left.  Several
\fB\-\fP's in a row will successively increase the columnspan. S \fB\-\fP
may not follow a \fB^\fP or a \fBx\fP.
.TP
\fBx\fP
This leaves an empty column between the \fIslave\fP on the left and
the \fIslave\fP on the right.
.TP
\fB^\fP
This extends the \fBrowspan\fP of the \fIslave\fP above the \fB^\fP's
in the grid.  The number of \fB^\fP's in a row must match the number of
columns spanned by the \fIslave\fP above it.
.RE
.SH "GEOMETRY PROPAGATION"
.PP
The gridbag normally computes how large a master must be to
just exactly meet the needs of its slaves, and it sets the
requested width and height of the master to these dimensions.
This causes geometry information to propagate up through a
window hierarchy to a top-level window so that the entire
sub-tree sizes itself to fit the needs of the leaf windows.
However, the \fBgrid propagate\fR command may be used to
turn off propagation for one or more masters.
If propagation is disabled then the gridbag will not set
the requested width and height of the gridbag.
This may be useful if, for example, you wish for a master
window to have a fixed size that you specify.

.SH "RESTRICTIONS ON MASTER WINDOWS"
.PP
The master for each slave must either be the slave's parent
(the default) or a descendant of the slave's parent.
This restriction is necessary to guarantee that the
slave can be placed over any part of its master that is
visible without danger of the slave being clipped by its parent.

.SH "STACKING ORDER"
.PP
If the master for a slave is not its parent then you must make sure
that the slave is higher in the stacking order than the master.
Otherwise the master will obscure the slave and it will appear as
if the slave hasn't been managed correctly.
The easiest way to make sure the slave is higher than the master is
to create the master window first:  the most recently created window
will be highest in the stacking order.

.SH CAVEATS
This version of \fBgrid\fR has been lifted from tk4.1 (alpha) while rest of 
perl/Tk is based on tk4.0 (production).
\fBgrid\fR has not really been tested. It is included because it 
is required by one of the GUI builders under development. 

.SH CREDITS
.PP
The \fBgrid\fP command is based on the \fIGridBag\fP geometry manager
written by D. Stein.

.SH KEYWORDS
geometry manager, location, grid, parcel, propagation, size, pack
