## @file
# Messages translation for Lemonldap::NG::Manager

## @class
# Messages translation for Lemonldap::NG::Manager.
package Lemonldap::NG::Manager::_i18n;

# Developer warning : this file must be utf8 encoded

use strict;
use AutoLoader qw(AUTOLOAD);
our $VERSION = '0.991';

## @method string translate(string text,string lang)
# Returns $text translated in $lang.
#@param $text textId
#@param $lang Optional language string. If not set, uses Accept-Language
# HTTP header.
sub translate {
    my ( $self, $text, $lang ) = @_;
    return $text unless ( $text =~ /[a-z]/ );
    $lang ||= $ENV{HTTP_ACCEPT_LANGUAGE};
    $lang = lc($lang);
    $lang =~ s/-/_/g;
    foreach ( split( /[,;]/, $lang ), 'en' ) {
        next if /=/;
        if ( __PACKAGE__->can($_) ) {
            no strict 'refs';
            my $r = &$_()->{$text};
            if ($r) {
                return $r;
            }
            else {
                $self->lmLog( __PACKAGE__ . ": $text not translated in $_",
                    'error' );
                return $text;
            }
        }
    }
}

*fr_fr = *fr;
*en_us = *en;

1;

__END__

sub en {
    return {
        _auth               => 'Authentication',
        _authChoice         => 'Authentication choice',
        _userDB             => 'User',
        _passwordDB         => 'Password',
        _issuerDB           => 'Issuer',
        _timezone           => 'Time zone',
        _session_id         => 'Session identifier',
        _user               => 'Login',
        _password           => 'Password',
        _utime              => 'Session timestamp',
        _lastAuthnUTime     => 'Authentication timestamp',
        _idp                => 'IDP EntityID',
        _idpConfKey         => 'IDP configuration key',
        _samlToken          => 'SAML token',
        _lassoSessionDump   => 'Lasso session dump',
        _lassoIdentityDump  => 'Lasso identity dump',
        advancedParams      => 'Advanced parameters',
        apacheParams        => 'Apache parameters',
        apacheAuthnLevel    => 'Authentication level',
        applicationList     => 'Categories and applications',
        attributesAndMacros => 'Attributes and macros',
        authChoiceModules   => 'Allowed modules',
        authChoiceParam     => 'URL parameter',
        authentication      => 'Authentication module',
        authenticationLevel => 'Authentication level',
        authenticationTitle => 'Authentication',
        AuthLDAPFilter      => 'Authentication filter',
        authParams          => 'Authentication modules',
        dbiAuthChain        => 'Chain',
        dbiAuthLoginCol     => 'Login field name',
        dbiAuthMailCol      => 'Mail field name',
        dbiAuthnLevel       => 'Authentication level',
        dbiAuthPassword     => 'Password',
        dbiAuthPasswordCol  => 'Password field name',
        dbiAuthPasswordHash => 'Hash scheme',
        dbiAuthTable        => 'Authentication table',
        dbiAuthUser         => 'User',
        dbiConnection       => 'Connection',
        dbiConnectionAuth   => 'Authentication process',
        dbiConnectionUser   => 'User process',
        dbiParams           => 'DBI parameters',
        dbiPassword         => 'Password',
        dbiSchema           => 'Schema',
        dbiUserChain        => 'Chain',
        dbiUserPassword     => 'Password',
        dbiUserTable        => 'User table',
        dbiUserUser         => 'User',
        deleteSession       => 'Delete session',
        CAS_authnLevel      => 'Authentication level',
        CAS_CAFile          => 'CA file',
        CAS_gateway         => 'Gateway authentication',
        CAS_pgtFile         => 'PGT file',
        CAS_proxiedServices => 'Proxied services',
        CAS_renew           => 'Renew authentication',
        CAS_url             => 'Server URL',
        casAttr             => 'CAS login',
        casParams           => 'CAS parameters',
        casStorage          => 'CAS sessions module name',
        casStorageOptions   => 'CAS sessions module options',
        cda                 => 'Multiple domains',
        clickHereToForce    => 'Click here to force',
        choiceParams        => 'Choice parameters',
        Configuration       => 'Configuration',
        confModuledeprecated =>
'This module has been deprecated, set "forceUpload=1" in lemonldap-ng.ini to use it',
        confSaved                    => 'Configuration saved',
        confWasChanged               => 'Configuration has been changed',
        connectionTitle              => 'Connection',
        cookieExpiration             => 'Cookie expiration time',
        cookieName                   => 'Cookie Name',
        cookieParams                 => 'Cookies',
        customFunctions              => 'Custom functions',
        databaseLocked               => 'Database locked by another process',
        dateTitle                    => 'Dates',
        dn                           => 'DN',
        domain                       => 'Domain',
        error                        => 'Error',
        exportedAttr                 => 'SOAP exported attributes',
        exportedVars                 => 'Exported Variables',
        generalParameters            => 'General Parameters',
        globalStorage                => 'Apache::Session module',
        globalStorageOptions         => 'Apache::Session module parameters',
        grantSessionRule             => 'Opening conditions',
        groups                       => 'Groups',
        headers                      => 'HTTP Headers',
        https                        => 'Default value for https parameter',
        ipAddr                       => 'IP address',
        issuerParams                 => 'Issuer modules',
        issuerDBSAML                 => 'SAML',
        issuerDBSAMLActivation       => 'Activation',
        issuerDBSAMLPath             => 'Path',
        issuerDBSAMLRule             => 'Use rule',
        issuerDBCAS                  => 'CAS',
        issuerDBCASActivation        => 'Activation',
        issuerDBCASPath              => 'Path',
        issuerDBCASRule              => 'Use rule',
        issuerDBCASOptions           => 'Options',
        issuerDBOpenID               => 'OpenID',
        issuerDBOpenIDActivation     => 'Activation',
        issuerDBOpenIDPath           => 'Path',
        issuerDBOpenIDRule           => 'Use rule',
        issuerDBOpenIDOptions        => 'Options',
        key                          => 'Encryption key',
        ldap                         => 'LDAP',
        ldapAuthnLevel               => 'Authentication level',
        ldapBase                     => 'Users search base',
        ldapChangePasswordAsUser     => 'Change as user',
        ldapConnection               => 'Connection',
        ldapFilters                  => 'Filters',
        LDAPFilter                   => 'Default filter',
        ldapGroupAttributeName       => 'Target attribute',
        ldapGroupAttributeNameGroup  => 'Group source attribute',
        ldapGroupAttributeNameSearch => 'Searched attributes',
        ldapGroupAttributeNameUser   => 'User source attribute',
        ldapGroupBase                => 'Search base',
        ldapGroupObjectClass         => 'Object class',
        ldapGroupRecursive           => 'Recursive',
        ldapGroups                   => 'Groups',
        ldapParams                   => 'LDAP parameters',
        ldapPassword                 => 'Password',
        ldapPpolicyControl           => 'Password policy control',
        ldapPort                     => 'Server port',
        ldapPwdEnc                   => 'LDAP password encoding',
        ldapRaw                      => 'Binary attributes',
        ldapServer                   => 'Server host',
        ldapSetPassword              => 'Password modify extended operation',
        ldapTimeout                  => 'Timeout',
        ldapVersion                  => 'Version',
        logoutServices               => 'Logout forward',
        logParams                    => 'Logs',
        macros                       => 'Macros',
        mailBody                     => 'Success mail content',
        mailConfirmBody              => 'Confirmation mail content',
        mailConfirmSubject           => 'Confirmation mail subject',
        mailFrom                     => 'Mail sender',
        mailLDAPFilter               => 'Mail filter',
        mailSubject                  => 'Success mail subject',
        mailUrl                      => 'Page URL',
        managerDn                    => 'Account',
        managerPassword              => 'Password',
        memberOfSSOGroups            => 'Member of SSO groups',
        modulesTitle                 => 'Used modules',
        multipleSessions             => 'Multiple sessions',
        notification                 => 'Activation',
        notifications                => 'Notifications',
        notificationStorage          => 'Storage module',
        notificationStorageOptions   => 'Storage module parameters',
        notifyDeleted                => 'Display deleted sessions',
        notifyOther                  => 'Display other sessions',
        nullAuthnLevel               => 'Authentication level',
        nullParams                   => 'Null parameters',
        openIdAttr                   => 'OpenID login',
        openIdAuthnLevel             => 'Authentication level',
        openIdIDPList                => 'Authorizated domains',
        openIdIssuerSecret           => 'Secret token',
        openIdParams                 => 'OpenID parameters',
        openIdSecret                 => 'Secret token',
        openIdSreg                   => 'SREG mapping',
        openIdSreg_fullname          => 'Full name',
        openIdSreg_nickname          => 'Nick name',
        openIdSreg_language          => 'Language',
        openIdSreg_postcode          => 'Postal code',
        openIdSreg_timezone          => 'Timezone',
        openIdSreg_country           => 'Country',
        openIdSreg_gender            => 'Gender',
        openIdSreg_email             => 'Email',
        openIdSreg_dob               => 'Date of birth',
        openIdSPList                 => 'Authorizated domains',
        passwordDB                   => 'Password module',
        passwordManagement           => 'Password management',
        port                         => 'Port',
        portal                       => 'URL',
        portalAutocomplete           => 'Auto complete',
        portalCustomization          => 'Customization',
        portalDisplayAppslist        => 'Applications list',
        portalDisplayChangePassword  => 'Password change',
        portalDisplayLogout          => 'Logout',
        portalDisplayResetPassword   => 'Reset password',
        portalForceAuthn             => 'Force authentication',
        portalMenu                   => 'Menu',
        portalModules                => 'Modules activation',
        portalOpenLinkInNewWindow    => 'New window',
        portalParams                 => 'Portal',
        portalRequireOldPassword     => 'Require old password',
        portalSkin                   => 'Skin',
        portalUserAttr               => 'User attribute',
        post                         => 'Form replay',
        proxyParams                  => 'Proxy parameters',
        randomPasswordRegexp         => 'Regexp for password generation',
        redirection                  => 'Handler redirections',
        remoteCookieName             => 'Cookie name',
        remoteGlobalStorage          => 'Sessions module',
        remoteGlobalStorageOptions   => 'Sessions module options',
        remoteParams                 => 'Remote parameters',
        remotePortal                 => 'Portal URL',
        rules                        => 'Rules',
        securedCookie                => 'Secured Cookie (SSL)',
        security                     => 'Security',
        session                      => 'session',
        sessions                     => 'sessions',
        sessionDeleted               => 'The session was deleted',
        sessionParams                => 'Sessions',
        sessionStartedAt             => 'Session started on',
        sessionStorage               => 'Sessions Storage',
        sessionTitle                 => 'Session content',
        singleIP                     => 'One IP only by user',
        singleSession                => 'One session only by user',
        singleUserByIP               => 'One user by IP address',
        SMTPServer                   => 'SMTP server',
        soap                         => 'SOAP',
        Soap                         => 'Activation',
        soapAuthService              => 'Portal URL',
        soapSessionService           => 'SOAP sessions end point',
        specialHandlers              => 'Special Handlers',
        SSLAuthnLevel                => 'Authentication level',
        SSLLDAPField                 => 'LDAP attribute used in filter',
        sslParams                    => 'SSL parameters',
        SSLRequire                   => 'SSL Required',
        SSLVar                       => 'Extracted certificate field',
        startTime                    => 'Creation date',
        storePassword                => 'Store user password in session datas',
        sympaHandler                 => 'Sympa',
        sympaMailKey                 => 'Mail session key',
        sympaSecret                  => 'Shared secret',
        syntaxError                  => 'Syntax Error',
        syslog                       => 'Syslog facility',
        timeout                      => 'Sessions timeout',
        timeoutActivity              => 'Sessions activity timeout',
        trustedDomains               => 'Trusted domains',
        twitterAppName               => 'Application name',
        twitterAuthnLevel            => 'Authentication level',
        twitterKey                   => 'API key',
        twitterParams                => 'Twitter parameters',
        twitterSecret                => 'API secret',
        unknownError                 => 'Unknown error',
        updateTime                   => 'Update date',
        uploadDenied                 => 'Upload denied',
        user                         => 'user',
        users                        => 'users',
        userDB                       => 'Users module',
        userControl                  => 'Username control',
        userPivot                    => 'Login field name in user table',
        useRedirectOnError           => 'Redirect on handler error',
        useRedirectOnForbidden       => 'Redirect on forbidden',
        useXForwardedForIP           => "Use X-Forwarded-For header address",
        variables                    => "Variables",
        vhostHttps                   => 'HTTPS',
        vhostOptions                 => 'Options',
        vhostPort                    => 'Port',
        virtualHosts                 => 'Virtual Hosts',
        whatToTrace                  => "REMOTE_USER environment variable",
        xForwardedForAddr            => 'Forwarded IP address',
        zimbraAccountKey             => 'Account session key',
        zimbraBy                     => 'Account type',
        zimbraHandler                => 'Zimbra',
        zimbraPreAuthKey             => 'Preauthentication key',
        zimbraSsoUrl                 => 'Local SSO URL pattern',
        zimbraUrl                    => 'Preauthentication URL',

        saml                               => 'SAML',
        samlNameIDFormatMap                => 'NameID formats',
        samlNameIDFormatMapEmail           => 'Email',
        samlNameIDFormatMapX509            => 'X509',
        samlNameIDFormatMapWindows         => 'Windows',
        samlNameIDFormatMapKerberos        => 'Kerberos',
        samlIDPMetaDataNode                => 'SAML identity providers',
        samlIDPMetaDataXML                 => 'Metadata',
        samlIDPMetaDataExportedAttributes  => 'Exported attributes',
        samlIDPMetaDataOptions             => 'Options',
        samlIDPMetaDataOptionsNameIDFormat => 'NameID format',
        samlIDPMetaDataOptionsForceAuthn   => 'Force authentication',
        samlIDPMetaDataOptionsIsPassive    => 'Passive authentication',
        samlIDPMetaDataOptionsAllowProxiedAuthn =>
          'Allow proxied authentication',
        samlIDPMetaDataOptionsAllowLoginFromIDP => 'Allow login from IDP',
        samlIDPMetaDataOptionsAdaptSessionUtime => 'Adapt session lifetime',
        samlIDPMetaDataOptionsSignSSOMessage    => 'Sign SSO message',
        samlIDPMetaDataOptionsCheckSSOMessageSignature =>
          'Check SSO message signature',
        samlIDPMetaDataOptionsSignSLOMessage => 'Sign SLO message',
        samlIDPMetaDataOptionsCheckSLOMessageSignature =>
          'Check SLO message signature',
        samlIDPMetaDataOptionsSSOBinding     => 'SSO binding',
        samlIDPMetaDataOptionsSLOBinding     => 'SLO binding',
        samlIDPMetaDataOptionsResolutionRule => 'Resolution rule',
        samlIDPMetaDataOptionsRequestedAuthnContext =>
          'Requested authentication context',
        samlIDPMetaDataOptionsForceUTF8       => 'Force UTF-8',
        samlIDPMetaDataOptionsEncryptionMode  => 'Encryption mode',
        samlIDPMetaDataOptionsCheckConditions => 'Check conditions',
        samlIDPMetaDataOptionsAuthnRequest    => 'Authentication request',
        samlIDPMetaDataOptionsSession         => 'Session',
        samlIDPMetaDataOptionsSignature       => 'Signature',
        samlIDPMetaDataOptionsBinding         => 'Binding',
        samlIDPMetaDataOptionsSecurity        => 'Security',
        samlSPMetaDataNode                    => 'SAML service providers',
        samlSPMetaDataXML                     => 'Metadata',
        samlSPMetaDataExportedAttributes      => 'Exported attributes',
        samlSPMetaDataOptions                 => 'Options',
        samlSPMetaDataOptionsNameIDFormat     => 'Default NameID format',
        samlSPMetaDataOptionsOneTimeUse       => 'One time use',
        samlSPMetaDataOptionsSignSSOMessage   => 'Sign SSO message',
        samlSPMetaDataOptionsCheckSSOMessageSignature =>
          'Check SSO message signature',
        samlSPMetaDataOptionsSignSLOMessage => 'Sign SLO message',
        samlSPMetaDataOptionsCheckSLOMessageSignature =>
          'Check SLO message signature',
        samlSPMetaDataOptionsEncryptionMode => 'Encryption mode',
        samlSPMetaDataOptionsAuthnResponse  => 'Authentication response',
        samlSPMetaDataOptionsSignature      => 'Signature',
        samlSPMetaDataOptionsSecurity       => 'Security',
        samlServiceMetaData                 => 'SAML 2 Service',
        samlEntityID                        => 'Entity Identifier',
        samlOrganization                    => 'Organization',
        samlOrganizationDisplayName         => 'Display Name',
        samlOrganizationName                => 'Name',
        samlOrganizationURL                 => 'URL',
        samlSPSSODescriptor                 => 'Service Provider',
        samlSPSSODescriptorAuthnRequestsSigned =>
          'Signed Authentication Request',
        samlSPSSODescriptorWantAssertionsSigned => 'Want Assertions Signed',
        samlSPSSODescriptorSingleLogoutService  => 'Single Logout',
        samlSPSSODescriptorSingleLogoutServiceHTTPRedirect => 'HTTP Redirect',
        samlSPSSODescriptorSingleLogoutServiceHTTPPost     => 'HTTP POST',
        samlSPSSODescriptorSingleLogoutServiceSOAP         => 'SOAP',
        samlSPSSODescriptorAssertionConsumerService => 'Assertion Consumer',
        samlSPSSODescriptorAssertionConsumerServiceHTTPArtifact =>
          'HTTP Artifact',
        samlSPSSODescriptorAssertionConsumerServiceHTTPPost => 'HTTP POST',
        samlSPSSODescriptorArtifactResolutionService => 'Artifact Resolution',
        samlSPSSODescriptorArtifactResolutionServiceArtifact =>
          'Artifact Service',
        samlIDPSSODescriptor => 'Identity Provider',
        samlIDPSSODescriptorWantAuthnRequestsSigned =>
          'Want Authentication Request Signed',
        samlIDPSSODescriptorSingleSignOnService             => 'Single Sign On',
        samlIDPSSODescriptorSingleSignOnServiceHTTPRedirect => 'HTTP Redirect',
        samlIDPSSODescriptorSingleSignOnServiceHTTPPost     => 'HTTP POST',
        samlIDPSSODescriptorSingleSignOnServiceHTTPArtifact => 'HTTP Artifact',
        samlIDPSSODescriptorSingleSignOnServiceSOAP         => 'SOAP',
        samlIDPSSODescriptorSingleLogoutService             => 'Single Logout',
        samlIDPSSODescriptorSingleLogoutServiceHTTPRedirect => 'HTTP Redirect',
        samlIDPSSODescriptorSingleLogoutServiceHTTPPost     => 'HTTP POST',
        samlIDPSSODescriptorSingleLogoutServiceSOAP         => 'SOAP',
        samlIDPSSODescriptorArtifactResolutionService => 'Artifact Resolution',
        samlIDPSSODescriptorArtifactResolutionServiceArtifact =>
          'Artifact Service',
        samlAttributeAuthorityDescriptor => 'Attribute Authority',
        samlAttributeAuthorityDescriptorAttributeService => 'Attribute Service',
        samlAttributeAuthorityDescriptorAttributeServiceSOAP => 'SOAP',
        samlServiceSecurity         => 'Security parameters',
        samlServiceSecuritySig      => 'Signature',
        samlServiceSecurityEnc      => 'Encryption',
        samlServicePrivateKeySig    => 'Private key',
        samlServicePrivateKeySigPwd => 'Private key password',
        samlServicePublicKeySig     => 'Public key',
        samlServicePrivateKeyEnc    => 'Private key',
        samlServicePrivateKeyEncPwd => 'Private key password',
        samlServicePublicKeyEnc     => 'Public key',
        samlAdvanced                => 'Advanced',
        samlIdPResolveCookie        => 'IDP resolution cookie name',
        samlMetadataForceUTF8       => 'UTF8 metadata conversion',
        samlStorage                 => 'SAML sessions module name',
        samlStorageOptions          => 'SAML sessions module options',
        samlAuthnContextMap         => 'Authentication contexts',
        samlAuthnContextMapPassword => 'Password',
        samlAuthnContextMapPasswordProtectedTransport =>
          'Password protected transport',
        samlAuthnContextMapTLSClient     => 'TLS client',
        samlAuthnContextMapKerberos      => 'Kerberos',
        samlCommonDomainCookie           => 'Common Domain Cookie',
        samlCommonDomainCookieActivation => 'Activation',
        samlCommonDomainCookieDomain     => 'Common domain',
        samlCommonDomainCookieReader     => 'Reader URL',
        samlCommonDomainCookieWriter     => 'Writer URL',
    };
}

sub fr {
    use utf8;
    return {
        _auth               => 'Authentification',
        _authChoice         => 'Choix d\'authentification',
        _userDB             => 'Utilisateur',
        _passwordDB         => 'Mot de passe',
        _issuerDB           => 'Fournisseur',
        _timezone           => 'Zone horaire',
        _session_id         => 'Identifiant de session',
        _user               => 'Identifiant',
        _password           => 'Mot de passe',
        _utime              => 'Tampon de la session',
        _lastAuthnUTime     => 'Tampon d\'authentification ',
        _idp                => 'Identifiant d\'entité de l\'IDP',
        _idpConfKey         => 'Clé de configuration de l\'IDP',
        _samlToken          => ' Jeton SAML ',
        _lassoSessionDump   => ' Dump session Lasso ',
        _lassoIdentityDump  => 'Dump identité Lasso',
        advancedParams      => 'Paramètres avancés',
        apacheParams        => 'Paramètres Apache',
        apacheAuthnLevel    => 'Niveau d\'authentification',
        applicationList     => 'Catégories et applications',
        attributesAndMacros => 'Attributs et macros',
        authChoiceModules   => 'Modules autorisés',
        authChoiceParam     => 'Parmètre de l\'URL',
        authentication      => "Module d'authentification",
        authenticationLevel => 'Niveau d\'authentification',
        authenticationTitle => 'Authentification',
        AuthLDAPFilter      => 'Filtre d\'authentification',
        authParams          => "Modules d'authentification",
        dbiAuthChain        => 'Chaîne',
        dbiAuthLoginCol     => 'Champ identifiant',
        dbiAuthMailCol      => 'Champ mail',
        dbiAuthnLevel       => 'Niveau d\'authentification',
        dbiAuthPassword     => 'Mot de passe',
        dbiAuthPasswordCol  => 'Champ mot de passe',
        dbiAuthPasswordHash => 'Schéma de hachage',
        dbiAuthTable        => 'Table authentification',
        dbiAuthUser         => 'Utilisateur',
        dbiConnection       => 'Connexion',
        dbiConnectionAuth   => 'Authentification',
        dbiConnectionUser   => 'Utilisateurs',
        dbiParams           => 'Paramètres DBI',
        dbiPassword         => 'Mot de passe',
        dbiSchema           => 'Schéma',
        dbiUserChain        => 'Chaîne',
        dbiUserPassword     => 'Mot de passe',
        dbiUserTable        => 'Table des utilisateurs',
        dbiUserUser         => 'Utilisateur',
        deleteSession       => 'Effacer la session',
        CAS_authnLevel      => 'Niveau d\'authentification',
        CAS_CAFile          => 'Fichier d\'AC',
        CAS_gateway         => 'Authentification transparente',
        CAS_pgtFile         => 'Fichier de PGT',
        CAS_renew           => 'Renouveller l\'authentication',
        CAS_proxiedServices => 'Services mandatés',
        CAS_url             => 'URL du serveur',
        casAttr             => 'Identifiant CAS',
        casParams           => 'Paramètres CAS',
        casStorage          => 'Nom du module des session CAS',
        casStorageOptions   => 'Options du module des sessions CAS',
        cda                 => 'Domaines multiples',
        clickHereToForce    => 'Cliquer ici pour forcer',
        choiceParams        => 'Paramètres des choix',
        Configuration       => 'Configuration',
        confModuledeprecated =>
"Ce module est obsolète, indiquez \"forceUpload=1\" dans le fichier lemonldap-ng.ini pour l'utiliser",
        confSaved        => 'Configuration sauvegardée',
        confWasChanged   => 'Configuration modifiée entre-temps',
        connectionTitle  => 'Connexion',
        cookieExpiration => 'Durée de vie du cookie',
        cookieName       => 'Nom du cookie',
        cookieParams     => 'Cookies',
        customFunctions  => 'Fonctions personnalisées',
        databaseLocked => 'Base de donnée verrouillée par un autre processus',
        dateTitle      => 'Dates',
        dn             => 'DN',
        domain         => 'Domaine',
        error          => 'Erreur',
        exportedAttr   => 'Attributs exportés par le portail (SOAP)',
        exportedVars   => 'Attributs à exporter',
        generalParameters           => 'Paramètres généraux',
        globalStorage               => 'Module Apache::Session',
        globalStorageOptions        => 'Paramètres du module Apache::Session',
        grantSessionRule            => "Conditions d'ouverture",
        groups                      => 'Groupes',
        headers                     => 'En-têtes HTTP',
        https                       => 'Valeur par défaut du paramètre https',
        ipAddr                      => 'Adresse IP',
        issuerParams                => 'Modules fournisseur',
        issuerDBSAML                => 'SAML',
        issuerDBSAMLActivation      => 'Activation',
        issuerDBSAMLPath            => 'Chemin',
        issuerDBSAMLRule            => 'Règle d\'utilisation',
        issuerDBCAS                 => 'CAS',
        issuerDBCASActivation       => 'Activation',
        issuerDBCASPath             => 'Chemin',
        issuerDBCASRule             => 'Règle d\'utilisation',
        issuerDBCASOptions          => 'Options',
        issuerDBOpenID              => 'OpenID',
        issuerDBOpenIDActivation    => 'Activation',
        issuerDBOpenIDPath          => 'Chemin',
        issuerDBOpenIDRule          => 'Règle d\'utilisation',
        issuerDBOpenIDOptions       => 'Options',
        key                         => 'Clef de chiffrement',
        ldap                        => 'LDAP',
        ldapAuthnLevel              => 'Niveau d\'authentification',
        ldapBase                    => 'Base de recherche des utilisateurs',
        ldapChangePasswordAsUser    => 'Changement en tant qu\'utilisateur',
        ldapConnection              => 'Connexion',
        ldapFilters                 => 'Filtres',
        LDAPFilter                  => 'Filtre par défaut',
        ldapGroupAttributeName      => 'Attribut cible',
        ldapGroupAttributeNameGroup => 'Attribut source groupe',
        ldapGroupAttributeNameSearch => 'Attributs recherchés',
        ldapGroupAttributeNameUser   => 'Attribut source utilisateur',
        ldapGroupBase                => 'Base de recherche',
        ldapGroupObjectClass         => 'Classe d\'objet',
        ldapGroupRecursive           => 'Recursif',
        ldapGroups                   => 'Groupes',
        ldapParams                   => 'Paramètres LDAP',
        ldapPassword                 => 'Mot de passe',
        ldapPpolicyControl           => 'Contrôle password policy',
        ldapPort                     => 'Port',
        ldapPwdEnc                   => 'Encodage des mots de passe LDAP',
        ldapRaw                      => 'Attributs binaires',
        ldapServer                   => 'Hôte',
        ldapSetPassword              => 'Opération étendue password modify',
        ldapTimeout                  => 'Temps maximum d\'inactivité',
        ldapVersion                  => 'Version',
        logoutServices               => 'Transfert de la déconnexion',
        logParams                    => 'Journalisation',
        macros                       => 'Macros',
        mailBody                     => 'Contenu du message de succès',
        mailConfirmBody              => 'Contenu du message de confirmation',
        mailConfirmSubject           => 'Sujet du message de confirmation',
        mailFrom                     => 'Expéditeur du message',
        mailLDAPFilter               => 'Filtre mail',
        mailSubject                  => 'Sujet du message de succès',
        mailUrl                      => 'URL de la page',
        managerDn                    => 'Compte de connexion LDAP',
        managerPassword              => 'Mot de passe LDAP',
        memberOfSSOGroups            => 'Membre des groupes SSO',
        modulesTitle                 => 'Modules utilisés',
        multipleSessions             => 'Sessions multiples',
        notification                 => 'Activation',
        notifications                => 'Notifications',
        notificationStorage          => 'Module de stockage',
        notificationStorageOptions   => 'Paramètres du module de stockage',
        notifyDeleted                => 'Affiche les sessions effacées',
        notifyOther                  => 'Affiche les autres sessions',
        nullAuthnLevel               => 'Niveau d\'authentification',
        nullParams                   => 'Paramètres Null',
        openIdAttr                   => 'Identifiant OpenID',
        openIdAuthnLevel             => 'Niveau d\'authentification',
        openIdIDPList                => 'Domaines autorisés',
        openIdIssuerSecret           => 'Jeton secret',
        openIdParams                 => 'Paramètres OpenID',
        openIdSecret                 => 'Jeton secret',
        openIdSreg                   => 'Associations SREG',
        openIdSreg_fullname          => 'Nom complet',
        openIdSreg_nickname          => 'Surnom',
        openIdSreg_language          => 'Langage',
        openIdSreg_postcode          => 'Code postal',
        openIdSreg_timezone          => 'Zone horaire',
        openIdSreg_country           => 'Pays',
        openIdSreg_gender            => 'Gendre',
        openIdSreg_email             => 'Email',
        openIdSreg_dob               => 'Date de naissance',
        openIdSPList                 => 'Domaines autorisés',
        passwordDB                   => 'Module de mot de passe',
        passwordManagement           => 'Gestion des mots de passe',
        port                         => 'Port',
        portal                       => 'URL',
        portalAutocomplete           => 'Auto complétion',
        portalCustomization          => 'Personnalisation',
        portalDisplayAppslist        => 'Liste des applications',
        portalDisplayChangePassword  => 'Changement de mot de passe',
        portalDisplayLogout          => 'Déconnexion',
        portalDisplayResetPassword   => 'Réinitialisation de mot de passe',
        portalForceAuthn             => 'Authentication forcée',
        portalMenu                   => 'Menu',
        portalModules                => 'Modules',
        portalOpenLinkInNewWindow    => 'Nouvelle fenêtre',
        portalParams                 => 'Portail',
        portalRequireOldPassword     => 'Ancien mot de passe requis',
        portalSkin                   => 'Thème visuel',
        portalUserAttr               => "Attribut de l'utilisateur",
        post                         => 'Rejeu de formulaires',
        proxyParams                  => 'Paramètres Proxy',
        randomPasswordRegexp =>
          'Expression regulière pour la génération des mots de passe',
        redirection                => 'Redirections du Handler',
        remoteCookieName           => 'Nom du cookie',
        remoteGlobalStorage        => 'Module des sessions',
        remoteGlobalStorageOptions => 'Options du module des sessions',
        remoteParams               => 'Paramètres Remote',
        remotePortal               => 'URL du portail',
        rules                      => 'Règles',
        securedCookie              => 'Cookie sécurisé (SSL)',
        security                   => 'Sécurité',
        session                    => 'session',
        sessions                   => 'sessions',
        sessionDeleted             => 'La session a été supprimée',
        sessionParams              => 'Sessions',
        sessionStartedAt           => 'Session démarrée le ',
        sessionStorage             => 'Stockage des sessions',
        sessionTitle               => 'Contenu de la session',
        singleIP                   => 'Une seule IP par utilisateur',
        singleSession              => 'Une seule session par utilisateur',
        singleUserByIP             => 'Une seule adresse IP par utilisateur',
        SMTPServer                 => 'Serveur SMTP',
        soap                       => 'SOAP',
        Soap                       => 'Activation',
        soapAuthService            => 'URL du portail',
        soapSessionService         => 'Point d\'accès SOAP des sessions',
        specialHandlers            => 'Handlers spéciaux',
        SSLAuthnLevel              => 'Niveau d\'authentification',
        SSLLDAPField               => 'Attribut LDAP pour le filtre',
        sslParams                  => 'Paramètres SSL',
        SSLRequire                 => 'SSL Requis',
        SSLVar                     => 'Champ extrait du certificat',
        startTime                  => 'Date de création',
        storePassword   => "Stocke le mot de passe de l'utilisateur en session",
        sympaHandler    => 'Sympa',
        sympaMailKey    => 'Clé de session pour le mail',
        sympaSecret     => 'Secret partagé',
        syntaxError     => 'Erreur de syntaxe',
        syslog          => 'Facilité syslog',
        timeout         => 'Durée de vie maximale des sessions',
        timeoutActivity => 'Délai d\'expiration des sessions',
        trustedDomains  => 'Domaines appouvés',
        twitterAppName  => 'Nom de l\'application',
        twitterAuthnLevel => 'Niveau d\'authentification',
        twitterKey        => 'Clé de l\'API',
        twitterParams     => 'Paramètres Twitter',
        twitterSecret     => 'Secret de l\'API',
        unknownError      => 'Erreur inconnue',
        updateTime        => 'Date de mise à jour',
        uploadDenied      => 'Téléchargement refusé',
        user              => 'utilisateur',
        users             => 'utilisateurs',
        userDB            => "Module d'utilisateurs",
        userControl       => "Contrôle du nom d'utilisateur",
        userPivot         => 'Champ identifiant dans la table des utilisateurs',
        useRedirectOnError     => 'Redirection pour les erreurs d\'agent',
        useRedirectOnForbidden => 'Redirection pour les accès interdits',
        useXForwardedForIP =>
          "Utiliser l'adresse IP de l'en-tête X-Forwarded-For",
        variables         => "Variables",
        vhostHttps        => 'HTTPS',
        vhostOptions      => 'Options',
        vhostPort         => 'Port',
        virtualHosts      => 'Hôtes virtuels',
        whatToTrace       => "Variable d'environnement REMOTE_USER",
        xForwardedForAddr => 'Adresse IP transférée',
        zimbraAccountKey  => 'Clé de session pour le compte',
        zimbraBy          => 'Type de compte',
        zimbraHandler     => 'Zimbra',
        zimbraPreAuthKey  => 'Clé de préauthentication',
        zimbraSsoUrl      => 'Motif pour l\' URL de SSO locale ',
        zimbraUrl         => 'URL de préauthentification',

        saml                               => 'SAML',
        samlNameIDFormatMap                => 'Formats de NameID',
        samlNameIDFormatMapEmail           => 'Email',
        samlNameIDFormatMapX509            => 'X509',
        samlNameIDFormatMapWindows         => 'Windows',
        samlNameIDFormatMapKerberos        => 'Kerberos',
        samlIDPMetaDataNode                => 'Fournisseurs d\'identité SAML',
        samlIDPMetaDataXML                 => 'Metadonnées',
        samlIDPMetaDataExportedAttributes  => 'Attributs exportés',
        samlIDPMetaDataOptions             => 'Options',
        samlIDPMetaDataOptionsNameIDFormat => 'Format du NameID',
        samlIDPMetaDataOptionsForceAuthn   => 'Authentification forcée',
        samlIDPMetaDataOptionsIsPassive    => 'Authentication passive',
        samlIDPMetaDataOptionsAllowProxiedAuthn =>
          'Authentification proxy autorisée',
        samlIDPMetaDataOptionsAllowLoginFromIDP =>
          'Authentification depuis le fournisseur autorisée',
        samlIDPMetaDataOptionsAdaptSessionUtime =>
          'Adapatation de la durée de vie de la session',
        samlIDPMetaDataOptionsSignSSOMessage => 'Signature des messages SSO',
        samlIDPMetaDataOptionsCheckSSOMessageSignature =>
          'Vérification de la signature des messages SSO',
        samlIDPMetaDataOptionsSignSLOMessage => 'Signature des messages SLO',
        samlIDPMetaDataOptionsCheckSLOMessageSignature =>
          'Vérification de la signature des messages SLO',
        samlIDPMetaDataOptionsSSOBinding     => 'Méthode SSO',
        samlIDPMetaDataOptionsSLOBinding     => 'Méthode SLO',
        samlIDPMetaDataOptionsResolutionRule => 'Règle de résolution',
        samlIDPMetaDataOptionsRequestedAuthnContext =>
          'Contexte d\'authentification demandé',
        samlIDPMetaDataOptionsForceUTF8       => 'Forcer l\'UTF-8',
        samlIDPMetaDataOptionsEncryptionMode  => 'Mode de chiffrement',
        samlIDPMetaDataOptionsCheckConditions => 'Vérifier les conditions',
        samlIDPMetaDataOptionsAuthnRequest    => 'Requête d\'authentification',
        samlIDPMetaDataOptionsSession         => 'Session',
        samlIDPMetaDataOptionsSignature       => 'Signature',
        samlIDPMetaDataOptionsBinding         => 'Méthode',
        samlIDPMetaDataOptionsSecurity        => 'Sécurité',
        samlSPMetaDataNode                    => 'Fournisseurs de service SAML',
        samlSPMetaDataXML                     => 'Metadonnées',
        samlSPMetaDataExportedAttributes      => 'Attributs exportés',
        samlSPMetaDataOptions                 => 'Options',
        samlSPMetaDataOptionsNameIDFormat     => 'Format par défaut du NameID',
        samlSPMetaDataOptionsOneTimeUse       => 'Utilisation unique',
        samlSPMetaDataOptionsSignSSOMessage   => 'Signature des messages SSO',
        samlSPMetaDataOptionsCheckSSOMessageSignature =>
          'Vérification de la signature des messages SSO',
        samlSPMetaDataOptionsSignSLOMessage => 'Signature des messages SLO',
        samlSPMetaDataOptionsCheckSLOMessageSignature =>
          'Vérification de la signature des messages SLO',
        samlSPMetaDataOptionsEncryptionMode => 'Mode de chiffrement',
        samlSPMetaDataOptionsAuthnResponse  => 'Réponse d\'authentification',
        samlSPMetaDataOptionsSignature      => 'Signature',
        samlSPMetaDataOptionsSecurity       => 'Sécurité',
        samlServiceMetaData                 => 'Service SAML 2',
        samlEntityID                        => 'Identifiant d\'entité',
        samlOrganization                    => 'Organisation',
        samlOrganizationDisplayName         => 'Nom affiché',
        samlOrganizationName                => 'Nom',
        samlOrganizationURL                 => 'URL',
        samlSPSSODescriptor                 => 'Fournisseur de service',
        samlSPSSODescriptorAuthnRequestsSigned =>
          'Requêtes d\'authentification signées',
        samlSPSSODescriptorWantAssertionsSigned =>
          'Exige des assertions signées',
        samlSPSSODescriptorSingleLogoutService => 'Single Logout',
        samlSPSSODescriptorSingleLogoutServiceHTTPRedirect =>
          'Redirection HTTP',
        samlSPSSODescriptorSingleLogoutServiceHTTPPost => 'POST HTTP',
        samlSPSSODescriptorSingleLogoutServiceSOAP     => 'SOAP',
        samlSPSSODescriptorAssertionConsumerService    => 'Assertions',
        samlSPSSODescriptorAssertionConsumerServiceHTTPArtifact =>
          'HTTP Artifact',
        samlSPSSODescriptorAssertionConsumerServiceHTTPPost => 'POST HTTP',
        samlSPSSODescriptorArtifactResolutionService =>
          'Résolution d\'Artifact',
        samlSPSSODescriptorArtifactResolutionServiceArtifact =>
          'Service Artifact',
        samlIDPSSODescriptor => 'Fournisseur d\'identité',
        samlIDPSSODescriptorWantAuthnRequestsSigned =>
          'Exige des requêtes d\'authentification signées',
        samlIDPSSODescriptorSingleSignOnService => 'Single Sign On',
        samlIDPSSODescriptorSingleSignOnServiceHTTPRedirect =>
          'Redirection HTTP',
        samlIDPSSODescriptorSingleSignOnServiceHTTPPost     => 'POST HTTP',
        samlIDPSSODescriptorSingleSignOnServiceHTTPArtifact => 'HTTP Artifact',
        samlIDPSSODescriptorSingleSignOnServiceSOAP         => 'SOAP',
        samlIDPSSODescriptorSingleLogoutService             => 'Single Logout',
        samlIDPSSODescriptorSingleLogoutServiceHTTPRedirect =>
          'Redirection HTTP',
        samlIDPSSODescriptorSingleLogoutServiceHTTPPost => 'POST HTTP',
        samlIDPSSODescriptorSingleLogoutServiceSOAP     => 'SOAP',
        samlIDPSSODescriptorArtifactResolutionService =>
          'Résolution d\'Artifact',
        samlIDPSSODescriptorArtifactResolutionServiceArtifact =>
          'Service Artifact',
        samlAttributeAuthorityDescriptor => 'Autorité d\'attributs',
        samlAttributeAuthorityDescriptorAttributeService =>
          'Service d\'attributs',
        samlAttributeAuthorityDescriptorAttributeServiceSOAP => 'SOAP',
        samlServiceSecurity         => 'Paramètres de sécurité',
        samlServiceSecuritySig      => 'Signature',
        samlServiceSecurityEnc      => 'Chiffrement',
        samlServicePrivateKeySig    => 'Clé privée',
        samlServicePrivateKeySigPwd => 'Mot de passe de la clé privée',
        samlServicePublicKeySig     => 'Clé publique',
        samlServicePrivateKeyEnc    => 'Clé privée',
        samlServicePrivateKeyEncPwd => 'Mot de passe de la clé privée',
        samlServicePublicKeyEnc     => 'Clé publique',
        samlAdvanced                => 'Avancé',
        samlIdPResolveCookie        => 'Nom du cookie de résolution IDP',
        samlMetadataForceUTF8       => 'Conversion des métadonnées en UTF8',
        samlStorage                 => 'Nom du module des session SAML',
        samlStorageOptions          => 'Options du module des sessions SAML',
        samlAuthnContextMap         => 'Contextes d\'authentification',
        samlAuthnContextMapPassword => 'Mot de passe',
        samlAuthnContextMapPasswordProtectedTransport =>
          'Mot de passe protégé',
        samlAuthnContextMapTLSClient     => 'Client TLS',
        samlAuthnContextMapKerberos      => 'Kerberos',
        samlCommonDomainCookie           => 'Cookie de Domaine Commun',
        samlCommonDomainCookieActivation => 'Activation',
        samlCommonDomainCookieDomain     => 'Domaine commun',
        samlCommonDomainCookieReader     => 'URL de lecture',
        samlCommonDomainCookieWriter     => 'URL d\'écriture',
    };
}

