#ifndef PQCLEAN_NTRULPR653_CLEAN_API_H
#define PQCLEAN_NTRULPR653_CLEAN_API_H

#include <stdint.h>


#define PQCLEAN_NTRULPR653_CLEAN_CRYPTO_ALGNAME "ntrulpr653"

#define PQCLEAN_NTRULPR653_CLEAN_CRYPTO_SECRETKEYBYTES 1125
#define PQCLEAN_NTRULPR653_CLEAN_CRYPTO_PUBLICKEYBYTES 897
#define PQCLEAN_NTRULPR653_CLEAN_CRYPTO_CIPHERTEXTBYTES 1025
#define PQCLEAN_NTRULPR653_CLEAN_CRYPTO_BYTES 32

int PQCLEAN_NTRULPR653_CLEAN_crypto_kem_keypair(uint8_t *pk, uint8_t *sk);
int PQCLEAN_NTRULPR653_CLEAN_crypto_kem_enc(uint8_t *c, uint8_t *k, const uint8_t *pk);
int PQCLEAN_NTRULPR653_CLEAN_crypto_kem_dec(uint8_t *k, const uint8_t *c, const uint8_t *sk);
#endif
