use lib 't', 'lib';
use strict;
use warnings;
use Test::More tests => 12;
use IO::All;
use IO_All_Test;

my $io1 = IO::All->new('t/mystuff');
is(ref($io1), 'IO::All');
test_file_contents($$io1, 't/mystuff');

my $io2 = io('t/mystuff');
is(ref($io2), 'IO::All');
test_file_contents($$io2, 't/mystuff');

my $io3 = io->file('t/mystuff');
is(ref($io3), 'IO::All');
test_file_contents($$io3, 't/mystuff');

my $io4 = $io3->file('t/construct.t');
is(ref($io4), 'IO::All');
test_file_contents($$io4, 't/construct.t');

my $io5 = $io4->file('t/mydir');
is(ref($io5), 'IO::All');
is(join('+', map $_->filename, $io5->all), 'dir1+dir2+file1+file2+file3');

my $io6 = io->rdonly->new->file('t/construct.t');
ok($io6->_rdonly);
test_file_contents(join('', map {"$_\n"} @$io6), 't/construct.t');
