use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'CGI::Application::Plugin::WSSE',
    dist_author         => 'Jaldhar H. Vyas <jaldhar@braincells.com>',
    license             => 'perl',
    build_requires => {
        'Test::More'                    => 0,
        'Test::WWW::Mechanize::CGIApp'  => 0,
    },
    requires => {
        'perl'                          => 5.008,
        'CGI::Application'              => 4.04,
        'Digest::SHA1'                  => 0,
        'Params::Validate'              => 0,
    },
    add_to_cleanup      => [ 'CGI-Application-Plugin-WSSE-*' ],
    create_makefile_pl  => 'small',
    sign                => 1,
    meta_merge => {
        resources => {
            repository  => 'http://github.com/jaldhar/CGI-Application-Plugin-WSSE',
            homepage    => 'http://jaldhar.github.com/CGI-Application-Plugin-WSSE',
        },
    },

);

$builder->create_build_script();

