/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.utils.Command;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;

public class ArraySetItemHandler
extends AbstractHandler {
    @Override
    Object process(Command command) throws Exception {
        if (command.getPayload()[0] instanceof Object[]) {
            return this.setArrayElement(command);
        }
        if (command.getPayload()[0] instanceof List) {
            return this.setListElement(command);
        }
        if (command.getPayload()[0] instanceof Map) {
            return this.setMapElement(command);
        }
        if (command.getPayload()[0] instanceof Dictionary) {
            return this.setDictionaryElement(command);
        }
        throw new Exception(String.format("Cannot set element from %s", command.getPayload()[0]));
    }

    private Object setArrayElement(Command command) throws Exception {
        Object array = command.getPayload()[0];
        Object[] indexes = command.getPayload()[1] instanceof Object[] ? (Object[])command.getPayload()[2] : new Object[]{command.getPayload()[2]};
        Object value = command.getPayload()[1];
        switch (indexes.length) {
            case 1: {
                ((Object[])array)[((Integer)indexes[0]).intValue()] = value;
                break;
            }
            case 2: {
                ((Object[][])array)[((Integer)indexes[0]).intValue()][((Integer)indexes[1]).intValue()] = value;
                break;
            }
            case 3: {
                ((Object[][][])array)[((Integer)indexes[0]).intValue()][((Integer)indexes[1]).intValue()][((Integer)indexes[2]).intValue()] = value;
                break;
            }
            default: {
                throw new Exception("ArrayGetItemHandler exception");
            }
        }
        return 0;
    }

    private Object setListElement(Command command) {
        List list = (List)command.getPayload()[0];
        Integer index = (Integer)command.getPayload()[1];
        Object value = command.getPayload()[2];
        return list.set(index, value);
    }

    private Object setMapElement(Command command) {
        Map map = (Map)command.getPayload()[0];
        Object key = command.getPayload()[1];
        Object value = command.getPayload()[2];
        return map.put(key, value);
    }

    private Object setDictionaryElement(Command command) {
        Dictionary dict = (Dictionary)command.getPayload()[0];
        Object key = command.getPayload()[1];
        Object value = command.getPayload()[2];
        return dict.put(key, value);
    }
}

