/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.sdk.java.Javonet;
import com.javonet.utils.RuntimeName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class BinariesUnloader {
    public static void extractBinariesFromJar(RuntimeName runtimeName) {
        try {
            String dir = Javonet.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String destDir = System.getProperty("user.dir");
            String binariesNativePath = BinariesUnloader.getBinariesSpecificPath("Native");
            String binariesJvmPath = BinariesUnloader.getBinariesSpecificPath(runtimeName.toString());
            JarFile jarFile = new JarFile(dir);
            BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesNativePath);
            BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesJvmPath);
            jarFile.close();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void extractNativeFromJar() {
        try {
            String dir = Javonet.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String destDir = System.getProperty("user.dir");
            String binariesNativePath = BinariesUnloader.getBinariesSpecificPath("Native");
            JarFile jarFile = new JarFile(dir);
            BinariesUnloader.extractFolderFromJar(jarFile, destDir, binariesNativePath);
            jarFile.close();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static void extractFolderFromJar(JarFile jar, String destDir, String folderPath) throws IOException {
        if (!Files.isDirectory(Paths.get(folderPath, new String[0]), new LinkOption[0])) {
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                int len;
                JarEntry file = enumEntries.nextElement();
                File f = new File(destDir + File.separator + file.getName());
                if (file.isDirectory() && file.getName().startsWith(folderPath)) {
                    f.mkdirs();
                    continue;
                }
                if (!file.getName().startsWith(folderPath)) continue;
                InputStream in = jar.getInputStream(file);
                WeakReference<File> fRef = new WeakReference<File>(f);
                f = null;
                FileOutputStream out = new FileOutputStream((File)Objects.requireNonNull(fRef.get()));
                WeakReference<FileOutputStream> outRef = new WeakReference<FileOutputStream>(out);
                out = null;
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((FileOutputStream)Objects.requireNonNull(outRef.get())).write(buf, 0, len);
                }
                in.close();
                ((FileOutputStream)Objects.requireNonNull(outRef.get())).close();
            }
        }
    }

    private static String getBinariesSpecificPath(String runtimeLib) {
        String osArch = "X64";
        String binariesPath = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win") ? "Binaries/" + runtimeLib + "/Windows/" + osArch + "/" : (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac") ? "Binaries/" + runtimeLib + "/MacOs/" + osArch + "/" : "Binaries/" + runtimeLib + "/Linux/" + osArch + "/");
        return binariesPath;
    }
}

