use ExtUtils::MakeMaker;
use strict;
use warnings;

my %WriteMakefileArgs = (
    NAME                => 'JavonetPerlSdk',
    VERSION_FROM        => 'VERSION',
    AUTHOR              => 'SdNCenter Sp. z o.o',
    ABSTRACT            => 'Javonet SDK for Perl',
    INSTALLDIRS         => ($] < 5.011 ? 'perl' : 'site'),
    PREREQ_PM           => {
         'Path::Tiny' => '0',
		 'Data::Cmp' => '0',
		 'Data::UUID' => '0',
		 'FFI::Platypus' => '0',
		 'Moose' => '0',
		 'aliased' => '0',
		 'Scalar::Util::Numeric' => '0',
		 'Attribute::Abstract' => '0',
		 'Nice::Try' => '0',
		 'autobox::universal' => '0',
    },
    ( eval { ExtUtils::MakeMaker->VERSION(6.46) } ? () : ( META_MERGE => {
        'meta-spec' => { version => 2 },
        dynamic_config => 1,
    })),
);

WriteMakefile(%WriteMakefileArgs);
