/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler.loadlibrary;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarAdder {
    public static void addJarToClasspath(File jarFile) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Class<?> clazz = cl.getClass();
        Method method = clazz.getSuperclass().getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        JarAdder.checkJarFile(jarFile);
        method.invoke((Object)cl, jarFile.toURI().toURL());
    }

    private static int getJavaMajorVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        int index = javaVersion.indexOf(46);
        if (index != -1) {
            javaVersion = javaVersion.substring(index + 1);
        }
        return Integer.parseInt(javaVersion) + 44;
    }

    private static void checkJarFile(File jarFile) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                InputStream stream = jar.getInputStream(entry);
                Throwable throwable = null;
                try {
                    int jarFileMajorVersion;
                    byte[] buffer = new byte[8];
                    if (stream.read(buffer) != 8 || (jarFileMajorVersion = (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF) <= JarAdder.getJavaMajorVersion()) continue;
                    throw new IOException("Unsupported class file version " + jarFileMajorVersion + " for " + entry.getName() + "Your java version is " + System.getProperty("java.version") + ". Please recompile the class with a compatible version.");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
        }
    }
}

