/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeSerializer;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;

public class CommandSerializer {
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private Deque<Command> deque = new ArrayDeque<Command>();

    public byte[] serialize(Command root, ConnectionType connectionType, TcpConnectionData tcpConnectionData) {
        this.byteBuffer = ByteBuffer.allocate(0);
        this.deque.push(root);
        this.insertIntoBuffer(new byte[]{(byte)root.getRuntimeName().ordinal(), 0});
        this.serializeTcp(connectionType, tcpConnectionData);
        this.insertIntoBuffer(new byte[]{(byte)RuntimeName.Jvm.ordinal(), (byte)root.getCommandType().ordinal()});
        return this.serializeRecursively(this.deque);
    }

    private void serializeTcp(ConnectionType connectionType, TcpConnectionData tcpConnectionData) {
        this.insertIntoBuffer(new byte[]{(byte)connectionType.ordinal()});
        if (connectionType == ConnectionType.TCP) {
            this.insertIntoBuffer(tcpConnectionData.getAddressBytes());
            this.insertIntoBuffer(tcpConnectionData.getPortBytes());
        } else {
            this.insertIntoBuffer(new byte[]{0, 0, 0, 0, 0, 0});
        }
    }

    private byte[] serializeRecursively(Deque<Command> deque) {
        if (deque.isEmpty()) {
            return this.byteBuffer.array();
        }
        Command cmd = deque.pop();
        deque.push(cmd.dropFirstPayloadArg());
        if (cmd.getPayload().length > 0) {
            if (cmd.getPayload()[0] != null && cmd.getPayload()[0] instanceof Command) {
                Command innerCommand = (Command)cmd.getPayload()[0];
                this.insertIntoBuffer(TypeSerializer.serializeCommand(innerCommand));
                deque.push(innerCommand);
            } else {
                byte[] result = TypeSerializer.serializePrimitive(cmd.getPayload()[0]);
                this.insertIntoBuffer(result);
            }
        } else {
            deque.pop();
        }
        return this.serializeRecursively(deque);
    }

    private void insertIntoBuffer(byte[] arg) {
        ByteBuffer newByteBuffer = ByteBuffer.allocate(arg.length + this.byteBuffer.limit());
        newByteBuffer.put(this.byteBuffer.array());
        newByteBuffer.put(arg);
        this.byteBuffer = newByteBuffer;
    }
}

