/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.transmitter;

import com.javonet.core.transmitter.TransmitterWrapper;
import com.javonet.utils.RuntimeName;

public class Transmitter {
    public static synchronized byte[] sendCommand(byte[] messageByteArray) {
        int responseByteArrayLen = TransmitterWrapper.sendCommand(messageByteArray);
        if (responseByteArrayLen > 0) {
            byte[] responseByteArray = new byte[responseByteArrayLen];
            TransmitterWrapper.readResponse(responseByteArray);
            return responseByteArray;
        }
        if (responseByteArrayLen == 0) {
            String errorMessage = "Response is empty";
            throw new RuntimeException(errorMessage);
        }
        String errorMessage = TransmitterWrapper.getNativeError();
        throw new RuntimeException("Javonet native error code: " + responseByteArrayLen + ". " + errorMessage);
    }

    public static boolean deployRuntime(byte[] byteArray, String path, byte channel) {
        return TransmitterWrapper.deployRuntime(byteArray, path, channel);
    }

    public static boolean setEmbeddedRuntime(byte calledRuntimeNumber, byte calledRuntimeVersion, String path) {
        return TransmitterWrapper.setEmbeddedRuntime((byte)RuntimeName.Jvm.ordinal(), calledRuntimeNumber, calledRuntimeVersion, path);
    }

    public static int activate(String licenseKey) {
        int activationResult = TransmitterWrapper.activate(licenseKey, "", "", "");
        if (activationResult < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet activation result: " + activationResult + ". Native error message: " + errorMessage);
        }
        return activationResult;
    }

    public static int setConfigSource(String configSource) {
        int setConfigResult = TransmitterWrapper.setConfigSource(configSource);
        if (setConfigResult < 0) {
            String errorMessage = TransmitterWrapper.getNativeError();
            throw new RuntimeException("Javonet set config source result: " + setConfigResult + ". Native error message: " + errorMessage);
        }
        return setConfigResult;
    }
}

