/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ExceptionType;
import java.util.Arrays;
import java.util.Optional;

public class ExceptionSerializer {
    public static Command serializeException(Throwable exception, Command command) {
        Command exceptionCommand = new Command(command.getRuntimeName(), CommandType.EXCEPTION, new Object[0]);
        boolean isDebug = false;
        StringBuilder stackClasses = new StringBuilder();
        StringBuilder stackMethods = new StringBuilder();
        StringBuilder stackLines = new StringBuilder();
        StringBuilder stackFiles = new StringBuilder();
        StackTraceElement[] stackTraceElements = isDebug ? exception.getStackTrace() : ExceptionSerializer.getStackTraceAfterReflection(exception.getStackTrace());
        ExceptionSerializer.serializeStackTrace(stackTraceElements, stackClasses, stackMethods, stackLines, stackFiles);
        exceptionCommand = exceptionCommand.addArgToPayload(ExceptionSerializer.getExceptionCode(exception));
        exceptionCommand = exceptionCommand.addArgToPayload(command.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(exception.getClass().getName());
        exceptionCommand = exceptionCommand.addArgToPayload(exception.getMessage());
        exceptionCommand = exceptionCommand.addArgToPayload(stackClasses.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackMethods.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackLines.toString());
        exceptionCommand = exceptionCommand.addArgToPayload(stackFiles.toString());
        return exceptionCommand;
    }

    private static void serializeStackTrace(StackTraceElement[] stackTraceElements, StringBuilder stackClasses, StringBuilder stackMethods, StringBuilder stackLines, StringBuilder stackFiles) {
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            stackClasses.append(Optional.of(stackTraceElement.getClassName()).orElse("undefined")).append("|");
            stackMethods.append(Optional.of(stackTraceElement.getMethodName()).orElse("undefined")).append("|");
            stackLines.append(Optional.of(stackTraceElement.getLineNumber()).orElse(0)).append("|");
            stackFiles.append(Optional.ofNullable(stackTraceElement.getFileName()).orElse("undefined")).append("|");
        }
    }

    private static StackTraceElement[] getStackTraceAfterReflection(StackTraceElement[] stackTrace) {
        int index = 0;
        for (StackTraceElement element : stackTrace) {
            if (element.getClassName().contains("javonet") || element.getClassName().contains("reflect")) break;
            ++index;
        }
        return Arrays.copyOfRange(stackTrace, 0, index);
    }

    private static Object getExceptionCode(Throwable exception) {
        switch (exception.getClass().getSimpleName()) {
            case "IOException": {
                return ExceptionType.IO_EXCEPTION.ordinal();
            }
            case "FileNotFoundException": {
                return ExceptionType.FILE_NOT_FOUND_EXCEPTION.ordinal();
            }
            case "RuntimeException": {
                return ExceptionType.RUNTIME_EXCEPTION.ordinal();
            }
            case "ArithmeticException": {
                return ExceptionType.ARITHMETIC_EXCEPTION.ordinal();
            }
            case "IllegalArgumentException": {
                return ExceptionType.ILLEGAL_ARGUMENT_EXCEPTION.ordinal();
            }
            case "IndexOutOfBoundsException": 
            case "StringIndexOutOfBoundsException": 
            case "ArrayIndexOutOfBoundsException": {
                return ExceptionType.INDEX_OUT_OF_BOUNDS_EXCEPTION.ordinal();
            }
            case "NullPointerException": {
                return ExceptionType.NULL_POINTER_EXCEPTION.ordinal();
            }
        }
        return ExceptionType.EXCEPTION.ordinal();
    }
}

