/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.referencecache;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReferencesCache {
    private static final ConcurrentMap<String, Object> REFERENCES_CACHE = new ConcurrentHashMap<String, Object>();
    private static ReferencesCache instance;

    private ReferencesCache() {
    }

    public static ReferencesCache getInstance() {
        if (instance == null) {
            instance = new ReferencesCache();
        }
        return instance;
    }

    public String cacheReference(Object reference) {
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        REFERENCES_CACHE.putIfAbsent(uuidString, reference);
        return uuidString;
    }

    public static boolean deleteReference(String uuidString) {
        Object result = REFERENCES_CACHE.remove(uuidString);
        return result == null;
    }

    public Object resolveReference(String uuidString) {
        return REFERENCES_CACHE.get(uuidString);
    }
}

