/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.interpreter;

import com.javonet.core.handler.Handler;
import com.javonet.core.protocol.CommandDeserializer;
import com.javonet.core.protocol.CommandSerializer;
import com.javonet.core.receiver.Receiver;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.core.websocket.WebSocketClient;
import com.javonet.utils.Command;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.connectiondata.IConnectionData;
import com.javonet.utils.exceptions.ExceptionSerializer;
import java.net.URI;

public class Interpreter {
    private final Handler handler = new Handler();

    public Command execute(Command command, IConnectionData connectionData) {
        byte[] messageByteArray = new CommandSerializer().serialize(command, connectionData);
        byte[] response = new byte[]{};
        if (connectionData.getConnectionType() == ConnectionType.WEB_SOCKET) {
            try {
                response = WebSocketClient.sendMessage(new URI(connectionData.getHostname()), messageByteArray);
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    return ExceptionSerializer.serializeException(e.getCause(), command);
                }
                return ExceptionSerializer.serializeException(e, command);
            }
        } else {
            response = command.getRuntimeName() == RuntimeName.Jvm && connectionData.getConnectionType() == ConnectionType.IN_MEMORY ? new Receiver().sendCommand(messageByteArray) : Transmitter.sendCommand(messageByteArray);
        }
        return new CommandDeserializer(response).deserialize();
    }

    public Command process(byte[] byteArray) {
        Command receivedCommand = new CommandDeserializer(byteArray).deserialize();
        return this.handler.handleCommand(receivedCommand);
    }
}

