/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.connectiondata;

import com.javonet.utils.ConnectionType;
import com.javonet.utils.connectiondata.IConnectionData;
import java.util.Objects;

public class WsConnectionData
implements IConnectionData {
    private String hostName = "";
    private final ConnectionType connectionType = ConnectionType.WEB_SOCKET;

    public WsConnectionData(String hostname) {
        this.hostName = hostname;
    }

    @Override
    public byte[] serializeConnectionData() {
        return new byte[]{(byte)this.getConnectionType().ordinal(), 0, 0, 0, 0, 0, 0};
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public String getHostname() {
        return this.hostName;
    }

    public String toString() {
        return this.hostName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WsConnectionData that = (WsConnectionData)o;
        return Objects.equals(this.hostName, that.hostName);
    }

    public int hashCode() {
        return Objects.hash(this.hostName);
    }
}

