use Mojo::XMLRPC;
use Mojo::Util;

use Mojo::DOM;

my $xmltest = <<'XML';
<?xml version="1.0" encoding="UTF-8"?>
<methodResponse>
    <params>
        <param>
            <value>
                <array>
                    <data>
                        <value>
                            <struct>
                                <member>
                                    <name>Contact.OwnerID</name>
                                    <value>
                                        <i4>6</i4>
                                    </value>
                                </member>
                                <member>
                                    <name>Contact.LastName</name>
                                    <value>Wheat</value>
                                </member>
                                <member>
                                    <name>DateCreated</name>
                                    <value>
                                        <dateTime.iso8601>20160303T11:58:50</dateTime.iso8601>
                                    </value>
                                </member>
                                <member>
                                    <name>Contact.FirstName</name>
                                    <value>Kiel</value>
                                </member>
                                <member>
                                    <name>ContactId</name>
                                    <value>
                                        <i4>3510</i4>
                                    </value>
                                </member>
                                <member>
                                    <name>ContactGroup</name>
                                    <value>DNA Mentoring - Active</value>
                                </member>
                                <member>
                                    <name>Contact.Email</name>
                                    <value>Kiel.wheat@gmail.com</value>
                                </member>
                            </struct>
                        </value>
                        <value>
                            <struct>
                                <member>
                                    <name>Contact.OwnerID</name>
                                    <value>
                                        <i4>6</i4>
                                    </value>
                                </member>
                                <member>
                                    <name>Contact.LastName</name>
                                    <value>Westbom</value>
                                </member>
                                <member>
                                    <name>DateCreated</name>
                                    <value>
                                        <dateTime.iso8601>20160303T11:00:26</dateTime.iso8601>
                                    </value>
                                </member>
                                <member>
                                    <name>Contact.FirstName</name>
                                    <value>Daniel</value>
                                </member>
                                <member>
                                    <name>ContactId</name>
                                    <value>
                                        <i4>8194</i4>
                                    </value>
                                </member>
                                <member>
                                    <name>ContactGroup</name>
                                    <value>DNA Mentoring - Active</value>
                                </member>
                                <member>
                                    <name>Contact.Email</name>
                                    <value>dwestbom@hotmail.com</value>
                                </member>
                            </struct>
                        </value>
                    </data>
                </array>
            </value>
        </param>
    </params>
</methodResponse>
XML

my $res = Mojo::XMLRPC::from_xmlrpc($xmltest);
print Mojo::Util::dumper $res;

