#!/usr/bin/perl
# Do not normalise this test file. It has deliberately unnormalised characters in it.
use v5.10;
use strict;
use warnings;
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Test::More tests => 290;
use Test::Exception;

use ok 'Locale::CLDR';

my $locale = Locale::CLDR->new('cy_GB');

is($locale->unit(1, 'acre', 'narrow'), '1erw', 'Welsh narrow 1 acre');
is($locale->unit(2, 'acre', 'narrow'), '2erw', 'Welsh narrow 2 acres');
is($locale->unit(1, 'acre', 'short'), '1 erw', 'Welsh short 1 acre');
is($locale->unit(2, 'acre', 'short'), '2 erw', 'Welsh short 2 acres');
is($locale->unit(1, 'acre'), '1 erw', 'Welsh long 1 acre');
is($locale->unit(2, 'acre'), '2 erw', 'Welsh long 2 acres');
is($locale->unit(1, 'arc-minute', 'narrow'), '1′', 'Welsh narrow 1 minute');
is($locale->unit(2, 'arc-minute', 'narrow'), '2′', 'Welsh narrow 2 minutes');
is($locale->unit(1, 'arc-minute', 'short'), '1′', 'Welsh short 1 arc minute');
is($locale->unit(2, 'arc-minute', 'short'), '2′', 'Welsh short 2 arc minutes');
is($locale->unit(1, 'arc-minute'), '1 arcfunud', 'Welsh long 1 arc minute');
is($locale->unit(2, 'arc-minute'), '2 arcfunud', 'Welsh long 2 arc minutes');
is($locale->unit(1, 'arc-second', 'narrow'), '1″', 'Welsh narrow 1 second');
is($locale->unit(2, 'arc-second', 'narrow'), '2″', 'Welsh narrow 2 seconds');
is($locale->unit(1, 'arc-second', 'short'), '1″', 'Welsh short 1 arc second');
is($locale->unit(2, 'arc-second', 'short'), '2″', 'Welsh short 2 arc seconds');
is($locale->unit(1, 'arc-second'), '1 arceiliad', 'Welsh long 1 arc second');
is($locale->unit(2, 'arc-second'), '2 arceiliad', 'Welsh long 2 arc seconds');
is($locale->unit(1, 'celsius', 'narrow'), '1°', 'Welsh narrow 1 degree Celsius');
is($locale->unit(2, 'celsius', 'narrow'), '2°', 'Welsh narrow 2 degrees Celsius');
is($locale->unit(1, 'celsius', 'short'), '1°C', 'Welsh short 1 degree Celsius');
is($locale->unit(2, 'celsius', 'short'), '2°C', 'Welsh short 2 degrees Celsius');
is($locale->unit(1, 'celsius'), '1 radd Celsius', 'Welsh long 1 degree Celsius');
is($locale->unit(2, 'celsius'), '2 radd Celsius', 'Welsh long 2 degrees Celsius');
is($locale->unit(1, 'centimeter', 'narrow'), '1cm', 'Welsh narrow 1 centimetre');
is($locale->unit(2, 'centimeter', 'narrow'), '2cm', 'Welsh narrow 2 centimetres');
is($locale->unit(1, 'centimeter', 'short'), '1 cm', 'Welsh short 1 centimetre');
is($locale->unit(2, 'centimeter', 'short'), '2 cm', 'Welsh short 2 centimetres');
is($locale->unit(1, 'centimeter'), '1 centimetr', 'Welsh long 1 centimetre');
is($locale->unit(2, 'centimeter'), '2 gentimetr', 'Welsh long 2 centimetres');
is($locale->unit(1, 'cubic-kilometer', 'narrow'), '1km³', 'Welsh narrow 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'narrow'), '2km³', 'Welsh narrow 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer', 'short'), '1 km³', 'Welsh short 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer', 'short'), '2 km³', 'Welsh short 2 cubic kilometres');
is($locale->unit(1, 'cubic-kilometer'), '1 cilometr ciwbig', 'Welsh long 1 cubic kilometre');
is($locale->unit(2, 'cubic-kilometer'), '2 gilometr ciwbig', 'Welsh long 2 cubic kilometres');
is($locale->unit(1, 'cubic-mile', 'narrow'), '1mi³', 'Welsh narrow 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'narrow'), '2mi³', 'Welsh narrow 2 cubic miles');
is($locale->unit(1, 'cubic-mile', 'short'), '1 mi³', 'Welsh short 1 cubic mile');
is($locale->unit(2, 'cubic-mile', 'short'), '2 mi³', 'Welsh short 2 cubic miles');
is($locale->unit(1, 'cubic-mile'), '1 filltir giwbig', 'Welsh long 1 cubic mile');
is($locale->unit(2, 'cubic-mile'), '2 filltir giwbig', 'Welsh long 2 cubic miles');
is($locale->unit(1, 'day', 'narrow'), '1d', 'Welsh narrow 1 day');
is($locale->unit(2, 'day', 'narrow'), '2d', 'Welsh narrow 2 days');
is($locale->unit(1, 'day', 'short'), '1 diwrnod', 'Welsh short 1 day');
is($locale->unit(2, 'day', 'short'), '2 ddiwrnod', 'Welsh short 2 days');
is($locale->unit(1, 'day'), '1 diwrnod', 'Welsh long 1 day');
is($locale->unit(2, 'day'), '2 ddiwrnod', 'Welsh long 2 days');
is($locale->unit(1, 'degree', 'narrow'), '1°', 'Welsh narrow 1 degree');
is($locale->unit(2, 'degree', 'narrow'), '2°', 'Welsh narrow 2 degrees');
is($locale->unit(1, 'degree', 'short'), '1°', 'Welsh short 1 degree');
is($locale->unit(2, 'degree', 'short'), '2°', 'Welsh short 2 degree');
is($locale->unit(1, 'degree'), '1 radd', 'Welsh long 1 degree');
is($locale->unit(2, 'degree'), '2 radd', 'Welsh long 2 degrees');
is($locale->unit(1, 'fahrenheit', 'narrow'), '1°F', 'Welsh narrow 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'narrow'), '2°F', 'Welsh narrow 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit', 'short'), '1°F', 'Welsh short 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit', 'short'), '2°F', 'Welsh short 2 degrees Fahrenheit');
is($locale->unit(1, 'fahrenheit'), '1 radd Fahrenheit', 'Welsh long 1 degree Fahrenheit');
is($locale->unit(2, 'fahrenheit'), '2 radd Fahrenheit', 'Welsh long 2 degrees Fahrenheit');
is($locale->unit(1, 'foot', 'narrow'), '1′', 'Welsh narrow 1 foot');
is($locale->unit(2, 'foot', 'narrow'), '2′', 'Welsh narrow 2 feet');
is($locale->unit(1, 'foot', 'short'), '1′', 'Welsh short 1 foot');
is($locale->unit(2, 'foot', 'short'), '2′', 'Welsh short 2 feet');
is($locale->unit(1, 'foot'), '1 droedfedd', 'Welsh long 1 foot');
is($locale->unit(2, 'foot'), '2 droedfedd', 'Welsh long 2 feet');
is($locale->unit(1, 'g-force', 'narrow'), '1G', 'Welsh narrow 1 g-force');
is($locale->unit(2, 'g-force', 'narrow'), '2G', 'Welsh narrow 2 g-force');
is($locale->unit(1, 'g-force', 'short'), '1 G', 'Welsh short 1 g-force');
is($locale->unit(2, 'g-force', 'short'), '2 G', 'Welsh short 2 g-force');
is($locale->unit(1, 'g-force'), '1 grym disgyrchedd', 'Welsh long 1 g-force');
is($locale->unit(2, 'g-force'), '2 rym disgyrchedd', 'Welsh long 2 g-force');
is($locale->unit(1, 'gram', 'narrow'), '1g', 'Welsh narrow 1 gram');
is($locale->unit(2, 'gram', 'narrow'), '2g', 'Welsh narrow 2 grams');
is($locale->unit(1, 'gram', 'short'), '1 g', 'Welsh short 1 gram');
is($locale->unit(2, 'gram', 'short'), '2 g', 'Welsh short 2 grams');
is($locale->unit(1, 'gram'), '1 gram', 'Welsh long 1 gram');
is($locale->unit(2, 'gram'), '2 gram', 'Welsh long 2 grams');
is($locale->unit(1, 'hectare', 'narrow'), '1ha', 'Welsh narrow 1 hectare');
is($locale->unit(2, 'hectare', 'narrow'), '2ha', 'Welsh narrow 2 hectares');
is($locale->unit(1, 'hectare', 'short'), '1 ha', 'Welsh short 1 hectare');
is($locale->unit(2, 'hectare', 'short'), '2 ha', 'Welsh short 2 hectares');
is($locale->unit(1, 'hectare'), '1 hectar', 'Welsh long 1 hectare');
is($locale->unit(2, 'hectare'), '2 hectar', 'Welsh long 2 hectares');
is($locale->unit(1, 'hectopascal', 'narrow'), '1hPa', 'Welsh narrow 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'narrow'), '2hPa', 'Welsh narrow 2 hectopascals');
is($locale->unit(1, 'hectopascal', 'short'), '1 hPa', 'Welsh short 1 hectopascal');
is($locale->unit(2, 'hectopascal', 'short'), '2 hPa', 'Welsh short 2 hectopascals');
is($locale->unit(1, 'hectopascal'), '1 hectopascal', 'Welsh long 1 hectopascal');
is($locale->unit(2, 'hectopascal'), '2 hectopascal', 'Welsh long 2 hectopascals');
is($locale->unit(1, 'horsepower', 'narrow'), '1hp', 'Welsh narrow 1 horsepower');
is($locale->unit(2, 'horsepower', 'narrow'), '2hp', 'Welsh narrow 2 horsepower');
is($locale->unit(1, 'horsepower', 'short'), '1 hp', 'Welsh short 1 horsepower');
is($locale->unit(2, 'horsepower', 'short'), '2 hp', 'Welsh short 2 horsepower');
is($locale->unit(1, 'horsepower'), '1 marchnerth', 'Welsh long 1 horsepower');
is($locale->unit(2, 'horsepower'), '2 farchnerth', 'Welsh long 2 horsepower');
is($locale->unit(1, 'hour', 'narrow'), '1 awr', 'Welsh narrow 1 hour');
is($locale->unit(2, 'hour', 'narrow'), '2 awr', 'Welsh narrow 2 hours');
is($locale->unit(1, 'hour', 'short'), '1 awr', 'Welsh short 1 hour');
is($locale->unit(2, 'hour', 'short'), '2 awr', 'Welsh short 2 hours');
is($locale->unit(1, 'hour'), '1 awr', 'Welsh long 1 hour');
is($locale->unit(2, 'hour'), '2 awr', 'Welsh long 2 hours');
is($locale->unit(1, 'inch', 'narrow'), '1″', 'Welsh narrow 1 inch');
is($locale->unit(2, 'inch', 'narrow'), '2″', 'Welsh narrow 2 inches');
is($locale->unit(1, 'inch', 'short'), '1 fodfedd', 'Welsh short 1 inch');
is($locale->unit(2, 'inch', 'short'), '2 fodfedd', 'Welsh short 2 inches');
is($locale->unit(1, 'inch'), '1 fodfedd', 'Welsh long 1 inch');
is($locale->unit(2, 'inch'), '2 fodfedd', 'Welsh long 2 inches');
is($locale->unit(1, 'inch-hg', 'narrow'), '1" Hg', 'Welsh narrow 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'narrow'), '2" Hg', 'Welsh narrow 2 inches of mercury');
is($locale->unit(1, 'inch-hg', 'short'), '1 ″ Hg', 'Welsh short 1 inch of mercury');
is($locale->unit(2, 'inch-hg', 'short'), '2 ″ Hg', 'Welsh short 2 inches of mercury');
is($locale->unit(1, 'inch-hg'), '1 fodfedd o fercwri', 'Welsh long 1 inch of mercury');
is($locale->unit(2, 'inch-hg'), '2 fodfedd o fercwri', 'Welsh long 2 inches of mercury');
is($locale->unit(1, 'kilogram', 'narrow'), '1kg', 'Welsh narrow 1 kilogram');
is($locale->unit(2, 'kilogram', 'narrow'), '2kg', 'Welsh narrow 2 kilograms');
is($locale->unit(1, 'kilogram', 'short'), '1 kg', 'Welsh short 1 kilogram');
is($locale->unit(2, 'kilogram', 'short'), '2 kg', 'Welsh short 2 kilograms');
is($locale->unit(1, 'kilogram'), '1 cilogram', 'Welsh long 1 kilogram');
is($locale->unit(2, 'kilogram'), '2 gilogram', 'Welsh long 2 kilograms');
is($locale->unit(1, 'kilometer', 'narrow'), '1km', 'Welsh narrow 1 kilometre');
is($locale->unit(2, 'kilometer', 'narrow'), '2km', 'Welsh narrow 2 kilometres');
is($locale->unit(1, 'kilometer', 'short'), '1 km', 'Welsh short 1 kilometre');
is($locale->unit(2, 'kilometer', 'short'), '2 km', 'Welsh short 2 kilometres');
is($locale->unit(1, 'kilometer'), '1 cilometr', 'Welsh long 1 kilometre');
is($locale->unit(2, 'kilometer'), '2 gilometr', 'Welsh long 2 kilometres');
is($locale->unit(1, 'kilometer-per-hour', 'narrow'), '1km/h', 'Welsh narrow 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'narrow'), '2km/h', 'Welsh narrow 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour', 'short'), '1 km/h', 'Welsh short 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour', 'short'), '2 km/h', 'Welsh short 2 kilometres per hour');
is($locale->unit(1, 'kilometer-per-hour'), '1 cilometr yr awr', 'Welsh long 1 kilometre per hour');
is($locale->unit(2, 'kilometer-per-hour'), '2 gilometr yr awr', 'Welsh long 2 kilometres per hour');
is($locale->unit(1, 'kilowatt', 'narrow'), '1kW', 'Welsh narrow 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'narrow'), '2kW', 'Welsh narrow 2 kilowatts');
is($locale->unit(1, 'kilowatt', 'short'), '1 kW', 'Welsh short 1 kilowatt');
is($locale->unit(2, 'kilowatt', 'short'), '2 kW', 'Welsh short 2 kilowatts');
is($locale->unit(1, 'kilowatt'), '1 cilowat', 'Welsh long 1 kilowatt');
is($locale->unit(2, 'kilowatt'), '2 gilowat', 'Welsh long 2 kilowatts');
is($locale->unit(1, 'light-year', 'narrow'), '1ly', 'Welsh narrow 1 light year');
is($locale->unit(2, 'light-year', 'narrow'), '2ly', 'Welsh narrow 2 light years');
is($locale->unit(1, 'light-year', 'short'), '1 flwyddyn golau', 'Welsh short 1 light year');
is($locale->unit(2, 'light-year', 'short'), '2 flwyddyn golau', 'Welsh short 2 light years');
is($locale->unit(1, 'light-year'), '1 flwyddyn golau', 'Welsh long 1 light year');
is($locale->unit(2, 'light-year'), '2 flwyddyn golau', 'Welsh long 2 light years');
is($locale->unit(1, 'liter', 'narrow'), '1 L', 'Welsh narrow 1 litre');
is($locale->unit(2, 'liter', 'narrow'), '2 L', 'Welsh narrow 2 litres');
is($locale->unit(1, 'liter', 'short'), '1 L', 'Welsh short 1 litre');
is($locale->unit(2, 'liter', 'short'), '2 L', 'Welsh short 2 litres');
is($locale->unit(1, 'liter'), '1 litr', 'Welsh long 1 litre');
is($locale->unit(2, 'liter'), '2 litr', 'Welsh long 2 litres');
is($locale->unit(1, 'meter', 'narrow'), '1m', 'Welsh narrow 1 meter');
is($locale->unit(2, 'meter', 'narrow'), '2m', 'Welsh narrow 2 meters');
is($locale->unit(1, 'meter', 'short'), '1 m', 'Welsh short 1 meter');
is($locale->unit(2, 'meter', 'short'), '2 m', 'Welsh short 2 meters');
is($locale->unit(1, 'meter'), '1 metr', 'Welsh long 1 meter');
is($locale->unit(2, 'meter'), '2 fetr', 'Welsh long 2 meters');
is($locale->unit(1, 'meter-per-second', 'narrow'), '1m/s', 'Welsh narrow 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'narrow'), '2m/s', 'Welsh narrow 2 meters per second');
is($locale->unit(1, 'meter-per-second', 'short'), '1 m/s', 'Welsh short 1 meter per second');
is($locale->unit(2, 'meter-per-second', 'short'), '2 m/s', 'Welsh short 2 meters per second');
is($locale->unit(1, 'meter-per-second'), '1 metr yr eiliad', 'Welsh long 1 meter per second');
is($locale->unit(2, 'meter-per-second'), '2 fetr yr eiliad', 'Welsh long 2 meters per second');
is($locale->unit(1, 'mile', 'narrow'), '1mi', 'Welsh narrow 1 mile');
is($locale->unit(2, 'mile', 'narrow'), '2mi', 'Welsh narrow 2 miles');
is($locale->unit(1, 'mile', 'short'), '1 mi', 'Welsh short 1 mile');
is($locale->unit(2, 'mile', 'short'), '2 mi', 'Welsh short 2 miles');
is($locale->unit(1, 'mile'), '1 filltir', 'Welsh long 1 mile');
is($locale->unit(2, 'mile'), '2 filltir', 'Welsh long 2 miles');
is($locale->unit(1, 'mile-per-hour', 'narrow'), '1m.y.a.', 'Welsh narrow 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'narrow'), '2m.y.a.', 'Welsh narrow 2 miles per hour');
is($locale->unit(1, 'mile-per-hour', 'short'), '1 m.y.a.', 'Welsh short 1 mile per hour');
is($locale->unit(2, 'mile-per-hour', 'short'), '2 m.y.a.', 'Welsh short 2 miles per hour');
is($locale->unit(1, 'mile-per-hour'), '1 filltir yr awr', 'Welsh long 1 mile per hour');
is($locale->unit(2, 'mile-per-hour'), '2 filltir yr awr', 'Welsh long 2 miles per hour');
is($locale->unit(1, 'millibar', 'narrow'), '1mb', 'Welsh narrow 1 millibar');
is($locale->unit(2, 'millibar', 'narrow'), '2mb', 'Welsh narrow 2 millibars');
is($locale->unit(1, 'millibar', 'short'), '1 mbar', 'Welsh short 1 millibar');
is($locale->unit(2, 'millibar', 'short'), '2 mbar', 'Welsh short 2 millibars');
is($locale->unit(1, 'millibar'), '1 milibar', 'Welsh long 1 millibar');
is($locale->unit(2, 'millibar'), '2 filibar', 'Welsh long 2 millibars');
is($locale->unit(1, 'millimeter', 'narrow'), '1mm', 'Welsh narrow 1 millimetre');
is($locale->unit(2, 'millimeter', 'narrow'), '2mm', 'Welsh narrow 2 millimetres');
is($locale->unit(1, 'millimeter', 'short'), '1 mm', 'Welsh short 1 millimetre');
is($locale->unit(2, 'millimeter', 'short'), '2 mm', 'Welsh short 2 millimetres');
is($locale->unit(1, 'millimeter'), '1 milimetr', 'Welsh long 1 millimetre');
is($locale->unit(2, 'millimeter'), '2 filimetr', 'Welsh long 2 millimetres');
is($locale->unit(1, 'millisecond', 'narrow'), '1ms', 'Welsh narrow 1 millisecond');
is($locale->unit(2, 'millisecond', 'narrow'), '2ms', 'Welsh narrow 2 milliseconds');
is($locale->unit(1, 'millisecond', 'short'), '1 ms', 'Welsh short 1 millisecond');
is($locale->unit(2, 'millisecond', 'short'), '2 ms', 'Welsh short 2 milliseconds');
is($locale->unit(1, 'millisecond'), '1 milieiliad', 'Welsh long 1 millisecond');
is($locale->unit(2, 'millisecond'), '2 filieiliad', 'Welsh long 2 milliseconds');
is($locale->unit(1, 'minute', 'narrow'), '1mun', 'Welsh narrow 1 minute');
is($locale->unit(2, 'minute', 'narrow'), '2mun', 'Welsh narrow 2 minutes');
is($locale->unit(1, 'minute', 'short'), '1 mun', 'Welsh short 1 minute');
is($locale->unit(2, 'minute', 'short'), '2 mun', 'Welsh short 2 minutes');
is($locale->unit(1, 'minute'), '1 munud', 'Welsh long 1 minute');
is($locale->unit(2, 'minute'), '2 funud', 'Welsh long 2 minutes');
is($locale->unit(1, 'month', 'narrow'), '1m', 'Welsh narrow 1 month');
is($locale->unit(2, 'month', 'narrow'), '2m', 'Welsh narrow 2 months');
is($locale->unit(1, 'month', 'short'), '1 mis', 'Welsh short 1 month');
is($locale->unit(2, 'month', 'short'), '2 fis', 'Welsh short 2 months');
is($locale->unit(1, 'month'), '1 mis', 'Welsh long 1 month');
is($locale->unit(2, 'month'), '2 fis', 'Welsh long 2 months');
is($locale->unit(1, 'ounce', 'narrow'), '1owns', 'Welsh narrow 1 ounce');
is($locale->unit(2, 'ounce', 'narrow'), '2owns', 'Welsh narrow 2 ounces');
is($locale->unit(1, 'ounce', 'short'), '1 owns', 'Welsh short 1 ounce');
is($locale->unit(2, 'ounce', 'short'), '2 owns', 'Welsh short 2 ounces');
is($locale->unit(1, 'ounce'), '1 owns', 'Welsh long 1 once');
is($locale->unit(2, 'ounce'), '2 owns', 'Welsh long 2 onces');
is($locale->unit(1, 'millimeter-per-second', 'narrow'), '1mm/e', 'Welsh narrow 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'narrow'), '2mm/e', 'Welsh narrow 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second', 'short'), '1 mm/eil', 'Welsh short 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second', 'short'), '2 mm/eil', 'Welsh short 2 millimetres per second');
is($locale->unit(1, 'millimeter-per-second'), '1 milimetr yr eiliad', 'Welsh long 1 millimetre per second');
is($locale->unit(2, 'millimeter-per-second'), '2 filimetr yr eiliad', 'Welsh long 2 millimetres per second');
is($locale->unit(1, 'picometer', 'narrow'), '1pm', 'Welsh narrow 1 picometre');
is($locale->unit(2, 'picometer', 'narrow'), '2pm', 'Welsh narrow 2 picometres');
is($locale->unit(1, 'picometer', 'short'), '1 pm', 'Welsh short 1 picometre');
is($locale->unit(2, 'picometer', 'short'), '2 pm', 'Welsh short 2 picometres');
is($locale->unit(1, 'picometer'), '1 picometr', 'Welsh long 1 picometre');
is($locale->unit(2, 'picometer'), '2 bicometr', 'Welsh long 2 picometres');
is($locale->unit(1, 'pound', 'narrow'), '1pwys', 'Welsh narrow 1 pound');
is($locale->unit(2, 'pound', 'narrow'), '2bwys', 'Welsh narrow 2 pounds');
is($locale->unit(1, 'pound', 'short'), '1 pwys', 'Welsh short 1 pound');
is($locale->unit(2, 'pound', 'short'), '2 bwys', 'Welsh short 2 pounds');
is($locale->unit(1, 'pound'), '1 pwys', 'Welsh long 1 pound');
is($locale->unit(2, 'pound'), '2 bwys', 'Welsh long 2 pounds');
is($locale->unit(1, 'second', 'narrow'), '1 eil', 'Welsh narrow 1 second');
is($locale->unit(2, 'second', 'narrow'), '2 eil', 'Welsh narrow 2 seconds');
is($locale->unit(1, 'second', 'short'), '1 eil', 'Welsh short 1 second');
is($locale->unit(2, 'second', 'short'), '2 eil', 'Welsh short 2 seconds');
is($locale->unit(1, 'second'), '1 eiliad', 'Welsh long 1 second');
is($locale->unit(2, 'second'), '2 eiliad', 'Welsh long 2 seconds');
is($locale->unit(1, 'square-foot', 'narrow'), '1ft²', 'Welsh narrow 1 square foot');
is($locale->unit(2, 'square-foot', 'narrow'), '2ft²', 'Welsh narrow 2 square feet');
is($locale->unit(1, 'square-foot', 'short'), '1 tr²', 'Welsh short 1 square foot');
is($locale->unit(2, 'square-foot', 'short'), '2 tr²', 'Welsh short 2 square feet');
is($locale->unit(1, 'square-foot'), '1 droedfedd sgwâr', 'Welsh long 1 square foot');
is($locale->unit(2, 'square-foot'), '2 droedfedd sgwâr', 'Welsh long 2 square feet');
is($locale->unit(1, 'square-kilometer', 'narrow'), '1km²', 'Welsh narrow 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'narrow'), '2km²', 'Welsh narrow 2 square kilometres');
is($locale->unit(1, 'square-kilometer', 'short'), '1 km²', 'Welsh short 1 square kilometre');
is($locale->unit(2, 'square-kilometer', 'short'), '2 km²', 'Welsh short 2 square kilometres');
is($locale->unit(1, 'square-kilometer'), '1 cilometr sgwâr', 'Welsh long 1 square kilometre');
is($locale->unit(2, 'square-kilometer'), '2 gilometr sgwâr', 'Welsh long 2 square kilometres');
is($locale->unit(1, 'square-meter', 'narrow'), '1m²', 'Welsh narrow 1 square meter');
is($locale->unit(2, 'square-meter', 'narrow'), '2m²', 'Welsh narrow 2 square meters');
is($locale->unit(1, 'square-meter', 'short'), '1 m²', 'Welsh short 1 square meter');
is($locale->unit(2, 'square-meter', 'short'), '2 m²', 'Welsh short 2 square metres');
is($locale->unit(1, 'square-meter'), '1 metr sgwâr', 'Welsh long 1 square metre');
is($locale->unit(2, 'square-meter'), '2 fetr sgwâr', 'Welsh long 2 square metres');
is($locale->unit(1, 'square-mile', 'narrow'), '1mi²', 'Welsh narrow 1 square mile');
is($locale->unit(2, 'square-mile', 'narrow'), '2mi²', 'Welsh narrow 2 square miles');
is($locale->unit(1, 'square-mile', 'short'), '1 mi²', 'Welsh short 1 square mile');
is($locale->unit(2, 'square-mile', 'short'), '2 mi²', 'Welsh short 2 square miles');
is($locale->unit(1, 'square-mile'), '1 filltir sgwâr', 'Welsh long 1 square mile');
is($locale->unit(2, 'square-mile'), '2 filltir sgwâr', 'Welsh long 2 square miles');
is($locale->unit(1, 'watt', 'narrow'), '1W', 'Welsh narrow 1 watt');
is($locale->unit(2, 'watt', 'narrow'), '2W', 'Welsh narrow 2 watts');
is($locale->unit(1, 'watt', 'short'), '1 W', 'Welsh short 1 watt');
is($locale->unit(2, 'watt', 'short'), '2 W', 'Welsh short 2 watts');
is($locale->unit(1, 'watt'), '1 wat', 'Welsh long 1 watt');
is($locale->unit(2, 'watt'), '2 wat', 'Welsh long 2 watts');
is($locale->unit(1, 'week', 'narrow'), '1w', 'Welsh narrow 1 week');
is($locale->unit(2, 'week', 'narrow'), '2w', 'Welsh narrow 2 weeks');
is($locale->unit(1, 'week', 'short'), '1 wythnos', 'Welsh short 1 week');
is($locale->unit(2, 'week', 'short'), '2 wythnos', 'Welsh short 2 weeks');
is($locale->unit(1, 'week'), '1 wythnos', 'Welsh long 1 week');
is($locale->unit(2, 'week'), '2 wythnos', 'Welsh long 2 weeks');
is($locale->unit(1, 'yard', 'narrow'), '1llath', 'Welsh narrow 1 yard');
is($locale->unit(2, 'yard', 'narrow'), '2lath', 'Welsh narrow 2 yards');
is($locale->unit(1, 'yard', 'short'), '1 llath', 'Welsh short 1 yard');
is($locale->unit(2, 'yard', 'short'), '2 lath', 'Welsh short 2 yards');
is($locale->unit(1, 'yard'), '1 llath', 'Welsh long 1 yard');
is($locale->unit(2, 'yard'), '2 lath', 'Welsh long 2 yards');
is($locale->unit(1, 'year', 'narrow'), '1bl', 'Welsh narrow 1 year');
is($locale->unit(2, 'year', 'narrow'), '2bl', 'Welsh narrow 2 years');
is($locale->unit(1, 'year', 'short'), '1 bl', 'Welsh short 1 year');
is($locale->unit(2, 'year', 'short'), '2 bl', 'Welsh short 2 years');
is($locale->unit(1, 'year'), '1 flwyddyn', 'Welsh long 1 year');
is($locale->unit(2, 'year'), '2 flynedd', 'Welsh long 2 years');
is($locale->duration_unit('hm', 1, 2), '1:02', 'Welsh duration hour, minuet');
is($locale->duration_unit('hms', 1, 2, 3 ), '1:02:03', 'Welsh duration hour, minuet, second');
is($locale->duration_unit('ms', 1, 2 ), '1:02', 'Welsh duration minuet, second');
is($locale->is_yes('ie'), 1, 'Welsh is yes');
is($locale->is_yes('es'), 0, 'Welsh is not yes');
is($locale->is_no('na'), 1, 'Welsh is no');
is($locale->is_no('N&'), 0, 'Welsh is not no');