=head1

Locale::CLDR::Locales::Mn - Package for language Mongolian

=cut

package Locale::CLDR::Locales::Mn;
# This file auto generated from Data\common\main\mn.xml
#	on Sun  4 Mar  1:20:58 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.32.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афар',
 				'ab' => 'абхаз',
 				'ace' => 'ачин',
 				'ada' => 'адангмэ',
 				'ady' => 'адигэ',
 				'af' => 'африк',
 				'agq' => 'агем',
 				'ain' => 'айну',
 				'ak' => 'акан',
 				'ale' => 'алют',
 				'alt' => 'өмнөд алтай',
 				'am' => 'амхар',
 				'an' => 'арагон',
 				'anp' => 'ангик',
 				'ar' => 'араб',
 				'ar_001' => 'стандарт араб',
 				'arn' => 'мапүчи',
 				'arp' => 'арапаго',
 				'as' => 'ассам',
 				'asa' => 'асу',
 				'ast' => 'астури',
 				'av' => 'авар',
 				'awa' => 'авадхи',
 				'ay' => 'аймара',
 				'az' => 'азербайжан',
 				'az@alt=short' => 'азери',
 				'ba' => 'башкир',
 				'ban' => 'бали',
 				'bas' => 'басаа',
 				'be' => 'беларусь',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'болгар',
 				'bho' => 'божпури',
 				'bi' => 'бислам',
 				'bin' => 'бини',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгал',
 				'bo' => 'төвд',
 				'br' => 'бретон',
 				'brx' => 'бодо',
 				'bs' => 'босни',
 				'bug' => 'буги',
 				'byn' => 'блин',
 				'ca' => 'каталан',
 				'ce' => 'чечень',
 				'ceb' => 'себуано',
 				'cgg' => 'чига',
 				'ch' => 'чаморро',
 				'chk' => 'чуук',
 				'chm' => 'мари хэл',
 				'cho' => 'чоктау',
 				'chr' => 'чироки',
 				'chy' => 'чэенн',
 				'ckb' => 'төв курд',
 				'co' => 'корсик',
 				'crs' => 'сеселва креолын франц',
 				'cs' => 'чех',
 				'cu' => 'сүмийн славян',
 				'cv' => 'чуваш',
 				'cy' => 'уэльс',
 				'da' => 'дани',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'dav' => 'тайта',
 				'de' => 'герман',
 				'de_AT' => 'австри-герман',
 				'de_CH' => 'швейцари дээр герман',
 				'dgr' => 'догриб',
 				'dje' => 'зарма',
 				'dsb' => 'доод сорби',
 				'dua' => 'дуала',
 				'dv' => 'дивехи',
 				'dyo' => 'жола-фони',
 				'dz' => 'зонха',
 				'dzg' => 'дазага',
 				'ebu' => 'эмбу',
 				'ee' => 'эвэ',
 				'efi' => 'эфик',
 				'eka' => 'экажук',
 				'el' => 'грек',
 				'en' => 'англи',
 				'en_AU' => 'австрали-англи',
 				'en_CA' => 'канад-англи',
 				'en_GB' => 'британи-англи',
 				'en_GB@alt=short' => 'британи-англи',
 				'en_US' => 'америк-англи',
 				'en_US@alt=short' => 'америк-англи',
 				'eo' => 'эсперанто',
 				'es' => 'испани',
 				'et' => 'эстони',
 				'eu' => 'баск',
 				'ewo' => 'эвондо',
 				'fa' => 'перс',
 				'ff' => 'фула',
 				'fi' => 'финлянд',
 				'fil' => 'филиппин',
 				'fj' => 'фижи',
 				'fo' => 'фарер',
 				'fon' => 'фон',
 				'fr' => 'франц',
 				'fr_CA' => 'канад-франц',
 				'fr_CH' => 'швейцари-франц',
 				'fur' => 'фриулан',
 				'fy' => 'баруун фриз',
 				'ga' => 'ирланд',
 				'gaa' => 'га',
 				'gag' => 'гагуз',
 				'gd' => 'шотландын гел',
 				'gez' => 'гийз',
 				'gil' => 'гилберт',
 				'gl' => 'галего',
 				'gn' => 'гуарани',
 				'gor' => 'горонтало',
 				'gsw' => 'швейцари-герман',
 				'gu' => 'гужарати',
 				'guz' => 'гузы',
 				'gv' => 'манкс',
 				'gwi' => 'гвичин',
 				'ha' => 'хауса',
 				'haw' => 'хавай',
 				'he' => 'еврей',
 				'hi' => 'хинди',
 				'hil' => 'хилигайнон',
 				'hmn' => 'хмонг',
 				'hr' => 'хорват',
 				'hsb' => 'дээд сорби',
 				'ht' => 'гаитийн креол',
 				'hu' => 'унгар',
 				'hup' => 'хупа',
 				'hy' => 'армен',
 				'hz' => 'хереро',
 				'ia' => 'интерлингво',
 				'iba' => 'ибан',
 				'ibb' => 'ибибио',
 				'id' => 'индонези',
 				'ie' => 'нэгдмэл хэл',
 				'ig' => 'игбо',
 				'ii' => 'сычуань и',
 				'ilo' => 'илоко',
 				'inh' => 'ингуш',
 				'io' => 'идо',
 				'is' => 'исланд',
 				'it' => 'итали',
 				'iu' => 'инуктитут',
 				'ja' => 'япон',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачамэ',
 				'jv' => 'ява',
 				'ka' => 'гүрж',
 				'kab' => 'кабиле',
 				'kac' => 'качин',
 				'kaj' => 'жжу',
 				'kam' => 'камба',
 				'kbd' => 'кабардин',
 				'kcg' => 'тяп',
 				'kde' => 'маконде',
 				'kea' => 'кабүвердиану',
 				'kfo' => 'коро',
 				'kha' => 'каси',
 				'khq' => 'койра чини',
 				'ki' => 'кикуюү',
 				'kj' => 'куаньяма',
 				'kk' => 'хасаг',
 				'kkj' => 'како',
 				'kl' => 'калалисут',
 				'kln' => 'каленжин',
 				'km' => 'кхмер',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'солонгос',
 				'koi' => 'коми-пермяк',
 				'kok' => 'конкани',
 				'kpe' => 'кпелле',
 				'kr' => 'канури',
 				'krc' => 'карачай-балкар',
 				'krl' => 'карель',
 				'kru' => 'курук',
 				'ks' => 'кашмир',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафиа',
 				'ksh' => 'кёльш',
 				'ku' => 'курд',
 				'kum' => 'кумук',
 				'kv' => 'коми',
 				'kw' => 'корн',
 				'ky' => 'киргиз',
 				'la' => 'латин',
 				'lad' => 'ладин',
 				'lag' => 'ланги',
 				'lb' => 'люксембург',
 				'lez' => 'лезги',
 				'lg' => 'ганда',
 				'li' => 'лимбург',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаос',
 				'loz' => 'лози',
 				'lrc' => 'хойд лури',
 				'lt' => 'литва',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'луяа',
 				'lv' => 'латви',
 				'mad' => 'мадури хэл',
 				'mag' => 'магахи',
 				'mai' => 'май',
 				'mak' => 'макасар',
 				'mas' => 'масай',
 				'mdf' => 'мокша',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисен',
 				'mg' => 'малагаси',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалл',
 				'mi' => 'маори',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македон',
 				'ml' => 'малаялам',
 				'mn' => 'монгол',
 				'mni' => 'манипури',
 				'moh' => 'мохаук',
 				'mos' => 'мосси',
 				'mr' => 'марати',
 				'ms' => 'малай',
 				'mt' => 'малта',
 				'mua' => 'мунданг',
 				'mul' => 'олон хэл',
 				'mus' => 'крик',
 				'mwl' => 'меранди',
 				'my' => 'бирм',
 				'myv' => 'эрзя',
 				'mzn' => 'мазандерани',
 				'na' => 'науру',
 				'nap' => 'неаполитан',
 				'naq' => 'нама',
 				'nb' => 'норвегийн букмол',
 				'nd' => 'хойд ндебеле',
 				'nds_NL' => 'бага саксон',
 				'ne' => 'балба',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'ниас хэл',
 				'niu' => 'ниуэ',
 				'nl' => 'нидерланд',
 				'nl_BE' => 'фламанд',
 				'nmg' => 'квазио',
 				'nn' => 'норвегийн нинорск',
 				'nnh' => 'нгиембүүн',
 				'no' => 'норвеги',
 				'nog' => 'ногаи',
 				'nqo' => 'нко',
 				'nr' => 'өмнөд ндебеле',
 				'nso' => 'хойд сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'ny' => 'нянжа',
 				'nyn' => 'нянколе',
 				'oc' => 'окситан',
 				'om' => 'оромо',
 				'or' => 'ория',
 				'os' => 'оссетин',
 				'pa' => 'панжаби',
 				'pag' => 'пангасин',
 				'pam' => 'пампанга',
 				'pap' => 'папьяменто',
 				'pau' => 'палау',
 				'pcm' => 'нигерийн пиджин',
 				'pl' => 'польш',
 				'prg' => 'прусс',
 				'ps' => 'пашто',
 				'pt' => 'португал',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'rap' => 'рапануи',
 				'rar' => 'раротонг',
 				'rm' => 'романш',
 				'rn' => 'рунди',
 				'ro' => 'румын',
 				'ro_MD' => 'молдав',
 				'rof' => 'ромбо',
 				'root' => 'рут',
 				'ru' => 'орос',
 				'rup' => 'ароманы',
 				'rw' => 'киньяруанда',
 				'rwk' => 'рва',
 				'sa' => 'санскрит',
 				'sad' => 'сандавэ',
 				'sah' => 'саха',
 				'saq' => 'самбүрү',
 				'sat' => 'сантали',
 				'sba' => 'нгамбай',
 				'sbp' => 'сангү',
 				'sc' => 'сардин',
 				'scn' => 'сицил',
 				'sco' => 'шотланд',
 				'sd' => 'синдхи',
 				'se' => 'хойд сами',
 				'seh' => 'сена',
 				'ses' => 'кёраборо сени',
 				'sg' => 'санго',
 				'sh' => 'хорватын серб',
 				'shi' => 'тачелхит',
 				'shn' => 'шань',
 				'si' => 'синхала',
 				'sk' => 'словак',
 				'sl' => 'словени',
 				'sm' => 'самоа',
 				'sma' => 'өмнөд сами',
 				'smj' => 'люле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомали',
 				'sq' => 'албани',
 				'sr' => 'серб',
 				'srn' => 'сранан тонго',
 				'ss' => 'свати',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'su' => 'сундан',
 				'suk' => 'сукума',
 				'sv' => 'швед',
 				'sw' => 'свахили',
 				'sw_CD' => 'конгогийн свахили',
 				'swb' => 'комори',
 				'syr' => 'сири',
 				'ta' => 'тамил',
 				'te' => 'тэлүгү',
 				'tem' => 'тимн',
 				'teo' => 'тэсо',
 				'tet' => 'тетум',
 				'tg' => 'тажик',
 				'th' => 'тай',
 				'ti' => 'тигринья',
 				'tig' => 'тигр',
 				'tk' => 'туркмен',
 				'tlh' => 'клингон',
 				'tn' => 'цвана',
 				'to' => 'тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турк',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tt' => 'татар',
 				'tum' => 'тумбула',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'twq' => 'тасавак',
 				'ty' => 'таити',
 				'tyv' => 'тува',
 				'tzm' => 'төв атласын тамазайт',
 				'udm' => 'удмурт',
 				'ug' => 'уйгур',
 				'uk' => 'украин',
 				'umb' => 'умбунду',
 				'und' => 'тодорхойгүй хэл',
 				'ur' => 'урду',
 				'uz' => 'узбек',
 				'vai' => 'вай',
 				've' => 'венда',
 				'vi' => 'вьетнам',
 				'vo' => 'волапюк',
 				'vun' => 'вунжо',
 				'wa' => 'уоллун',
 				'wae' => 'уолсэр',
 				'wal' => 'уоллайтта',
 				'war' => 'варай',
 				'wo' => 'волоф',
 				'xal' => 'халимаг',
 				'xh' => 'хоса',
 				'xog' => 'сога',
 				'yav' => 'янгбен',
 				'ybb' => 'емба',
 				'yi' => 'иддиш',
 				'yo' => 'ёруба',
 				'yue' => 'кантон',
 				'zgh' => 'тамазит',
 				'zh' => 'хятад',
 				'zh_Hans' => 'хялбаршуулсан хятад',
 				'zh_Hant' => 'уламжлалт хятад',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'хэл зүйн агуулгагүй',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'араб',
 			'Armn' => 'армени',
 			'Beng' => 'бенгал',
 			'Bopo' => 'вопомофо',
 			'Brai' => 'брайл',
 			'Cyrl' => 'кирилл',
 			'Deva' => 'деванагари',
 			'Ethi' => 'этиоп',
 			'Geor' => 'гүрж',
 			'Grek' => 'грек',
 			'Gujr' => 'гужарати',
 			'Guru' => 'гүрмүх',
 			'Hanb' => 'Бопомофотой ханз',
 			'Hang' => 'хангыль',
 			'Hani' => 'ханз',
 			'Hans' => 'хялбаршуулсан',
 			'Hans@alt=stand-alone' => 'хялбаршуулсан ханз',
 			'Hant' => 'уламжлалт',
 			'Hant@alt=stand-alone' => 'уламжлалт ханз',
 			'Hebr' => 'еврей',
 			'Hira' => 'хирагана',
 			'Hrkt' => 'япон хэлний үеийн цагаан толгой',
 			'Jamo' => 'жамо',
 			'Jpan' => 'япон',
 			'Kana' => 'катакана',
 			'Khmr' => 'кхмер',
 			'Knda' => 'каннада',
 			'Kore' => 'солонгос',
 			'Laoo' => 'лаос',
 			'Latn' => 'латин',
 			'Mlym' => 'малаялам',
 			'Mong' => 'монгол бичиг',
 			'Mymr' => 'мьянмар',
 			'Orya' => 'ория',
 			'Sinh' => 'синхала',
 			'Taml' => 'тамил',
 			'Telu' => 'тэлүгү',
 			'Thaa' => 'тана',
 			'Thai' => 'тай',
 			'Tibt' => 'төвд',
 			'Zmth' => 'математик тооллын систем',
 			'Zsye' => 'эможи',
 			'Zsym' => 'тэмдэг',
 			'Zxxx' => 'бичигдээгүй',
 			'Zyyy' => 'нийтлэг',
 			'Zzzz' => 'тодорхойгүй бичиг',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Дэлхий',
 			'002' => 'Африк',
 			'003' => 'Хойд Америк',
 			'005' => 'Өмнөд Америк',
 			'009' => 'Номхон далайн орнууд',
 			'011' => 'Баруун Африк',
 			'013' => 'Төв Америк',
 			'014' => 'Зүүн Африк',
 			'015' => 'Хойд Африк',
 			'017' => 'Төв Африк',
 			'018' => 'Өмнөд Африк тив',
 			'019' => 'Америк',
 			'021' => 'Хойд Америк тив',
 			'029' => 'Карибын',
 			'030' => 'Зүүн Ази',
 			'034' => 'Өмнөд Ази',
 			'035' => 'Зүүн өмнөд Ази',
 			'039' => 'Өмнөд Европ',
 			'053' => 'Австралиази',
 			'054' => 'Меланези',
 			'057' => 'Микронезийн бүс',
 			'061' => 'Полинези',
 			'142' => 'Ази',
 			'143' => 'Төв Ази',
 			'145' => 'Баруун Ази',
 			'150' => 'Европ',
 			'151' => 'Зүүн Европ',
 			'154' => 'Хойд Европ',
 			'155' => 'Баруун Европ',
 			'419' => 'Латин Америк',
 			'AC' => 'Асенсион арал',
 			'AD' => 'Андорра',
 			'AE' => 'Арабын Нэгдсэн Эмират Улс',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа ба Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албани',
 			'AM' => 'Армени',
 			'AO' => 'Ангол',
 			'AQ' => 'Антарктид',
 			'AR' => 'Аргентин',
 			'AS' => 'Америкийн Самоа',
 			'AT' => 'Австри',
 			'AU' => 'Австрали',
 			'AW' => 'Аруба',
 			'AX' => 'Аландын арлууд',
 			'AZ' => 'Азербайжан',
 			'BA' => 'Босни-Герцеговин',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельги',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Болгар',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент-Бартельми',
 			'BM' => 'Бермуда',
 			'BN' => 'Бруней',
 			'BO' => 'Боливи',
 			'BQ' => 'Карибын Нидерланд',
 			'BR' => 'Бразил',
 			'BS' => 'Багамын арлууд',
 			'BT' => 'Бутан',
 			'BV' => 'Буве арал',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канад',
 			'CC' => 'Кокос (Кийлинг) арлууд',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Бүгд Найрамдах Ардчилсан Конго Улс',
 			'CF' => 'Төв Африкийн Бүгд Найрамдах Улс',
 			'CG' => 'Конго Браззавиль',
 			'CG@alt=variant' => 'Конго (Бүгд Найрамдах улс)',
 			'CH' => 'Швейцарь',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Зааны ясан эрэг',
 			'CK' => 'Күүкийн арлууд',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Хятад',
 			'CO' => 'Колумби',
 			'CP' => 'Клиппертон арал',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Зул сарын арал',
 			'CY' => 'Кипр',
 			'CZ' => 'Чех',
 			'CZ@alt=variant' => 'Бүгд Найрамдах Чех Улс',
 			'DE' => 'Герман',
 			'DG' => 'Диего Гарсиа',
 			'DJ' => 'Джибути',
 			'DK' => 'Дани',
 			'DM' => 'Доминика',
 			'DO' => 'Бүгд Найрамдах Доминикан Улс',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута ба Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстони',
 			'EG' => 'Египет',
 			'EH' => 'Баруун Сахар',
 			'ER' => 'Эритрей',
 			'ES' => 'Испани',
 			'ET' => 'Этиоп',
 			'EU' => 'Европын Холбоо',
 			'EZ' => 'Евро бүс',
 			'FI' => 'Финланд',
 			'FJ' => 'Фижи',
 			'FK' => 'Фолклендийн арлууд',
 			'FK@alt=variant' => 'Фолклендийн арлууд (Мальвины арлууд)',
 			'FM' => 'Микронези',
 			'FO' => 'Фарерын арлууд',
 			'FR' => 'Франц',
 			'GA' => 'Габон',
 			'GB' => 'Их Британи',
 			'GB@alt=short' => 'ИБ',
 			'GD' => 'Гренада',
 			'GE' => 'Гүрж',
 			'GF' => 'Францын Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамби',
 			'GN' => 'Гвиней',
 			'GP' => 'Гваделуп',
 			'GQ' => 'Экваторын Гвиней',
 			'GR' => 'Грек',
 			'GS' => 'Өмнөд Жоржиа ба Өмнөд Сэндвичийн Арлууд',
 			'GT' => 'Гватемал',
 			'GU' => 'Гуам',
 			'GW' => 'Гвиней-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'БНХАУ-ын Тусгай захиргааны бүс Хонг Конг',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Херд ба Макдональдийн арлууд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорват',
 			'HT' => 'Гаити',
 			'HU' => 'Унгар',
 			'IC' => 'Канарын арлууд',
 			'ID' => 'Индонез',
 			'IE' => 'Ирланд',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн Арал',
 			'IN' => 'Энэтхэг',
 			'IO' => 'Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэр',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Итали',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Йордан',
 			'JP' => 'Япон',
 			'KE' => 'Кени',
 			'KG' => 'Кыргызстан',
 			'KH' => 'Камбож',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморын арлууд',
 			'KN' => 'Сент-Киттс ба Невис',
 			'KP' => 'Хойд Солонгос',
 			'KR' => 'Өмнөд Солонгос',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманы арлууд',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент Люсиа',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либери',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латви',
 			'LY' => 'Ливи',
 			'MA' => 'Морокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдав',
 			'ME' => 'Монтенегро',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллын арлууд',
 			'MK' => 'Македон',
 			'MK@alt=variant' => 'Македон (Хуучин Югославын бүрэлдэхүүний Македон)',
 			'ML' => 'Мали',
 			'MM' => 'Мьянмар',
 			'MN' => 'Монгол',
 			'MO' => 'БНХАУ-ын Тусгай захиргааны бүс Макао',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Хойд Марианы арлууд',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавритани',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврики',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексик',
 			'MY' => 'Малайз',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намиби',
 			'NC' => 'Шинэ Каледони',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк арал',
 			'NG' => 'Нигери',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвеги',
 			'NP' => 'Балба',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Шинэ Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панам',
 			'PE' => 'Перу',
 			'PF' => 'Францын Полинез',
 			'PG' => 'Папуа Шинэ Гвиней',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польш',
 			'PM' => 'Сент-Пьер ба Микело',
 			'PN' => 'Питкэрн арлууд',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестины нутаг дэвсгэрүүд',
 			'PS@alt=short' => 'Палестин',
 			'PT' => 'Португал',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Номхон далайг тойрсон улс орнууд',
 			'RE' => 'Реюнион',
 			'RO' => 'Румын',
 			'RS' => 'Серби',
 			'RU' => 'Орос',
 			'RW' => 'Руанда',
 			'SA' => 'Саудын Араб',
 			'SB' => 'Соломоны арлууд',
 			'SC' => 'Сейшелийн арлууд',
 			'SD' => 'Судан',
 			'SE' => 'Швед',
 			'SG' => 'Сингапур',
 			'SH' => 'Сент Хелена',
 			'SI' => 'Словени',
 			'SJ' => 'Свалбард ба Ян Майен',
 			'SK' => 'Словак',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Өмнөд Судан',
 			'ST' => 'Сан-Томе ба Принсипи',
 			'SV' => 'Эль Сальвадор',
 			'SX' => 'Синт Мартен',
 			'SY' => 'Сири',
 			'SZ' => 'Свазиланд',
 			'TA' => 'Тристан да Кунъя',
 			'TC' => 'Турк ба Кайкосын Арлууд',
 			'TD' => 'Чад',
 			'TF' => 'Францын өмнөд газар нутаг',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Тажикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Зүүн Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турк',
 			'TT' => 'Тринидад ба Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзани',
 			'UA' => 'Украин',
 			'UG' => 'Уганда',
 			'UM' => 'Америкийн Нэгдсэн Улсын бага арлууд',
 			'UN' => 'Нэгдсэн Үндэстний Байгууллага',
 			'UN@alt=short' => 'НҮБ',
 			'US' => 'Америкийн Нэгдсэн Улс',
 			'US@alt=short' => 'АНУ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан хот улс',
 			'VC' => 'Сент-Винсент ба Гренадин',
 			'VE' => 'Венесуэл',
 			'VG' => 'Британийн Виржиний Арлууд',
 			'VI' => 'АНУ-ын Виржиний Арлууд',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис ба Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Өмнөд Африк',
 			'ZM' => 'Замби',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Тодорхойгүй бүс',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'хуанли',
 			'cf' => 'валютын формат',
 			'collation' => 'Захиалга ялгах',
 			'currency' => 'мөнгөн тэмдэгт',
 			'hc' => 'Цагийн горим (12 эсвэл 24)',
 			'lb' => 'Мөрийн зайн загвар',
 			'ms' => 'Хэмжүүрийн систем',
 			'numbers' => 'Тоо',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддын хуанли},
 				'chinese' => q{хятад хуанли},
 				'dangi' => q{данги хуанли},
 				'ethiopic' => q{этиоп хуанли},
 				'gregorian' => q{грегорийн хуанли},
 				'hebrew' => q{еврей хуанли},
 				'islamic' => q{исламын хуанли},
 				'iso8601' => q{ISO-8601 хуанли},
 				'japanese' => q{япон хуанли},
 				'persian' => q{перс хуанли},
 				'roc' => q{минго хуанли},
 			},
 			'cf' => {
 				'account' => q{Нягтлангийн валютын формат},
 				'standard' => q{стандарт валютын формат},
 			},
 			'collation' => {
 				'ducet' => q{юникодын үндсэн эрэмбэлэх дараалал},
 				'search' => q{ерөнхий зорилготой хайлт},
 				'standard' => q{стандарт эрэмбэлэх дараалал},
 			},
 			'hc' => {
 				'h11' => q{12 цагийн систем (0–11)},
 				'h12' => q{12 цагийн систем (1–12)},
 				'h23' => q{24 цагийн систем (0–23)},
 				'h24' => q{24 цагийн систем (1–24)},
 			},
 			'lb' => {
 				'loose' => q{урт мөрийн зайн загвар},
 				'normal' => q{энгийн мөрийн зайн загвар},
 				'strict' => q{шулуун мөрийн зайн загвар},
 			},
 			'ms' => {
 				'metric' => q{метрийн систем},
 				'uksystem' => q{английн хэмжүүрийн систем},
 				'ussystem' => q{америк хэмжүүрийн систем},
 			},
 			'numbers' => {
 				'arab' => q{араб-энэтхэг тоо},
 				'arabext' => q{өргөтгөсөн араб-энэтхэг тоо},
 				'armn' => q{армени тоо},
 				'armnlow' => q{жижиг армени тоо},
 				'beng' => q{бенгал тоо},
 				'deva' => q{деванагари тоо},
 				'ethi' => q{этиоп тоо},
 				'fullwide' => q{бүрэн хэмжээтэй тоо},
 				'geor' => q{гүрж тоо},
 				'grek' => q{грек тоо},
 				'greklow' => q{жижиг грек тоо},
 				'gujr' => q{гүжарати тоо},
 				'guru' => q{гүрмүкхи тоо},
 				'hanidec' => q{хятад аравтын тоо},
 				'hans' => q{хялбаршуулсан хятад тоо},
 				'hansfin' => q{хялбаршуулсан хятад санхүүгийн тоо},
 				'hant' => q{уламжлалт хятад тоо},
 				'hantfin' => q{уламжлалт хятад санхүүгийн тоо},
 				'hebr' => q{еврей тоо},
 				'jpan' => q{япон тоо},
 				'jpanfin' => q{япон санхүүгийн тоо},
 				'khmr' => q{кхмер тоо},
 				'knda' => q{каннада тоо},
 				'laoo' => q{лаос тоо},
 				'latn' => q{араб тоо},
 				'mlym' => q{малаялам тоо},
 				'mong' => q{монгол тоо},
 				'mymr' => q{мьянмар тоо},
 				'orya' => q{ория тоо},
 				'roman' => q{ром тоо},
 				'romanlow' => q{жижиг ром тоо},
 				'taml' => q{уламжлалт тамил тоо},
 				'tamldec' => q{тамил тоо},
 				'telu' => q{телүгү тоо},
 				'thai' => q{тай тоо},
 				'tibt' => q{төвд тоо},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрийн},
 			'UK' => q{ИБ},
 			'US' => q{АНУ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'region' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ә җ ӊ һ]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а б в г д е ё ж з и й к л м н о ө п р с т у ү ф х ц ч ш щ ъ ы ь э ю я]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'hh:mm',
				hms => 'hh:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фут),
					},
					'ampere' => {
						'name' => q(ампер),
						'one' => q({0} ампер),
						'other' => q({0} ампер),
					},
					'arc-minute' => {
						'name' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					'arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					'astronomical-unit' => {
						'name' => q(сансрын нэгж),
						'one' => q({0} сансрын нэгж),
						'other' => q({0} сансрын нэгж),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'celsius' => {
						'name' => q(Цельсийн хэм),
						'one' => q({0} Цельсийн хэм),
						'other' => q({0} Цельсийн хэм),
					},
					'centiliter' => {
						'name' => q(центилитр),
						'one' => q({0} центилитр),
						'other' => q({0} центилитр),
					},
					'centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					'century' => {
						'name' => q(зуун),
						'one' => q({0}зуун),
						'other' => q({0}зуун),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}Умард),
						'south' => q({0}Өмнөд),
						'west' => q({0}Өрнөд),
					},
					'cubic-centimeter' => {
						'name' => q(куб сантиметр),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					'cubic-foot' => {
						'name' => q(куб фут),
						'one' => q({0} куб фут),
						'other' => q({0} куб фут),
					},
					'cubic-inch' => {
						'name' => q(куб инч),
						'one' => q({0} куб инч),
						'other' => q({0} куб инч),
					},
					'cubic-kilometer' => {
						'name' => q(куб километр),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'name' => q(куб метр),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					'cubic-mile' => {
						'name' => q(куб миль),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'name' => q(аяга),
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					'cup-metric' => {
						'name' => q(хэмжүүрийн аяга),
						'one' => q({0} хэмжүүрийн аяга),
						'other' => q({0} хэмжүүрийн аяга),
					},
					'day' => {
						'name' => q(өдөр),
						'one' => q({0} өдөр),
						'other' => q({0} өдөр),
						'per' => q({0}/өдөрт),
					},
					'deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					'decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					'fahrenheit' => {
						'name' => q(Фаренгейтын хэм),
						'one' => q({0} Фаренгейтын хэм),
						'other' => q({0} Фаренгейтын хэм),
					},
					'fluid-ounce' => {
						'name' => q(шингэн унц),
						'one' => q({0} ш унц),
						'other' => q({0} ш унц),
					},
					'foodcalorie' => {
						'name' => q(Калори),
						'one' => q({0} Калори),
						'other' => q({0} Калори),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					'g-force' => {
						'name' => q(жи-хүч),
						'one' => q({0} жи-хүч),
						'other' => q({0} жи-хүч),
					},
					'gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галл.),
					},
					'gallon-imperial' => {
						'name' => q(ИБ галлон),
						'one' => q({0} ИБ галлон),
						'other' => q({0} ИБ галлон),
						'per' => q({0}/ИБ галлон),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					'gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					'gigahertz' => {
						'name' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					'gigawatt' => {
						'name' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q({0}/гр),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					'hectoliter' => {
						'name' => q(хектолитр),
						'one' => q({0} хектолитр),
						'other' => q({0} хектолитр),
					},
					'hectopascal' => {
						'name' => q(гектопаскал),
						'one' => q({0} гектопаскал),
						'other' => q({0} гектопаскал),
					},
					'hertz' => {
						'name' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					'horsepower' => {
						'name' => q(морины хүч),
						'one' => q({0} морины хүч),
						'other' => q({0} морины хүч),
					},
					'hour' => {
						'name' => q(цаг),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
						'per' => q({0}/ц),
					},
					'inch' => {
						'name' => q(инч),
						'one' => q({0} инч),
						'other' => q({0} инч),
						'per' => q({0}/инч),
					},
					'inch-hg' => {
						'name' => q(мөнгөн усны инч),
						'one' => q({0} мөнгөн усны инч),
						'other' => q({0} мөнгөн усны инч),
					},
					'joule' => {
						'name' => q(жоуль),
						'one' => q({0} жоуль),
						'other' => q({0} жоуль),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'name' => q(келвиний хэм),
						'one' => q({0} келвиний хэм),
						'other' => q({0} келвиний хэм),
					},
					'kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					'kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					'kilocalorie' => {
						'name' => q(килокалори),
						'one' => q({0} килокалори),
						'other' => q({0} килокалори),
					},
					'kilogram' => {
						'name' => q(килограм),
						'one' => q({0} килограм),
						'other' => q({0} килограм),
						'per' => q({0}/кг),
					},
					'kilohertz' => {
						'name' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					'kilojoule' => {
						'name' => q(киложоуль),
						'one' => q({0} киложоуль),
						'other' => q({0} киложоуль),
					},
					'kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					'kilometer-per-hour' => {
						'name' => q(километр/цаг),
						'one' => q({0} километр/цаг),
						'other' => q({0} километр/цаг),
					},
					'kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					'kilowatt-hour' => {
						'name' => q(киловатт цаг),
						'one' => q({0} киловатт цаг),
						'other' => q({0} киловатт цаг),
					},
					'knot' => {
						'name' => q(зангилаа),
						'one' => q({0}/зангилаа),
						'other' => q({0}/зангилаа),
					},
					'light-year' => {
						'name' => q(гэрлийн жил),
						'one' => q({0} гэрлийн жил),
						'other' => q({0} гэрлийн жил),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q({0}/л),
					},
					'liter-per-100kilometers' => {
						'name' => q(л/100км),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					'liter-per-kilometer' => {
						'name' => q(литр/километр),
						'one' => q({0} литр/километр),
						'other' => q({0} литр/километр),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					'megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					'megahertz' => {
						'name' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					'megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					'megawatt' => {
						'name' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q({0}/м),
					},
					'meter-per-second' => {
						'name' => q(метр/секунд),
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					'meter-per-second-squared' => {
						'name' => q(метр сек кв),
						'one' => q({0} метр сек кв),
						'other' => q({0} метр сек кв),
					},
					'metric-ton' => {
						'name' => q(метрийн тонн),
						'one' => q({0} метрийн тонн),
						'other' => q({0} метрийн тонн),
					},
					'microgram' => {
						'name' => q(микрограм),
						'one' => q({0} микрограм),
						'other' => q({0} микрограм),
					},
					'micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'mile' => {
						'name' => q(миль),
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					'mile-per-gallon' => {
						'name' => q(миль/галлон),
						'one' => q({0} миль/галлон),
						'other' => q({0} миль/галлон),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(миль/ИБгаллон),
						'one' => q({0} миль/ИБгаллон),
						'other' => q({0} миль/ИБгаллон),
					},
					'mile-per-hour' => {
						'name' => q(миль/цаг),
						'one' => q({0} миль/цаг),
						'other' => q({0} миль/цаг),
					},
					'mile-scandinavian' => {
						'name' => q(скандинавын миль),
						'one' => q({0} скандинавын миль),
						'other' => q({0} скандинавын миль),
					},
					'milliampere' => {
						'name' => q(милиампер),
						'one' => q({0} милиампер),
						'other' => q({0} милиампер),
					},
					'millibar' => {
						'name' => q(милибар),
						'one' => q({0} милибар),
						'other' => q({0} милибар),
					},
					'milligram' => {
						'name' => q(милиграм),
						'one' => q({0} милиграм),
						'other' => q({0} милиграм),
					},
					'milligram-per-deciliter' => {
						'name' => q(мг/дЛ),
						'one' => q({0} мг/дЛ),
						'other' => q({0} мг/дЛ),
					},
					'milliliter' => {
						'name' => q(милилитр),
						'one' => q({0} милилитр),
						'other' => q({0} милилитр),
					},
					'millimeter' => {
						'name' => q(милиметр),
						'one' => q({0} милиметр),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'name' => q(мөнгөн усны милиметр),
						'one' => q({0} мөнгөн усны милиметр),
						'other' => q({0} мөнгөн усны милиметр),
					},
					'millimole-per-liter' => {
						'name' => q(ммол/л),
						'one' => q({0} ммол/л),
						'other' => q({0} ммол/л),
					},
					'millisecond' => {
						'name' => q(милисекунд),
						'one' => q({0} милисекунд),
						'other' => q({0} милисекунд),
					},
					'milliwatt' => {
						'name' => q(миливатт),
						'one' => q({0} миливатт),
						'other' => q({0} миливатт),
					},
					'minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
						'per' => q({0}/мин),
					},
					'month' => {
						'name' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
						'per' => q({0}/сард),
					},
					'nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					'nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'nautical-mile' => {
						'name' => q(далайн миль),
						'one' => q({0} далайн миль),
						'other' => q({0} далайн миль),
					},
					'ohm' => {
						'name' => q(ом),
						'one' => q({0} ом),
						'other' => q({0} ом),
					},
					'ounce' => {
						'name' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
						'per' => q({0}/унц),
					},
					'ounce-troy' => {
						'name' => q(трой унц),
						'one' => q({0} трой унц),
						'other' => q({0} трой унц),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					'part-per-million' => {
						'name' => q(хэсэг/саяд),
						'one' => q({0} хэсэг/саяд),
						'other' => q({0} хэсэг/саяд),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					'pint' => {
						'name' => q(пайнт),
						'one' => q({0} пайнт),
						'other' => q({0} пайнт),
					},
					'pint-metric' => {
						'name' => q(хэмжүүрийн пинт),
						'one' => q({0} хэмж. пинт),
						'other' => q({0} хэмж. пинт),
					},
					'point' => {
						'name' => q(оноо),
						'one' => q({0} оноо),
						'other' => q({0} оноо),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					'pound-per-square-inch' => {
						'name' => q(фунт/квадрат инч),
						'one' => q({0} фунт/кв.инч),
						'other' => q({0} фунт/кв.инч),
					},
					'quart' => {
						'name' => q(кварц),
						'one' => q({0} кварц),
						'other' => q({0} кварц),
					},
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					'revolution' => {
						'name' => q(эргэлт),
						'one' => q({0} эргэлт),
						'other' => q({0} эргэлт),
					},
					'second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q({0}/сек),
					},
					'square-centimeter' => {
						'name' => q(сантиметр квадрат),
						'one' => q({0} сантиметр квадрат),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'name' => q(кв.фут),
						'one' => q({0} кв.фут),
						'other' => q({0} кв.фут),
					},
					'square-inch' => {
						'name' => q(кв.инч),
						'one' => q({0} кв.инч),
						'other' => q({0} кв.инч),
						'per' => q({0}/инч²),
					},
					'square-kilometer' => {
						'name' => q(квадрат километр),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					'square-meter' => {
						'name' => q(квадрат метр),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					'square-mile' => {
						'name' => q(кв.миль),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'name' => q(хоолны халбага),
						'one' => q({0} хоолны халбага),
						'other' => q({0} хоолны халбага),
					},
					'teaspoon' => {
						'name' => q(цайны халбага),
						'one' => q({0} цайны халбага),
						'other' => q({0} цайны халбага),
					},
					'terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					'terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					'ton' => {
						'name' => q(тонн),
						'one' => q({0} тонн),
						'other' => q({0} тонн),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'name' => q(долоо хоног),
						'one' => q({0} долоо хоног),
						'other' => q({0} долоо хоног),
						'per' => q({0}/7хоногт),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
						'per' => q({0}/жилд),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'coordinate' => {
						'east' => q({0}Зүүн),
						'north' => q({0}Умард),
						'south' => q({0}Өмнөд),
						'west' => q({0}Өрнөд),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} миль куб),
						'other' => q({0} миль куб),
					},
					'day' => {
						'name' => q(өдөр),
						'one' => q({0} өдөр),
						'other' => q({0} өдөр),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} фт),
						'other' => q({0} фт),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
					},
					'hectare' => {
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'one' => q({0} м.х.),
						'other' => q({0} м.х.),
					},
					'hour' => {
						'name' => q(цаг),
						'one' => q({0} ц),
						'other' => q({0} ц),
					},
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инч),
					},
					'inch-hg' => {
						'one' => q({0} муб),
						'other' => q({0} муб),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/ц),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					'kilowatt' => {
						'one' => q({0} кватт),
						'other' => q({0} кватт),
					},
					'light-year' => {
						'one' => q({0} гэр/жил),
						'other' => q({0} гэр/жил),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-100kilometers' => {
						'name' => q(л/100км),
						'one' => q({0} л/100км),
						'other' => q({0}л/100км),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/сек),
						'other' => q({0} м/сек),
					},
					'mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					'mile-per-hour' => {
						'one' => q({0} миль/цаг),
						'other' => q({0} миль/цаг),
					},
					'millibar' => {
						'one' => q({0} милбар),
						'other' => q({0} милбар),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'name' => q(мсек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'name' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
					},
					'ounce' => {
						'one' => q({0} унц),
						'other' => q({0} унц),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} миль²),
						'other' => q({0} миль²),
					},
					'watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'name' => q(дол/хон),
						'one' => q({0} д/х),
						'other' => q({0} д/х),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(акр фут),
						'one' => q({0} акр фут),
						'other' => q({0} акр фут),
					},
					'ampere' => {
						'name' => q(амп),
						'one' => q({0} А),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					'arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					'astronomical-unit' => {
						'name' => q(сн),
						'one' => q({0} сн),
						'other' => q({0} сн),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} крт),
						'other' => q({0} крт),
					},
					'celsius' => {
						'name' => q(C хэм),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(цЛ),
						'one' => q({0} цЛ),
						'other' => q({0} цЛ),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					'century' => {
						'name' => q(зуун),
						'one' => q({0}зуун),
						'other' => q({0}зуун),
					},
					'coordinate' => {
						'east' => q({0}Зүүн),
						'north' => q({0}Умард),
						'south' => q({0}Өмнөд),
						'west' => q({0}Өрнөд),
					},
					'cubic-centimeter' => {
						'name' => q(см³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					'cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					'cubic-inch' => {
						'name' => q(инч³),
						'one' => q({0} инч³),
						'other' => q({0} инч³),
					},
					'cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					'cubic-mile' => {
						'name' => q(ми³),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'name' => q(аяга),
						'one' => q({0} а),
						'other' => q({0} а),
					},
					'cup-metric' => {
						'name' => q(хэмжүүрийн аяга),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(өдөр),
						'one' => q({0} өдөр),
						'other' => q({0} өдөр),
						'per' => q({0}/өдөрт),
					},
					'deciliter' => {
						'name' => q(дЛ),
						'one' => q({0} дЛ),
						'other' => q({0} дЛ),
					},
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					'fahrenheit' => {
						'name' => q(F хэм),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(ш унц),
						'one' => q({0} ш унц),
						'other' => q({0} ш унц),
					},
					'foodcalorie' => {
						'name' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					'g-force' => {
						'name' => q(Жи),
						'one' => q({0} Жи),
						'other' => q({0} Жи),
					},
					'gallon' => {
						'name' => q(галл.),
						'one' => q({0} галл.),
						'other' => q({0} галл.),
						'per' => q({0}/АНУ галлон),
					},
					'gallon-imperial' => {
						'name' => q(ИБ галлон),
						'one' => q({0} ИБ галлон),
						'other' => q({0} ИБ галлон),
						'per' => q({0}/ИБ галлон),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					'gigawatt' => {
						'name' => q(ГВ),
						'one' => q({0} ГВ),
						'other' => q({0} ГВ),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
						'per' => q({0}/гр),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'name' => q(хЛ),
						'one' => q({0} хЛ),
						'other' => q({0} хЛ),
					},
					'hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'name' => q(мх),
						'one' => q({0} мх),
						'other' => q({0} мх),
					},
					'hour' => {
						'name' => q(цаг),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
						'per' => q({0}/ц),
					},
					'inch' => {
						'name' => q(инч),
						'one' => q({0} инч),
						'other' => q({0} инч),
						'per' => q({0}/инч),
					},
					'inch-hg' => {
						'name' => q(МөУсИн),
						'one' => q({0} МөУсИн),
						'other' => q({0} МөУсИн),
					},
					'joule' => {
						'name' => q(жоуль),
						'one' => q({0} жо),
						'other' => q({0} жо),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0}°К),
						'other' => q({0}°К),
					},
					'kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					'kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'name' => q(киложоуль),
						'one' => q({0} кж),
						'other' => q({0} кж),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/цаг),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					'kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'name' => q(кВ-цаг),
						'one' => q({0} кВц),
						'other' => q({0} кВц),
					},
					'knot' => {
						'name' => q(зангилаа),
						'one' => q({0} зангилаа),
						'other' => q({0} зангилаа),
					},
					'light-year' => {
						'name' => q(гэрл. жил),
						'one' => q({0} гэрл.жил),
						'other' => q({0} гэрл.жил),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					'liter-per-100kilometers' => {
						'name' => q(л/100км),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					'liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					'megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					'megahertz' => {
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					'megaliter' => {
						'name' => q(МЛ),
						'one' => q({0} МЛ),
						'other' => q({0} МЛ),
					},
					'megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					'meter-per-second' => {
						'name' => q(метр/сек),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'name' => q(µг),
						'one' => q({0} µг),
						'other' => q({0} µг),
					},
					'micrometer' => {
						'name' => q(µметр),
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'name' => q(μсек),
						'one' => q({0} μсек),
						'other' => q({0} μсек),
					},
					'mile' => {
						'name' => q(миль),
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-gallon' => {
						'name' => q(миль/галл.),
						'one' => q(миль/галл.),
						'other' => q({0} ми/гал),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(миль/ИБгаллон),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(миль/цаг),
						'one' => q({0} ми/ц),
						'other' => q({0} ми/ц),
					},
					'mile-scandinavian' => {
						'name' => q(скандинавын миль),
						'one' => q({0} ск. миль),
						'other' => q({0} ск. миль),
					},
					'milliampere' => {
						'name' => q(милиамп),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milligram-per-deciliter' => {
						'name' => q(мг/дЛ),
						'one' => q({0} мг/дЛ),
						'other' => q({0} мг/дЛ),
					},
					'milliliter' => {
						'name' => q(мЛ),
						'one' => q({0} мЛ),
						'other' => q({0} мЛ),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'name' => q(МөУс мм),
						'one' => q({0} МөУс мм),
						'other' => q({0} МөУс мм),
					},
					'millimole-per-liter' => {
						'name' => q(ммол/л),
						'one' => q({0} ммол/л),
						'other' => q({0} ммол/л),
					},
					'millisecond' => {
						'name' => q(милисек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					'month' => {
						'name' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
						'per' => q({0}/сард),
					},
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'name' => q(дмиль),
						'one' => q({0} дмиль),
						'other' => q({0} дмиль),
					},
					'ohm' => {
						'name' => q(ом),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
						'per' => q({0}/унц),
					},
					'ounce-troy' => {
						'name' => q(трой унц),
						'one' => q({0} т унц),
						'other' => q({0} т унц),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'part-per-million' => {
						'name' => q(хэсэг/саяд),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'name' => q(пайнт),
						'one' => q({0} пнт),
						'other' => q({0} пнт),
					},
					'pint-metric' => {
						'name' => q(хэмж. пинт),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'point' => {
						'name' => q(оноо),
						'one' => q({0} оноо),
						'other' => q({0} оноо),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					'pound-per-square-inch' => {
						'name' => q(фунт/кв.инч),
						'one' => q({0} ф/инч²),
						'other' => q({0} ф/инч²),
					},
					'quart' => {
						'name' => q(крц),
						'one' => q({0} крц),
						'other' => q({0} крц),
					},
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					'revolution' => {
						'name' => q(эргэлт),
						'one' => q({0} эргэлт),
						'other' => q({0} эргэлт),
					},
					'second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/сек),
					},
					'square-centimeter' => {
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'name' => q(фут²),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-inch' => {
						'name' => q(инч²),
						'one' => q({0} инч²),
						'other' => q({0} инч²),
						'per' => q({0}/инч²),
					},
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					'square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					'square-mile' => {
						'name' => q(миль²),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'name' => q(х/халбага),
						'one' => q({0} х/халбага),
						'other' => q({0} х/халбага),
					},
					'teaspoon' => {
						'name' => q(ц/халбага),
						'one' => q({0} ц/халбага),
						'other' => q({0} ц/халбага),
					},
					'terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					'terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					'ton' => {
						'name' => q(тонн),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'name' => q(дол/хон),
						'one' => q({0} дол/хон),
						'other' => q({0} дол/хон),
						'per' => q({0}/7хоногт),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
						'per' => q({0}/жилд),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:тийм|т|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:үгүй|ү|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0мянга',
					'other' => '0мянга',
				},
				'10000' => {
					'one' => '00мянга',
					'other' => '00мянга',
				},
				'100000' => {
					'one' => '000мянга',
					'other' => '000мянга',
				},
				'1000000' => {
					'one' => '0сая',
					'other' => '0сая',
				},
				'10000000' => {
					'one' => '00сая',
					'other' => '00сая',
				},
				'100000000' => {
					'one' => '000сая',
					'other' => '000сая',
				},
				'1000000000' => {
					'one' => '0тэрбум',
					'other' => '0тэрбум',
				},
				'10000000000' => {
					'one' => '00тэрбум',
					'other' => '00тэрбум',
				},
				'100000000000' => {
					'one' => '000Т',
					'other' => '000Т',
				},
				'1000000000000' => {
					'one' => '0ИН',
					'other' => '0ИН',
				},
				'10000000000000' => {
					'one' => '00ИН',
					'other' => '00ИН',
				},
				'100000000000000' => {
					'one' => '000ИН',
					'other' => '000ИН',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 мянга',
					'other' => '0 мянга',
				},
				'10000' => {
					'one' => '00 мянга',
					'other' => '00 мянга',
				},
				'100000' => {
					'one' => '000 мянга',
					'other' => '000 мянга',
				},
				'1000000' => {
					'one' => '0 сая',
					'other' => '0 сая',
				},
				'10000000' => {
					'one' => '00 сая',
					'other' => '00 сая',
				},
				'100000000' => {
					'one' => '000 сая',
					'other' => '000 сая',
				},
				'1000000000' => {
					'one' => '0 тэрбум',
					'other' => '0 тэрбум',
				},
				'10000000000' => {
					'one' => '00 тэрбум',
					'other' => '00 тэрбум',
				},
				'100000000000' => {
					'one' => '000 тэрбум',
					'other' => '000 тэрбум',
				},
				'1000000000000' => {
					'one' => '0 их наяд',
					'other' => '0 их наяд',
				},
				'10000000000000' => {
					'one' => '00 их наяд',
					'other' => '00 их наяд',
				},
				'100000000000000' => {
					'one' => '000 их наяд',
					'other' => '000 их наяд',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0мянга',
					'other' => '0мянга',
				},
				'10000' => {
					'one' => '00мянга',
					'other' => '00мянга',
				},
				'100000' => {
					'one' => '000мянга',
					'other' => '000мянга',
				},
				'1000000' => {
					'one' => '0сая',
					'other' => '0сая',
				},
				'10000000' => {
					'one' => '00сая',
					'other' => '00сая',
				},
				'100000000' => {
					'one' => '000сая',
					'other' => '000сая',
				},
				'1000000000' => {
					'one' => '0тэрбум',
					'other' => '0тэрбум',
				},
				'10000000000' => {
					'one' => '00тэрбум',
					'other' => '00тэрбум',
				},
				'100000000000' => {
					'one' => '000Т',
					'other' => '000Т',
				},
				'1000000000000' => {
					'one' => '0ИН',
					'other' => '0ИН',
				},
				'10000000000000' => {
					'one' => '00ИН',
					'other' => '00ИН',
				},
				'100000000000000' => {
					'one' => '000ИН',
					'other' => '000ИН',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(арабын нэгдсэн эмиратын дирхам),
				'one' => q(арабын нэгдсэн эмиратын дирхам),
				'other' => q(арабын нэгдсэн эмиратын дирхам),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(афганистан афгани),
				'one' => q(афганистан афгани),
				'other' => q(афганистан афгани),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(албанийн лек),
				'one' => q(албанийн лек),
				'other' => q(албанийн лек),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(арменийн драм),
				'one' => q(арменийн драм),
				'other' => q(арменийн драм),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(нидерландын антиллъя гулдер),
				'one' => q(нидерландын антиллъя гулдер),
				'other' => q(нидерландын антиллъя гулдер),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ангол кванза),
				'one' => q(ангол кванза),
				'other' => q(ангол кванза),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентин песо),
				'one' => q(аргентин песо),
				'other' => q(аргентин песо),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(австрали доллар),
				'one' => q(австрали доллар),
				'other' => q(австрали доллар),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(арубын флорин),
				'one' => q(арубын флорин),
				'other' => q(арубын флорин),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(азербайжаны манат),
				'one' => q(азербайжаны манат),
				'other' => q(азербайжаны манат),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(босни-герцеговин хөрвөгч марк),
				'one' => q(босни-герцеговин хөрвөгч марк),
				'other' => q(босни-герцеговин хөрвөгч марк),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадос доллар),
				'one' => q(барбадос доллар),
				'other' => q(барбадос доллар),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(бангладеш така),
				'one' => q(бангладеш така),
				'other' => q(бангладеш така),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгарын лев),
				'one' => q(болгарын лев),
				'other' => q(болгарын лев),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(бахрейн динар),
				'one' => q(бахрейн динар),
				'other' => q(бахрейн динар),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(бурунд франк),
				'one' => q(бурунд франк),
				'other' => q(бурунд франк),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермуд доллар),
				'one' => q(бермуд доллар),
				'other' => q(бермуд доллар),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(бруней доллар),
				'one' => q(бруней доллар),
				'other' => q(бруней доллар),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(боливи боливиано),
				'one' => q(боливи боливиано),
				'other' => q(боливи боливиано),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(бразилийн рил),
				'one' => q(бразилийн рил),
				'other' => q(бразилийн рил),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(багам доллар),
				'one' => q(багам доллар),
				'other' => q(багам доллар),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(бутаны нгултрум),
				'one' => q(бутаны нгултрум),
				'other' => q(бутаны нгултрум),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ботсвани пула),
				'one' => q(ботсвани пула),
				'other' => q(ботсвани пула),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(беларусь рубль),
				'one' => q(беларусь рубль),
				'other' => q(беларусь рубль),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(беларусь рубль \(2000–2016\)),
				'one' => q(беларусь рубль \(2000–2016\)),
				'other' => q(беларусь рубль \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белиз доллар),
				'one' => q(белиз доллар),
				'other' => q(белиз доллар),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(канад доллар),
				'one' => q(канад доллар),
				'other' => q(канад доллар),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(конго франк),
				'one' => q(конго франк),
				'other' => q(конго франк),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцарь франк),
				'one' => q(швейцарь франк),
				'other' => q(швейцарь франк),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чилийн песо),
				'one' => q(чилийн песо),
				'other' => q(чилийн песо),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(Хятадын юань),
				'one' => q(Хятадын юань),
				'other' => q(Хятадын юань),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(хятад юань),
				'one' => q(хятад юань),
				'other' => q(хятад юань),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбын песо),
				'one' => q(колумбын песо),
				'other' => q(колумбын песо),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(коста рикагийн колон),
				'one' => q(коста рикагийн колон),
				'other' => q(коста рикагийн колон),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(кубын хөрвөгч песо),
				'one' => q(кубын хөрвөгч песо),
				'other' => q(кубын хөрвөгч песо),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(кубын песо),
				'one' => q(кубын песо),
				'other' => q(кубын песо),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(кабо-верде эскудо),
				'one' => q(кабо-верде эскудо),
				'other' => q(кабо-верде эскудо),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чехийн коруна),
				'one' => q(чехийн коруна),
				'other' => q(чехийн коруна),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(жибоути франк),
				'one' => q(жибоути франк),
				'other' => q(жибоути франк),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(данийн крон),
				'one' => q(данийн крон),
				'other' => q(данийн крон),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(доминиканы песо),
				'one' => q(доминиканы песо),
				'other' => q(доминиканы песо),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(алжир доллар),
				'one' => q(алжир доллар),
				'other' => q(алжир доллар),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(египет паунд),
				'one' => q(египет паунд),
				'other' => q(египет паунд),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(эритрей накфа),
				'one' => q(эритрей накфа),
				'other' => q(эритрей накфа),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(этиоп бирр),
				'one' => q(этиоп бирр),
				'other' => q(этиоп бирр),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(евро),
				'one' => q(евро),
				'other' => q(евро),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(фижи доллар),
				'one' => q(фижи доллар),
				'other' => q(фижи доллар),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фолклэнд арлын паунд),
				'one' => q(фолклэнд арлын паунд),
				'other' => q(фолклэнд арлын паунд),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(британийн фунт),
				'one' => q(британийн фунт),
				'other' => q(британийн фунт),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(гүржийн лари),
				'one' => q(гүржийн лари),
				'other' => q(гүржийн лари),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(гана седи),
				'one' => q(гана седи),
				'other' => q(гана седи),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гибралтар паунд),
				'one' => q(гибралтар паунд),
				'other' => q(гибралтар паунд),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(гамби даласи),
				'one' => q(гамби даласи),
				'other' => q(гамби даласи),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(гвиней франк),
				'one' => q(гвиней франк),
				'other' => q(гвиней франк),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемалын кецал),
				'one' => q(гватемалын кецал),
				'other' => q(гватемалын кецал),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гайана доллар),
				'one' => q(гайана доллар),
				'other' => q(гайана доллар),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(хонгконг доллар),
				'one' => q(хонгконг доллар),
				'other' => q(хонгконг доллар),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондурасын лемпира),
				'one' => q(гондурасын лемпира),
				'other' => q(гондурасын лемпира),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорватын куна),
				'one' => q(хорватын куна),
				'other' => q(хорватын куна),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(гаитийн гоурд),
				'one' => q(гаитийн гоурд),
				'other' => q(гаитийн гоурд),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(унгарын форинт),
				'one' => q(унгарын форинт),
				'other' => q(унгарын форинт),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(индонези рупи),
				'one' => q(индонези рупи),
				'other' => q(индонези рупи),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(израилийн шинэ шекел),
				'one' => q(израилийн шинэ шекел),
				'other' => q(израилийн шинэ шекел),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(энэтхэг рупи),
				'one' => q(энэтхэг рупи),
				'other' => q(энэтхэг рупи),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ирак динар),
				'one' => q(ирак динар),
				'other' => q(ирак динар),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(иран риал),
				'one' => q(иран риал),
				'other' => q(иран риал),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(исландын крон),
				'one' => q(исландын крон),
				'other' => q(исландын крон),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ямайк доллар),
				'one' => q(ямайк доллар),
				'other' => q(ямайк доллар),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(йордан динар),
				'one' => q(йордан динар),
				'other' => q(йордан динар),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(япон иен),
				'one' => q(япон иен),
				'other' => q(япон иен),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(кени шиллинг),
				'one' => q(кени шиллинг),
				'other' => q(кени шиллинг),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(кыргыз сом),
				'one' => q(кыргыз сом),
				'other' => q(кыргыз сом),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(камбож риел),
				'one' => q(камбож риел),
				'other' => q(камбож риел),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(комор франк),
				'one' => q(комор франк),
				'other' => q(комор франк),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(хойд солонгос вон),
				'one' => q(хойд солонгос вон),
				'other' => q(хойд солонгос вон),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(өмнөд солонгос вон),
				'one' => q(өмнөд солонгос вон),
				'other' => q(өмнөд солонгос вон),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(кувейт динар),
				'one' => q(кувейт динар),
				'other' => q(кувейт динар),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(кайман арлын доллар),
				'one' => q(кайман арлын доллар),
				'other' => q(кайман арлын доллар),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(казахын тэнгэ),
				'one' => q(казахын тэнгэ),
				'other' => q(казахын тэнгэ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(лаосын кип),
				'one' => q(лаосын кип),
				'other' => q(лаосын кип),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ливан паунд),
				'one' => q(ливан паунд),
				'other' => q(ливан паунд),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(шри-ланк рупи),
				'one' => q(шри-ланк рупи),
				'other' => q(шри-ланк рупи),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(либери доллар),
				'one' => q(либери доллар),
				'other' => q(либери доллар),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литвийн литас),
				'one' => q(литвийн литас),
				'other' => q(литвийн литас),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвийн лац),
				'one' => q(латвийн лац),
				'other' => q(латвийн лац),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ливи доллар),
				'one' => q(ливи доллар),
				'other' => q(ливи доллар),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(мароккогийн дирхам),
				'one' => q(мароккогийн дирхам),
				'other' => q(мароккогийн дирхам),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(молдавын леу),
				'one' => q(молдавын леу),
				'other' => q(молдавын леу),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(малайн ариари),
				'one' => q(малайн ариари),
				'other' => q(малайн ариари),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македони динар),
				'one' => q(македони динар),
				'other' => q(македони динар),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(мьянмарын киат),
				'one' => q(мьянмарын киат),
				'other' => q(мьянмарын киат),
			},
		},
		'MNT' => {
			symbol => '₮',
			display_name => {
				'currency' => q(төгрөг),
				'one' => q(төгрөг),
				'other' => q(төгрөг),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(макаогийн патака),
				'one' => q(макаогийн патака),
				'other' => q(макаогийн патака),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(мавритан угия),
				'one' => q(мавритан угия),
				'other' => q(мавритан угия),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(мавритын рупи),
				'one' => q(мавритын рупи),
				'other' => q(мавритын рупи),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(мальдив руфия),
				'one' => q(мальдив руфия),
				'other' => q(мальдив руфия),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(малави квача),
				'one' => q(малави квача),
				'other' => q(малави квача),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(мексикийн песо),
				'one' => q(мексикийн песо),
				'other' => q(мексикийн песо),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(малайзын рингит),
				'one' => q(малайзын рингит),
				'other' => q(малайзын рингит),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(мозамбик метикал),
				'one' => q(мозамбик метикал),
				'other' => q(мозамбик метикал),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(намиби доллар),
				'one' => q(намиби доллар),
				'other' => q(намиби доллар),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(нигери найра),
				'one' => q(нигери найра),
				'other' => q(нигери найра),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(никарагуагийн кордоба),
				'one' => q(никарагуагийн кордоба),
				'other' => q(никарагуагийн кордоба),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвегийн крон),
				'one' => q(норвегийн крон),
				'other' => q(норвегийн крон),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(балба рупи),
				'one' => q(балба рупи),
				'other' => q(балба рупи),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(шинэ зеланд доллар),
				'one' => q(шинэ зеланд доллар),
				'other' => q(шинэ зеланд доллар),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(омани риал),
				'one' => q(омани риал),
				'other' => q(омани риал),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панамын бальбоа),
				'one' => q(панамын бальбоа),
				'other' => q(панамын бальбоа),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перугийн соль),
				'one' => q(перугийн соль),
				'other' => q(перугийн соль),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(папуа-шинэ гвинейн кина),
				'one' => q(папуа-шинэ гвинейн кина),
				'other' => q(папуа-шинэ гвинейн кина),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(филиппин песо),
				'one' => q(филиппин песо),
				'other' => q(филиппин песо),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(пакистан рупи),
				'one' => q(пакистан рупи),
				'other' => q(пакистан рупи),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польшийн злот),
				'one' => q(польшийн злот),
				'other' => q(польшийн злот),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвайн гуарани),
				'one' => q(парагвайн гуарани),
				'other' => q(парагвайн гуарани),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(катар риал),
				'one' => q(катар риал),
				'other' => q(катар риал),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румыны леу),
				'one' => q(румыны леу),
				'other' => q(румыны леу),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(серб динар),
				'one' => q(серб динар),
				'other' => q(серб динар),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(орос рубль),
				'one' => q(орос рубль),
				'other' => q(орос рубль),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(руанд франк),
				'one' => q(руанд франк),
				'other' => q(руанд франк),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(сауди риал),
				'one' => q(сауди риал),
				'other' => q(сауди риал),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(соломон арлын доллар),
				'one' => q(соломон арлын доллар),
				'other' => q(соломон арлын доллар),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(сейшел рупи),
				'one' => q(сейшел рупи),
				'other' => q(сейшел рупи),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(судан паунд),
				'one' => q(судан паунд),
				'other' => q(судан паунд),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(шведийн крон),
				'one' => q(шведийн крон),
				'other' => q(шведийн крон),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(сингапур доллар),
				'one' => q(сингапур доллар),
				'other' => q(сингапур доллар),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(сент хелена фунт),
				'one' => q(сент хелена паунд),
				'other' => q(сент хелена фунт),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(сьерра леоны леон),
				'one' => q(сьерра леоне леоне),
				'other' => q(сьерра леоне леоне),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(сомали шиллинг),
				'one' => q(сомали шиллинг),
				'other' => q(сомали шиллинг),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринам доллар),
				'one' => q(суринам доллар),
				'other' => q(суринам доллар),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(өмнөд судан паунд),
				'one' => q(өмнөд судан паунд),
				'other' => q(өмнөд судан паунд),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(сан-томе ба принсипи добра),
				'one' => q(сан-томе ба принсипи добра),
				'other' => q(сан-томе ба принсипи добра),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(сири паунд),
				'one' => q(сири паунд),
				'other' => q(сири паунд),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(свазиланд лилангени),
				'one' => q(свазиланд лилангени),
				'other' => q(свазиланд лилангени),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(тайландын бат),
				'one' => q(тайландын бат),
				'other' => q(тайландын бат),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(тажикийн сомон),
				'one' => q(тажикийн сомон),
				'other' => q(тажикийн сомон),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(туркмен манат),
				'one' => q(туркмен манат),
				'other' => q(туркмен манат),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(тунис доллар),
				'one' => q(тунис доллар),
				'other' => q(тунис доллар),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(тонгагийн панга),
				'one' => q(тонгагийн панга),
				'other' => q(тонгагийн панга),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(туркийн лира),
				'one' => q(туркийн лира),
				'other' => q(туркийн лира),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(тринидад ба тобаго доллар),
				'one' => q(тринидад ба тобаго доллар),
				'other' => q(тринидад ба тобаго доллар),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(шинэ тайвань доллар),
				'one' => q(шинэ тайвань доллар),
				'other' => q(шинэ тайвань доллар),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(танзани шиллинг),
				'one' => q(танзани шиллинг),
				'other' => q(танзани шиллинг),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(украины гривня),
				'one' => q(украины гривня),
				'other' => q(украины гривня),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(уганд шиллинг),
				'one' => q(уганд шиллинг),
				'other' => q(уганд шиллинг),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(америк доллар),
				'one' => q(америк доллар),
				'other' => q(америк доллар),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвайн песо),
				'one' => q(уругвайн песо),
				'other' => q(уругвайн песо),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(узбекийн сом),
				'one' => q(узбекийн сом),
				'other' => q(узбекийн сом),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуэлийн боливар),
				'one' => q(венесуэлийн боливар),
				'other' => q(венесуэлийн боливар),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(вьетнамын донг),
				'one' => q(вьетнамын донг),
				'other' => q(вьетнамын донг),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(вануатугийн вату),
				'one' => q(вануатугийн вату),
				'other' => q(вануатугийн вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(самоагийн тала),
				'one' => q(самоагийн тала),
				'other' => q(самоагийн тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(төв африкийн франк),
				'one' => q(төв африкийн франк),
				'other' => q(төв африкийн франк),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(зүүн карибийн доллар),
				'one' => q(зүүн карибийн доллар),
				'other' => q(зүүн карибийн доллар),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(баруун африкийн франк),
				'one' => q(баруун африкийн франк),
				'other' => q(баруун африкийн франк),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(францын колоний франк),
				'one' => q(францын колоний франк),
				'other' => q(францын колоний франк),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(тодорхойгүй мөнгөн тэмдэгт),
				'one' => q(\(тодорхойгүй мөнгөн тэмдэгтийн нэгж\)),
				'other' => q(\(тодорхойгүй мөнгөн тэмдэгт\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(йемен риал),
				'one' => q(йемен риал),
				'other' => q(йемен риал),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(өмнөд африкийн ранд),
				'one' => q(өмнөд африкийн ранд),
				'other' => q(өмнөд африкийн ранд),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замби квача \(1968–2012\)),
				'one' => q(Замби квача \(1968–2012\)),
				'other' => q(Замби квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(замби квача),
				'one' => q(замби квача),
				'other' => q(замби квача),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'I',
							'II',
							'III',
							'IV',
							'V',
							'VI',
							'VII',
							'VIII',
							'IX',
							'X',
							'XI',
							'XII'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Нэгдүгээр сар',
							'Хоёрдугаар сар',
							'Гуравдугаар сар',
							'Дөрөвдүгээр сар',
							'Тавдугаар сар',
							'Зургаадугаар сар',
							'Долдугаар сар',
							'Наймдугаар сар',
							'Есдүгээр сар',
							'Аравдугаар сар',
							'Арван нэгдүгээр сар',
							'Арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'I',
							'II',
							'III',
							'IV',
							'V',
							'VI',
							'VII',
							'VIII',
							'IX',
							'X',
							'XI',
							'XII'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Нэгдүгээр сар',
							'Хоёрдугаар сар',
							'Гуравдугаар сар',
							'Дөрөвдүгээр сар',
							'Тавдугаар сар',
							'Зургаадугаар сар',
							'Долдугаар сар',
							'Наймдугаар сар',
							'Есдүгээр сар',
							'Аравдугаар сар',
							'Арван нэгдүгээр сар',
							'Арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					narrow => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					short => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'даваа',
						tue => 'мягмар',
						wed => 'лхагва',
						thu => 'пүрэв',
						fri => 'баасан',
						sat => 'бямба',
						sun => 'ням'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					narrow => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					short => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'даваа',
						tue => 'мягмар',
						wed => 'лхагва',
						thu => 'пүрэв',
						fri => 'баасан',
						sat => 'бямба',
						sun => 'ням'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'I улирал',
						1 => 'II улирал',
						2 => 'III улирал',
						3 => 'IV улирал'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => '1-р улирал',
						1 => '2-р улирал',
						2 => '3-р улирал',
						3 => '4-р улирал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => '1-р улирал',
						1 => '2-р улирал',
						2 => '3-р улирал',
						3 => '4-р улирал'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{ҮӨ},
					'noon' => q{үд дунд},
					'pm' => q{ҮХ},
					'morning1' => q{өглөө},
					'afternoon1' => q{өдөр},
					'night1' => q{шөнө},
					'evening1' => q{орой},
					'midnight' => q{шөнө дунд},
				},
				'narrow' => {
					'night1' => q{шөнө},
					'midnight' => q{шөнө дунд},
					'evening1' => q{орой},
					'afternoon1' => q{өдөр},
					'morning1' => q{өглөө},
					'pm' => q{үх},
					'am' => q{үө},
					'noon' => q{үд дунд},
				},
				'wide' => {
					'am' => q{ү.ө},
					'noon' => q{үд дунд},
					'pm' => q{ү.х},
					'morning1' => q{өглөө},
					'afternoon1' => q{өдөр},
					'night1' => q{шөнө},
					'midnight' => q{шөнө дунд},
					'evening1' => q{орой},
				},
			},
			'stand-alone' => {
				'wide' => {
					'noon' => q{үд дунд},
					'am' => q{ҮӨ},
					'morning1' => q{өглөө},
					'pm' => q{ҮХ},
					'afternoon1' => q{өдөр},
					'midnight' => q{шөнө дунд},
					'evening1' => q{орой},
					'night1' => q{шөнө},
				},
				'abbreviated' => {
					'am' => q{ҮӨ},
					'noon' => q{үд дунд},
					'morning1' => q{өглөө},
					'pm' => q{ҮХ},
					'afternoon1' => q{өдөр},
					'night1' => q{шөнө},
					'evening1' => q{орой},
					'midnight' => q{шөнө дунд},
				},
				'narrow' => {
					'noon' => q{үд дунд},
					'am' => q{ҮӨ},
					'morning1' => q{өглөө},
					'pm' => q{ҮХ},
					'afternoon1' => q{өдөр},
					'midnight' => q{шөнө дунд},
					'evening1' => q{орой},
					'night1' => q{шөнө},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'МЭӨ',
				'1' => 'МЭ'
			},
			narrow => {
				'0' => 'МЭӨ',
				'1' => 'МЭ'
			},
			wide => {
				'0' => 'манай эриний өмнөх',
				'1' => 'манай эриний'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, y 'оны' MM 'сарын' dd},
			'long' => q{y 'оны' MM 'сарын' dd},
			'medium' => q{y MM d},
			'short' => q{y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y 'оны' MMM'ын' d. EEEE 'гараг'.},
			'long' => q{y 'оны' MMM'ын' d},
			'medium' => q{y.MM.dd},
			'short' => q{y.MM.dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss (zzzz)},
			'long' => q{HH:mm:ss (z)},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{dd E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{M-d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E, B h:mm},
			EBhms => q{E, B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{dd E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y 'оны' MMM},
			GyMMMEd => q{G y 'оны' MMM'ын' d, E},
			GyMMMd => q{G y 'оны' MMM'ын' d},
			H => q{HH 'ц'},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM/dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM'ын' d, E},
			MMMMW => q{MMM'ын' W-'р' 'долоо' 'хоног'},
			MMMMd => q{MMM'ын' d},
			MMMd => q{MMM'ын' d},
			Md => q{MM/dd},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y M},
			yMEd => q{y.MM.dd, E},
			yMMM => q{y 'оны' MMM},
			yMMMEd => q{y.MM.dd, E},
			yMMMM => q{y 'оны' MMM},
			yMMMd => q{y.MM.dd},
			yMd => q{y.MM.dd},
			yQQQ => q{y QQQ},
			yQQQQ => q{y 'оны' QQQQ},
			yw => q{Y 'оны' w-'р' 'долоо' 'хоног'},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{E, MM/dd – E, MM/dd},
				d => q{E, MM/dd – E, MM/dd},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MM/dd – E, MM/dd},
				d => q{E, MM/dd – E, MM/dd},
			},
			MMMd => {
				M => q{MM/d – MM/d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{MM/dd–MM/dd},
				d => q{MM/dd–MM/dd},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{GGGGG y-MM – y-MM},
				y => q{GGGGG y-MM – y-MM},
			},
			yMEd => {
				M => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{GGGGG y-MM-dd, E – y-MM-dd, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{GGGGG y-MM-dd – y-MM-dd},
				d => q{GGGGG y-MM-dd – y-MM-dd},
				y => q{GGGGG y-MM-dd – y-MM-dd},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH – HH 'ц'},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH 'ц' v},
			},
			M => {
				M => q{M – M-'р' 'сар'},
			},
			MEd => {
				M => q{E, MM/dd – E, MM/dd},
				d => q{E, MM/dd – E, MM/dd},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, MM/dd – E, MM/dd},
				d => q{E, MM/dd – E, MM/dd},
			},
			MMMd => {
				M => q{MM/d – MM/d},
				d => q{MM/d–d},
			},
			Md => {
				M => q{MM/dd–MM/dd},
				d => q{MM/dd–MM/dd},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{y/MM–MM},
				y => q{y/MM – y/MM},
			},
			yMEd => {
				M => q{E, y/MM/dd – E, y/MM/dd},
				d => q{E, y/MM/dd – E, y/MM/dd},
				y => q{E, y/MM/dd – E, y/MM/dd},
			},
			yMMM => {
				M => q{y/MM–MM},
				y => q{y/MM – y/MM},
			},
			yMMMEd => {
				M => q{E, y/MM/dd – E, y/MM/dd},
				d => q{E, y/MM/dd – E, y/MM/dd},
				y => q{E, y/MM/dd – E, y/MM/dd},
			},
			yMMMM => {
				M => q{y 'оны' MM–MM-'р' 'сар'},
				y => q{y/MM –y/MM},
			},
			yMMMd => {
				M => q{y/MM/dd – MM/dd},
				d => q{y/MM/d–d},
				y => q{y/MM/dd – y/MM/dd},
			},
			yMd => {
				M => q{y/MM/dd –MM/dd},
				d => q{y/MM/dd–dd},
				y => q{y/MM/dd – y/MM/dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} цаг),
		regionFormat => q({0} зуны цаг),
		regionFormat => q({0} стандарт цаг),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#Афганистаны цаг#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абижан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуй#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Биссау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Жибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Жуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровиа#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нжамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Төв Африкийн цаг#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Зүүн Африкийн цаг#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Өмнөд Африкийн стандарт цаг#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Баруун Африкийн зуны цаг#,
				'generic' => q#Баруун Африкийн цаг#,
				'standard' => q#Баруун Африкийн стандарт цаг#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляскийн зуны цаг#,
				'generic' => q#Аляскийн цаг#,
				'standard' => q#Аляскийн стандарт цаг#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазоны зуны цаг#,
				'generic' => q#Амазоны цаг#,
				'standard' => q#Амазоны стандарт цаг#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкораж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаяна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байя#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахья Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Боисе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кэмбрижийн булан#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо-Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Эль Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нэльсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс булан#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нүүк#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гуус булан#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделуп#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемал#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенес, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендик#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Ловер Принсес Квартер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Маригот#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норона#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Била, Хойд Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Төв, Хойд Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Хойд Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ожинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Принс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Испаний боомт#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Арена#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Рэнкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио-Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабель#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент-Бартельми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Жонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Киттс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент Люсиа#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Сандер Бэй#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорз#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йелоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Төв зуны цаг#,
				'generic' => q#Төв цаг#,
				'standard' => q#Төв стандарт цаг#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Зүүн эргийн зуны цаг#,
				'generic' => q#Зүүн эргийн цаг#,
				'standard' => q#Зүүн эргийн стандарт цаг#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Уулын зуны цаг#,
				'generic' => q#Уулын цаг#,
				'standard' => q#Уулын стандарт цаг#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Номхон далайн зуны цаг#,
				'generic' => q#Номхон далайн цаг#,
				'standard' => q#Номхон далайн стандарт цаг#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кэсей#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мөрдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиагийн зуны цаг#,
				'generic' => q#Апиагийн цаг#,
				'standard' => q#Апиагийн стандарт цаг#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабын зуны цаг#,
				'generic' => q#Арабын цаг#,
				'standard' => q#Арабын стандарт цаг#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгирбайен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентины зуны цаг#,
				'generic' => q#Аргентины цаг#,
				'standard' => q#Аргентины стандарт цаг#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Баруун Аргентины зуны цаг#,
				'generic' => q#Баруун Аргентины цаг#,
				'standard' => q#Баруун Аргентины стандарт цаг#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Арменийн зуны цаг#,
				'generic' => q#Арменийн цаг#,
				'standard' => q#Арменийн стандарт цаг#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актөбе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Эрхүү#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Жакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Жайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалем#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Кандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучин#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пёньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорд#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин хот#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сөүл#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улаанбаатар#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрүмчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантын зуны цаг#,
				'generic' => q#Атлантын цаг#,
				'standard' => q#Атлантын стандарт цаг#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фароэ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Өмнөд Жоржиа#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Хелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хилл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Кюрри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Еукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдемэн#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хоу#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перс#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Төв Австралийн зуны цаг#,
				'generic' => q#Төв Австралийн цаг#,
				'standard' => q#Төв Австралийн стандарт цаг#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Австралийн төв баруун эргийн зуны цаг#,
				'generic' => q#Австралийн төв баруун эргийн цаг#,
				'standard' => q#Австралийн төв баруун эргийн стандарт цаг#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Австралийн зүүн эргийн зуны цаг#,
				'generic' => q#Зүүн Австралийн цаг#,
				'standard' => q#Австралийн зүүн эргийн стандарт цаг#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Австралийн баруун эргийн зуны цаг#,
				'generic' => q#Баруун Австралийн цаг#,
				'standard' => q#Австралийн баруун эргийн стандарт цаг#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербайжаны зуны цаг#,
				'generic' => q#Азербайжаны цаг#,
				'standard' => q#Азербайжаны стандарт цаг#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азорын зуны цаг#,
				'generic' => q#Азорын цаг#,
				'standard' => q#Азорын стандарт цаг#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладешийн зуны цаг#,
				'generic' => q#Бангладешийн цаг#,
				'standard' => q#Бангладешийн стандарт цаг#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутаны цаг#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливийн цаг#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилийн зуны цаг#,
				'generic' => q#Бразилийн цаг#,
				'standard' => q#Бразилийн стандарт цаг#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней Даруссаламын цаг#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо Вердийн зуны цаг#,
				'generic' => q#Кабо Вердийн цаг#,
				'standard' => q#Кабо Вердийн стандарт цаг#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморрогийн цаг#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатемын зуны цаг#,
				'generic' => q#Чатемын цаг#,
				'standard' => q#Чатемын стандарт цаг#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чилийн зуны цаг#,
				'generic' => q#Чилийн цаг#,
				'standard' => q#Чилийн стандарт цаг#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Хятадын зуны цаг#,
				'generic' => q#Хятадын цаг#,
				'standard' => q#Хятадын стандарт цаг#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсангийн зуны цаг#,
				'generic' => q#Чойбалсангийн цаг#,
				'standard' => q#Чойбалсангийн стандарт цаг#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Крисмас арлын цаг#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос арлын цаг#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбын зуны цаг#,
				'generic' => q#Колумбын цаг#,
				'standard' => q#Колумбын стандарт цаг#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Күүк арлын хагас зуны цаг#,
				'generic' => q#Күүк арлын цаг#,
				'standard' => q#Күүк арлын стандарт цаг#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Кубын зуны цаг#,
				'generic' => q#Кубын цаг#,
				'standard' => q#Кубын стандарт цаг#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дэвисийн цаг#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон д’Юрвилийн цаг#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Зүүн Тиморын цаг#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Зүүн Исландын зуны цаг#,
				'generic' => q#Зүүн Исландын цаг#,
				'standard' => q#Зүүн Исландын стандарт цаг#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадорын цаг#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Олон улсын зохицуулалттай цаг#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Үл мэдэгдэх хот#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афин#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислав#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бусинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинёв#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирландын стандарт цаг#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинк#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн Арал#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Жерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисбон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британийн зуны цаг#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Парис#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Ром#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшав#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Төв Европын зуны цаг#,
				'generic' => q#Төв Европын цаг#,
				'standard' => q#Төв Европын стандарт цаг#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Зүүн Европын зуны цаг#,
				'generic' => q#Зүүн Европын цаг#,
				'standard' => q#Зүүн Европын стандарт цаг#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Алс дорнод Европын цаг#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Баруун Европын зуны цаг#,
				'generic' => q#Баруун Европын цаг#,
				'standard' => q#Баруун Европын стандарт цаг#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолклендийн арлуудын зуны цаг#,
				'generic' => q#Фолклендийн арлуудын цаг#,
				'standard' => q#Фолклендийн арлуудын стандарт цаг#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фижигийн зуны цаг#,
				'generic' => q#Фижигийн цаг#,
				'standard' => q#Фижигийн стандарт цаг#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Францын Гвианагийн цаг#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Францын Өмнөд ба Антарктидийн цаг#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвичийн цаг#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагосын цаг#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбьегийн цаг#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Гүржийн зуны цаг#,
				'generic' => q#Гүржийн цаг#,
				'standard' => q#Гүржийн стандарт цаг#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Жильбер арлын цаг#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Зүүн Гринландын зуны цаг#,
				'generic' => q#Зүүн Гринландын цаг#,
				'standard' => q#Зүүн Гринландын стандарт цаг#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Баруун Гринландын зуны цаг#,
				'generic' => q#Баруун Гринландын цаг#,
				'standard' => q#Баруун Гринландын стандарт цаг#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Галфийн стандарт цаг#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайанагийн цаг#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Хавай-Алеутын зуны цаг#,
				'generic' => q#Хавай-Алеутын цаг#,
				'standard' => q#Хавай-Алеутын стандарт цаг#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Хонг Конгийн зуны цаг#,
				'generic' => q#Хонг Конгийн цаг#,
				'standard' => q#Хонг Конгийн стандарт цаг#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховдын зуны цаг#,
				'generic' => q#Ховдын цаг#,
				'standard' => q#Ховдын стандарт цаг#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Энэтхэгийн цаг#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Крисмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Энэтхэгийн далайн цаг#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Энэтхэг-Хятадын хойгийн цаг#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Төв Индонезийн цаг#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Зүүн Индонезийн цаг#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Баруун Индонезийн цаг#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Ираны зуны цаг#,
				'generic' => q#Ираны цаг#,
				'standard' => q#Ираны стандарт цаг#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Эрхүүгийн зуны цаг#,
				'generic' => q#Эрхүүгийн цаг#,
				'standard' => q#Эрхүүгийн стандарт цаг#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израилийн зуны цаг#,
				'generic' => q#Израилийн цаг#,
				'standard' => q#Израилийн стандарт цаг#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Японы зуны цаг#,
				'generic' => q#Японы цаг#,
				'standard' => q#Японы стандарт цаг#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Зүүн Казахстаны цаг#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Баруун Казахстаны цаг#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Солонгосын зуны цаг#,
				'generic' => q#Солонгосын цаг#,
				'standard' => q#Солонгосын стандарт цаг#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрэгийн цаг#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярскийн зуны цаг#,
				'generic' => q#Красноярскийн цаг#,
				'standard' => q#Красноярскийн стандарт цаг#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргизийн цаг#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн арлын цаг#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хоугийн зуны цаг#,
				'generic' => q#Лорд Хоугийн цаг#,
				'standard' => q#Лорд Хоугийн стандарт цаг#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Маккуори Арлын цаг#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магаданы зуны цаг#,
				'generic' => q#Магаданы цаг#,
				'standard' => q#Магаданы стандарт цаг#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзын цаг#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдивийн цаг#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркесасын цаг#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршаллын арлын цаг#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикийн зуны цаг#,
				'generic' => q#Маврикийн цаг#,
				'standard' => q#Маврикийн стандарт цаг#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусоны цаг#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Баруун хойд Мексикийн зуны цаг#,
				'generic' => q#Баруун хойд Мексикийн цаг#,
				'standard' => q#Баруун хойд Мексикийн стандарт цаг#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексик-Номхон далайн зуны цаг#,
				'generic' => q#Мексик-Номхон далайн цаг#,
				'standard' => q#Мексик-Номхон далайн стандарт цаг#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улаанбаатарын зуны цаг#,
				'generic' => q#Улаанбаатарын цаг#,
				'standard' => q#Улаанбаатарын стандарт цаг#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москвагийн зуны цаг#,
				'generic' => q#Москвагийн цаг#,
				'standard' => q#Москвагийн стандарт цаг#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянмарын цаг#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науругийн цаг#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Балбын цаг#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Шинэ Каледонийн зуны цаг#,
				'generic' => q#Шинэ Каледонийн цаг#,
				'standard' => q#Шинэ Каледонийн стандарт цаг#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Шинэ Зеландын зуны цаг#,
				'generic' => q#Шинэ Зеландын цаг#,
				'standard' => q#Шинэ Зеландын стандарт цаг#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Нью-Фаундлендын зуны цаг#,
				'generic' => q#Нью-Фаундлендын цаг#,
				'standard' => q#Нью-Фаундлендын стандарт цаг#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэгийн цаг#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#Норфолк арлын цаг#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Норонагийн зуны цаг#,
				'generic' => q#Фернандо де Норонагийн цаг#,
				'standard' => q#Фернандо де Норонагийн стандарт цаг#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирскийн зуны цаг#,
				'generic' => q#Новосибирскийн цаг#,
				'standard' => q#Новосибирскийн стандарт цаг#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омскийн зуны цаг#,
				'generic' => q#Омскийн цаг#,
				'standard' => q#Омскийн стандарт цаг#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оукленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фижи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбьер#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Жонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрэ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кважалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизас#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чүүк#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистаны зуны цаг#,
				'generic' => q#Пакистаны цаг#,
				'standard' => q#Пакистаны стандарт цаг#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палаугийн цаг#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа Шинэ Гвинейн цаг#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвайн зуны цаг#,
				'generic' => q#Парагвайн цаг#,
				'standard' => q#Парагвайн стандарт цаг#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перугийн зуны цаг#,
				'generic' => q#Перугийн цаг#,
				'standard' => q#Перугийн стандарт цаг#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппиний зуны цаг#,
				'generic' => q#Филиппиний цаг#,
				'standard' => q#Филиппиний стандарт цаг#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс арлын цаг#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен-Пьер ба Микелоны зуны цаг#,
				'generic' => q#Сен-Пьер ба Микелоны цаг#,
				'standard' => q#Сен-Пьер ба Микелоны стандарт цаг#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкернийн цаг#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понапегийн цаг#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пёньяны цаг#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюнионы цаг#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротерагийн цаг#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалины зуны цаг#,
				'generic' => q#Сахалины цаг#,
				'standard' => q#Сахалины стандарт цаг#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоагийн зуны цаг#,
				'generic' => q#Самоагийн цаг#,
				'standard' => q#Самоагийн стандарт цаг#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшелийн арлуудын цаг#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапурын цаг#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломоны арлуудын цаг#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Өмнөд Жоржийн цаг#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринамын цаг#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сёвагийн цаг#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таитигийн цаг#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайпейн зуны цаг#,
				'generic' => q#Тайпейн цаг#,
				'standard' => q#Тайпейн стандарт цаг#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Тажикистаны цаг#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелаугийн цаг#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонгагийн зуны цаг#,
				'generic' => q#Тонгагийн цаг#,
				'standard' => q#Тонгагийн стандарт цаг#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чүүкийн цаг#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистаны зуны цаг#,
				'generic' => q#Туркменистаны цаг#,
				'standard' => q#Туркменистаны стандарт цаг#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалугийн цаг#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвайн зуны цаг#,
				'generic' => q#Уругвайн цаг#,
				'standard' => q#Уругвайн стандарт цаг#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистаны зуны цаг#,
				'generic' => q#Узбекистаны цаг#,
				'standard' => q#Узбекистаны стандарт цаг#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануатугийн зуны цаг#,
				'generic' => q#Вануатугийн цаг#,
				'standard' => q#Вануатугийн стандарт цаг#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэлийн цаг#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивостокийн зуны цаг#,
				'generic' => q#Владивостокийн цаг#,
				'standard' => q#Владивостокийн стандарт цаг#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоградын зуны цаг#,
				'generic' => q#Волгоградын цаг#,
				'standard' => q#Волгоградын стандарт цаг#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Востокийн цаг#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Вейк арлын цаг#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллис ба Футунагийн цаг#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутын зуны цаг#,
				'generic' => q#Якутын цаг#,
				'standard' => q#Якутын стандарт цаг#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбургийн зуны цаг#,
				'generic' => q#Екатеринбургийн цаг#,
				'standard' => q#Екатеринбургийн стандарт цаг#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
