package Kubernetes::REST::Result2Object;
  use Moo;
  use IO::K8s;
  use Kubernetes::REST::Error;

  has parser => (is => 'ro', default => sub { IO::K8s->new });

  sub result2return {
    my ($self, $call, $req, $response) = @_;

    if ($response->status >= 400) {
      return $self->process_error($response);
    } else {
      return 1 if (not defined $response->content);
      return $self->process_response($call, $response);
    } 
  }

  sub process_response {
    my ($self, $call, $response) = @_;
    
    my $return_class = $self->method_map->{ $call->method };
    die "No return object" if (not defined $return_class);
    my $object = eval {
      $self->parser->json_to_object($return_class, $response->content);
    };
    Kubernetes::REST::Error->throw(
      type => 'UnparseableResponse',
      message => 'Can\'t parse response ' . $response->content . ' with error ' . $@
    ) if ($@);

    return $object;
  }

  sub process_error {
    my ($self, $response) = @_;

    my $struct = eval {
      $self->parser->decode($response->content);
    };

    Kubernetes::REST::Error->throw(
      type => 'UnparseableResponse',
      message => 'Can\'t parse JSON content',
      detail => $response->content,
    ) if ($@);

    # Throw a Kubernetes::REST::RemoteError exception from
    # the info in $struct
    # {"kind":"Status","apiVersion":"v1","metadata":{},"status":"Failure","message":"Unauthorized","reason":"Unauthorized","code":401}
    Kubernetes::REST::RemoteError->throw(
      status => $response->status,
      type => 'RemoteError',
      message => "$struct->{ message }: $struct->{ reason }",
    );
  }

  has method_map => (is => 'ro', default => sub { {
  
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    CreateInitializerConfiguration => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    CreateMutatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    CreateValidatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    CreateCustomResourceDefinition => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    CreateAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    CreateAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    CreateNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    CreateNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1::DaemonSet',
    CreateNamespacedDeployment => 'IO::K8s::Api::Apps::V1::Deployment',
    CreateNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    CreateNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1::StatefulSet',
    CreateNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    CreateNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    CreateNamespacedDeploymentRollback => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    CreateNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    CreateNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    CreateNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    CreateNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    CreateNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    CreateNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    CreateAuditSink => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    CreateTokenReview => 'IO::K8s::Api::Authentication::V1::TokenReview',
    CreateTokenReview => 'IO::K8s::Api::Authentication::V1beta1::TokenReview',
    CreateNamespacedLocalSubjectAccessReview => 'IO::K8s::Api::Authorization::V1::LocalSubjectAccessReview',
    CreateSelfSubjectAccessReview => 'IO::K8s::Api::Authorization::V1::SelfSubjectAccessReview',
    CreateSelfSubjectRulesReview => 'IO::K8s::Api::Authorization::V1::SelfSubjectRulesReview',
    CreateSubjectAccessReview => 'IO::K8s::Api::Authorization::V1::SubjectAccessReview',
    CreateNamespacedLocalSubjectAccessReview => 'IO::K8s::Api::Authorization::V1beta1::LocalSubjectAccessReview',
    CreateSelfSubjectAccessReview => 'IO::K8s::Api::Authorization::V1beta1::SelfSubjectAccessReview',
    CreateSelfSubjectRulesReview => 'IO::K8s::Api::Authorization::V1beta1::SelfSubjectRulesReview',
    CreateSubjectAccessReview => 'IO::K8s::Api::Authorization::V1beta1::SubjectAccessReview',
    CreateNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    CreateNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    CreateNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    CreateNamespacedJob => 'IO::K8s::Api::Batch::V1::Job',
    CreateNamespacedCronJob => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    CreateNamespacedCronJob => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    CreateCertificateSigningRequest => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    CreateNamespacedLease => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    CreateNamespace => 'IO::K8s::Api::Core::V1::Namespace',
    CreateNamespacedBinding => 'IO::K8s::Api::Core::V1::Binding',
    CreateNamespacedConfigMap => 'IO::K8s::Api::Core::V1::ConfigMap',
    CreateNamespacedEndpoints => 'IO::K8s::Api::Core::V1::Endpoints',
    CreateNamespacedEvent => 'IO::K8s::Api::Core::V1::Event',
    CreateNamespacedLimitRange => 'IO::K8s::Api::Core::V1::LimitRange',
    CreateNamespacedPersistentVolumeClaim => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    CreateNamespacedPod => 'IO::K8s::Api::Core::V1::Pod',
    CreateNamespacedPodBinding => 'IO::K8s::Api::Core::V1::Binding',
    CreateNamespacedPodEviction => 'IO::K8s::Api::Policy::V1beta1::Eviction',
    CreateNamespacedPodTemplate => 'IO::K8s::Api::Core::V1::PodTemplate',
    CreateNamespacedReplicationController => 'IO::K8s::Api::Core::V1::ReplicationController',
    CreateNamespacedResourceQuota => 'IO::K8s::Api::Core::V1::ResourceQuota',
    CreateNamespacedSecret => 'IO::K8s::Api::Core::V1::Secret',
    CreateNamespacedService => 'IO::K8s::Api::Core::V1::Service',
    CreateNamespacedServiceAccount => 'IO::K8s::Api::Core::V1::ServiceAccount',
    CreateNode => 'IO::K8s::Api::Core::V1::Node',
    CreatePersistentVolume => 'IO::K8s::Api::Core::V1::PersistentVolume',
    CreateNamespacedEvent => 'IO::K8s::Api::Events::V1beta1::Event',
    CreateNamespacedDaemonSet => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    CreateNamespacedDeployment => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    CreateNamespacedDeploymentRollback => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    CreateNamespacedIngress => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    CreateNamespacedNetworkPolicy => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    CreateNamespacedReplicaSet => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    CreatePodSecurityPolicy => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    CreateNamespacedNetworkPolicy => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    CreateNamespacedPodDisruptionBudget => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    CreatePodSecurityPolicy => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    CreateClusterRole => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    CreateClusterRoleBinding => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    CreateNamespacedRole => 'IO::K8s::Api::Rbac::V1::Role',
    CreateNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    CreateClusterRole => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    CreateClusterRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    CreateNamespacedRole => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    CreateNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    CreateClusterRole => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    CreateClusterRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    CreateNamespacedRole => 'IO::K8s::Api::Rbac::V1beta1::Role',
    CreateNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    CreatePriorityClass => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    CreatePriorityClass => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    CreateNamespacedPodPreset => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    CreateStorageClass => 'IO::K8s::Api::Storage::V1::StorageClass',
    CreateVolumeAttachment => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    CreateStorageClass => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    CreateVolumeAttachment => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    DeleteCollectionInitializerConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteInitializerConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionMutatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionValidatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteMutatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteValidatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionCustomResourceDefinition => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCustomResourceDefinition => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteAuditSink => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionAuditSink => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCertificateSigningRequest => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionCertificateSigningRequest => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedLease => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedLease => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedConfigMap => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedEndpoints => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedLimitRange => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedPersistentVolumeClaim => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedPod => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedPodTemplate => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedReplicationController => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedResourceQuota => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedSecret => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedServiceAccount => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNode => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionPersistentVolume => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespace => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedConfigMap => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedEndpoints => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedLimitRange => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedPersistentVolumeClaim => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedPod => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedPodTemplate => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedReplicationController => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedResourceQuota => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedSecret => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedServiceAccount => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNode => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeletePersistentVolume => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedIngress => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionPodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedIngress => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeletePodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedPodDisruptionBudget => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionPodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedPodDisruptionBudget => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeletePodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionPriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeletePriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionPriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeletePriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionNamespacedPodPreset => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteNamespacedPodPreset => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteCollectionVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    DeleteVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::Status',
    GetAPIVersions => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroupList',
    GetAdmissionregistrationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetApiextensionsAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetApiregistrationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAppsAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAuditregistrationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAuthenticationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAuthorizationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAutoscalingAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetBatchAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetCertificatesAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetCodeVersion => 'IO::K8s::Apimachinery::Pkg::Version::Info',
    GetCoordinationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetCoreAPIVersions => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIVersions',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetEventsAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetExtensionsAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetNetworkingAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetPolicyAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetRbacAuthorizationAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetSchedulingAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetSettingsAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetStorageAPIGroup => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIGroup',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    GetAPIResources => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::APIResourceList',
    ListInitializerConfiguration => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfigurationList',
    ListMutatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfigurationList',
    ListValidatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfigurationList',
    ListCustomResourceDefinition => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinitionList',
    ListAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIServiceList',
    ListAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIServiceList',
    ListControllerRevisionForAllNamespaces => 'IO::K8s::Api::Apps::V1::ControllerRevisionList',
    ListDaemonSetForAllNamespaces => 'IO::K8s::Api::Apps::V1::DaemonSetList',
    ListDeploymentForAllNamespaces => 'IO::K8s::Api::Apps::V1::DeploymentList',
    ListNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1::ControllerRevisionList',
    ListNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1::DaemonSetList',
    ListNamespacedDeployment => 'IO::K8s::Api::Apps::V1::DeploymentList',
    ListNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1::ReplicaSetList',
    ListNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1::StatefulSetList',
    ListReplicaSetForAllNamespaces => 'IO::K8s::Api::Apps::V1::ReplicaSetList',
    ListStatefulSetForAllNamespaces => 'IO::K8s::Api::Apps::V1::StatefulSetList',
    ListControllerRevisionForAllNamespaces => 'IO::K8s::Api::Apps::V1beta1::ControllerRevisionList',
    ListDeploymentForAllNamespaces => 'IO::K8s::Api::Apps::V1beta1::DeploymentList',
    ListNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta1::ControllerRevisionList',
    ListNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta1::DeploymentList',
    ListNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta1::StatefulSetList',
    ListStatefulSetForAllNamespaces => 'IO::K8s::Api::Apps::V1beta1::StatefulSetList',
    ListControllerRevisionForAllNamespaces => 'IO::K8s::Api::Apps::V1beta2::ControllerRevisionList',
    ListDaemonSetForAllNamespaces => 'IO::K8s::Api::Apps::V1beta2::DaemonSetList',
    ListDeploymentForAllNamespaces => 'IO::K8s::Api::Apps::V1beta2::DeploymentList',
    ListNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta2::ControllerRevisionList',
    ListNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1beta2::DaemonSetList',
    ListNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta2::DeploymentList',
    ListNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1beta2::ReplicaSetList',
    ListNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta2::StatefulSetList',
    ListReplicaSetForAllNamespaces => 'IO::K8s::Api::Apps::V1beta2::ReplicaSetList',
    ListStatefulSetForAllNamespaces => 'IO::K8s::Api::Apps::V1beta2::StatefulSetList',
    ListAuditSink => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSinkList',
    ListHorizontalPodAutoscalerForAllNamespaces => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscalerList',
    ListNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscalerList',
    ListHorizontalPodAutoscalerForAllNamespaces => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscalerList',
    ListNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscalerList',
    ListHorizontalPodAutoscalerForAllNamespaces => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscalerList',
    ListNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscalerList',
    ListJobForAllNamespaces => 'IO::K8s::Api::Batch::V1::JobList',
    ListNamespacedJob => 'IO::K8s::Api::Batch::V1::JobList',
    ListCronJobForAllNamespaces => 'IO::K8s::Api::Batch::V1beta1::CronJobList',
    ListNamespacedCronJob => 'IO::K8s::Api::Batch::V1beta1::CronJobList',
    ListCronJobForAllNamespaces => 'IO::K8s::Api::Batch::V2alpha1::CronJobList',
    ListNamespacedCronJob => 'IO::K8s::Api::Batch::V2alpha1::CronJobList',
    ListCertificateSigningRequest => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequestList',
    ListLeaseForAllNamespaces => 'IO::K8s::Api::Coordination::V1beta1::LeaseList',
    ListNamespacedLease => 'IO::K8s::Api::Coordination::V1beta1::LeaseList',
    ListComponentStatus => 'IO::K8s::Api::Core::V1::ComponentStatusList',
    ListConfigMapForAllNamespaces => 'IO::K8s::Api::Core::V1::ConfigMapList',
    ListEndpointsForAllNamespaces => 'IO::K8s::Api::Core::V1::EndpointsList',
    ListEventForAllNamespaces => 'IO::K8s::Api::Core::V1::EventList',
    ListLimitRangeForAllNamespaces => 'IO::K8s::Api::Core::V1::LimitRangeList',
    ListNamespace => 'IO::K8s::Api::Core::V1::NamespaceList',
    ListNamespacedConfigMap => 'IO::K8s::Api::Core::V1::ConfigMapList',
    ListNamespacedEndpoints => 'IO::K8s::Api::Core::V1::EndpointsList',
    ListNamespacedEvent => 'IO::K8s::Api::Core::V1::EventList',
    ListNamespacedLimitRange => 'IO::K8s::Api::Core::V1::LimitRangeList',
    ListNamespacedPersistentVolumeClaim => 'IO::K8s::Api::Core::V1::PersistentVolumeClaimList',
    ListNamespacedPod => 'IO::K8s::Api::Core::V1::PodList',
    ListNamespacedPodTemplate => 'IO::K8s::Api::Core::V1::PodTemplateList',
    ListNamespacedReplicationController => 'IO::K8s::Api::Core::V1::ReplicationControllerList',
    ListNamespacedResourceQuota => 'IO::K8s::Api::Core::V1::ResourceQuotaList',
    ListNamespacedSecret => 'IO::K8s::Api::Core::V1::SecretList',
    ListNamespacedService => 'IO::K8s::Api::Core::V1::ServiceList',
    ListNamespacedServiceAccount => 'IO::K8s::Api::Core::V1::ServiceAccountList',
    ListNode => 'IO::K8s::Api::Core::V1::NodeList',
    ListPersistentVolume => 'IO::K8s::Api::Core::V1::PersistentVolumeList',
    ListPersistentVolumeClaimForAllNamespaces => 'IO::K8s::Api::Core::V1::PersistentVolumeClaimList',
    ListPodForAllNamespaces => 'IO::K8s::Api::Core::V1::PodList',
    ListPodTemplateForAllNamespaces => 'IO::K8s::Api::Core::V1::PodTemplateList',
    ListReplicationControllerForAllNamespaces => 'IO::K8s::Api::Core::V1::ReplicationControllerList',
    ListResourceQuotaForAllNamespaces => 'IO::K8s::Api::Core::V1::ResourceQuotaList',
    ListSecretForAllNamespaces => 'IO::K8s::Api::Core::V1::SecretList',
    ListServiceAccountForAllNamespaces => 'IO::K8s::Api::Core::V1::ServiceAccountList',
    ListServiceForAllNamespaces => 'IO::K8s::Api::Core::V1::ServiceList',
    ListEventForAllNamespaces => 'IO::K8s::Api::Events::V1beta1::EventList',
    ListNamespacedEvent => 'IO::K8s::Api::Events::V1beta1::EventList',
    ListDaemonSetForAllNamespaces => 'IO::K8s::Api::Extensions::V1beta1::DaemonSetList',
    ListDeploymentForAllNamespaces => 'IO::K8s::Api::Extensions::V1beta1::DeploymentList',
    ListIngressForAllNamespaces => 'IO::K8s::Api::Extensions::V1beta1::IngressList',
    ListNamespacedDaemonSet => 'IO::K8s::Api::Extensions::V1beta1::DaemonSetList',
    ListNamespacedDeployment => 'IO::K8s::Api::Extensions::V1beta1::DeploymentList',
    ListNamespacedIngress => 'IO::K8s::Api::Extensions::V1beta1::IngressList',
    ListNamespacedNetworkPolicy => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicyList',
    ListNamespacedReplicaSet => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSetList',
    ListNetworkPolicyForAllNamespaces => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicyList',
    ListPodSecurityPolicy => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicyList',
    ListReplicaSetForAllNamespaces => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSetList',
    ListNamespacedNetworkPolicy => 'IO::K8s::Api::Networking::V1::NetworkPolicyList',
    ListNetworkPolicyForAllNamespaces => 'IO::K8s::Api::Networking::V1::NetworkPolicyList',
    ListNamespacedPodDisruptionBudget => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudgetList',
    ListPodDisruptionBudgetForAllNamespaces => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudgetList',
    ListPodSecurityPolicy => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicyList',
    ListClusterRole => 'IO::K8s::Api::Rbac::V1::ClusterRoleList',
    ListClusterRoleBinding => 'IO::K8s::Api::Rbac::V1::ClusterRoleBindingList',
    ListNamespacedRole => 'IO::K8s::Api::Rbac::V1::RoleList',
    ListNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1::RoleBindingList',
    ListRoleBindingForAllNamespaces => 'IO::K8s::Api::Rbac::V1::RoleBindingList',
    ListRoleForAllNamespaces => 'IO::K8s::Api::Rbac::V1::RoleList',
    ListClusterRole => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleList',
    ListClusterRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBindingList',
    ListNamespacedRole => 'IO::K8s::Api::Rbac::V1alpha1::RoleList',
    ListNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::RoleBindingList',
    ListRoleBindingForAllNamespaces => 'IO::K8s::Api::Rbac::V1alpha1::RoleBindingList',
    ListRoleForAllNamespaces => 'IO::K8s::Api::Rbac::V1alpha1::RoleList',
    ListClusterRole => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleList',
    ListClusterRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBindingList',
    ListNamespacedRole => 'IO::K8s::Api::Rbac::V1beta1::RoleList',
    ListNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::RoleBindingList',
    ListRoleBindingForAllNamespaces => 'IO::K8s::Api::Rbac::V1beta1::RoleBindingList',
    ListRoleForAllNamespaces => 'IO::K8s::Api::Rbac::V1beta1::RoleList',
    ListPriorityClass => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClassList',
    ListPriorityClass => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClassList',
    ListNamespacedPodPreset => 'IO::K8s::Api::Settings::V1alpha1::PodPresetList',
    ListPodPresetForAllNamespaces => 'IO::K8s::Api::Settings::V1alpha1::PodPresetList',
    ListStorageClass => 'IO::K8s::Api::Storage::V1::StorageClassList',
    ListVolumeAttachment => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachmentList',
    ListStorageClass => 'IO::K8s::Api::Storage::V1beta1::StorageClassList',
    ListVolumeAttachment => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachmentList',
    
    
    PatchInitializerConfiguration => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    PatchMutatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    PatchValidatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    PatchCustomResourceDefinition => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    PatchCustomResourceDefinitionStatus => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    PatchAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    PatchAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    PatchAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    PatchAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    PatchNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    PatchNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1::DaemonSet',
    PatchNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1::DaemonSet',
    PatchNamespacedDeployment => 'IO::K8s::Api::Apps::V1::Deployment',
    PatchNamespacedDeploymentScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    PatchNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1::Deployment',
    PatchNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    PatchNamespacedReplicaSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    PatchNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    PatchNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1::StatefulSet',
    PatchNamespacedStatefulSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    PatchNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1::StatefulSet',
    PatchNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    PatchNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    PatchNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    PatchNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    PatchNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    PatchNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    PatchNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    PatchNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    PatchNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    PatchNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    PatchNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    PatchNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    PatchNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    PatchNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    PatchNamespacedReplicaSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    PatchNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    PatchNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    PatchNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    PatchNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    PatchAuditSink => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    PatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    PatchNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    PatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    PatchNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    PatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    PatchNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    PatchNamespacedJob => 'IO::K8s::Api::Batch::V1::Job',
    PatchNamespacedJobStatus => 'IO::K8s::Api::Batch::V1::Job',
    PatchNamespacedCronJob => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    PatchNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    PatchNamespacedCronJob => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    PatchNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    PatchCertificateSigningRequest => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    PatchCertificateSigningRequestStatus => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    PatchNamespacedLease => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    PatchNamespace => 'IO::K8s::Api::Core::V1::Namespace',
    PatchNamespaceStatus => 'IO::K8s::Api::Core::V1::Namespace',
    PatchNamespacedConfigMap => 'IO::K8s::Api::Core::V1::ConfigMap',
    PatchNamespacedEndpoints => 'IO::K8s::Api::Core::V1::Endpoints',
    PatchNamespacedEvent => 'IO::K8s::Api::Core::V1::Event',
    PatchNamespacedLimitRange => 'IO::K8s::Api::Core::V1::LimitRange',
    PatchNamespacedPersistentVolumeClaim => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    PatchNamespacedPersistentVolumeClaimStatus => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    PatchNamespacedPod => 'IO::K8s::Api::Core::V1::Pod',
    PatchNamespacedPodStatus => 'IO::K8s::Api::Core::V1::Pod',
    PatchNamespacedPodTemplate => 'IO::K8s::Api::Core::V1::PodTemplate',
    PatchNamespacedReplicationController => 'IO::K8s::Api::Core::V1::ReplicationController',
    PatchNamespacedReplicationControllerScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    PatchNamespacedReplicationControllerStatus => 'IO::K8s::Api::Core::V1::ReplicationController',
    PatchNamespacedResourceQuota => 'IO::K8s::Api::Core::V1::ResourceQuota',
    PatchNamespacedResourceQuotaStatus => 'IO::K8s::Api::Core::V1::ResourceQuota',
    PatchNamespacedSecret => 'IO::K8s::Api::Core::V1::Secret',
    PatchNamespacedService => 'IO::K8s::Api::Core::V1::Service',
    PatchNamespacedServiceAccount => 'IO::K8s::Api::Core::V1::ServiceAccount',
    PatchNamespacedServiceStatus => 'IO::K8s::Api::Core::V1::Service',
    PatchNode => 'IO::K8s::Api::Core::V1::Node',
    PatchNodeStatus => 'IO::K8s::Api::Core::V1::Node',
    PatchPersistentVolume => 'IO::K8s::Api::Core::V1::PersistentVolume',
    PatchPersistentVolumeStatus => 'IO::K8s::Api::Core::V1::PersistentVolume',
    PatchNamespacedEvent => 'IO::K8s::Api::Events::V1beta1::Event',
    PatchNamespacedDaemonSet => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    PatchNamespacedDaemonSetStatus => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    PatchNamespacedDeployment => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    PatchNamespacedDeploymentScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    PatchNamespacedDeploymentStatus => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    PatchNamespacedIngress => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    PatchNamespacedIngressStatus => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    PatchNamespacedNetworkPolicy => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    PatchNamespacedReplicaSet => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    PatchNamespacedReplicaSetScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    PatchNamespacedReplicaSetStatus => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    PatchNamespacedReplicationControllerDummyScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    PatchPodSecurityPolicy => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    PatchNamespacedNetworkPolicy => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    PatchNamespacedPodDisruptionBudget => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    PatchNamespacedPodDisruptionBudgetStatus => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    PatchPodSecurityPolicy => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    PatchClusterRole => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    PatchClusterRoleBinding => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    PatchNamespacedRole => 'IO::K8s::Api::Rbac::V1::Role',
    PatchNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    PatchClusterRole => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    PatchClusterRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    PatchNamespacedRole => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    PatchNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    PatchClusterRole => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    PatchClusterRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    PatchNamespacedRole => 'IO::K8s::Api::Rbac::V1beta1::Role',
    PatchNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    PatchPriorityClass => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    PatchPriorityClass => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    PatchNamespacedPodPreset => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    PatchStorageClass => 'IO::K8s::Api::Storage::V1::StorageClass',
    PatchVolumeAttachment => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    PatchStorageClass => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    PatchVolumeAttachment => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    ReadInitializerConfiguration => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    ReadMutatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    ReadValidatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    ReadCustomResourceDefinition => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    ReadCustomResourceDefinitionStatus => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    ReadAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    ReadAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    ReadAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    ReadAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    ReadNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    ReadNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1::DaemonSet',
    ReadNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1::DaemonSet',
    ReadNamespacedDeployment => 'IO::K8s::Api::Apps::V1::Deployment',
    ReadNamespacedDeploymentScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReadNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1::Deployment',
    ReadNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    ReadNamespacedReplicaSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReadNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    ReadNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1::StatefulSet',
    ReadNamespacedStatefulSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReadNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1::StatefulSet',
    ReadNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    ReadNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    ReadNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    ReadNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    ReadNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    ReadNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    ReadNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    ReadNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    ReadNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    ReadNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    ReadNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    ReadNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReadNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    ReadNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    ReadNamespacedReplicaSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReadNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    ReadNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    ReadNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReadNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    ReadAuditSink => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    ReadNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    ReadNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    ReadNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    ReadNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    ReadNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    ReadNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    ReadNamespacedJob => 'IO::K8s::Api::Batch::V1::Job',
    ReadNamespacedJobStatus => 'IO::K8s::Api::Batch::V1::Job',
    ReadNamespacedCronJob => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    ReadNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    ReadNamespacedCronJob => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    ReadNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    ReadCertificateSigningRequest => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    ReadCertificateSigningRequestStatus => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    ReadNamespacedLease => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    ReadComponentStatus => 'IO::K8s::Api::Core::V1::ComponentStatus',
    ReadNamespace => 'IO::K8s::Api::Core::V1::Namespace',
    ReadNamespaceStatus => 'IO::K8s::Api::Core::V1::Namespace',
    ReadNamespacedConfigMap => 'IO::K8s::Api::Core::V1::ConfigMap',
    ReadNamespacedEndpoints => 'IO::K8s::Api::Core::V1::Endpoints',
    ReadNamespacedEvent => 'IO::K8s::Api::Core::V1::Event',
    ReadNamespacedLimitRange => 'IO::K8s::Api::Core::V1::LimitRange',
    ReadNamespacedPersistentVolumeClaim => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    ReadNamespacedPersistentVolumeClaimStatus => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    ReadNamespacedPod => 'IO::K8s::Api::Core::V1::Pod',
    
    ReadNamespacedPodStatus => 'IO::K8s::Api::Core::V1::Pod',
    ReadNamespacedPodTemplate => 'IO::K8s::Api::Core::V1::PodTemplate',
    ReadNamespacedReplicationController => 'IO::K8s::Api::Core::V1::ReplicationController',
    ReadNamespacedReplicationControllerScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReadNamespacedReplicationControllerStatus => 'IO::K8s::Api::Core::V1::ReplicationController',
    ReadNamespacedResourceQuota => 'IO::K8s::Api::Core::V1::ResourceQuota',
    ReadNamespacedResourceQuotaStatus => 'IO::K8s::Api::Core::V1::ResourceQuota',
    ReadNamespacedSecret => 'IO::K8s::Api::Core::V1::Secret',
    ReadNamespacedService => 'IO::K8s::Api::Core::V1::Service',
    ReadNamespacedServiceAccount => 'IO::K8s::Api::Core::V1::ServiceAccount',
    ReadNamespacedServiceStatus => 'IO::K8s::Api::Core::V1::Service',
    ReadNode => 'IO::K8s::Api::Core::V1::Node',
    ReadNodeStatus => 'IO::K8s::Api::Core::V1::Node',
    ReadPersistentVolume => 'IO::K8s::Api::Core::V1::PersistentVolume',
    ReadPersistentVolumeStatus => 'IO::K8s::Api::Core::V1::PersistentVolume',
    ReadNamespacedEvent => 'IO::K8s::Api::Events::V1beta1::Event',
    ReadNamespacedDaemonSet => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    ReadNamespacedDaemonSetStatus => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    ReadNamespacedDeployment => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    ReadNamespacedDeploymentScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReadNamespacedDeploymentStatus => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    ReadNamespacedIngress => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    ReadNamespacedIngressStatus => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    ReadNamespacedNetworkPolicy => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    ReadNamespacedReplicaSet => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    ReadNamespacedReplicaSetScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReadNamespacedReplicaSetStatus => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    ReadNamespacedReplicationControllerDummyScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReadPodSecurityPolicy => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    ReadNamespacedNetworkPolicy => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    ReadNamespacedPodDisruptionBudget => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    ReadNamespacedPodDisruptionBudgetStatus => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    ReadPodSecurityPolicy => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    ReadClusterRole => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    ReadClusterRoleBinding => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    ReadNamespacedRole => 'IO::K8s::Api::Rbac::V1::Role',
    ReadNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    ReadClusterRole => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    ReadClusterRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    ReadNamespacedRole => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    ReadNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    ReadClusterRole => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    ReadClusterRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    ReadNamespacedRole => 'IO::K8s::Api::Rbac::V1beta1::Role',
    ReadNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    ReadPriorityClass => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    ReadPriorityClass => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    ReadNamespacedPodPreset => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    ReadStorageClass => 'IO::K8s::Api::Storage::V1::StorageClass',
    ReadVolumeAttachment => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    ReadStorageClass => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    ReadVolumeAttachment => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    ReplaceInitializerConfiguration => 'IO::K8s::Api::Admissionregistration::V1alpha1::InitializerConfiguration',
    ReplaceMutatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::MutatingWebhookConfiguration',
    ReplaceValidatingWebhookConfiguration => 'IO::K8s::Api::Admissionregistration::V1beta1::ValidatingWebhookConfiguration',
    ReplaceCustomResourceDefinition => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    ReplaceCustomResourceDefinitionStatus => 'IO::K8s::ApiExtensionsApiServer::Pkg::Apis::Apiextensions::V1beta1::CustomResourceDefinition',
    ReplaceAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    ReplaceAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1::APIService',
    ReplaceAPIService => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    ReplaceAPIServiceStatus => 'IO::K8s::KubeAggregator::Pkg::Apis::Apiregistration::V1beta1::APIService',
    ReplaceNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1::ControllerRevision',
    ReplaceNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1::DaemonSet',
    ReplaceNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1::DaemonSet',
    ReplaceNamespacedDeployment => 'IO::K8s::Api::Apps::V1::Deployment',
    ReplaceNamespacedDeploymentScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReplaceNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1::Deployment',
    ReplaceNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    ReplaceNamespacedReplicaSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReplaceNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1::ReplicaSet',
    ReplaceNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1::StatefulSet',
    ReplaceNamespacedStatefulSetScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReplaceNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1::StatefulSet',
    ReplaceNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta1::ControllerRevision',
    ReplaceNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    ReplaceNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    ReplaceNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta1::Deployment',
    ReplaceNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    ReplaceNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta1::Scale',
    ReplaceNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta1::StatefulSet',
    ReplaceNamespacedControllerRevision => 'IO::K8s::Api::Apps::V1beta2::ControllerRevision',
    ReplaceNamespacedDaemonSet => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    ReplaceNamespacedDaemonSetStatus => 'IO::K8s::Api::Apps::V1beta2::DaemonSet',
    ReplaceNamespacedDeployment => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    ReplaceNamespacedDeploymentScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReplaceNamespacedDeploymentStatus => 'IO::K8s::Api::Apps::V1beta2::Deployment',
    ReplaceNamespacedReplicaSet => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    ReplaceNamespacedReplicaSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReplaceNamespacedReplicaSetStatus => 'IO::K8s::Api::Apps::V1beta2::ReplicaSet',
    ReplaceNamespacedStatefulSet => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    ReplaceNamespacedStatefulSetScale => 'IO::K8s::Api::Apps::V1beta2::Scale',
    ReplaceNamespacedStatefulSetStatus => 'IO::K8s::Api::Apps::V1beta2::StatefulSet',
    ReplaceAuditSink => 'IO::K8s::Api::Auditregistration::V1alpha1::AuditSink',
    ReplaceNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    ReplaceNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V1::HorizontalPodAutoscaler',
    ReplaceNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    ReplaceNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta1::HorizontalPodAutoscaler',
    ReplaceNamespacedHorizontalPodAutoscaler => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    ReplaceNamespacedHorizontalPodAutoscalerStatus => 'IO::K8s::Api::Autoscaling::V2beta2::HorizontalPodAutoscaler',
    ReplaceNamespacedJob => 'IO::K8s::Api::Batch::V1::Job',
    ReplaceNamespacedJobStatus => 'IO::K8s::Api::Batch::V1::Job',
    ReplaceNamespacedCronJob => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    ReplaceNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V1beta1::CronJob',
    ReplaceNamespacedCronJob => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    ReplaceNamespacedCronJobStatus => 'IO::K8s::Api::Batch::V2alpha1::CronJob',
    ReplaceCertificateSigningRequest => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    ReplaceCertificateSigningRequestApproval => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    ReplaceCertificateSigningRequestStatus => 'IO::K8s::Api::Certificates::V1beta1::CertificateSigningRequest',
    ReplaceNamespacedLease => 'IO::K8s::Api::Coordination::V1beta1::Lease',
    ReplaceNamespace => 'IO::K8s::Api::Core::V1::Namespace',
    ReplaceNamespaceFinalize => 'IO::K8s::Api::Core::V1::Namespace',
    ReplaceNamespaceStatus => 'IO::K8s::Api::Core::V1::Namespace',
    ReplaceNamespacedConfigMap => 'IO::K8s::Api::Core::V1::ConfigMap',
    ReplaceNamespacedEndpoints => 'IO::K8s::Api::Core::V1::Endpoints',
    ReplaceNamespacedEvent => 'IO::K8s::Api::Core::V1::Event',
    ReplaceNamespacedLimitRange => 'IO::K8s::Api::Core::V1::LimitRange',
    ReplaceNamespacedPersistentVolumeClaim => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    ReplaceNamespacedPersistentVolumeClaimStatus => 'IO::K8s::Api::Core::V1::PersistentVolumeClaim',
    ReplaceNamespacedPod => 'IO::K8s::Api::Core::V1::Pod',
    ReplaceNamespacedPodStatus => 'IO::K8s::Api::Core::V1::Pod',
    ReplaceNamespacedPodTemplate => 'IO::K8s::Api::Core::V1::PodTemplate',
    ReplaceNamespacedReplicationController => 'IO::K8s::Api::Core::V1::ReplicationController',
    ReplaceNamespacedReplicationControllerScale => 'IO::K8s::Api::Autoscaling::V1::Scale',
    ReplaceNamespacedReplicationControllerStatus => 'IO::K8s::Api::Core::V1::ReplicationController',
    ReplaceNamespacedResourceQuota => 'IO::K8s::Api::Core::V1::ResourceQuota',
    ReplaceNamespacedResourceQuotaStatus => 'IO::K8s::Api::Core::V1::ResourceQuota',
    ReplaceNamespacedSecret => 'IO::K8s::Api::Core::V1::Secret',
    ReplaceNamespacedService => 'IO::K8s::Api::Core::V1::Service',
    ReplaceNamespacedServiceAccount => 'IO::K8s::Api::Core::V1::ServiceAccount',
    ReplaceNamespacedServiceStatus => 'IO::K8s::Api::Core::V1::Service',
    ReplaceNode => 'IO::K8s::Api::Core::V1::Node',
    ReplaceNodeStatus => 'IO::K8s::Api::Core::V1::Node',
    ReplacePersistentVolume => 'IO::K8s::Api::Core::V1::PersistentVolume',
    ReplacePersistentVolumeStatus => 'IO::K8s::Api::Core::V1::PersistentVolume',
    ReplaceNamespacedEvent => 'IO::K8s::Api::Events::V1beta1::Event',
    ReplaceNamespacedDaemonSet => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    ReplaceNamespacedDaemonSetStatus => 'IO::K8s::Api::Extensions::V1beta1::DaemonSet',
    ReplaceNamespacedDeployment => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    ReplaceNamespacedDeploymentScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReplaceNamespacedDeploymentStatus => 'IO::K8s::Api::Extensions::V1beta1::Deployment',
    ReplaceNamespacedIngress => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    ReplaceNamespacedIngressStatus => 'IO::K8s::Api::Extensions::V1beta1::Ingress',
    ReplaceNamespacedNetworkPolicy => 'IO::K8s::Api::Extensions::V1beta1::NetworkPolicy',
    ReplaceNamespacedReplicaSet => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    ReplaceNamespacedReplicaSetScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReplaceNamespacedReplicaSetStatus => 'IO::K8s::Api::Extensions::V1beta1::ReplicaSet',
    ReplaceNamespacedReplicationControllerDummyScale => 'IO::K8s::Api::Extensions::V1beta1::Scale',
    ReplacePodSecurityPolicy => 'IO::K8s::Api::Extensions::V1beta1::PodSecurityPolicy',
    ReplaceNamespacedNetworkPolicy => 'IO::K8s::Api::Networking::V1::NetworkPolicy',
    ReplaceNamespacedPodDisruptionBudget => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    ReplaceNamespacedPodDisruptionBudgetStatus => 'IO::K8s::Api::Policy::V1beta1::PodDisruptionBudget',
    ReplacePodSecurityPolicy => 'IO::K8s::Api::Policy::V1beta1::PodSecurityPolicy',
    ReplaceClusterRole => 'IO::K8s::Api::Rbac::V1::ClusterRole',
    ReplaceClusterRoleBinding => 'IO::K8s::Api::Rbac::V1::ClusterRoleBinding',
    ReplaceNamespacedRole => 'IO::K8s::Api::Rbac::V1::Role',
    ReplaceNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1::RoleBinding',
    ReplaceClusterRole => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRole',
    ReplaceClusterRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::ClusterRoleBinding',
    ReplaceNamespacedRole => 'IO::K8s::Api::Rbac::V1alpha1::Role',
    ReplaceNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1alpha1::RoleBinding',
    ReplaceClusterRole => 'IO::K8s::Api::Rbac::V1beta1::ClusterRole',
    ReplaceClusterRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::ClusterRoleBinding',
    ReplaceNamespacedRole => 'IO::K8s::Api::Rbac::V1beta1::Role',
    ReplaceNamespacedRoleBinding => 'IO::K8s::Api::Rbac::V1beta1::RoleBinding',
    ReplacePriorityClass => 'IO::K8s::Api::Scheduling::V1alpha1::PriorityClass',
    ReplacePriorityClass => 'IO::K8s::Api::Scheduling::V1beta1::PriorityClass',
    ReplaceNamespacedPodPreset => 'IO::K8s::Api::Settings::V1alpha1::PodPreset',
    ReplaceStorageClass => 'IO::K8s::Api::Storage::V1::StorageClass',
    ReplaceVolumeAttachment => 'IO::K8s::Api::Storage::V1alpha1::VolumeAttachment',
    ReplaceStorageClass => 'IO::K8s::Api::Storage::V1beta1::StorageClass',
    ReplaceVolumeAttachment => 'IO::K8s::Api::Storage::V1beta1::VolumeAttachment',
    WatchInitializerConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchInitializerConfigurationList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchMutatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchMutatingWebhookConfigurationList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchValidatingWebhookConfiguration => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchValidatingWebhookConfigurationList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCustomResourceDefinition => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCustomResourceDefinitionList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAPIServiceList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAPIService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAPIServiceList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchControllerRevisionListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDaemonSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDeploymentListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevisionList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeploymentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchReplicaSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStatefulSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchControllerRevisionListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDeploymentListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevisionList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeploymentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStatefulSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchControllerRevisionListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDaemonSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDeploymentListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevision => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedControllerRevisionList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeploymentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedStatefulSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchReplicaSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStatefulSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAuditSink => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchAuditSinkList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchHorizontalPodAutoscalerListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscalerList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchHorizontalPodAutoscalerListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscalerList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchHorizontalPodAutoscalerListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscaler => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedHorizontalPodAutoscalerList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchJobListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedJobList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCronJobListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedCronJobList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCronJobListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedCronJob => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedCronJobList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCertificateSigningRequest => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchCertificateSigningRequestList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchLeaseListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedLease => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedLeaseList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchConfigMapListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchEndpointsListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchEventListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchLimitRangeListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespace => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespaceList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedConfigMap => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedConfigMapList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEndpoints => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEndpointsList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEventList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedLimitRange => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedLimitRangeList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPersistentVolumeClaim => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPersistentVolumeClaimList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPod => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodTemplate => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodTemplateList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicationController => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicationControllerList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedResourceQuota => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedResourceQuotaList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedSecret => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedSecretList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedService => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedServiceAccount => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedServiceAccountList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedServiceList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNode => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNodeList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPersistentVolume => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPersistentVolumeClaimListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPersistentVolumeList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodTemplateListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchReplicationControllerListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchResourceQuotaListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchSecretListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchServiceAccountListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchServiceListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchEventListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEvent => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedEventList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDaemonSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchDeploymentListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchIngressListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDaemonSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeployment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedDeploymentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedIngress => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedIngressList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedNetworkPolicyList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSet => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedReplicaSetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNetworkPolicyListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodSecurityPolicyList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchReplicaSetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedNetworkPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedNetworkPolicyList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNetworkPolicyListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodDisruptionBudget => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodDisruptionBudgetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodDisruptionBudgetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodSecurityPolicy => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodSecurityPolicyList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleBindingListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleBindingListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchClusterRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRole => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBinding => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleBindingList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedRoleList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleBindingListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchRoleListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPriorityClassList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPriorityClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPriorityClassList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodPreset => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchNamespacedPodPresetList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchPodPresetListForAllNamespaces => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStorageClassList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchVolumeAttachmentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStorageClass => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchStorageClassList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchVolumeAttachment => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
    WatchVolumeAttachmentList => 'IO::K8s::Apimachinery::Pkg::Apis::Meta::V1::WatchEvent',
  } });

1;
