# Generated by default/object.tt
package Paws::ES::InboundCrossClusterSearchConnection;
  use Moose;
  has ConnectionStatus => (is => 'ro', isa => 'Paws::ES::InboundCrossClusterSearchConnectionStatus');
  has CrossClusterSearchConnectionId => (is => 'ro', isa => 'Str');
  has DestinationDomainInfo => (is => 'ro', isa => 'Paws::ES::DomainInformation');
  has SourceDomainInfo => (is => 'ro', isa => 'Paws::ES::DomainInformation');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::InboundCrossClusterSearchConnection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::InboundCrossClusterSearchConnection object:

  $service_obj->Method(Att1 => { ConnectionStatus => $value, ..., SourceDomainInfo => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::InboundCrossClusterSearchConnection object:

  $result = $service_obj->Method(...);
  $result->Att1->ConnectionStatus

=head1 DESCRIPTION

Specifies details of an inbound connection.

=head1 ATTRIBUTES


=head2 ConnectionStatus => L<Paws::ES::InboundCrossClusterSearchConnectionStatus>

Specifies the C<InboundCrossClusterSearchConnectionStatus> for the
outbound connection.


=head2 CrossClusterSearchConnectionId => Str

Specifies the connection id for the inbound cross-cluster search
connection.


=head2 DestinationDomainInfo => L<Paws::ES::DomainInformation>

Specifies the C<DomainInformation> for the destination Elasticsearch
domain.


=head2 SourceDomainInfo => L<Paws::ES::DomainInformation>

Specifies the C<DomainInformation> for the source Elasticsearch domain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

