# Generated by default/object.tt
package Paws::Quicksight::AnalysisSummary;
  use Moose;
  has AnalysisId => (is => 'ro', isa => 'Str');
  has Arn => (is => 'ro', isa => 'Str');
  has CreatedTime => (is => 'ro', isa => 'Str');
  has LastUpdatedTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::AnalysisSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::AnalysisSummary object:

  $service_obj->Method(Att1 => { AnalysisId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::AnalysisSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AnalysisId

=head1 DESCRIPTION

The summary metadata that describes an analysis.

=head1 ATTRIBUTES


=head2 AnalysisId => Str

The ID of the analysis. This ID displays in the URL.


=head2 Arn => Str

The Amazon Resource Name (ARN) for the analysis.


=head2 CreatedTime => Str

The time that the analysis was created.


=head2 LastUpdatedTime => Str

The time that the analysis was last updated.


=head2 Name => Str

The name of the analysis. This name is displayed in the QuickSight
console.


=head2 Status => Str

The last known status for the analysis.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

