#!/usr/local/bin/perl -sw
#
# $Id: Makefile.PL,v 1.2 1998/07/14 10:55:08 joe Exp joe $
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#
BEGIN { require 5.004 }	# 5.004 is required for Win32
use Config;
use ExtUtils::MakeMaker 5.16, qw(&WriteMakefile $Verbose);
use File::Basename;
use Getopt::Long;

use DBI 0.93;		# must be installed first
use DBI::DBD;
use strict;

if (!exists($ENV{'DBROOT'})) {
    print "You must set the 'DBROOT' variable before running me.\n";
    exit 1;
}

my %opts = 
(
    'NAME'	=> 'DBD::Adabas',
    'VERSION_FROM' => 'Adabas.pm',
    clean	=> { FILES=> 'Adabas.xsi dbdodbc.h' },
    dist	=> {
		#DIST_DEFAULT=> 'clean distcheck disttest ci tardist',
		DIST_DEFAULT=> 'clean distcheck ci tardist',
		PREOP    => '$(MAKE) -f Makefile.old distdir',
		COMPRESS => 'gzip -v9', SUFFIX => 'gz'
	    },
    OBJECT	=> '$(O_FILES)',
);
if ($ExtUtils::MakeMaker::VERSION >= 5.43) {
    $opts{AUTHOR} = 'Tim Bunce and Jeff Urlwin (dbi-users@fugue.com)';
    $opts{ABSTRACT_FROM} = 'ODBC driver for the DBI module.';
    $opts{PREREQ_PM} = { DBI => 0 };
    $opts{CAPI} = 'TRUE' if $Config{archname} =~ /-object\b/i;
}


$::opt_g = 0;
$::opt_o = '';
GetOptions(qw(g! o=s)) or die "Invalid arguments";

$opts{OPTIMIZE} = '-g -O0' if $::opt_g;


print "\nConfiguring DBD::Adabas ...\n
>>>\tRemember to actually *READ* the README file!
   \tAnd re-read it if you have any problems.\n
";

my $dbi_dir      = dbd_dbi_dir();
my $dbi_arch_dir = dbd_dbi_arch_dir();

open(SQLH, ">dbdodbc.h") || die "Can't open dbdodbc.h: $!\n";
print SQLH "/* Do not edit this file. It is automatically written by Makefile.PL.\n";
print SQLH "   Any changes made here will be lost. \n*/\n\n";
print SQLH "#undef WORD /* from perly.y */\n";

if ($^O eq 'MSWin32') {
	my $extrainc = "";
	$extrainc = ";$Config{incpath}\\mfc" if $Config{cc} eq 'bcc32';
    $opts{SKIP} = ['processPL'];
    $opts{DEFINE}  = "";
    $opts{INC}  = "-I$dbi_arch_dir" . $extrainc;
    $opts{LIBS} = ["ODBC32.LIB"];
    $opts{macro}->{EXTRALIB} = 'ODBC32.LIB';
    print SQLH "#include <windows.h>\n";
    print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
}
else {
    my $odbchome = $::opt_o || $ENV{DBROOT} || $ENV{ODBCHOME};
    unless ($odbchome) {
	print "\n";
	print "The DBD::ODBC module needs to link with an ODBC 'Driver Manager'.\n";
	print "(The Driver Manager, in turn, needs one or more database specific ODBC drivers.\n";
	print "The DBD::ODBC module does _not_ include any ODBC drivers!)\n\n";
	print "You need to indicate where your ODBC Driver Manager is installed.\n";
	print "You can do this ether by setting the ODBCHOME environment variable\n";
	print "or by runing 'perl Makefile.PL -o odbcdir'.\n\n";
	print "If you do not have an ODBC Driver Manager you can try building\n";
	print "the free iODBC Driver Manager in the iodbcsrc directory.\n\n";
	die "Makefile.PL aborted.\n";
    }
    die "ODBCHOME environment variable ($odbchome) does not refer to a directory.\n"
	unless -d $odbchome;
    warn "Using ODBC in $odbchome\n";
    $opts{INC}  = "-I. -I$dbi_arch_dir";

    # Try to work out which driver manager is being used.
    # Feel free to come up with neat (or un-neat) hacks to get your's to build!

    my $lib_d1 = "$odbchome/lib";
    my $lib_d2 = "$odbchome/dlls";
    my $libs   = "odbc";
    $opts{LIBS} = " -L$lib_d1 -R$lib_d1 -L$lib_d2 -R$lib_d2 -l$libs";

    my $myodbc = '';	# edit and hack to suit!

    $myodbc = 'iodbc'
		if <$odbchome/*iodbc*>;

    $myodbc = 'empress'
		if <$odbchome/lib/libempodbc.*>;
    $myodbc = 'intersolve'
		if -f "$odbchome/include/qeodbc.h";

    $myodbc = 'adabas'
		if $ENV{DBROOT} && $odbchome eq $ENV{DBROOT} && -f "$odbchome/lib/odbclib.a";
  
    warn "\nUmm, this looks like a $myodbc type of driver manager.\n";


    if ($myodbc eq 'iodbc') {
	my @ilibs = <$odbchome/*iodbc*.*>;
	@ilibs = grep { /\.($Config{so}|$Config{dlext}|a)$/ } @ilibs;
	die "That's odd, I can't see any iodbc libs in $odbchome" unless @ilibs;
	# This is a hack using Intersolve's free Solaris ODBC manager
	# Since it doesn't come with the sql header files (!) we get them from iODBC!
	# Note: we use DEFINE not INC for iODBC so we don't get its config.h
	print "\n";
	print "We expect to find the isql.h, isqlext.h and iodbc.h files (which were\n";
	print "supplied with iODBC) in \$ODBCHOME directory alongside\n";
	print "the @ilibs library.\n\n";
	my $ilibpath = $ilibs[0]; # XXX if both .so and .a, pick based on LINKTYPE?
	my $ilibname = basename($ilibpath);
	$opts{DEFINE} = "-I$odbchome";
	if ($ilibname =~ /^iodbc/) { # no "lib" prefix
	    $opts{LIBS} = "";
	    $opts{dynamic_lib} = { OTHERLDFLAGS => "$ilibpath" };
	}
	else {
	    # remove lib prefix and .so suffix so "-l" style link can be used
	    $ilibname =~ s/^lib(iodbc.*?)\.\w+$/$1/;
	    $opts{LIBS} = "-L$odbchome -l$ilibpath";
	    warn "Warning: LD_LIBRARY_PATH doesn't include $odbchome\n"
		unless $ENV{LD_LIBRARY_PATH} =~ /\Q$odbchome/;
	}
	print SQLH qq{#define FAR \n#define EXPORT \n#define CALLBACK \n};
	print SQLH qq{#include <iodbc.h>\n};
	print SQLH qq{#include <isqlext.h>\n};
	print SQLH qq{#include <isqlext.h>\n};
	print SQLH qq{#include "fixup_t.h"\n};
    }
    elsif ($myodbc eq 'intersolve') {
	$opts{DEFINE}  = "";
  	print SQLH qq{#include <qeodbc.h>\n};
	if (-f "$odbchome/include/sql.h") {
	    print "You seem to have the official header files.\n";
	    $opts{INC} .= " -I$odbchome/include";
	    print SQLH qq{#include <sql.h> \n#include <sqlext.h>\n};
	}
	else {
	    # This is common on Solaris
	    print "You don't seem to have the official header files,\n";
	    print "so I'll use the iODBC ones instead.\n";
	    $opts{INC} .= " -I$odbchome/include -Iiodbcsrc";
	    print SQLH qq{#include <isql.h> \n#include <isqlext.h>\n};
	}
    }
    elsif ($myodbc eq 'empress') {
	$opts{INC} .= " -I$odbchome/include";
	$opts{DEFINE}  = "";
	print SQLH qq{#include <odbcsys.h>\n};
	print SQLH qq{#include <sql.h>\n#include <sqlext.h>\n};
	$opts{LIBS} = "-L$odbchome/lib -R$odbchome/lib -lempodbc";
    }
    elsif ($myodbc eq 'adabas') {
	print SQLH qq{#define FAR \n#define EXPORT \n#define CALLBACK \n};
	print SQLH qq{#include <WINDOWS.H>\n};
	print SQLH qq{#include <sql.h>\n};
	print SQLH qq{#include <sqlext.h>\n};
	print SQLH qq{#include "fixup_t.h"\n};
	$opts{INC} .= " -I$odbchome/incl";
	$opts{LIBS} = "-L$odbchome/lib -lsqlrte -lsqlptc";
	$opts{LDFROM} = "\$(OBJECT) $odbchome/lib/odbclib.a";
    }
    else {
 	print "\n*** WARNING ***\a\n";
 	print "Unknown driver manager. Using default build process.\n";
	print "This will almost certainly fail at some point.\n";
 	print "In which case you will need to edit/hack the Makefile.PL\n";
 	print "to suit your needs. (Specifically to locate your odbc\n";
 	print "library and header files.)\n\n";
	$opts{DEFINE}  = "";
	print SQLH "#include <sql.h> \n#include <sqlext.h>\n";
    }
}

print SQLH "\n";
print SQLH "#include \"fixup_c.h\"\n";
print SQLH "\n";
print SQLH "\n";
close(SQLH);

print "\n";
WriteMakefile(%opts);

local($^W)=0;
print qq{
The DBD::Adabas tests will use these values for the database connection:
    DBI_DSN=$ENV{DBI_DSN}		e.g. dbi:Adabas:demo
    DBI_USER=$ENV{DBI_USER}
    DBI_PASS=$ENV{DBI_PASS}
};
print "Warning: not all required environment variables are set.\n"
	unless ($ENV{DBI_DSN} && $ENV{DBI_USER} && $ENV{DBI_PASS});
print "Warning: DBI_DSN ($ENV{DBI_DSN}) doesn't start with 'dbi:Adabas:'\n"
	if ($ENV{DBI_DSN} && $ENV{DBI_DSN} !~ m/^[dD][bB][iI]:Adabas:/);
print "\n";

sub MY::postamble {
    return dbd_postamble(@_);
}

__END__


