
use strict;
use warnings;

use Test::More;
use Test::DZil;
use Path::Tiny qw( path tempdir );
use Test::Differences qw( eq_or_diff );
require Module::Install;

# FILENAME: basic.t
# CREATED: 07/29/14 02:25:01 by Kent Fredric (kentnl) <kentfredric@gmail.com>
# ABSTRACT: Really basic test to make sure this works

my $scratch = tempdir();
my $ini = simple_ini( [ 'GatherDir', {} ], [ 'ModuleInstall', {} ], );
$scratch->child('dist.ini')->spew_raw($ini);

my $tzil = Builder->from_config(
  {
    dist_root => $scratch->stringify
  }
);

{
  local $@;
  my $failed = 1;
  eval {
    $tzil->build;
    undef $failed;
  };
  ok( !$failed, 'Build O.K.' ) or diag explain $@;
}
{
  my $distini = path( $tzil->tempdir )->child('build/dist.ini');
  ok( -e $distini, 'dist.ini exists' );
  eq_or_diff( $distini->slurp_raw, $ini, 'ini is expected content' );
}
{
  my $mkf = path( $tzil->tempdir )->child('build/Makefile.PL');
  ok( -e $mkf, 'Makefile.PL exists' );
  my $version = $Dist::Zilla::Plugin::ModuleInstall::VERSION;
  my $miver   = $Module::Install::VERSION;

  eq_or_diff( $mkf->slurp_raw, <<"EOF", 'Makefile.PL is expected content' );
use strict;
use warnings;
# Warning: This code was generated by Dist::Zilla::Plugin::ModuleInstall Version ${version}
# As part of Dist::Zilla's build generation.
# Do not modify this file, instead, modify the dist.ini that configures its generation.
use inc::Module::Install $miver;
name 'DZT-Sample';

abstract "Sample\\ DZ\\ Dist";

author "E\\.\\ Xavier\\ Ample\\ \\<example\\\@example\\.org\\>";

version "0\\.001";

license "perl";


# configure requires => configure_requires
configure_requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# build requires => requires
requires  "ExtUtils\\:\\:MakeMaker" => "6\\.42";


# runtime requires => requires

# runtime recommends => recommends

# test requires => test_requires

# :ExecFiles
WriteAll();
EOF
}

my ( $msg, ) = grep { $_->{level} eq 'info' and $_->{message} =~ q^inc/Module/Install\.pm^ } @{ $tzil->log_events };

ok( $msg, "Notice about adding inc::Module::Install" );

my $gtemp = path( $tzil->tempdir )->iterator( { recurse => 1 } );
while ( my $child = $gtemp->() ) {
  note $child;
}

done_testing;

