#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Byte__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Byte__val = -1;
static int32_t FIELD_ID_SPVM__Double__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Double__val = -1;
static int32_t FIELD_ID_SPVM__Float__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Float__val = -1;
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
static int32_t FIELD_ID_SPVM__Long__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Long__val = -1;
static int32_t FIELD_ID_SPVM__Short__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Short__val = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Byte__new = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Double__new = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Float__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Long__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Short__new = - 1;
static int32_t SUB_ID_SPVM__Byte__val = - 1;
static int32_t SUB_ID_SPVM__Double__val = - 1;
static int32_t SUB_ID_SPVM__Float__val = - 1;
static int32_t SUB_ID_SPVM__Int__val = - 1;
static int32_t SUB_ID_SPVM__Long__val = - 1;
static int32_t SUB_ID_SPVM__Short__val = - 1;
static int32_t SUB_ID_SPVM__Comparator__ = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_SPVM__Byte = -1;
static int32_t BASIC_TYPE_ID_SPVM__Double = -1;
static int32_t BASIC_TYPE_ID_SPVM__Float = -1;
static int32_t BASIC_TYPE_ID_SPVM__Int = -1;
static int32_t BASIC_TYPE_ID_SPVM__Long = -1;
static int32_t BASIC_TYPE_ID_SPVM__Short = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_SPVM__Comparator = -1;
static int32_t BASIC_TYPE_ID_TestCase__Callback__Callback = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_double = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_byte_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_int_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_int_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_short_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_short_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_double_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_float_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_int_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_long_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_int_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_int_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_short_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_callback_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_numeric_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_object_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_string(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_callback(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_object(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Byte->new
  {
    if (SUB_ID_SPVM__Byte__new < 0) {
      SUB_ID_SPVM__Byte__new = env->get_sub_id(env, "SPVM::Byte", "new", "SPVM::Byte(byte)");
      if (SUB_ID_SPVM__Byte__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Byte new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Byte__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_BYTE_OBJECT_TO_BYTE
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->byte_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
byte_vars[0] = *(int8_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 719;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 765;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Double->new
  {
    if (SUB_ID_SPVM__Double__new < 0) {
      SUB_ID_SPVM__Double__new = env->get_sub_id(env, "SPVM::Double", "new", "SPVM::Double(double)");
      if (SUB_ID_SPVM__Double__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Double new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Double__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 765;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 765;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_DOUBLE_OBJECT_TO_DOUBLE
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->double_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
double_vars[0] = *(double*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 766;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 768;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Float->new
  {
    if (SUB_ID_SPVM__Float__new < 0) {
      SUB_ID_SPVM__Float__new = env->get_sub_id(env, "SPVM::Float", "new", "SPVM::Float(float)");
      if (SUB_ID_SPVM__Float__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Float new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Float__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 756;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_FLOAT_OBJECT_TO_FLOAT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->float_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
float_vars[0] = *(float*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 757;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 759;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L5: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[2] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 737;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 739;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Long->new
  {
    if (SUB_ID_SPVM__Long__new < 0) {
      SUB_ID_SPVM__Long__new = env->get_sub_id(env, "SPVM::Long", "new", "SPVM::Long(long)");
      if (SUB_ID_SPVM__Long__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Long new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Long__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_LONG_OBJECT_TO_LONG
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->long_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
long_vars[0] = *(int64_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 747;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 749;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_any_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Short->new
  {
    if (SUB_ID_SPVM__Short__new < 0) {
      SUB_ID_SPVM__Short__new = env->get_sub_id(env, "SPVM::Short", "new", "SPVM::Short(short)");
      if (SUB_ID_SPVM__Short__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Short new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Short__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 726;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // CONVERT_SHORT_OBJECT_TO_SHORT
  {
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->short_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
short_vars[0] = *(int16_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 727;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_any_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 729;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_object_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Byte->new
  {
    if (SUB_ID_SPVM__Byte__new < 0) {
      SUB_ID_SPVM__Byte__new = env->get_sub_id(env, "SPVM::Byte", "new", "SPVM::Byte(byte)");
      if (SUB_ID_SPVM__Byte__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Byte new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Byte__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 657;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // CONVERT_BYTE_OBJECT_TO_BYTE
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->byte_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
byte_vars[0] = *(int8_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 658;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L10: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_object_to_byte";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_BYTE_TO_BYTE_OBJECT
  {
    int8_t value = byte_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->byte_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int8_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L11: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Byte__val < 0, 0)) {
      FIELD_ID_SPVM__Byte__val = env->get_field_id(env, "SPVM::Byte", "val", "byte");
      if (FIELD_ID_SPVM__Byte__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Byte val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Byte__val = env->get_field_offset(env, FIELD_ID_SPVM__Byte__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[1] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Byte__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L25;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 255;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_byte_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_byte_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_BYTE_TO_BYTE_OBJECT
  {
    int8_t value = byte_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->byte_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int8_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L8: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Byte__val < 0, 0)) {
      FIELD_ID_SPVM__Byte__val = env->get_field_id(env, "SPVM::Byte", "val", "byte");
      if (FIELD_ID_SPVM__Byte__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Byte val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Byte__val = env->get_field_offset(env, FIELD_ID_SPVM__Byte__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[1] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Byte__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_byte_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L11: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_byte_to_byte_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 127.0;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 127.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_int_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 255;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_int_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 255;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_LONG
  long_vars[0] = (int64_t)byte_vars[0];
L4: // MOVE_CONSTANT_LONG
  long_vars[1] = -1LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_LONG
  long_vars[0] = (int64_t)byte_vars[0];
L4: // MOVE_CONSTANT_LONG
  long_vars[1] = 127LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_short_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 255;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_SHORT
  short_vars[0] = (int16_t)byte_vars[0];
L4: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 65535;
L6: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L7: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_byte_to_short_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 127;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_SHORT
  short_vars[0] = (int16_t)byte_vars[0];
L4: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L6: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L7: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_object_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Double->new
  {
    if (SUB_ID_SPVM__Double__new < 0) {
      SUB_ID_SPVM__Double__new = env->get_sub_id(env, "SPVM::Double", "new", "SPVM::Double(double)");
      if (SUB_ID_SPVM__Double__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Double new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Double__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_DOUBLE_OBJECT_TO_DOUBLE
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->double_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
double_vars[0] = *(double*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 707;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_object_to_double";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 709;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_DOUBLE_TO_DOUBLE_OBJECT
  {
    double value = double_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->double_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(double*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Double__val < 0, 0)) {
      FIELD_ID_SPVM__Double__val = env->get_field_id(env, "SPVM::Double", "val", "double");
      if (FIELD_ID_SPVM__Double__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Double val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Double__val = env->get_field_offset(env, FIELD_ID_SPVM__Double__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[1] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Double__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 127.09999999999999;
L2: // CONVERT_DOUBLE_TO_BYTE
  byte_vars[0] = (int8_t)double_vars[0];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[0]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_double_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_double_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 567;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_DOUBLE_TO_DOUBLE_OBJECT
  {
    double value = double_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->double_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(double*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Double__val < 0, 0)) {
      FIELD_ID_SPVM__Double__val = env->get_field_id(env, "SPVM::Double", "val", "double");
      if (FIELD_ID_SPVM__Double__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Double val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Double__val = env->get_field_offset(env, FIELD_ID_SPVM__Double__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[1] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Double__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_double_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 571;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_double_to_double_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 571;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // CONVERT_DOUBLE_TO_FLOAT
  float_vars[0] = (float)double_vars[0];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L4: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2147483646.0999999;
L2: // CONVERT_DOUBLE_TO_INT
  int_vars[1] = (int32_t)double_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2147483646;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L14;
L12: // INIT_INT
  int_vars[7] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2147483646.0999999;
L2: // CONVERT_DOUBLE_TO_LONG
  long_vars[0] = (int64_t)double_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[1] = 2147483646LL;
L4: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_double_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 32767.099999999999;
L2: // CONVERT_DOUBLE_TO_SHORT
  short_vars[0] = (int16_t)double_vars[0];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_object_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Float->new
  {
    if (SUB_ID_SPVM__Float__new < 0) {
      SUB_ID_SPVM__Float__new = env->get_sub_id(env, "SPVM::Float", "new", "SPVM::Float(float)");
      if (SUB_ID_SPVM__Float__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Float new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Float__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_FLOAT_OBJECT_TO_FLOAT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->float_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
float_vars[0] = *(float*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_object_to_float";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 631;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_FLOAT_TO_FLOAT_OBJECT
  {
    float value = float_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->float_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(float*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Float__val < 0, 0)) {
      FIELD_ID_SPVM__Float__val = env->get_field_id(env, "SPVM::Float", "val", "float");
      if (FIELD_ID_SPVM__Float__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Float val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Float__val = env->get_field_offset(env, FIELD_ID_SPVM__Float__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[1] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Float__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 127.099998;
L2: // CONVERT_FLOAT_TO_BYTE
  byte_vars[0] = (int8_t)float_vars[0];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 32767.0;
L2: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 32767.0;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L4: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[0]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_float_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_float_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_FLOAT_TO_FLOAT_OBJECT
  {
    float value = float_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->float_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(float*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Float < 0) {
      BASIC_TYPE_ID_SPVM__Float = env->get_basic_type_id(env, "SPVM::Float");
      if (BASIC_TYPE_ID_SPVM__Float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Float;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Float__val < 0, 0)) {
      FIELD_ID_SPVM__Float__val = env->get_field_id(env, "SPVM::Float", "val", "float");
      if (FIELD_ID_SPVM__Float__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Float val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Float__val = env->get_field_offset(env, FIELD_ID_SPVM__Float__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[1] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Float__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_float_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_float_to_float_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 132767.094;
L2: // CONVERT_FLOAT_TO_INT
  int_vars[1] = (int32_t)float_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 132767;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L14;
L12: // INIT_INT
  int_vars[7] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 132767.094;
L2: // CONVERT_FLOAT_TO_LONG
  long_vars[0] = (int64_t)float_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[1] = 132767LL;
L4: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_float_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 32767.0996;
L2: // CONVERT_FLOAT_TO_SHORT
  short_vars[0] = (int16_t)float_vars[0];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_object_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L5: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[2] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 678;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_object_to_int";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L21;
L19: // INIT_INT
  int_vars[7] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 609;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 610;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 610;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483647;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2147483647.0;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 32767.0;
L4: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L4: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L14;
L12: // INIT_INT
  int_vars[7] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_int_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_int_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 531;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_int_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_int_to_int_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_LONG
  long_vars[1] = -1LL;
L4: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2147483647;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_LONG
  long_vars[1] = 2147483647LL;
L4: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_int_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 65535;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_object_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_LONG
  *(int64_t*)&stack[0] = long_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Long->new
  {
    if (SUB_ID_SPVM__Long__new < 0) {
      SUB_ID_SPVM__Long__new = env->get_sub_id(env, "SPVM::Long", "new", "SPVM::Long(long)");
      if (SUB_ID_SPVM__Long__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Long new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Long__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L7: // CONVERT_LONG_OBJECT_TO_LONG
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->long_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
long_vars[0] = *(int64_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_object_to_long";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 690;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 618;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_LONG_TO_LONG_OBJECT
  {
    int64_t value = long_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->long_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int64_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 622;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L11: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_SPVM__Long__val < 0, 0)) {
      FIELD_ID_SPVM__Long__val = env->get_field_id(env, "SPVM::Long", "val", "long");
      if (FIELD_ID_SPVM__Long__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Long val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Long__val = env->get_field_offset(env, FIELD_ID_SPVM__Long__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[1] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Long__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 623;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 623;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L15: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L20: // GOTO
  goto L21;
L21: // GOTO
  goto L23;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // CONVERT_LONG_TO_BYTE
  byte_vars[0] = (int8_t)long_vars[0];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2147483647LL;
L2: // CONVERT_LONG_TO_DOUBLE
  double_vars[0] = (double)long_vars[0];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2147483647.0;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 32767LL;
L2: // CONVERT_LONG_TO_FLOAT
  float_vars[0] = (float)long_vars[0];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 32767.0;
L4: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // CONVERT_LONG_TO_INT
  int_vars[1] = (int32_t)long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L14;
L12: // INIT_INT
  int_vars[7] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L4: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_long_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_long_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_LONG_TO_LONG_OBJECT
  {
    int64_t value = long_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->long_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int64_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Long < 0) {
      BASIC_TYPE_ID_SPVM__Long = env->get_basic_type_id(env, "SPVM::Long");
      if (BASIC_TYPE_ID_SPVM__Long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Long;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_SPVM__Long__val < 0, 0)) {
      FIELD_ID_SPVM__Long__val = env->get_field_id(env, "SPVM::Long", "val", "long");
      if (FIELD_ID_SPVM__Long__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Long val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Long__val = env->get_field_offset(env, FIELD_ID_SPVM__Long__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[1] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Long__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_long_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_long_to_long_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_long_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // CONVERT_LONG_TO_SHORT
  short_vars[0] = (int16_t)long_vars[0];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 65535;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_object_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Short->new
  {
    if (SUB_ID_SPVM__Short__new < 0) {
      SUB_ID_SPVM__Short__new = env->get_sub_id(env, "SPVM::Short", "new", "SPVM::Short(short)");
      if (SUB_ID_SPVM__Short__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Short new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Short__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // CONVERT_SHORT_OBJECT_TO_SHORT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->short_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
short_vars[0] = *(int16_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L10: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_object_to_short";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_SHORT_TO_SHORT_OBJECT
  {
    int16_t value = short_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->short_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int16_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L11: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Short__val < 0, 0)) {
      FIELD_ID_SPVM__Short__val = env->get_field_id(env, "SPVM::Short", "val", "short");
      if (FIELD_ID_SPVM__Short__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Short val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Short__val = env->get_field_offset(env, FIELD_ID_SPVM__Short__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[1] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Short__val);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L25;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65535;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_BYTE
  byte_vars[0] = (int8_t)short_vars[0];
L4: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 32767.0;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 32767.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_int_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65535;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_int_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L5: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_long_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65535;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_LONG
  long_vars[0] = (int64_t)short_vars[0];
L4: // MOVE_CONSTANT_LONG
  long_vars[1] = -1LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_long_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32767;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_LONG
  long_vars[0] = (int64_t)short_vars[0];
L4: // MOVE_CONSTANT_LONG
  long_vars[1] = 32767LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65535;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L4: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 65535;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L7: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L8: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_short_to_short_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_short_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 519;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_SHORT_TO_SHORT_OBJECT
  {
    int16_t value = short_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->short_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int16_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L5: // IS_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Short < 0) {
      BASIC_TYPE_ID_SPVM__Short = env->get_basic_type_id(env, "SPVM::Short");
      if (BASIC_TYPE_ID_SPVM__Short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Short;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L8: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Short__val < 0, 0)) {
      FIELD_ID_SPVM__Short__val = env->get_field_id(env, "SPVM::Short", "val", "short");
      if (FIELD_ID_SPVM__Short__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Short val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Short__val = env->get_field_offset(env, FIELD_ID_SPVM__Short__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[1] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Short__val);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_short_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[1];
L11: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_short_to_short_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L13;
  }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L11: // INIT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // CHECK_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      if (env->has_callback(env, object, callback_basic_type_id)) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_callback";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L9: // PUSH_ARG_UNDEF
  *(void**)&stack[1] = NULL;
L10: // PUSH_ARG_UNDEF
  *(void**)&stack[2] = NULL;
L11: // CALL_METHOD_INT
  // SPVM::Comparator->
  {
    void* object = object_vars[2];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,object,object)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Comparator ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_callback";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_callback_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Callback__Callback < 0) {
      BASIC_TYPE_ID_TestCase__Callback__Callback = env->get_basic_type_id(env, "TestCase::Callback::Callback");
      if (BASIC_TYPE_ID_TestCase__Callback__Callback < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Callback::Callback");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Callback__Callback;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_callback_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Callback__Callback < 0) {
      BASIC_TYPE_ID_TestCase__Callback__Callback = env->get_basic_type_id(env, "TestCase::Callback::Callback");
      if (BASIC_TYPE_ID_TestCase__Callback__Callback < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Callback::Callback");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Callback__Callback;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_callback_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L12;
L10: // INIT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_numeric_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[12] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 9;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L10: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L13: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_short < 0) {
      BASIC_TYPE_ID_short = env->get_basic_type_id(env, "short");
      if (BASIC_TYPE_ID_short < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_short;
    int32_t check_type_dimension = 1;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 11;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L17: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 12;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_int;
    int32_t check_type_dimension = 1;
    void* object = object_vars[4];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[4]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L24: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L27: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_long < 0) {
      BASIC_TYPE_ID_long = env->get_basic_type_id(env, "long");
      if (BASIC_TYPE_ID_long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_long;
    int32_t check_type_dimension = 1;
    void* object = object_vars[6];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[6]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L31: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L34: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_float < 0) {
      BASIC_TYPE_ID_float = env->get_basic_type_id(env, "float");
      if (BASIC_TYPE_ID_float < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_float;
    int32_t check_type_dimension = 1;
    void* object = object_vars[8];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L38: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[10], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L41: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_double < 0) {
      BASIC_TYPE_ID_double = env->get_basic_type_id(env, "double");
      if (BASIC_TYPE_ID_double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_double;
    int32_t check_type_dimension = 1;
    void* object = object_vars[10];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[10]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_numeric_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L45: // INIT_INT
  int_vars[4] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_object_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_object_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_object_array";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 82;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L12;
L10: // INIT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_string(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  double double_vars[1];
  float float_vars[1];
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 23;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // CONVERT_BYTE_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId8, byte_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], string);
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // CONVERT_SHORT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId16, short_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string);
  }
L12: // MOVE_CONSTANT_LONG
  long_vars[0] = 23LL;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_LONG_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId64, long_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L15: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L17: // CONVERT_FLOAT_TO_STRING
  {
    sprintf(convert_string_buffer, "%g", float_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string);
  }
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONVERT_DOUBLE_TO_STRING
  {
    sprintf(convert_string_buffer, "%g", double_vars[0]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string);
  }
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x32\x33", 2));
L23: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L29: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x32\x33", 2));
L30: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x32\x33", 2));
L37: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L43: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x32\x33", 2));
L44: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L50: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x30\x2E\x32\x35", 4));
L51: // STRING_EQ
  {
    void* object1 = object_vars[4];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L55: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L57: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x30\x2E\x32\x35", 4));
L58: // STRING_EQ
  {
    void* object1 = object_vars[5];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_string";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L86;
L65: // GOTO
  goto L66;
L66: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 11;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L67: // GOTO
  goto L69;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 11;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // GOTO
  goto L72;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // GOTO
  goto L75;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L76: // GOTO
  goto L78;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // GOTO
  goto L81;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L84: // INIT_INT
  int_vars[6] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_any_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_undef_to_any_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L16;
  }
L6: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L16;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L16;
L14: // INIT_INT
  int_vars[6] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L16;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_callback(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // CHECK_CALLBACK
  {
    if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
      BASIC_TYPE_ID_SPVM__Comparator = env->get_basic_type_id(env, "SPVM::Comparator");
      if (BASIC_TYPE_ID_SPVM__Comparator < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Comparator");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t callback_basic_type_id = BASIC_TYPE_ID_SPVM__Comparator;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      if (env->has_callback(env, object, callback_basic_type_id)) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_undef_to_callback";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L16;
  }
L6: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L16;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L16;
L14: // INIT_INT
  int_vars[6] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L16;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Convert__convert_to_undef_to_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Convert";
    const char* sub_name = "convert_to_undef_to_object";
    const char* file = "TestCase/Convert.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L16;
  }
L6: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L16;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L16;
L14: // INIT_INT
  int_vars[6] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L16;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


