#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Inline__constant_sub_return_double = - 1;
static int32_t SUB_ID_TestCase__Inline__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Inline = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Inline__constant_sub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__Inline__constant_sub_return_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Inline()
int32_t SPPRECOMPILE__TestCase__Inline__new(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Inline__new_inline(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Inline__constant_sub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // TestCase::Inline->constant_sub_return_double
  {
    if (SUB_ID_TestCase__Inline__constant_sub_return_double < 0) {
      SUB_ID_TestCase__Inline__constant_sub_return_double = env->get_sub_id(env, "TestCase::Inline", "constant_sub_return_double", "double()");
      if (SUB_ID_TestCase__Inline__constant_sub_return_double < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Inline constant_sub_return_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Inline__constant_sub_return_double;
    exception_flag = SPPRECOMPILE__TestCase__Inline__constant_sub_return_double(env, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Inline";
    const char* sub_name = "constant_sub";
    const char* file = "TestCase/Inline.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Inline__constant_sub_return_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Inline__new(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Inline < 0) {
      BASIC_TYPE_ID_TestCase__Inline = env->get_basic_type_id(env, "TestCase::Inline");
      if (BASIC_TYPE_ID_TestCase__Inline < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Inline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Inline;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L7;
L7: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L8: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Inline__new_inline(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Inline->new
  {
    if (SUB_ID_TestCase__Inline__new < 0) {
      SUB_ID_TestCase__Inline__new = env->get_sub_id(env, "TestCase::Inline", "new", "TestCase::Inline()");
      if (SUB_ID_TestCase__Inline__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Inline new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Inline__new;
    exception_flag = SPPRECOMPILE__TestCase__Inline__new(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Inline";
    const char* sub_name = "new_inline";
    const char* file = "TestCase/Inline.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Inline < 0) {
      BASIC_TYPE_ID_TestCase__Inline = env->get_basic_type_id(env, "TestCase::Inline");
      if (BASIC_TYPE_ID_TestCase__Inline < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Inline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Inline;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


