#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
static int32_t FIELD_ID_SPVM__Hash__max_load_factor = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Comparator__ = - 1;
static int32_t SUB_ID_SPVM__Hash__new = - 1;
static int32_t SUB_ID_SPVM__Hash__set = - 1;
static int32_t SUB_ID_SPVM__Hash__copy = - 1;
static int32_t SUB_ID_SPVM__Hash__get = - 1;
static int32_t SUB_ID_SPVM__Int__val = - 1;
static int32_t SUB_ID_SPVM__Hash__exists = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__Hash__delete = - 1;
static int32_t SUB_ID_SPVM__Hash__count = - 1;
static int32_t SUB_ID_SPVM__Hash__new_opt = - 1;
static int32_t SUB_ID_SPVM__Hash___bucket_count = - 1;
static int32_t SUB_ID_SPVM__Hash___index_by_key = - 1;
static int32_t SUB_ID_SPVM__Hash__each = - 1;
static int32_t SUB_ID_SPVM__ObjectList__new = - 1;
static int32_t SUB_ID_SPVM__ObjectList__push = - 1;
static int32_t SUB_ID_SPVM__ObjectList__to_array = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = - 1;
static int32_t SUB_ID_SPVM__Hash__newa = - 1;
static int32_t SUB_ID_SPVM__Hash__keys = - 1;
static int32_t SUB_ID_SPVM__Hash__load_factor = - 1;
static int32_t SUB_ID_SPVM__Hash__values = - 1;
static int32_t SUB_ID_SPVM__Hash__murmur_hash = - 1;
static int32_t SUB_ID_SPVM__Hash___entries = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_SPVM__Int = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_anon2 = -1;
static int32_t BASIC_TYPE_ID_anon3 = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_anon4 = -1;
static int32_t BASIC_TYPE_ID_anon5 = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_anon1 = -1;
// Function Declarations
// [SIG]int(object[],object[],SPVM::Comparator)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_copy(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_delete_with_hash_collision(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_delete_with_no_hash_collision(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_each(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_exists(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_get(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_keys(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_load_factor(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_many_hash_collisions(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_murmur_hash(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_new_capacity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_allocated_capacity_should_power_of_2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_die_when_odd_number_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_do_not_refer_caller_key(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_rehash(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_rehash_with_max_load_factor_0_5(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set_do_not_refer_caller_key(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set_rehash_when_max_load_factor_changes(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_values(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }
  object_vars[2] = *(void**)&stack[2];
  if (object_vars[2] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[2]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[1] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L6: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L13: // GOTO
  goto L14;
L14: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L17: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // GOTO
  goto L85;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L23: // GOTO
  goto L71;
L24: // ARRAY_FETCH_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[5];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L32: // BOOL_INT
  int_vars[0] = int_vars[6];
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L56; }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L39: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object); 
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[5];
L44: // CALL_METHOD_INT
  // SPVM::Comparator->
  {
    void* object = object_vars[2];
    int32_t call_sub_id = env->get_method_sub_id(env, object, "", "int(self,object,object)");
    if (call_sub_id == 0) {
      void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Comparator ");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L46: // BOOL_INT
  int_vars[0] = int_vars[5];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L51: // BOOL_INT
  int_vars[0] = int_vars[5];
L52: // GOTO
  goto L55;
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L54: // BOOL_INT
  int_vars[0] = int_vars[6];
L55: // GOTO
  goto L59;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[7];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // ARRAY_STORE_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L65: // GOTO
  goto L76;
L66: // GOTO
  goto L67;
L67: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L70: // ADD_INT
  int_vars[4] = int_vars[4] + int_vars[6];
L71: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[5] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L73: // LT_INT
  int_vars[0] = (int_vars[4] < int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L76: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[3];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L112;
L81: // GOTO
  goto L82;
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L84: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L85: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L87: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // GOTO
  goto L103;
L93: // ARRAY_FETCH_INT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 380;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L95: // BOOL_INT
  int_vars[0] = int_vars[3];
L96: // IF_NE_ZERO
  if (int_vars[0]) { goto L100; }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L112;
L99: // GOTO
  goto L100;
L100: // MOVE_INT
  int_vars[5] = int_vars[2];
L101: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L102: // ADD_INT
  int_vars[2] = int_vars[5] + int_vars[6];
L103: // ARRAY_LENGTH
  if (object_vars[3] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[3] + (intptr_t)env->object_length_offset);
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "_same_unordered_objects";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L112;
  }
L105: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L110: // INIT_INT
  int_vars[5] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_copy(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 535;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // GOTO
  goto L34;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x6B\x65\x79", 3));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string);
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L11: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L16: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L19: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[2];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object);
  }
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[6];
L23: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 537;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L35: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L6; }
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // CALL_SUB_OBJECT
  // SPVM::Hash->copy
  {
    if (SUB_ID_SPVM__Hash__copy < 0) {
      SUB_ID_SPVM__Hash__copy = env->get_sub_id(env, "SPVM::Hash", "copy", "SPVM::Hash(self)");
      if (SUB_ID_SPVM__Hash__copy < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash copy");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__copy;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // GOTO
  goto L84;
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L46: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x6B\x65\x79", 3));
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L48: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L50: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "", 0));
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L55: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L60: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L63: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[7];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[7]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L65: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[8];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L67: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L71: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L73: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L79: // GOTO
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L83: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[5];
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L85: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_NE_ZERO
  if (int_vars[0]) { goto L45; }
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L90: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x65\x78\x74\x72\x61\x5F\x6B\x65\x79", 9));
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L92: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L93: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[2];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L97: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L101: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L102: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x65\x78\x74\x72\x61\x5F\x6B\x65\x79\x73", 10));
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L105: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L107: // BOOL_INT
  int_vars[0] = int_vars[2];
L108: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L113; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L115: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x65\x78\x74\x72\x61\x5F\x6B\x65\x79", 9));
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L118: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_copy";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 549;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L120: // BOOL_INT
  int_vars[0] = int_vars[4];
L121: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L122: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L123: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L125: // GOTO
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L131;
L129: // INIT_INT
  int_vars[6] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L131;
L131: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L132: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_delete_with_hash_collision(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 203;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L14: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 203;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L22: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L23: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L28: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L40: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L42: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L45: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L57: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L59: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L62: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L68: // GOTO
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L71: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L74: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L79: // GOTO
  goto L80;
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L85: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L87: // IS_UNDEF
  int_vars[0] = object_vars[2] == NULL;
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L90: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L97: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L100: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L105: // GOTO
  goto L106;
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L107: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L108: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L110: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L113: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L114: // BOOL_INT
  int_vars[0] = int_vars[0];
L115: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L116: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L119: // GOTO
  goto L120;
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L122: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L123: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L124: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L125: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L126: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L128: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L129: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L131: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L133: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L134: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_NE_ZERO
  if (int_vars[0]) { goto L143; }
L137: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L138: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L140: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L141: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L142: // GOTO
  goto L143;
L143: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L144: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L145: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L147: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L148: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L149: // BOOL_INT
  int_vars[0] = int_vars[0];
L150: // IF_NE_ZERO
  if (int_vars[0]) { goto L154; }
L151: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L153: // GOTO
  goto L154;
L154: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L155: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L156: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L157: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L158: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L173;
  }
L160: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L161: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_NE_ZERO
  if (int_vars[0]) { goto L168; }
L164: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L165: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L166: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L173;
L167: // GOTO
  goto L168;
L168: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L169: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L170: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L173;
L171: // INIT_INT
  int_vars[6] = 0;
L172: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L173;
L173: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L174: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_delete_with_no_hash_collision(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L31: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L36: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L44: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L45: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L50: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L55: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L56: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L57: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L60: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L61: // CALL_SUB_INT
  // SPVM::Hash->_index_by_key
  {
    if (SUB_ID_SPVM__Hash___index_by_key < 0) {
      SUB_ID_SPVM__Hash___index_by_key = env->get_sub_id(env, "SPVM::Hash", "_index_by_key", "int(string,int)");
      if (SUB_ID_SPVM__Hash___index_by_key < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _index_by_key");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___index_by_key;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L64: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L65: // MOVE_CONSTANT_INT
  int_vars[5] = 123456789;
L66: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L67: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L68: // CALL_SUB_INT
  // SPVM::Hash->_index_by_key
  {
    if (SUB_ID_SPVM__Hash___index_by_key < 0) {
      SUB_ID_SPVM__Hash___index_by_key = env->get_sub_id(env, "SPVM::Hash", "_index_by_key", "int(string,int)");
      if (SUB_ID_SPVM__Hash___index_by_key < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _index_by_key");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___index_by_key;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L70: // REMAINDER_INT
  if (__builtin_expect(int_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[6] % /* REMAINDER */ int_vars[1];
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L72: // NE_INT
  int_vars[0] = (int_vars[4] != int_vars[7]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L79: // GOTO
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L82: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L86: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L88: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L89: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L91: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L94: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_NE_ZERO
  if (int_vars[0]) { goto L103; }
L97: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L98: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L102: // GOTO
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L105: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L106: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L107: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L108: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L111: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_NE_ZERO
  if (int_vars[0]) { goto L118; }
L114: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L115: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L117: // GOTO
  goto L118;
L118: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L119: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L120: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L123: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L129; }
L126: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L128: // GOTO
  goto L129;
L129: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L130: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L132: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L133: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L134: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L136: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_NE_ZERO
  if (int_vars[0]) { goto L144; }
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L141: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L143: // GOTO
  goto L144;
L144: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L145: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L146: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x63\x61\x72\x6F\x6C", 5));
L147: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L148: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L149: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L150: // CALL_SUB_OBJECT
  // SPVM::Hash->delete
  {
    if (SUB_ID_SPVM__Hash__delete < 0) {
      SUB_ID_SPVM__Hash__delete = env->get_sub_id(env, "SPVM::Hash", "delete", "object(self,string)");
      if (SUB_ID_SPVM__Hash__delete < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash delete");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__delete;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L151: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L152: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L153: // BOOL_INT
  int_vars[0] = int_vars[0];
L154: // IF_NE_ZERO
  if (int_vars[0]) { goto L160; }
L155: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L156: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L158: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L159: // GOTO
  goto L160;
L160: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L161: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L162: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L163: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L164: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L165: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L166: // BOOL_INT
  int_vars[0] = int_vars[0];
L167: // IF_NE_ZERO
  if (int_vars[0]) { goto L171; }
L168: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L169: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L170: // GOTO
  goto L171;
L171: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L172: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L173: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L174: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L175: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L176: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_delete_with_no_hash_collision";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L190;
  }
L177: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L178: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L179: // BOOL_INT
  int_vars[0] = int_vars[0];
L180: // IF_NE_ZERO
  if (int_vars[0]) { goto L185; }
L181: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L182: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L183: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L190;
L184: // GOTO
  goto L185;
L185: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L187: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L190;
L188: // INIT_INT
  int_vars[7] = 0;
L189: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L190;
L190: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L191: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_each(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[28];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62\x62", 2));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x31\x32\x33\x34\x35", 5));
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L26: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[1]);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L38: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L39: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L42: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L50: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L53: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L57: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[7];
L58: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L61: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L64: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[1]);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L69: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L71: // GOTO
  goto L92;
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L73: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L76: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L79: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L82: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L84: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L87: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L88: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L91: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L92: // ARRAY_LENGTH
  if (object_vars[6] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[6] + (intptr_t)env->object_length_offset);
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L94: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L99: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon2 < 0) {
      BASIC_TYPE_ID_anon2 = env->get_basic_type_id(env, "anon2");
      if (BASIC_TYPE_ID_anon2 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon2;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L100: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L101: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon3 < 0) {
      BASIC_TYPE_ID_anon3 = env->get_basic_type_id(env, "anon3");
      if (BASIC_TYPE_ID_anon3 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon3");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon3;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L104: // CALL_SUB_OBJECT
  // SPVM::Hash->each
  {
    if (SUB_ID_SPVM__Hash__each < 0) {
      SUB_ID_SPVM__Hash__each = env->get_sub_id(env, "SPVM::Hash", "each", "object[][](self)");
      if (SUB_ID_SPVM__Hash__each < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash each");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__each;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L106: // ARRAY_LENGTH
  if (object_vars[3] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[3] + (intptr_t)env->object_length_offset);
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 456;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L108: // ARRAY_LENGTH
  if (object_vars[6] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[6] + (intptr_t)env->object_length_offset);
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 456;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L110: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L111: // BOOL_INT
  int_vars[0] = int_vars[0];
L112: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L195;
L115: // GOTO
  goto L116;
L116: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L117: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new
  {
    if (SUB_ID_SPVM__ObjectList__new < 0) {
      SUB_ID_SPVM__ObjectList__new = env->get_sub_id(env, "SPVM::ObjectList", "new", "SPVM::ObjectList()");
      if (SUB_ID_SPVM__ObjectList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L119: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L120: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new
  {
    if (SUB_ID_SPVM__ObjectList__new < 0) {
      SUB_ID_SPVM__ObjectList__new = env->get_sub_id(env, "SPVM::ObjectList", "new", "SPVM::ObjectList()");
      if (SUB_ID_SPVM__ObjectList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 460;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L123: // GOTO
  goto L153;
L124: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L125: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object); 
      } 
    } 
  } 
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L128: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L129: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object); 
      } 
    } 
  } 
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L131: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L132: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[9];
L133: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L134: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L135: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L136: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L137: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L138: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object); 
      } 
    } 
  } 
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L140: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L141: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L142: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object); 
      } 
    } 
  } 
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L144: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L145: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[9];
L146: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L148: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L149: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 18;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L152: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L153: // ARRAY_LENGTH
  if (object_vars[3] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[3] + (intptr_t)env->object_length_offset);
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L155: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L156: // BOOL_INT
  int_vars[0] = int_vars[0];
L157: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L158: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 18;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L159: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L160: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L161: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L163: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L164: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L165: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L166: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L168: // BOOL_INT
  int_vars[0] = int_vars[2];
L169: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L189; }
L170: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L171: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L172: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L173: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L174: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L175: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L176: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L177: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L178: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L179: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_each";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L195;
  }
L180: // BOOL_INT
  int_vars[0] = int_vars[2];
L181: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L186; }
L182: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L184: // BOOL_INT
  int_vars[0] = int_vars[2];
L185: // GOTO
  goto L188;
L186: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L187: // BOOL_INT
  int_vars[0] = int_vars[3];
L188: // GOTO
  goto L192;
L189: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 19;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L190: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L191: // BOOL_INT
  int_vars[0] = int_vars[4];
L192: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[0];
  goto L195;
L193: // INIT_INT
  int_vars[6] = 0;
L194: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L195;
L195: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L196: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_exists(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[14];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L18: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L22: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L27: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L35: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L38: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L46: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 153;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // GOTO
  goto L66;
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L51: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L54: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L56: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L57: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L59: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L65: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L66: // ARRAY_LENGTH
  if (object_vars[3] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[3] + (intptr_t)env->object_length_offset);
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L68: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // GOTO
  goto L91;
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L75: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L77: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L78: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L79: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L81: // BOOL_INT
  int_vars[0] = int_vars[3];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L116;
L86: // GOTO
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L90: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[5];
L91: // ARRAY_LENGTH
  if (object_vars[3] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[3] + (intptr_t)env->object_length_offset);
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L93: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L98: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x72\x6F\x6C", 5));
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L100: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L101: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_exists";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 162;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L104: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L105: // BOOL_INT
  int_vars[0] = int_vars[0];
L106: // IF_NE_ZERO
  if (int_vars[0]) { goto L111; }
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L116;
L110: // GOTO
  goto L111;
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L113: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L116;
L114: // INIT_INT
  int_vars[6] = 0;
L115: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L116;
L116: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L117: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_get(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L15: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62", 1));
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L26: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[6] < 0 || int_vars[6]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L29: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x63", 1));
L30: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L31: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x73\x74\x72", 3));
L35: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L36: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L40: // CALL_SUB_OBJECT
  // SPVM::Hash->newa
  {
    if (SUB_ID_SPVM__Hash__newa < 0) {
      SUB_ID_SPVM__Hash__newa = env->get_sub_id(env, "SPVM::Hash", "newa", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L50: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L54: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L57: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L59: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L62: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L70: // GOTO
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L73: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62", 1));
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L77: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L79: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L82: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L86: // GOTO
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L89: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x63", 1));
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L91: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L93: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L95: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L96: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L99: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x73\x74\x72", 3));
L100: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_NE_ZERO
  if (int_vars[0]) { goto L111; }
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L105: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L106: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L110: // GOTO
  goto L111;
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L113: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x6E\x6F\x5F\x6B\x65\x79", 6));
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L115: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L117: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L119: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L120: // BOOL_INT
  int_vars[0] = int_vars[0];
L121: // IF_NE_ZERO
  if (int_vars[0]) { goto L127; }
L122: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L123: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L126: // GOTO
  goto L127;
L127: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L132;
L130: // INIT_INT
  int_vars[6] = 0;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L132;
L132: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L133: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_keys(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x62\x62", 2));
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x31\x32\x33\x34\x35", 5));
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L21: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L24: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[1]);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L36: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L44: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L51: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[7];
L52: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L55: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L58: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[1]);
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // GOTO
  goto L81;
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L66: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L72: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L73: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L74: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 11;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L80: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L81: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L83: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 11;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L89: // CALL_SUB_OBJECT
  // SPVM::Hash->keys
  {
    if (SUB_ID_SPVM__Hash__keys < 0) {
      SUB_ID_SPVM__Hash__keys = env->get_sub_id(env, "SPVM::Hash", "keys", "string[](self)");
      if (SUB_ID_SPVM__Hash__keys < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash keys");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__keys;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L91: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L94: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // GOTO
  goto L108;
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L99: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 397;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L101: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 397;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L104: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L105: // MOVE_INT
  int_vars[3] = int_vars[2];
L106: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L107: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L108: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 396;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L110: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L111: // BOOL_INT
  int_vars[0] = int_vars[0];
L112: // IF_NE_ZERO
  if (int_vars[0]) { goto L98; }
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L116: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L117: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 399;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L120: // GOTO
  goto L131;
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L122: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object); 
      } 
    } 
  } 
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L124: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L126: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L127: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L128: // MOVE_INT
  int_vars[3] = int_vars[2];
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L130: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L131: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 400;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L133: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L134: // BOOL_INT
  int_vars[0] = int_vars[0];
L135: // IF_NE_ZERO
  if (int_vars[0]) { goto L121; }
L136: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L137: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L138: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L139: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L141: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[4];
L142: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_keys";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L147;
  }
L144: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L147;
L145: // INIT_INT
  int_vars[4] = 0;
L146: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L147;
L147: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L148: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_load_factor(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  double double_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L27: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor) = double_vars[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L34: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L39: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L44: // CALL_SUB_DOUBLE
  // SPVM::Hash->load_factor
  {
    if (SUB_ID_SPVM__Hash__load_factor < 0) {
      SUB_ID_SPVM__Hash__load_factor = env->get_sub_id(env, "SPVM::Hash", "load_factor", "double(self)");
      if (SUB_ID_SPVM__Hash__load_factor < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__load_factor;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_load_factor";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L46: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L47: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[1];
L48: // DIVIDE_DOUBLE
  double_vars[3] = double_vars[1] / double_vars[2];
L49: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[0] - double_vars[3];
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L51: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[3];
L52: // LT_DOUBLE
  int_vars[0] = (double_vars[4] < double_vars[0]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L55: // NEGATE_DOUBLE
  double_vars[4] = -double_vars[4];
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.01;
L58: // LT_DOUBLE
  int_vars[0] = (double_vars[4] < double_vars[0]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L68;
L63: // GOTO
  goto L64;
L64: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L68;
L66: // INIT_INT
  int_vars[7] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_many_hash_collisions(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  double double_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[27];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 1024;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 16;
L28: // MULTIPLY_INT
  int_vars[5] = int_vars[3] * int_vars[4];
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L30: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L31: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[7];
L32: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor) = double_vars[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 1024;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L36: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 1024;
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // GOTO
  goto L99;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L45: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x41", 2));
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L47: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L52: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 32;
L54: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[3] / int_vars[6];
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L56: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L57: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[8];
L58: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L61: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L63: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 32;
L65: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[3] % /* REMAINDER */ int_vars[6];
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L67: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L68: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[8];
L69: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L72: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[3]);
L73: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 479;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L78: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L80: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L82: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L84: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L87: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object); 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L91: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[5];
L92: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L95: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 1024;
L100: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L105: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 484;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L107: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[1]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L237;
L112: // GOTO
  goto L113;
L113: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L114: // GOTO
  goto L148;
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L116: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L118: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L119: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L120: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L121: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L123: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L124: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[3];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[3]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 490;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L126: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L127: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L128: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L129: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L132: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L134: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L135: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[5];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L137: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L139: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_NE_ZERO
  if (int_vars[0]) { goto L145; }
L142: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L237;
L144: // GOTO
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L147: // ADD_INT
  int_vars[5] = int_vars[5] + int_vars[6];
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 1024;
L149: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L150: // BOOL_INT
  int_vars[0] = int_vars[0];
L151: // IF_NE_ZERO
  if (int_vars[0]) { goto L115; }
L152: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L153: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L154: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L155: // CALL_SUB_OBJECT
  // SPVM::Hash->keys
  {
    if (SUB_ID_SPVM__Hash__keys < 0) {
      SUB_ID_SPVM__Hash__keys = env->get_sub_id(env, "SPVM::Hash", "keys", "string[](self)");
      if (SUB_ID_SPVM__Hash__keys < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash keys");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__keys;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L157: // ARRAY_LENGTH
  if (object_vars[2] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[2] + (intptr_t)env->object_length_offset);
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L159: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L160: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L162: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L163: // GOTO
  goto L174;
L164: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L165: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object); 
      } 
    } 
  } 
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L167: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L168: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L169: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L170: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L171: // MOVE_INT
  int_vars[4] = int_vars[3];
L172: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L173: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L174: // ARRAY_LENGTH
  if (object_vars[2] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[2] + (intptr_t)env->object_length_offset);
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L176: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L177: // BOOL_INT
  int_vars[0] = int_vars[0];
L178: // IF_NE_ZERO
  if (int_vars[0]) { goto L164; }
L179: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L180: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L181: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L182: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L183: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L186: // GOTO
  goto L197;
L187: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L188: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object); 
      } 
    } 
  } 
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L190: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L192: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L193: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L194: // MOVE_INT
  int_vars[4] = int_vars[3];
L195: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L196: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L197: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L198: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L199: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L200: // BOOL_INT
  int_vars[0] = int_vars[0];
L201: // IF_NE_ZERO
  if (int_vars[0]) { goto L187; }
L202: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L203: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L204: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon4 < 0) {
      BASIC_TYPE_ID_anon4 = env->get_basic_type_id(env, "anon4");
      if (BASIC_TYPE_ID_anon4 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon4");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon4;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object);
  }
L205: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L206: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[6];
L208: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L210: // BOOL_INT
  int_vars[0] = int_vars[3];
L211: // IF_NE_ZERO
  if (int_vars[0]) { goto L215; }
L212: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L213: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L237;
L214: // GOTO
  goto L215;
L215: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L216: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon5 < 0) {
      BASIC_TYPE_ID_anon5 = env->get_basic_type_id(env, "anon5");
      if (BASIC_TYPE_ID_anon5 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon5");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon5;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object);
  }
L217: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L218: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L219: // CALL_SUB_OBJECT
  // SPVM::Hash->values
  {
    if (SUB_ID_SPVM__Hash__values < 0) {
      SUB_ID_SPVM__Hash__values = env->get_sub_id(env, "SPVM::Hash", "values", "object[](self)");
      if (SUB_ID_SPVM__Hash__values < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash values");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__values;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L220: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L221: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L222: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L223: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L224: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L225: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_many_hash_collisions";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L237;
  }
L226: // BOOL_INT
  int_vars[0] = int_vars[3];
L227: // IF_NE_ZERO
  if (int_vars[0]) { goto L232; }
L228: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L229: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L230: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L237;
L231: // GOTO
  goto L232;
L232: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L233: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L234: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L237;
L235: // INIT_INT
  int_vars[7] = 0;
L236: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L237;
L237: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L238: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_murmur_hash(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[11] = {0};
  int64_t long_vars[9];
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 123456789;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x3C\x3E", 2));
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L17: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L19: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x31\x32\x33\x34", 4));
L23: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L24: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x73\x64\x66\x67", 5));
L28: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L29: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x7A\x78\x63\x76\x62\x6E", 6));
L33: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L34: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L37: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x31\x71\x61\x7A\x78\x73\x77", 7));
L38: // MOVE_CONSTANT_INT
  int_vars[10] = 6;
L39: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L42: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x33\x65\x64\x63\x76\x66\x72\x34", 8));
L43: // MOVE_CONSTANT_INT
  int_vars[11] = 7;
L44: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L47: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], env->new_string_len_raw(env, "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x30\x2D\x3D\x5C\x5D\x5B\x70\x6F\x69\x75\x79\x74\x72\x65\x77\x71\x61\x73\x64\x66\x67\x68\x6A\x6B\x6C\x3B\x27", 36));
L48: // MOVE_CONSTANT_INT
  int_vars[12] = 8;
L49: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[9]
        );
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L52: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], object_vars[0]);
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L54: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L55: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 9;
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L67: // MOVE_CONSTANT_LONG
  long_vars[0] = 846967266LL;
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L71: // MOVE_CONSTANT_LONG
  long_vars[1] = 200612280LL;
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L75: // MOVE_CONSTANT_LONG
  long_vars[2] = 4178773334LL;
L76: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L77: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L79: // MOVE_CONSTANT_LONG
  long_vars[3] = 1870759112LL;
L80: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L81: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L83: // MOVE_CONSTANT_LONG
  long_vars[4] = 61159236LL;
L84: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L85: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[4];
      } 
    } 
  } 
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L87: // MOVE_CONSTANT_LONG
  long_vars[5] = 623182920LL;
L88: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L89: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[5];
      } 
    } 
  } 
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L91: // MOVE_CONSTANT_LONG
  long_vars[6] = 1738266155LL;
L92: // MOVE_CONSTANT_INT
  int_vars[10] = 6;
L93: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[6];
      } 
    } 
  } 
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L95: // MOVE_CONSTANT_LONG
  long_vars[7] = 123403562LL;
L96: // MOVE_CONSTANT_INT
  int_vars[11] = 7;
L97: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[7];
      } 
    } 
  } 
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L99: // MOVE_CONSTANT_LONG
  long_vars[8] = 4243681504LL;
L100: // MOVE_CONSTANT_INT
  int_vars[12] = 8;
L101: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[8];
      } 
    } 
  } 
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L103: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L104: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L105: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L107: // GOTO
  goto L128;
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L109: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[10];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L111: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L112: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[1];
L113: // CALL_SUB_LONG
  // SPVM::Hash->murmur_hash
  {
    if (SUB_ID_SPVM__Hash__murmur_hash < 0) {
      SUB_ID_SPVM__Hash__murmur_hash = env->get_sub_id(env, "SPVM::Hash", "murmur_hash", "long(string,int)");
      if (SUB_ID_SPVM__Hash__murmur_hash < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash murmur_hash");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__murmur_hash;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L115: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[1] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L117: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L120: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L121: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L138;
L123: // GOTO
  goto L124;
L124: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L125: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L127: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[6];
L128: // ARRAY_LENGTH
  if (object_vars[10] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[10] + (intptr_t)env->object_length_offset);
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_murmur_hash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L130: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L133: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L136: // INIT_INT
  int_vars[6] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L138;
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_new_capacity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L27: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L30: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L35: // GOTO
  goto L36;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L37: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L40: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L45: // GOTO
  goto L46;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L48: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L50: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[5] = 10;
L53: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L59: // GOTO
  goto L60;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor);
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_new_capacity";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L63: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L64: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L69: // GOTO
  goto L70;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L74;
L72: // INIT_INT
  int_vars[6] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L74;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x31", 1));
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62", 1));
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L20: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L24: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L25: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L28: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L32: // CALL_SUB_OBJECT
  // SPVM::Hash->newa
  {
    if (SUB_ID_SPVM__Hash__newa < 0) {
      SUB_ID_SPVM__Hash__newa = env->get_sub_id(env, "SPVM::Hash", "newa", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L41: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L44: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L49: // GOTO
  goto L50;
L50: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L51: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L54: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L59: // GOTO
  goto L60;
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L62: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 48;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L64: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 48;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L67: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L73: // GOTO
  goto L74;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[6];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor);
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L77: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.0;
L78: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L83: // GOTO
  goto L84;
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L85: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L89: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L91: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L92: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L95: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x31", 1));
L96: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L106: // GOTO
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L109: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62", 1));
L110: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L111: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L113: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L116: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L118: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L121: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L130; }
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L125: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L126: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L127: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L135;
L129: // GOTO
  goto L130;
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L135;
L133: // INIT_INT
  int_vars[6] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L135;
L135: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L136: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_allocated_capacity_should_power_of_2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[11];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 6;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x31", 1));
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62", 1));
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L20: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x32", 1));
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L25: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L28: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x63", 1));
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L30: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L33: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x33", 1));
L34: // MOVE_CONSTANT_INT
  int_vars[7] = 5;
L35: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L39: // CALL_SUB_OBJECT
  // SPVM::Hash->newa
  {
    if (SUB_ID_SPVM__Hash__newa < 0) {
      SUB_ID_SPVM__Hash__newa = env->get_sub_id(env, "SPVM::Hash", "newa", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L50: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L53: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L88;
L58: // GOTO
  goto L59;
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L60: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L88;
L68: // GOTO
  goto L69;
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L70: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L71: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L73: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_allocated_capacity_should_power_of_2";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L76: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L88;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L88;
L86: // INIT_INT
  int_vars[6] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L88;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_die_when_odd_number_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_die_when_odd_number_array";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 79;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_die_when_odd_number_array";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 79;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x31", 1));
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_die_when_odd_number_array";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 79;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62", 1));
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L21: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L22: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_die_when_odd_number_array";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 79;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L25: // CALL_SUB_OBJECT
  // SPVM::Hash->newa
  {
    if (SUB_ID_SPVM__Hash__newa < 0) {
      SUB_ID_SPVM__Hash__newa = env->get_sub_id(env, "SPVM::Hash", "newa", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_die_when_odd_number_array";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 79;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L33: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L35: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L36: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L46: // INIT_INT
  int_vars[4] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_newa_do_not_refer_caller_key(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x31", 1));
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L25: // CALL_SUB_OBJECT
  // SPVM::Hash->newa
  {
    if (SUB_ID_SPVM__Hash__newa < 0) {
      SUB_ID_SPVM__Hash__newa = env->get_sub_id(env, "SPVM::Hash", "newa", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62", 1));
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L30: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L37: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L39: // BOOL_INT
  int_vars[0] = int_vars[2];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L45; }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L65;
L44: // GOTO
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L47: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62", 1));
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L50: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_newa_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L53: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L65;
L59: // GOTO
  goto L60;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L65;
L63: // INIT_INT
  int_vars[6] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L65;
L65: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L66: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_rehash(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[26];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L33: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L38: // ADD_INT
  int_vars[6] = int_vars[1] + int_vars[5];
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L40: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[6];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L41: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L42: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L46: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L53: // GOTO
  goto L96;
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L55: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L57: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L60: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L63: // ADD_INT
  int_vars[6] = int_vars[5] + int_vars[3];
L64: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L65: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L68: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L70: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L71: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L73: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L76: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L78: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L83: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L84: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L89: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L95: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L96: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L97: // ADD_INT
  int_vars[5] = int_vars[1] + int_vars[4];
L98: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[5]);
L99: // BOOL_INT
  int_vars[0] = int_vars[0];
L100: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L101: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L103: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L106: // MULTIPLY_INT
  int_vars[6] = int_vars[1] * int_vars[5];
L107: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L228;
L112: // GOTO
  goto L113;
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L114: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L117: // ADD_INT
  int_vars[7] = int_vars[1] + int_vars[6];
L118: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L228;
L123: // GOTO
  goto L124;
L124: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L125: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L126: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L128: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[5] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L130: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L131: // MULTIPLY_INT
  int_vars[7] = int_vars[1] * int_vars[6];
L132: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L139; }
L135: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L136: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L228;
L138: // GOTO
  goto L139;
L139: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L141: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L144: // ADD_INT
  int_vars[7] = int_vars[1] + int_vars[6];
L145: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L146: // BOOL_INT
  int_vars[0] = int_vars[0];
L147: // IF_NE_ZERO
  if (int_vars[0]) { goto L151; }
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L228;
L150: // GOTO
  goto L151;
L151: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L152: // GOTO
  goto L218;
L153: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L154: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L155: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L156: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L157: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L158: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L159: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L161: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L162: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L163: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L164: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L166: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L167: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L168: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L169: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L170: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L171: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L173: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L174: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L176: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L177: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L178: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L179: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L180: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L181: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L182: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L183: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L185: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L186: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L187: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L188: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L189: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L190: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L192: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[6];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L194: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L208; }
L197: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L198: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L199: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L200: // BOOL_INT
  int_vars[0] = int_vars[0];
L201: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L205; }
L202: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L203: // BOOL_INT
  int_vars[0] = int_vars[3];
L204: // GOTO
  goto L207;
L205: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L206: // BOOL_INT
  int_vars[0] = int_vars[4];
L207: // GOTO
  goto L210;
L208: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L209: // BOOL_INT
  int_vars[0] = int_vars[6];
L210: // BOOL_INT
  int_vars[0] = int_vars[0];
L211: // IF_NE_ZERO
  if (int_vars[0]) { goto L215; }
L212: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L213: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L228;
L214: // GOTO
  goto L215;
L215: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L216: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L217: // ADD_INT
  int_vars[5] = int_vars[5] + int_vars[6];
L218: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L219: // ADD_INT
  int_vars[4] = int_vars[1] + int_vars[3];
L220: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[4]);
L221: // BOOL_INT
  int_vars[0] = int_vars[0];
L222: // IF_NE_ZERO
  if (int_vars[0]) { goto L153; }
L223: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L225: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L228;
L226: // INIT_INT
  int_vars[6] = 0;
L227: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L228;
L228: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L229: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_rehash_with_max_load_factor_0_5(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  double double_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[26];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L27: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor) = double_vars[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L42: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L43: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // GOTO
  goto L97;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L58: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L63: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L64: // ADD_INT
  int_vars[6] = int_vars[5] + int_vars[3];
L65: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L66: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L69: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L71: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L72: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L77: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L82: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L84: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L85: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L90: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L96: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L97: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[1]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L100: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L102: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L105: // MULTIPLY_INT
  int_vars[6] = int_vars[1] * int_vars[5];
L106: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L221;
L111: // GOTO
  goto L112;
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L113: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L115: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[1]);
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_NE_ZERO
  if (int_vars[0]) { goto L121; }
L118: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L221;
L120: // GOTO
  goto L121;
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L122: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L123: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L125: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[5] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L128: // MULTIPLY_INT
  int_vars[7] = int_vars[1] * int_vars[6];
L129: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L136; }
L132: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L221;
L135: // GOTO
  goto L136;
L136: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L137: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L138: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L140: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[1]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_NE_ZERO
  if (int_vars[0]) { goto L146; }
L143: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L144: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L221;
L145: // GOTO
  goto L146;
L146: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L147: // GOTO
  goto L213;
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L149: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L150: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L151: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L152: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L153: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L154: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 311;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L156: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L157: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L158: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L159: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 311;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L161: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L162: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L163: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L164: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L165: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L166: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L168: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L169: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L171: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L172: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L173: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L174: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L175: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L176: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L177: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L178: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L179: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L180: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L181: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L183: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L184: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L185: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L187: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[6];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L188: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L189: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L203; }
L192: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_rehash_with_max_load_factor_0_5";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L221;
  }
L194: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L200; }
L197: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L198: // BOOL_INT
  int_vars[0] = int_vars[3];
L199: // GOTO
  goto L202;
L200: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L201: // BOOL_INT
  int_vars[0] = int_vars[4];
L202: // GOTO
  goto L205;
L203: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L204: // BOOL_INT
  int_vars[0] = int_vars[6];
L205: // BOOL_INT
  int_vars[0] = int_vars[0];
L206: // IF_NE_ZERO
  if (int_vars[0]) { goto L210; }
L207: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L208: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L221;
L209: // GOTO
  goto L210;
L210: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L211: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L212: // ADD_INT
  int_vars[5] = int_vars[5] + int_vars[6];
L213: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[1]);
L214: // BOOL_INT
  int_vars[0] = int_vars[0];
L215: // IF_NE_ZERO
  if (int_vars[0]) { goto L148; }
L216: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L217: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L218: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L221;
L219: // INIT_INT
  int_vars[6] = 0;
L220: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L221;
L221: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L222: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[18];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x6C\x69\x63\x65", 5));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x62\x6F\x62", 3));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x63\x61\x72\x6F\x6C", 5));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x31\x32\x33\x34\x35\x36\x37\x38\x39\x30\x2D\x3D", 12));
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L26: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L38: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L39: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L46: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L47: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L50: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L53: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[7] < 0 || int_vars[7]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L57: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[8];
L58: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L61: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L64: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L70: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // GOTO
  goto L90;
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L75: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L78: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L82: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L83: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L89: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L90: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L92: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L93: // BOOL_INT
  int_vars[0] = int_vars[0];
L94: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L97: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L99: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L101: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L143;
L106: // GOTO
  goto L107;
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L108: // GOTO
  goto L133;
L109: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L110: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L112: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L115: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L117: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L118: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L120: // EQ_OBJECT
  int_vars[0] = (object_vars[2] == object_vars[3]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_NE_ZERO
  if (int_vars[0]) { goto L129; }
L123: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L125: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L126: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L143;
L128: // GOTO
  goto L129;
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L132: // ADD_INT
  int_vars[4] = int_vars[4] + int_vars[5];
L133: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L134: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L135: // LT_INT
  int_vars[0] = (int_vars[4] < int_vars[2]);
L136: // BOOL_INT
  int_vars[0] = int_vars[0];
L137: // IF_NE_ZERO
  if (int_vars[0]) { goto L109; }
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L143;
L141: // INIT_INT
  int_vars[5] = 0;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L143;
L143: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L144: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set_do_not_refer_caller_key(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 120;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L14: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L17: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62", 1));
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L22: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L29: // GOTO
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x62", 1));
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Hash->exists
  {
    if (SUB_ID_SPVM__Hash__exists < 0) {
      SUB_ID_SPVM__Hash__exists = env->get_sub_id(env, "SPVM::Hash", "exists", "int(self,string)");
      if (SUB_ID_SPVM__Hash__exists < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash exists");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__exists;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_do_not_refer_caller_key";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L38: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L45; }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L44: // GOTO
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L50;
L48: // INIT_INT
  int_vars[6] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_set_rehash_when_max_load_factor_changes(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  double double_vars[1];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[36];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x61\x70\x61\x63\x69\x74\x79", 8));
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L33: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L38: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[1];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L40: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L44: // CALL_SUB_OBJECT
  // SPVM::Hash->new_opt
  {
    if (SUB_ID_SPVM__Hash__new_opt < 0) {
      SUB_ID_SPVM__Hash__new_opt = env->get_sub_id(env, "SPVM::Hash", "new_opt", "SPVM::Hash(object[])");
      if (SUB_ID_SPVM__Hash__new_opt < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new_opt");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new_opt;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L51: // GOTO
  goto L94;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L55: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 327;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L61: // ADD_INT
  int_vars[6] = int_vars[5] + int_vars[3];
L62: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L63: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 327;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L66: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L68: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L69: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L72: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L73: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L74: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L79: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L81: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L82: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L87: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L90: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L93: // ADD_INT
  int_vars[3] = int_vars[3] + int_vars[4];
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L95: // SUBTRACT_INT
  int_vars[5] = int_vars[1] - int_vars[4];
L96: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[5]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L52; }
L99: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L100: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L101: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Hash__max_load_factor < 0, 0)) {
      FIELD_ID_SPVM__Hash__max_load_factor = env->get_field_id(env, "SPVM::Hash", "max_load_factor", "double");
      if (FIELD_ID_SPVM__Hash__max_load_factor < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Hash max_load_factor");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor = env->get_field_offset(env, FIELD_ID_SPVM__Hash__max_load_factor);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Hash__max_load_factor) = double_vars[0];
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L103: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L104: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x6E\x65\x77\x5F\x6B\x65\x79", 7));
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L107: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L108: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L110: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L111: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L113: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L115: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L116: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L117: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L118: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x6E\x65\x77\x5F\x6B\x65\x79", 7));
L119: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L121: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L122: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L124: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L125: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L126: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L127: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L129: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L131: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L132: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L135: // MULTIPLY_INT
  int_vars[5] = int_vars[1] * int_vars[4];
L136: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_NE_ZERO
  if (int_vars[0]) { goto L142; }
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L140: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L141: // GOTO
  goto L142;
L142: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L143: // CALL_SUB_INT
  // SPVM::Hash->count
  {
    if (SUB_ID_SPVM__Hash__count < 0) {
      SUB_ID_SPVM__Hash__count = env->get_sub_id(env, "SPVM::Hash", "count", "int(self)");
      if (SUB_ID_SPVM__Hash__count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L144: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 337;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L145: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[1]);
L146: // BOOL_INT
  int_vars[0] = int_vars[0];
L147: // IF_NE_ZERO
  if (int_vars[0]) { goto L151; }
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L150: // GOTO
  goto L151;
L151: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L152: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L153: // CALL_SUB_OBJECT
  // SPVM::Hash->_entries
  {
    if (SUB_ID_SPVM__Hash___entries < 0) {
      SUB_ID_SPVM__Hash___entries = env->get_sub_id(env, "SPVM::Hash", "_entries", "SPVM::Hash::Entry[](self)");
      if (SUB_ID_SPVM__Hash___entries < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _entries");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___entries;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 340;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L155: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[5] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 340;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L157: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L158: // MULTIPLY_INT
  int_vars[7] = int_vars[1] * int_vars[6];
L159: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L160: // BOOL_INT
  int_vars[0] = int_vars[0];
L161: // IF_NE_ZERO
  if (int_vars[0]) { goto L166; }
L162: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L163: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L164: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L165: // GOTO
  goto L166;
L166: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L167: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L168: // CALL_SUB_INT
  // SPVM::Hash->_bucket_count
  {
    if (SUB_ID_SPVM__Hash___bucket_count < 0) {
      SUB_ID_SPVM__Hash___bucket_count = env->get_sub_id(env, "SPVM::Hash", "_bucket_count", "int(self)");
      if (SUB_ID_SPVM__Hash___bucket_count < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash _bucket_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash___bucket_count;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L170: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[1]);
L171: // BOOL_INT
  int_vars[0] = int_vars[0];
L172: // IF_NE_ZERO
  if (int_vars[0]) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L175: // GOTO
  goto L176;
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L177: // GOTO
  goto L243;
L178: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L179: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41", 1));
L180: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L181: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L182: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L183: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L184: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 348;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L186: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L187: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L188: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L189: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 348;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L191: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L192: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L193: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L194: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L195: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L196: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L197: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L198: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L199: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L201: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L202: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L203: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L204: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object_vars[1]);
L205: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L206: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L208: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L210: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L211: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L213: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L214: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L215: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L216: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L217: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[6];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L218: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L219: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L220: // BOOL_INT
  int_vars[0] = int_vars[0];
L221: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L222: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L223: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L224: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L228: // BOOL_INT
  int_vars[0] = int_vars[3];
L229: // GOTO
  goto L232;
L230: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L231: // BOOL_INT
  int_vars[0] = int_vars[4];
L232: // GOTO
  goto L235;
L233: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L234: // BOOL_INT
  int_vars[0] = int_vars[6];
L235: // BOOL_INT
  int_vars[0] = int_vars[0];
L236: // IF_NE_ZERO
  if (int_vars[0]) { goto L240; }
L237: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L238: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L239: // GOTO
  goto L240;
L240: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L241: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L242: // ADD_INT
  int_vars[5] = int_vars[5] + int_vars[6];
L243: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L244: // SUBTRACT_INT
  int_vars[4] = int_vars[1] - int_vars[3];
L245: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[4]);
L246: // BOOL_INT
  int_vars[0] = int_vars[0];
L247: // IF_NE_ZERO
  if (int_vars[0]) { goto L178; }
L248: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L249: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L250: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x6E\x65\x77\x5F\x6B\x65\x79", 7));
L251: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L252: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L253: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L254: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L255: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L256: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L257: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L258: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L259: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L260: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L261: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L262: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6E\x65\x77\x5F\x6B\x65\x79", 7));
L263: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L264: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L265: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L266: // CALL_SUB_OBJECT
  // SPVM::Hash->get
  {
    if (SUB_ID_SPVM__Hash__get < 0) {
      SUB_ID_SPVM__Hash__get = env->get_sub_id(env, "SPVM::Hash", "get", "object(self,string)");
      if (SUB_ID_SPVM__Hash__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L267: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L268: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L269: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[6];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[6]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L270: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L271: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[7];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L272: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_set_rehash_when_max_load_factor_changes";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L290;
  }
L273: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L274: // BOOL_INT
  int_vars[0] = int_vars[0];
L275: // IF_NE_ZERO
  if (int_vars[0]) { goto L285; }
L276: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L277: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L278: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L279: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L280: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L281: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L282: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L283: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L290;
L284: // GOTO
  goto L285;
L285: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L286: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L287: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L290;
L288: // INIT_INT
  int_vars[7] = 0;
L289: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L290;
L290: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L291: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Hash__test_values(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::Hash->new
  {
    if (SUB_ID_SPVM__Hash__new < 0) {
      SUB_ID_SPVM__Hash__new = env->get_sub_id(env, "SPVM::Hash", "new", "SPVM::Hash()");
      if (SUB_ID_SPVM__Hash__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x62\x62", 2));
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x31\x32\x33\x34\x35", 5));
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L21: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L24: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[1]);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L36: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L39: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[2]);
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L46: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L47: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L50: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L54: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[7];
L55: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L58: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L61: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[1]);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L63: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // GOTO
  goto L85;
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L70: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L73: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L77: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L78: // CALL_SUB_VOID
  // SPVM::Hash->set
  {
    if (SUB_ID_SPVM__Hash__set < 0) {
      SUB_ID_SPVM__Hash__set = env->get_sub_id(env, "SPVM::Hash", "set", "void(self,string,object)");
      if (SUB_ID_SPVM__Hash__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L81: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L84: // ADD_INT
  int_vars[2] = int_vars[2] + int_vars[3];
L85: // ARRAY_LENGTH
  if (object_vars[5] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[5] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 418;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L87: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L92: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon1 < 0) {
      BASIC_TYPE_ID_anon1 = env->get_basic_type_id(env, "anon1");
      if (BASIC_TYPE_ID_anon1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon1;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L95: // CALL_SUB_OBJECT
  // SPVM::Hash->values
  {
    if (SUB_ID_SPVM__Hash__values < 0) {
      SUB_ID_SPVM__Hash__values = env->get_sub_id(env, "SPVM::Hash", "values", "object[](self)");
      if (SUB_ID_SPVM__Hash__values < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Hash values");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Hash__values;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 429;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L100: // CALL_SUB_INT
  // TestCase::Lib::SPVM::Hash->_same_unordered_objects
  {
    if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
      SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects = env->get_sub_id(env, "TestCase::Lib::SPVM::Hash", "_same_unordered_objects", "int(object[],object[],SPVM::Comparator)");
      if (SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::Hash _same_unordered_objects");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__Hash___same_unordered_objects;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__Hash___same_unordered_objects(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Hash";
    const char* sub_name = "test_values";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 429;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L103: // INIT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


