#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Regex__caps = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Regex__caps = -1;
static int32_t FIELD_ID_SPVM__Regex__match_start = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Regex__match_start = -1;
static int32_t FIELD_ID_SPVM__Regex__match_length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Regex__match_length = -1;
static int32_t FIELD_ID_SPVM__Regex__replace_count = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Regex__new = - 1;
static int32_t SUB_ID_SPVM__Regex__match = - 1;
static int32_t SUB_ID_SPVM__Regex__caps = - 1;
static int32_t SUB_ID_SPVM__Regex__match_start = - 1;
static int32_t SUB_ID_SPVM__Regex__match_length = - 1;
static int32_t SUB_ID_SPVM__Regex__replace = - 1;
static int32_t SUB_ID_SPVM__Regex__replace_count = - 1;
static int32_t SUB_ID_SPVM__Regex__replace_all = - 1;
static int32_t SUB_ID_SPVM__Regex__replace_all_cb = - 1;
static int32_t SUB_ID_SPVM__Regex__replace_cb = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_anon1 = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__compile(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__invalid_regex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_capture(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class_negate(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class_range(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_end(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_number(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_space(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_word(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_number(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_offset(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_one_more(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_one_or_zero(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_quantifier(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_space(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_start(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_start_and_end(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_word(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_zero_more(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_all(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_all_cb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_cb(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__compile(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "compile";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 5;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L12;
L10: // INIT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__invalid_regex(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[25];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x2A\x61", 3));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 723;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L10;
  }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L10: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L12: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L13: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L15: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L18: // GOTO
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x3F\x61", 3));
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L25: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 728;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L32: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L37: // GOTO
  goto L38;
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x2B\x61", 3));
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L44: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L45: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 733;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L50: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L51: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L56: // GOTO
  goto L57;
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x7B\x31\x2C\x33\x7D\x61", 7));
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L63: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L64: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 738;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L67;
  }
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L67: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L69: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L70: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L76; }
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L75: // GOTO
  goto L76;
L76: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L77: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L79: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x64\x2B\x5C\x44\x2A\x5C\x64\x2B", 9));
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L82: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 743;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L88: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L89: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L98: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x64\x2B\x5C\x44\x3F\x5C\x64\x2B", 9));
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L100: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L101: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L102: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 748;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L107: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L108: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L110: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L116: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L117: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L118: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x61", 2));
L119: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L120: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L121: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 758;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L146;
  }
L123: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L126: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x7B\x33\x2C\x33\x7D\x61", 7));
L127: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L128: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L129: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 759;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L146;
  }
L131: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L132: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L133: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L134: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x64\x5C\x44\x5C\x64", 6));
L135: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L136: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L137: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "invalid_regex";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 760;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L146;
  }
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L141: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L142: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L146;
L144: // INIT_INT
  int_vars[4] = 0;
L145: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L146;
L146: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L147: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_capture(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[61];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x28\x61\x2A\x29", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x61\x61", 3));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L17: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L21: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x61\x61", 3));
L25: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x28\x62\x29\x63", 5));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L45: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L50: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L56: // GOTO
  goto L57;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L62: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x62", 1));
L66: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L76; }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L71: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L75: // GOTO
  goto L76;
L76: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L79: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\x28\xE3\x81\x84\x29\xE3\x81\x86", 11));
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L82: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x82\x93\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86\xE3\x82\x93", 15));
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L91: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L93: // BOOL_INT
  int_vars[0] = int_vars[3];
L94: // IF_NE_ZERO
  if (int_vars[0]) { goto L98; }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L97: // GOTO
  goto L98;
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L99: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L103: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L106: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\xE3\x81\x84", 3));
L107: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L117; }
L111: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L112: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L113: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L116: // GOTO
  goto L117;
L117: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L118: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L119: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L120: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x28\x62\x3F\x29\x63", 6));
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L122: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L123: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L125: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L127: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x63\x7A", 4));
L128: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L129: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L130: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L131: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L132: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L134: // BOOL_INT
  int_vars[0] = int_vars[3];
L135: // IF_NE_ZERO
  if (int_vars[0]) { goto L139; }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L138: // GOTO
  goto L139;
L139: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L140: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L141: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L142: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L144: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L146: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L147: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L148: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L150: // BOOL_INT
  int_vars[0] = int_vars[0];
L151: // IF_NE_ZERO
  if (int_vars[0]) { goto L158; }
L152: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L153: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L154: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L156: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L157: // GOTO
  goto L158;
L158: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L159: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L160: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L161: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x2D\x28\x5C\x77\x2B\x29\x5C\x2D", 9));
L162: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L163: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L164: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L166: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L167: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L168: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2D\x61\x62\x63\x38\x39\x2D", 7));
L169: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L170: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L171: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L172: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L173: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L174: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L175: // BOOL_INT
  int_vars[0] = int_vars[3];
L176: // IF_NE_ZERO
  if (int_vars[0]) { goto L180; }
L177: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L178: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L179: // GOTO
  goto L180;
L180: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L181: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L185: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L187: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L188: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x38\x39", 5));
L189: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L191: // BOOL_INT
  int_vars[0] = int_vars[0];
L192: // IF_NE_ZERO
  if (int_vars[0]) { goto L199; }
L193: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L194: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L195: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L196: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L197: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L198: // GOTO
  goto L199;
L199: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L200: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L201: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L202: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x2D\x28\x5C\x77\x2B\x29\x20\x28\x5C\x77\x2B\x29\x20\x28\x5C\x77\x2B\x29\x20\x28\x5C\x77\x2B\x29\x20\x28\x5C\x77\x2B\x29", 31));
L203: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L204: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L205: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L207: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L208: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L209: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2D\x61\x62\x63\x31\x20\x61\x62\x63\x32\x20\x61\x62\x63\x33\x20\x61\x62\x63\x34\x20\x61\x62\x63\x35\x20\x61\x62\x63\x36\x2D", 31));
L210: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L211: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L212: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L213: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L214: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L215: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L216: // BOOL_INT
  int_vars[0] = int_vars[3];
L217: // IF_NE_ZERO
  if (int_vars[0]) { goto L221; }
L218: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L219: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L220: // GOTO
  goto L221;
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L222: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L223: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L225: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L226: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L227: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L228: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L229: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x31", 4));
L230: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L231: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L232: // BOOL_INT
  int_vars[0] = int_vars[0];
L233: // IF_NE_ZERO
  if (int_vars[0]) { goto L240; }
L234: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L235: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L236: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L237: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L238: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L239: // GOTO
  goto L240;
L240: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L241: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L242: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L243: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L244: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L245: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L246: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L247: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L248: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L249: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x32", 4));
L250: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L252: // BOOL_INT
  int_vars[0] = int_vars[0];
L253: // IF_NE_ZERO
  if (int_vars[0]) { goto L260; }
L254: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L255: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L256: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L257: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L258: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L259: // GOTO
  goto L260;
L260: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L261: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L262: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L263: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L264: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L265: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L266: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L267: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L268: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L269: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x33", 4));
L270: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L271: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L272: // BOOL_INT
  int_vars[0] = int_vars[0];
L273: // IF_NE_ZERO
  if (int_vars[0]) { goto L280; }
L274: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L275: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L276: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L277: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L278: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L279: // GOTO
  goto L280;
L280: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L281: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L282: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L283: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L284: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L285: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L286: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L287: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L288: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L289: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x34", 4));
L290: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L291: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L292: // BOOL_INT
  int_vars[0] = int_vars[0];
L293: // IF_NE_ZERO
  if (int_vars[0]) { goto L300; }
L294: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L295: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L296: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L297: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L298: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L299: // GOTO
  goto L300;
L300: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L301: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L302: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L303: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L304: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L305: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L306: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L307: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L308: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L309: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x35", 4));
L310: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L311: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L312: // BOOL_INT
  int_vars[0] = int_vars[0];
L313: // IF_NE_ZERO
  if (int_vars[0]) { goto L320; }
L314: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L315: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L316: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L317: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L318: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L319: // GOTO
  goto L320;
L320: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L321: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L322: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L323: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L324: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x29\x61\x62\x63", 4));
L325: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L326: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L327: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L328: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 362;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L331;
  }
L329: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L330: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L331: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L332: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L333: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L334: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L335: // IF_NE_ZERO
  if (int_vars[0]) { goto L340; }
L336: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L337: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L338: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L339: // GOTO
  goto L340;
L340: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L341: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L342: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L343: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x28\x28\x61\x62\x63\x29", 6));
L344: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L345: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L346: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L347: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 366;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L350;
  }
L348: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L349: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L350: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L351: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L352: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L353: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L354: // IF_NE_ZERO
  if (int_vars[0]) { goto L359; }
L355: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L356: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L357: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L358: // GOTO
  goto L359;
L359: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L360: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L361: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L362: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L363: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x28\x61\x2A\x29", 4));
L364: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L365: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L366: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L367: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 376;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L368: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L369: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L370: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x61\x61", 3));
L371: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L372: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L373: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L374: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L375: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L376: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 378;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L377: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L378: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__caps < 0, 0)) {
      FIELD_ID_SPVM__Regex__caps = env->get_field_id(env, "SPVM::Regex", "caps", "string[]");
      if (FIELD_ID_SPVM__Regex__caps < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex caps");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__caps = env->get_field_offset(env, FIELD_ID_SPVM__Regex__caps);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__caps);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L379: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L380: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L381: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L382: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L383: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L384: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L385: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x61\x61", 3));
L386: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L387: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_capture";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 379;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L402;
  }
L388: // BOOL_INT
  int_vars[0] = int_vars[0];
L389: // IF_NE_ZERO
  if (int_vars[0]) { goto L396; }
L390: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L391: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L392: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L393: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L394: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L402;
L395: // GOTO
  goto L396;
L396: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L397: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L398: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L399: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L402;
L400: // INIT_INT
  int_vars[6] = 0;
L401: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L402;
L402: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L403: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x62\x63\x64\xE3\x81\x82\x5D\x2B", 9));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\xE3\x81\x82\x7A", 8));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L68;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x5C\x64\x61\x5D\x2B", 6));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 460;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x30\x31\x61\x7A", 5));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L68;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x62\x63\x64\x5C\x64\x5D\x2B", 8));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x65", 2));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 475;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L68;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L68;
L66: // INIT_INT
  int_vars[6] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class_negate(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x5E\x30\x2D\x39\x5D\x2B", 7));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_negate";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_negate";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x5E\x30\x2D\x39\x5D\x2B", 7));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_negate";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x30\x31\x32", 3));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_negate";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_char_class_range(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x30\x2D\x39\x5D\x2B", 6));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_range";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x30\x39\x61\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_range";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 393;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x30\x2D\x39\x61\x2D\x63\x5D\x2B", 9));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_range";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x7A", 2));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_char_class_range";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_end(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2B\x63\x24", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 771;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 774;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2B\x63\x24", 5));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 783;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 786;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_number(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x30\x5C\x44\x2B\x39", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x30\x61\x62\x63\x39", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L26;
L24: // INIT_INT
  int_vars[6] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_space(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x73\x2B\x5C\x53\x2B\x5C\x73\x2B", 9));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 489;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x0C\x09\x7A\x61\x63\x7A\x20\x0D\x0A", 9));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 492;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x53\x2B", 3));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x0C\x09\x20\x0D\x0A", 5));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_not_word(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x77\x5C\x57\x2B\x5C\x77", 7));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x30\x2D\x3A\x39", 4));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 549;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x77\x5C\x57\x2B\x5C\x77", 7));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 558;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x60\x7B\x79\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x77\x5C\x57\x2B\x5C\x77", 7));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 570;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41\x42\x60\x7B\x59\x5A", 6));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x77\x5C\x57\x2B\x5C\x77", 7));
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L68: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 582;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5F\x5E\x60\x5F", 4));
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L76: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L77: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x57\x2B", 3));
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L89: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L93: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x7A\x41\x5A\x5F\x30\x39", 7));
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L97: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L98: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_not_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L100: // BOOL_INT
  int_vars[0] = int_vars[3];
L101: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L102: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L104: // GOTO
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L110;
L108: // INIT_INT
  int_vars[6] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L110;
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_number(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x64\x2B\x63", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x63\x7A", 14));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 696;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x64\x2B\x5C\x44\x2B\x5C\x64\x2B", 9));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 706;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x32\x33\x61\x62\x63\x37\x38\x39", 9));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_number";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 709;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_offset(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_offset";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1077;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_offset";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1080;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_offset";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1089;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_offset";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1092;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_one_more(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2B\x63", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 980;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 983;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2B\x63", 4));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 992;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 995;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2B\x63", 4));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x63\x7A", 4));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L69;
L67: // INIT_INT
  int_vars[6] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_one_or_zero(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x3F\x63", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 937;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 940;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x3F\x63", 4));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 952;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x3F\x63", 4));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x63\x7A", 4));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_one_or_zero";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 964;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L69;
L67: // INIT_INT
  int_vars[6] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_quantifier(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[25];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x2C\x33\x7D\x63", 8));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 833;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 836;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x2C\x33\x7D\x63", 8));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 845;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x63\x7A", 7));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 848;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x2C\x33\x7D\x63", 8));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 857;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x63\x7A", 4));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 860;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x2C\x33\x7D\x63", 8));
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L68: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 868;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x62\x63\x7A", 8));
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L76: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L77: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 871;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L87: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x31\x2C\x31\x33\x7D\x63", 10));
L88: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L90: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 883;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L94: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x63\x7A", 15));
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L98: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L99: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 886;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[3];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L105: // GOTO
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L108: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x31\x2C\x31\x33\x7D\x63", 10));
L109: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L110: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L111: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 895;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L113: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L115: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x63\x7A", 17));
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L118: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L119: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L120: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 898;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L122: // BOOL_INT
  int_vars[0] = int_vars[3];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L127; }
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L126: // GOTO
  goto L127;
L127: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L128: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L129: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x31\x2C\x31\x33\x7D\x63", 10));
L130: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L131: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L132: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 907;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L134: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L135: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L136: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x63\x7A", 14));
L137: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L138: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L139: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L140: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L141: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 910;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L143: // BOOL_INT
  int_vars[0] = int_vars[3];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L148; }
L145: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L146: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L147: // GOTO
  goto L148;
L148: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L149: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L150: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x7B\x31\x31\x2C\x31\x33\x7D\x63", 10));
L151: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L152: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L153: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 918;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L155: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L156: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L157: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x62\x63\x7A", 18));
L158: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L159: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L160: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L161: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L162: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L163: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_quantifier";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 921;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L175;
  }
L164: // BOOL_INT
  int_vars[0] = int_vars[3];
L165: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L166: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L167: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L175;
L168: // GOTO
  goto L169;
L169: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L170: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L171: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L172: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L175;
L173: // INIT_INT
  int_vars[6] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L175;
L175: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L176: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_space(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x73\x2B\x63", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 517;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x0C\x09\x0D\x0A\x20\x63\x7A", 9));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 520;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x73\x2B", 3));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x07\x61\x62\x63\x00", 5));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_space";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 532;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_start(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5E\x61\x62\x2B\x63", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 802;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 805;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5E\x61\x62\x2B\x63", 5));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 814;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 817;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L48;
L46: // INIT_INT
  int_vars[6] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_start_and_end(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A", 7));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L20: // GOTO
  goto L21;
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_start < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_start = env->get_field_id(env, "SPVM::Regex", "match_start", "int");
      if (FIELD_ID_SPVM__Regex__match_start < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_start");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_start = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_start);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_start);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L24: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L29: // GOTO
  goto L30;
L30: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_length < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_length = env->get_field_id(env, "SPVM::Regex", "match_length", "int");
      if (FIELD_ID_SPVM__Regex__match_length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_length = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_length);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L33: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L38: // GOTO
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\xE3\x81\x84\x5B\xE3\x81\x8B\xE3\x81\x8D\xE3\x81\x8F\xE3\x81\x91\xE3\x81\x93\x5D\x2B\xE3\x81\x86", 27));
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L44: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x82\x93\xE3\x82\x93\xE3\x81\x82\xE3\x81\x84\xE3\x81\x8B\xE3\x81\x8F\xE3\x81\x93\xE3\x81\x86\xE3\x82\x93", 27));
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L51: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L52: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L53: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 203;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L59: // GOTO
  goto L60;
L60: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_start < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_start = env->get_field_id(env, "SPVM::Regex", "match_start", "int");
      if (FIELD_ID_SPVM__Regex__match_start < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_start");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_start = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_start);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_start);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[6] = 6;
L63: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L68: // GOTO
  goto L69;
L69: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_length < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_length = env->get_field_id(env, "SPVM::Regex", "match_length", "int");
      if (FIELD_ID_SPVM__Regex__match_length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_length = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_length);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 212;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 18;
L72: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L80: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62\x2A\x63", 3));
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L82: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L83: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L87: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x7A\x63\x7A", 4));
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L91: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L92: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L94: // BOOL_INT
  int_vars[0] = int_vars[3];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L98: // GOTO
  goto L99;
L99: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_start < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_start = env->get_field_id(env, "SPVM::Regex", "match_start", "int");
      if (FIELD_ID_SPVM__Regex__match_start < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_start");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_start = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_start);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_start);
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L102: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L105: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L107: // GOTO
  goto L108;
L108: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_length < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_length = env->get_field_id(env, "SPVM::Regex", "match_length", "int");
      if (FIELD_ID_SPVM__Regex__match_length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_length = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_length);
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L111: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_NE_ZERO
  if (int_vars[0]) { goto L117; }
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L116: // GOTO
  goto L117;
L117: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L118: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L119: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x62\x2A", 2));
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L121: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L122: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L126: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x7A\x63\x7A", 4));
L127: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L128: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L129: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L130: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L131: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L133: // BOOL_INT
  int_vars[0] = int_vars[3];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L138; }
L135: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L137: // GOTO
  goto L138;
L138: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_start < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_start = env->get_field_id(env, "SPVM::Regex", "match_start", "int");
      if (FIELD_ID_SPVM__Regex__match_start < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_start");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_start = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_start);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_start);
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L140: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L141: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_NE_ZERO
  if (int_vars[0]) { goto L147; }
L144: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L145: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L146: // GOTO
  goto L147;
L147: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__match_length < 0, 0)) {
      FIELD_ID_SPVM__Regex__match_length = env->get_field_id(env, "SPVM::Regex", "match_length", "int");
      if (FIELD_ID_SPVM__Regex__match_length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex match_length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__match_length = env->get_field_offset(env, FIELD_ID_SPVM__Regex__match_length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__match_length);
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_start_and_end";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L161;
  }
L149: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L150: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L151: // BOOL_INT
  int_vars[0] = int_vars[0];
L152: // IF_NE_ZERO
  if (int_vars[0]) { goto L156; }
L153: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L154: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L161;
L155: // GOTO
  goto L156;
L156: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L158: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L161;
L159: // INIT_INT
  int_vars[6] = 0;
L160: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L161;
L161: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L162: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_word(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x2D\x5C\x77\x2B\x5C\x3A", 7));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 611;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2D\x30\x31\x32\x33\x34\x35\x36\x37\x38\x39\x3A", 12));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x60\x5C\x77\x2B\x5C\x7B", 7));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 623;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x60\x61\x62\x79\x7A\x7B", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x60\x5C\x77\x2B\x5C\x7B", 7));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x60\x41\x42\x59\x5A\x7B", 6));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x5E\x5C\x77\x2B\x5C\x60", 7));
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L68: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5E\x5F\x5F\x60", 4));
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L76: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L77: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5C\x77\x2B", 3));
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L89: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L93: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7B\x7D\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86", 11));
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L97: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L98: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_word";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L100: // BOOL_INT
  int_vars[0] = int_vars[3];
L101: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L102: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L104: // GOTO
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L110;
L108: // INIT_INT
  int_vars[6] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L110;
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__match_zero_more(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2A\x63", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1023;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x63\x7A", 5));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L14: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1026;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L16: // BOOL_INT
  int_vars[0] = int_vars[3];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L90;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2A\x63", 4));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1035;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x63\x7A", 6));
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L35: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1038;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L90;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2A\x63", 4));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1047;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x63\x7A", 4));
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L56: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1050;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L90;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x2A\x63", 4));
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L68: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1059;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L70: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x62\x62\x64\x7A", 6));
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L76: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L77: // CALL_SUB_INT
  // SPVM::Regex->match
  {
    if (SUB_ID_SPVM__Regex__match < 0) {
      SUB_ID_SPVM__Regex__match = env->get_sub_id(env, "SPVM::Regex", "match", "int(self,string,int)");
      if (SUB_ID_SPVM__Regex__match < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex match");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__match;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "match_zero_more";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 1062;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L90;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L90;
L88: // INIT_INT
  int_vars[6] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L90;
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[25];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A", 7));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L18: // CALL_SUB_OBJECT
  // SPVM::Regex->replace
  {
    if (SUB_ID_SPVM__Regex__replace < 0) {
      SUB_ID_SPVM__Regex__replace = env->get_sub_id(env, "SPVM::Regex", "replace", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L29: // GOTO
  goto L30;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x41\x42\x43\x7A", 7));
L32: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L46: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L50: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A", 15));
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L56: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L57: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L59: // CALL_SUB_OBJECT
  // SPVM::Regex->replace
  {
    if (SUB_ID_SPVM__Regex__replace < 0) {
      SUB_ID_SPVM__Regex__replace = env->get_sub_id(env, "SPVM::Regex", "replace", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L62: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L70: // GOTO
  goto L71;
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x41\x42\x43\x7A\x61\x62\x63\x7A", 15));
L73: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L84: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x64\x2B\x62", 5));
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L87: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L91: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x31\x32\x33\x62\x7A", 7));
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L94: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L95: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L98: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L100: // CALL_SUB_OBJECT
  // SPVM::Regex->replace
  {
    if (SUB_ID_SPVM__Regex__replace < 0) {
      SUB_ID_SPVM__Regex__replace = env->get_sub_id(env, "SPVM::Regex", "replace", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L103: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L106: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L111: // GOTO
  goto L112;
L112: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L113: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x7A\x41\x42\x43\x7A", 5));
L114: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_NE_ZERO
  if (int_vars[0]) { goto L122; }
L118: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L121: // GOTO
  goto L122;
L122: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L125: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x64\x2B\x62", 5));
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L127: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L128: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L132: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x70\x70", 4));
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L134: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L135: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L136: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L137: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L138: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L139: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L141: // CALL_SUB_OBJECT
  // SPVM::Regex->replace
  {
    if (SUB_ID_SPVM__Regex__replace < 0) {
      SUB_ID_SPVM__Regex__replace = env->get_sub_id(env, "SPVM::Regex", "replace", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L143: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L144: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L146: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L147: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L148: // BOOL_INT
  int_vars[0] = int_vars[0];
L149: // IF_NE_ZERO
  if (int_vars[0]) { goto L153; }
L150: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L151: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L152: // GOTO
  goto L153;
L153: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L154: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x70\x70", 4));
L155: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_NE_ZERO
  if (int_vars[0]) { goto L163; }
L159: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L160: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L162: // GOTO
  goto L163;
L163: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L166: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L169;
L167: // INIT_INT
  int_vars[6] = 0;
L168: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L169;
L169: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L170: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_all(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[25];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A", 11));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L18: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_all
  {
    if (SUB_ID_SPVM__Regex__replace_all < 0) {
      SUB_ID_SPVM__Regex__replace_all = env->get_sub_id(env, "SPVM::Regex", "replace_all", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L29: // GOTO
  goto L30;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x41\x42\x43\x7A\x41\x42\x43\x7A", 11));
L32: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L46: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L50: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A", 15));
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L56: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L57: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L59: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_all
  {
    if (SUB_ID_SPVM__Regex__replace_all < 0) {
      SUB_ID_SPVM__Regex__replace_all = env->get_sub_id(env, "SPVM::Regex", "replace_all", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L62: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L70: // GOTO
  goto L71;
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x41\x42\x43\x7A\x41\x42\x43\x7A", 15));
L73: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L84: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x64\x2B\x62", 5));
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L87: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L91: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x7A\x61\x31\x32\x33\x62\x7A", 7));
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L94: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L95: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L98: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L100: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_all
  {
    if (SUB_ID_SPVM__Regex__replace_all < 0) {
      SUB_ID_SPVM__Regex__replace_all = env->get_sub_id(env, "SPVM::Regex", "replace_all", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L103: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L106: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L111: // GOTO
  goto L112;
L112: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L113: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x7A\x41\x42\x43\x7A", 5));
L114: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_NE_ZERO
  if (int_vars[0]) { goto L122; }
L118: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L121: // GOTO
  goto L122;
L122: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L125: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x5C\x64\x2B\x62", 5));
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L127: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L128: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L132: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x70\x70", 4));
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L134: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L135: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L136: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L137: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L138: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L139: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L141: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_all
  {
    if (SUB_ID_SPVM__Regex__replace_all < 0) {
      SUB_ID_SPVM__Regex__replace_all = env->get_sub_id(env, "SPVM::Regex", "replace_all", "string(self,string,int,string)");
      if (SUB_ID_SPVM__Regex__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 82;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L143: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L144: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 84;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L146: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L147: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L148: // BOOL_INT
  int_vars[0] = int_vars[0];
L149: // IF_NE_ZERO
  if (int_vars[0]) { goto L153; }
L150: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L151: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L152: // GOTO
  goto L153;
L153: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L154: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x70\x70", 4));
L155: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L169;
  }
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_NE_ZERO
  if (int_vars[0]) { goto L163; }
L159: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L160: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L169;
L162: // GOTO
  goto L163;
L163: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L166: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L169;
L167: // INIT_INT
  int_vars[6] = 0;
L168: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L169;
L169: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L170: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_all_cb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x28\x62\x63\x29", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A\x61\x62\x63\x7A", 11));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L18: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_all_cb
  {
    if (SUB_ID_SPVM__Regex__replace_all_cb < 0) {
      SUB_ID_SPVM__Regex__replace_all_cb = env->get_sub_id(env, "SPVM::Regex", "replace_all_cb", "string(self,string,int,SPVM::Regex::Replacer)");
      if (SUB_ID_SPVM__Regex__replace_all_cb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_all_cb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_all_cb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L29: // GOTO
  goto L30;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x41\x42\x43\x62\x63\x50\x51\x52\x53\x7A\x41\x42\x43\x62\x63\x50\x51\x52\x53\x7A", 23));
L32: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_all_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Regex__replace_cb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x28\x62\x63\x29", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Regex->new
  {
    if (SUB_ID_SPVM__Regex__new < 0) {
      SUB_ID_SPVM__Regex__new = env->get_sub_id(env, "SPVM::Regex", "new", "SPVM::Regex(string)");
      if (SUB_ID_SPVM__Regex__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x70\x70\x7A\x61\x62\x63\x7A", 7));
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon1 < 0) {
      BASIC_TYPE_ID_anon1 = env->get_basic_type_id(env, "anon1");
      if (BASIC_TYPE_ID_anon1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon1;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L15: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[2];
L18: // CALL_SUB_OBJECT
  // SPVM::Regex->replace_cb
  {
    if (SUB_ID_SPVM__Regex__replace_cb < 0) {
      SUB_ID_SPVM__Regex__replace_cb = env->get_sub_id(env, "SPVM::Regex", "replace_cb", "string(self,string,int,SPVM::Regex::Replacer)");
      if (SUB_ID_SPVM__Regex__replace_cb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Regex replace_cb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Regex__replace_cb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Regex__replace_count < 0, 0)) {
      FIELD_ID_SPVM__Regex__replace_count = env->get_field_id(env, "SPVM::Regex", "replace_count", "int");
      if (FIELD_ID_SPVM__Regex__replace_count < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Regex replace_count");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Regex__replace_count = env->get_field_offset(env, FIELD_ID_SPVM__Regex__replace_count);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Regex__replace_count);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L29: // GOTO
  goto L30;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x70\x7A\x41\x42\x62\x63\x43\x7A", 9));
L32: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Regex";
    const char* sub_name = "replace_cb";
    const char* file = "TestCase/Lib/SPVM/Regex.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


