#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Unicode__ERROR_INVALID_UTF8 = - 1;
static int32_t SUB_ID_SPVM__Unicode__uchar = - 1;
static int32_t SUB_ID_SPVM__Unicode__uchar_to_utf8 = - 1;
static int32_t SUB_ID_SPVM__Unicode__utf16_to_utf32 = - 1;
static int32_t SUB_ID_SPVM__Unicode__utf16_to_utf8 = - 1;
static int32_t SUB_ID_SPVM__Unicode__utf32_to_utf16 = - 1;
static int32_t SUB_ID_SPVM__Unicode__utf8_to_utf16 = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_short = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__ERROR_INVALID_UTF8(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__uchar(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__uchar_to_utf8(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf16_to_utf32(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf16_to_utf8(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf32_to_utf16(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf8_to_utf16(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__ERROR_INVALID_UTF8(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -2;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = -2;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__uchar(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  void* ref_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\x61\xE3\x81\x84", 7));
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L4: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 12354;
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L22: // GOTO
  goto L23;
L23: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L25: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L26: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L29: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L30: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L37: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L42: // GOTO
  goto L43;
L43: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L45: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L46: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 12356;
L49: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L54: // GOTO
  goto L55;
L55: // MOVE_CONSTANT_INT
  int_vars[6] = 7;
L56: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L61: // GOTO
  goto L62;
L62: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L63: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L64: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L65: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[4] = -1;
L68: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L73: // GOTO
  goto L74;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L76: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\x61\xE3\x81\x84", 7));
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L79: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 12354;
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L83: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L85: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L86: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L87: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L88: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[7] = 12356;
L91: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L92: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L95: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L96: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L98: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L99: // GOTO
  goto L111;
L100: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L102: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L105: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L125;
L107: // GOTO
  goto L108;
L108: // MOVE_INT
  int_vars[7] = int_vars[3];
L109: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L110: // ADD_INT
  int_vars[3] = int_vars[7] + int_vars[8];
L111: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L113: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L114: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L125;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L117: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_NE_ZERO
  if (int_vars[0]) { goto L100; }
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L125;
L123: // INIT_INT
  int_vars[4] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L125;
L125: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L126: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__uchar_to_utf8(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 12354;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L5: // CALL_SUB_OBJECT
  // SPVM::Unicode->uchar_to_utf8
  {
    if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
      SUB_ID_SPVM__Unicode__uchar_to_utf8 = env->get_sub_id(env, "SPVM::Unicode", "uchar_to_utf8", "string(int)");
      if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar_to_utf8");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar_to_utf8;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L7: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L10: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L86;
L15: // GOTO
  goto L16;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\xE3\x81\x82", 3));
L18: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L26; }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L86;
L25: // GOTO
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L29: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L32: // CALL_SUB_OBJECT
  // SPVM::Unicode->uchar_to_utf8
  {
    if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
      SUB_ID_SPVM__Unicode__uchar_to_utf8 = env->get_sub_id(env, "SPVM::Unicode", "uchar_to_utf8", "string(int)");
      if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar_to_utf8");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar_to_utf8;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L34: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L42: // GOTO
  goto L43;
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61", 1));
L45: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 12356;
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L57: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L58: // CALL_SUB_OBJECT
  // SPVM::Unicode->uchar_to_utf8
  {
    if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
      SUB_ID_SPVM__Unicode__uchar_to_utf8 = env->get_sub_id(env, "SPVM::Unicode", "uchar_to_utf8", "string(int)");
      if (SUB_ID_SPVM__Unicode__uchar_to_utf8 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar_to_utf8");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar_to_utf8;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 121;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L60: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L86;
L68: // GOTO
  goto L69;
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L70: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\xE3\x81\x84", 3));
L71: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "uchar_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L86;
  }
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L76: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L86;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L86;
L84: // INIT_INT
  int_vars[4] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf16_to_utf32(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 12354;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L11: // CONVERT_BYTE_TO_SHORT
  short_vars[1] = (int16_t)byte_vars[0];
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 12356;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf16_to_utf32
  {
    if (SUB_ID_SPVM__Unicode__utf16_to_utf32 < 0) {
      SUB_ID_SPVM__Unicode__utf16_to_utf32 = env->get_sub_id(env, "SPVM::Unicode", "utf16_to_utf32", "int[](short[])");
      if (SUB_ID_SPVM__Unicode__utf16_to_utf32 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf16_to_utf32");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf16_to_utf32;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L33: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L34: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L41: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L44: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L46: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[0];
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L54: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L57: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L59: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[0];
L60: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L65: // GOTO
  goto L66;
L66: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L69: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 12354;
L72: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 55362;
L77: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[7];
L78: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L79: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[9] = 57271;
L82: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[9];
L83: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L84: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L86: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L87: // CONVERT_BYTE_TO_SHORT
  short_vars[3] = (int16_t)byte_vars[0];
L88: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L89: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L91: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L92: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L96: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf16_to_utf32
  {
    if (SUB_ID_SPVM__Unicode__utf16_to_utf32 < 0) {
      SUB_ID_SPVM__Unicode__utf16_to_utf32 = env->get_sub_id(env, "SPVM::Unicode", "utf16_to_utf32", "int[](short[])");
      if (SUB_ID_SPVM__Unicode__utf16_to_utf32 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf16_to_utf32");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf16_to_utf32;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L99: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 12354;
L102: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L105: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L107: // GOTO
  goto L108;
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L111: // MOVE_CONSTANT_INT
  int_vars[6] = 134071;
L112: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L113: // BOOL_INT
  int_vars[0] = int_vars[0];
L114: // IF_NE_ZERO
  if (int_vars[0]) { goto L118; }
L115: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L117: // GOTO
  goto L118;
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L119: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf32";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L121: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L122: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L123: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L129; }
L126: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L128: // GOTO
  goto L129;
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L134;
L132: // INIT_INT
  int_vars[6] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L134;
L134: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L135: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf16_to_utf8(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 12354;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 55362;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 57271;
L16: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L20: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L21: // CONVERT_BYTE_TO_SHORT
  short_vars[3] = (int16_t)byte_vars[0];
L22: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L23: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L30: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf16_to_utf8
  {
    if (SUB_ID_SPVM__Unicode__utf16_to_utf8 < 0) {
      SUB_ID_SPVM__Unicode__utf16_to_utf8 = env->get_sub_id(env, "SPVM::Unicode", "utf16_to_utf8", "string(short[])");
      if (SUB_ID_SPVM__Unicode__utf16_to_utf8 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf16_to_utf8");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf16_to_utf8;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L33: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\xE3\x81\x82\xF0\xA0\xAE\xB7\x61", 8));
L34: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf16_to_utf8";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L41: // GOTO
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf32_to_utf16(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 12354;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L9: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L10: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[6] = 12356;
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L23: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf32_to_utf16
  {
    if (SUB_ID_SPVM__Unicode__utf32_to_utf16 < 0) {
      SUB_ID_SPVM__Unicode__utf32_to_utf16 = env->get_sub_id(env, "SPVM::Unicode", "utf32_to_utf16", "short[](int[])");
      if (SUB_ID_SPVM__Unicode__utf32_to_utf16 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf32_to_utf16");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf32_to_utf16;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 139;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L28: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L32: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L43: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L45: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L52: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L54: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L55: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L56: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[7] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L58: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L63: // GOTO
  goto L64;
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L67: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 12354;
L70: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L71: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[7] = 134071;
L74: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L75: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L77: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L78: // CONVERT_BYTE_TO_INT
  int_vars[9] = (int32_t)byte_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L87: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf32_to_utf16
  {
    if (SUB_ID_SPVM__Unicode__utf32_to_utf16 < 0) {
      SUB_ID_SPVM__Unicode__utf32_to_utf16 = env->get_sub_id(env, "SPVM::Unicode", "utf32_to_utf16", "short[](int[])");
      if (SUB_ID_SPVM__Unicode__utf32_to_utf16 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf32_to_utf16");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf32_to_utf16;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L89: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L92: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L93: // BOOL_INT
  int_vars[0] = int_vars[0];
L94: // IF_NE_ZERO
  if (int_vars[0]) { goto L98; }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L97: // GOTO
  goto L98;
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L99: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L101: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L102: // MOVE_CONSTANT_INT
  int_vars[6] = 12354;
L103: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L104: // BOOL_INT
  int_vars[0] = int_vars[0];
L105: // IF_NE_ZERO
  if (int_vars[0]) { goto L109; }
L106: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L107: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L108: // GOTO
  goto L109;
L109: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L110: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L112: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L113: // MOVE_CONSTANT_INT
  int_vars[6] = 55362;
L114: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L115: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L116: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L122; }
L119: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L121: // GOTO
  goto L122;
L122: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L123: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L125: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L126: // MOVE_CONSTANT_INT
  int_vars[6] = 57271;
L127: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L128: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L129: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L135; }
L132: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L134: // GOTO
  goto L135;
L135: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L136: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf32_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L152;
  }
L138: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L139: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L140: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L141: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_NE_ZERO
  if (int_vars[0]) { goto L147; }
L144: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L145: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L152;
L146: // GOTO
  goto L147;
L147: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L152;
L150: // INIT_INT
  int_vars[6] = 0;
L151: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L152;
L152: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L153: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Unicode__utf8_to_utf16(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\xF0\xA0\xAE\xB7\x61", 8));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Unicode->utf8_to_utf16
  {
    if (SUB_ID_SPVM__Unicode__utf8_to_utf16 < 0) {
      SUB_ID_SPVM__Unicode__utf8_to_utf16 = env->get_sub_id(env, "SPVM::Unicode", "utf8_to_utf16", "short[](string)");
      if (SUB_ID_SPVM__Unicode__utf8_to_utf16 < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode utf8_to_utf16");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__utf8_to_utf16;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L7: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L19: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L20: // MOVE_CONSTANT_INT
  int_vars[6] = 12354;
L21: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_NE_ZERO
  if (int_vars[0]) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L30: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 55362;
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L33: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L34: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_NE_ZERO
  if (int_vars[0]) { goto L40; }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L41: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L43: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L44: // MOVE_CONSTANT_INT
  int_vars[6] = 57271;
L45: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L46: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L54: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Unicode";
    const char* sub_name = "utf8_to_utf16";
    const char* file = "TestCase/Lib/SPVM/Unicode.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L56: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L57: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L58: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L59: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L64: // GOTO
  goto L65;
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L69;
L67: // INIT_INT
  int_vars[6] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


