#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__add(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__divide(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_minus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__negate(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__plus(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__NumericOperator__remainder(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__NumericOperator__add(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[11];
  float float_vars[9];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L9: // ADD_FLOAT
  float_vars[3] = float_vars[0] + float_vars[1];
L10: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L13: // CONVERT_BYTE_TO_FLOAT
  float_vars[1] = (float)byte_vars[0];
L14: // ADD_FLOAT
  float_vars[4] = float_vars[0] + float_vars[1];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L16: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L17: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L18: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L19: // ADD_FLOAT
  float_vars[5] = float_vars[0] + float_vars[1];
L20: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L22: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L23: // CONVERT_SHORT_TO_FLOAT
  float_vars[1] = (float)short_vars[0];
L24: // ADD_FLOAT
  float_vars[6] = float_vars[0] + float_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[3];
L27: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L28: // ADD_FLOAT
  float_vars[7] = float_vars[0] + float_vars[1];
L29: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L31: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L32: // ADD_FLOAT
  float_vars[8] = float_vars[0] + float_vars[1];
L33: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.75;
L34: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L37: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L38: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L41: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L42: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L45: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L46: // EQ_FLOAT
  int_vars[0] = (float_vars[5] == float_vars[0]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L49: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L50: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[0]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L53: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L54: // EQ_FLOAT
  int_vars[0] = (float_vars[7] == float_vars[0]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L57: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.5;
L58: // EQ_FLOAT
  int_vars[0] = (float_vars[8] == float_vars[0]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L61: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L62: // GOTO
  goto L63;
L63: // GOTO
  goto L64;
L64: // GOTO
  goto L65;
L65: // GOTO
  goto L66;
L66: // GOTO
  goto L67;
L67: // GOTO
  goto L68;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L71: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L72: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L73: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L74: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L75: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L77: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L78: // CONVERT_BYTE_TO_DOUBLE
  double_vars[1] = (double)byte_vars[0];
L79: // ADD_DOUBLE
  double_vars[3] = double_vars[0] + double_vars[1];
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L81: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L82: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L83: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L84: // ADD_DOUBLE
  double_vars[4] = double_vars[0] + double_vars[1];
L85: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L86: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L87: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L88: // CONVERT_SHORT_TO_DOUBLE
  double_vars[1] = (double)short_vars[0];
L89: // ADD_DOUBLE
  double_vars[5] = double_vars[0] + double_vars[1];
L90: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L91: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[4];
L92: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L93: // ADD_DOUBLE
  double_vars[6] = double_vars[0] + double_vars[1];
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L96: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L97: // ADD_DOUBLE
  double_vars[7] = double_vars[0] + double_vars[1];
L98: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L99: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L100: // ADD_DOUBLE
  double_vars[8] = double_vars[0] + double_vars[1];
L101: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L102: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L103: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[0];
L104: // ADD_DOUBLE
  double_vars[9] = double_vars[0] + double_vars[1];
L105: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L106: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L107: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L108: // ADD_DOUBLE
  double_vars[10] = double_vars[0] + double_vars[1];
L109: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L110: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L111: // BOOL_INT
  int_vars[0] = int_vars[0];
L112: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L113: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L114: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L117: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L118: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L121: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L122: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[0]);
L123: // BOOL_INT
  int_vars[0] = int_vars[0];
L124: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L125: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L126: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[0]);
L127: // BOOL_INT
  int_vars[0] = int_vars[0];
L128: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L129: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 2.5;
L130: // EQ_DOUBLE
  int_vars[0] = (double_vars[7] == double_vars[0]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L133: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.75;
L134: // EQ_DOUBLE
  int_vars[0] = (double_vars[8] == double_vars[0]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L137: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.75;
L138: // EQ_DOUBLE
  int_vars[0] = (double_vars[9] == double_vars[0]);
L139: // BOOL_INT
  int_vars[0] = int_vars[0];
L140: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L148; }
L141: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.75;
L142: // EQ_DOUBLE
  int_vars[0] = (double_vars[10] == double_vars[0]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L147; }
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L146: // GOTO
  goto L147;
L147: // GOTO
  goto L148;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // BOOL_INT
  int_vars[0] = int_vars[1];
L156: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L165; }
L157: // BOOL_INT
  int_vars[0] = int_vars[3];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L162; }
L159: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L160: // BOOL_INT
  int_vars[0] = int_vars[4];
L161: // GOTO
  goto L164;
L162: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L163: // BOOL_INT
  int_vars[0] = int_vars[5];
L164: // GOTO
  goto L167;
L165: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L166: // BOOL_INT
  int_vars[0] = int_vars[6];
L167: // BOOL_INT
  int_vars[0] = int_vars[0];
L168: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L169: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L170: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L176;
L171: // GOTO
  goto L172;
L172: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L173: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L176;
L174: // INIT_INT
  int_vars[8] = 0;
L175: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L176;
L176: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__divide(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[11];
  float float_vars[9];
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L4: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[3] / int_vars[4];
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 264;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L7: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L8: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L9: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L10: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[4] / int_vars[6];
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L15: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L16: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[8] = int_vars[3] / int_vars[6];
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 266;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L20: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L22: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[9] = int_vars[4] / int_vars[6];
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L26: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L27: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L28: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[10] = int_vars[3] / int_vars[6];
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L31: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L32: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L34: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L35: // CONVERT_BYTE_TO_INT
  int_vars[11] = (int32_t)byte_vars[1];
L36: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[12] = int_vars[4] / int_vars[11];
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L39: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L40: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L42: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L43: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[1];
L44: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[13] = int_vars[4] / int_vars[11];
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L47: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L48: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L50: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L51: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[0];
L52: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[14] = int_vars[4] / int_vars[11];
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L56: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[4];
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "divide";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L59: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L104; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L63: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[3]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L67: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[3]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L71: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L75: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[3]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L78: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L79: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[3]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L83: // EQ_INT
  int_vars[0] = (int_vars[13] == int_vars[3]);
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L87: // EQ_INT
  int_vars[0] = (int_vars[14] == int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L91: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L94: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // GOTO
  goto L104;
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L106: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L107: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L110: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L111: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L112: // DIVIDE_FLOAT
  float_vars[3] = float_vars[0] / float_vars[1];
L113: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L114: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L115: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L116: // CONVERT_BYTE_TO_FLOAT
  float_vars[1] = (float)byte_vars[0];
L117: // DIVIDE_FLOAT
  float_vars[4] = float_vars[0] / float_vars[1];
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L120: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L121: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L122: // DIVIDE_FLOAT
  float_vars[5] = float_vars[0] / float_vars[1];
L123: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L124: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L125: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L126: // CONVERT_SHORT_TO_FLOAT
  float_vars[1] = (float)short_vars[0];
L127: // DIVIDE_FLOAT
  float_vars[6] = float_vars[0] / float_vars[1];
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L129: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L130: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L131: // DIVIDE_FLOAT
  float_vars[7] = float_vars[0] / float_vars[1];
L132: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L133: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L134: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L135: // DIVIDE_FLOAT
  float_vars[8] = float_vars[0] / float_vars[1];
L136: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L137: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L140: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L141: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L171; }
L144: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L145: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L146: // BOOL_INT
  int_vars[0] = int_vars[0];
L147: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L170; }
L148: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L149: // EQ_FLOAT
  int_vars[0] = (float_vars[5] == float_vars[0]);
L150: // BOOL_INT
  int_vars[0] = int_vars[0];
L151: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L152: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L153: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[0]);
L154: // BOOL_INT
  int_vars[0] = int_vars[0];
L155: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L168; }
L156: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L157: // EQ_FLOAT
  int_vars[0] = (float_vars[7] == float_vars[0]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L167; }
L160: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L161: // EQ_FLOAT
  int_vars[0] = (float_vars[8] == float_vars[0]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L166; }
L164: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L165: // GOTO
  goto L166;
L166: // GOTO
  goto L167;
L167: // GOTO
  goto L168;
L168: // GOTO
  goto L169;
L169: // GOTO
  goto L170;
L170: // GOTO
  goto L171;
L171: // GOTO
  goto L172;
L172: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L173: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L174: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L175: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L177: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L178: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L179: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L180: // DIVIDE_DOUBLE
  double_vars[3] = double_vars[0] / double_vars[1];
L181: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L182: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L183: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L184: // CONVERT_BYTE_TO_DOUBLE
  double_vars[1] = (double)byte_vars[0];
L185: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[0] / double_vars[1];
L186: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L187: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L188: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L189: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L190: // DIVIDE_DOUBLE
  double_vars[5] = double_vars[0] / double_vars[1];
L191: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L193: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L194: // CONVERT_SHORT_TO_DOUBLE
  double_vars[1] = (double)short_vars[0];
L195: // DIVIDE_DOUBLE
  double_vars[6] = double_vars[0] / double_vars[1];
L196: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L197: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[5];
L198: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L199: // DIVIDE_DOUBLE
  double_vars[7] = double_vars[0] / double_vars[1];
L200: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L201: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L202: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[5];
L203: // DIVIDE_DOUBLE
  double_vars[8] = double_vars[0] / double_vars[1];
L204: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L205: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L206: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[0];
L207: // DIVIDE_DOUBLE
  double_vars[9] = double_vars[0] / double_vars[1];
L208: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L209: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L210: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L211: // DIVIDE_DOUBLE
  double_vars[10] = double_vars[0] / double_vars[1];
L212: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L213: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L214: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L215: // BOOL_INT
  int_vars[0] = int_vars[0];
L216: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L267; }
L217: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L218: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L219: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L220: // BOOL_INT
  int_vars[0] = int_vars[0];
L221: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L266; }
L222: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L223: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L224: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L265; }
L227: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L228: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L229: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[0]);
L230: // BOOL_INT
  int_vars[0] = int_vars[0];
L231: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L264; }
L232: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L233: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L234: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[0]);
L235: // BOOL_INT
  int_vars[0] = int_vars[0];
L236: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L263; }
L237: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L238: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L239: // EQ_DOUBLE
  int_vars[0] = (double_vars[7] == double_vars[0]);
L240: // BOOL_INT
  int_vars[0] = int_vars[0];
L241: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L262; }
L242: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L243: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L244: // EQ_DOUBLE
  int_vars[0] = (double_vars[8] == double_vars[0]);
L245: // BOOL_INT
  int_vars[0] = int_vars[0];
L246: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L261; }
L247: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L248: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L249: // EQ_DOUBLE
  int_vars[0] = (double_vars[9] == double_vars[0]);
L250: // BOOL_INT
  int_vars[0] = int_vars[0];
L251: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L260; }
L252: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L253: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L254: // EQ_DOUBLE
  int_vars[0] = (double_vars[10] == double_vars[0]);
L255: // BOOL_INT
  int_vars[0] = int_vars[0];
L256: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L259; }
L257: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L258: // GOTO
  goto L259;
L259: // GOTO
  goto L260;
L260: // GOTO
  goto L261;
L261: // GOTO
  goto L262;
L262: // GOTO
  goto L263;
L263: // GOTO
  goto L264;
L264: // GOTO
  goto L265;
L265: // GOTO
  goto L266;
L266: // GOTO
  goto L267;
L267: // BOOL_INT
  int_vars[0] = int_vars[1];
L268: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L277; }
L269: // BOOL_INT
  int_vars[0] = int_vars[3];
L270: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L274; }
L271: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L272: // BOOL_INT
  int_vars[0] = int_vars[5];
L273: // GOTO
  goto L276;
L274: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L275: // BOOL_INT
  int_vars[0] = int_vars[6];
L276: // GOTO
  goto L279;
L277: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L278: // BOOL_INT
  int_vars[0] = int_vars[7];
L279: // BOOL_INT
  int_vars[0] = int_vars[0];
L280: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L289; }
L281: // BOOL_INT
  int_vars[0] = int_vars[4];
L282: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L286; }
L283: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L284: // BOOL_INT
  int_vars[0] = int_vars[5];
L285: // GOTO
  goto L288;
L286: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L287: // BOOL_INT
  int_vars[0] = int_vars[6];
L288: // GOTO
  goto L291;
L289: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L290: // BOOL_INT
  int_vars[0] = int_vars[7];
L291: // BOOL_INT
  int_vars[0] = int_vars[0];
L292: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L296; }
L293: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L294: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L300;
L295: // GOTO
  goto L296;
L296: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L297: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L300;
L298: // INIT_INT
  int_vars[9] = 0;
L299: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L300;
L300: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[11];
  float float_vars[9];
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L4: // MULTIPLY_INT
  int_vars[5] = int_vars[3] * int_vars[4];
L5: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L7: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L8: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L9: // MULTIPLY_INT
  int_vars[7] = int_vars[4] * int_vars[6];
L10: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L12: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L13: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L14: // MULTIPLY_INT
  int_vars[8] = int_vars[3] * int_vars[6];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L16: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L17: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L19: // MULTIPLY_INT
  int_vars[9] = int_vars[4] * int_vars[6];
L20: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L22: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L23: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L24: // MULTIPLY_INT
  int_vars[10] = int_vars[3] * int_vars[6];
L25: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L27: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 7;
L29: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L30: // CONVERT_BYTE_TO_INT
  int_vars[11] = (int32_t)byte_vars[1];
L31: // MULTIPLY_INT
  int_vars[12] = int_vars[4] * int_vars[11];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L33: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L34: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 8;
L36: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L37: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[1];
L38: // MULTIPLY_INT
  int_vars[13] = int_vars[4] * int_vars[11];
L39: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L40: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L41: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L43: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L44: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[0];
L45: // MULTIPLY_INT
  int_vars[14] = int_vars[4] * int_vars[11];
L46: // MOVE_CONSTANT_INT
  int_vars[3] = -4;
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = -6;
L51: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = -8;
L55: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = -10;
L59: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[3]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = -12;
L63: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[3]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = -14;
L67: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[3]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = -16;
L71: // EQ_INT
  int_vars[0] = (int_vars[13] == int_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = -18;
L75: // EQ_INT
  int_vars[0] = (int_vars[14] == int_vars[3]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L78: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L79: // GOTO
  goto L80;
L80: // GOTO
  goto L81;
L81: // GOTO
  goto L82;
L82: // GOTO
  goto L83;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L88: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L89: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L90: // MULTIPLY_FLOAT
  float_vars[2] = float_vars[0] * float_vars[1];
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L92: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L93: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L94: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L95: // MULTIPLY_FLOAT
  float_vars[3] = float_vars[0] * float_vars[1];
L96: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L98: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L99: // CONVERT_BYTE_TO_FLOAT
  float_vars[1] = (float)byte_vars[0];
L100: // MULTIPLY_FLOAT
  float_vars[4] = float_vars[0] * float_vars[1];
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L102: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L103: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L104: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L105: // MULTIPLY_FLOAT
  float_vars[5] = float_vars[0] * float_vars[1];
L106: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L108: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L109: // CONVERT_SHORT_TO_FLOAT
  float_vars[1] = (float)short_vars[0];
L110: // MULTIPLY_FLOAT
  float_vars[6] = float_vars[0] * float_vars[1];
L111: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L112: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L113: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L114: // MULTIPLY_FLOAT
  float_vars[7] = float_vars[0] * float_vars[1];
L115: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L116: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L117: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L118: // MULTIPLY_FLOAT
  float_vars[8] = float_vars[0] * float_vars[1];
L119: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.125;
L120: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L123: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L124: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L125: // BOOL_INT
  int_vars[0] = int_vars[0];
L126: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L127: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L128: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L131: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L132: // EQ_FLOAT
  int_vars[0] = (float_vars[5] == float_vars[0]);
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L135: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L136: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[0]);
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L139: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L140: // EQ_FLOAT
  int_vars[0] = (float_vars[7] == float_vars[0]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L143: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L144: // EQ_FLOAT
  int_vars[0] = (float_vars[8] == float_vars[0]);
L145: // BOOL_INT
  int_vars[0] = int_vars[0];
L146: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L147: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L156: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L157: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L158: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L159: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L160: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L161: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L162: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L163: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L164: // CONVERT_BYTE_TO_DOUBLE
  double_vars[1] = (double)byte_vars[0];
L165: // MULTIPLY_DOUBLE
  double_vars[3] = double_vars[0] * double_vars[1];
L166: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L167: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L168: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L169: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L170: // MULTIPLY_DOUBLE
  double_vars[4] = double_vars[0] * double_vars[1];
L171: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L172: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L173: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L174: // CONVERT_SHORT_TO_DOUBLE
  double_vars[1] = (double)short_vars[0];
L175: // MULTIPLY_DOUBLE
  double_vars[5] = double_vars[0] * double_vars[1];
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L177: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[5];
L178: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L179: // MULTIPLY_DOUBLE
  double_vars[6] = double_vars[0] * double_vars[1];
L180: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L181: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L182: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[5];
L183: // MULTIPLY_DOUBLE
  double_vars[7] = double_vars[0] * double_vars[1];
L184: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L185: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L186: // MULTIPLY_DOUBLE
  double_vars[8] = double_vars[0] * double_vars[1];
L187: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L188: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L189: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[0];
L190: // MULTIPLY_DOUBLE
  double_vars[9] = double_vars[0] * double_vars[1];
L191: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L192: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L193: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L194: // MULTIPLY_DOUBLE
  double_vars[10] = double_vars[0] * double_vars[1];
L195: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L196: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L197: // BOOL_INT
  int_vars[0] = int_vars[0];
L198: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L199: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L200: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L201: // BOOL_INT
  int_vars[0] = int_vars[0];
L202: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L203: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L204: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L205: // BOOL_INT
  int_vars[0] = int_vars[0];
L206: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L207: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L208: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[0]);
L209: // BOOL_INT
  int_vars[0] = int_vars[0];
L210: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L211: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L212: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[0]);
L213: // BOOL_INT
  int_vars[0] = int_vars[0];
L214: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L215: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L216: // EQ_DOUBLE
  int_vars[0] = (double_vars[7] == double_vars[0]);
L217: // BOOL_INT
  int_vars[0] = int_vars[0];
L218: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L219: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L220: // EQ_DOUBLE
  int_vars[0] = (double_vars[8] == double_vars[0]);
L221: // BOOL_INT
  int_vars[0] = int_vars[0];
L222: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L223: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L224: // EQ_DOUBLE
  int_vars[0] = (double_vars[9] == double_vars[0]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L227: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.125;
L228: // EQ_DOUBLE
  int_vars[0] = (double_vars[10] == double_vars[0]);
L229: // BOOL_INT
  int_vars[0] = int_vars[0];
L230: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L231: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // BOOL_INT
  int_vars[0] = int_vars[1];
L242: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L251; }
L243: // BOOL_INT
  int_vars[0] = int_vars[3];
L244: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L246: // BOOL_INT
  int_vars[0] = int_vars[5];
L247: // GOTO
  goto L250;
L248: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L249: // BOOL_INT
  int_vars[0] = int_vars[6];
L250: // GOTO
  goto L253;
L251: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L252: // BOOL_INT
  int_vars[0] = int_vars[7];
L253: // BOOL_INT
  int_vars[0] = int_vars[0];
L254: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L263; }
L255: // BOOL_INT
  int_vars[0] = int_vars[4];
L256: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L260; }
L257: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L258: // BOOL_INT
  int_vars[0] = int_vars[5];
L259: // GOTO
  goto L262;
L260: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L261: // BOOL_INT
  int_vars[0] = int_vars[6];
L262: // GOTO
  goto L265;
L263: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L264: // BOOL_INT
  int_vars[0] = int_vars[7];
L265: // BOOL_INT
  int_vars[0] = int_vars[0];
L266: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L270; }
L267: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L268: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L274;
L269: // GOTO
  goto L270;
L270: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L271: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L274;
L272: // INIT_INT
  int_vars[9] = 0;
L273: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L274;
L274: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 536870912;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1073741824;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_int_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 536870912;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULTIPLY_INT
  int_vars[5] = int_vars[2] * int_vars[4];
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L9;
L7: // INIT_INT
  int_vars[7] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_minus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2305843009213693952LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = -2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4611686018427387904LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = 2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__multiply_long_plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 2305843009213693952LL;
L2: // MOVE_LONG
  long_vars[1] = long_vars[0];
L3: // MOVE_CONSTANT_LONG
  long_vars[2] = 2LL;
L4: // MOVE_LONG
  long_vars[3] = long_vars[2];
L5: // MULTIPLY_LONG
  long_vars[4] = long_vars[1] * long_vars[3];
L6: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  goto L9;
L7: // INIT_LONG
  long_vars[5] = 0;
L8: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[5];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__negate(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[3];
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // NEGATE_INT
  int_vars[4] = -int_vars[3];
L11: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L12: // NEGATE_INT
  int_vars[5] = -int_vars[3];
L13: // NEGATE_INT
  int_vars[3] = -int_vars[2];
L14: // NEGATE_LONG
  long_vars[1] = -long_vars[0];
L15: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L16: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L18: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L21: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L22: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L25: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L26: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L29: // MOVE_CONSTANT_LONG
  long_vars[2] = -1LL;
L30: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L33: // MOVE_CONSTANT_FLOAT
  float_vars[2] = -1.0;
L34: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L37: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = -1.0;
L38: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // GOTO
  goto L47;
L47: // GOTO
  goto L48;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L53;
L51: // INIT_INT
  int_vars[10] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__plus(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  float float_vars[3];
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // MOVE_INT
  int_vars[4] = int_vars[3];
L11: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L12: // MOVE_INT
  int_vars[5] = int_vars[3];
L13: // MOVE_INT
  int_vars[3] = int_vars[2];
L14: // MOVE_LONG
  long_vars[1] = long_vars[0];
L15: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L16: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L18: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L49; }
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L22: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L25: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L26: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L29: // MOVE_CONSTANT_LONG
  long_vars[2] = 1LL;
L30: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L33: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 1.0;
L34: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L37: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 1.0;
L38: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // GOTO
  goto L47;
L47: // GOTO
  goto L48;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L53;
L51: // INIT_INT
  int_vars[10] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L53;
L53: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__NumericOperator__remainder(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[4];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // REMAINDER_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[4];
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L12: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L15: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L16: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L18: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[6];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L20: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L21: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L23: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L24: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L25: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L27: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[6];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L29: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L30: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L33: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L34: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L36: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L39: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[4] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L43: // REMAINDER_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[5] = int_vars[2] % /* REMAINDER */ int_vars[3];
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 367;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_LONG
  long_vars[0] = 5LL;
L46: // MOVE_CONSTANT_LONG
  long_vars[1] = 3LL;
L47: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[2] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L49: // MOVE_CONSTANT_LONG
  long_vars[0] = -3LL;
L50: // MOVE_CONSTANT_LONG
  long_vars[1] = 5LL;
L51: // REMAINDER_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    long_vars[3] = long_vars[0] % /* REMAINDER */ long_vars[1];
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::NumericOperator";
    const char* sub_name = "remainder";
    const char* file = "TestCase/NumericOperator.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L53: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L55: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L58: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[3];
L59: // MOVE_CONSTANT_INT
  int_vars[3] = -3;
L60: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L63: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L68: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[3];
L69: // MOVE_CONSTANT_INT
  int_vars[3] = -3;
L70: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L74: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = -3;
L78: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L81: // MOVE_CONSTANT_LONG
  long_vars[0] = 2LL;
L82: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L85: // MOVE_CONSTANT_LONG
  long_vars[0] = -3LL;
L86: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L101: // INIT_INT
  int_vars[8] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L103;
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


