#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Return__return_implicite_convertion_stub = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__Int__val = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Return__return_implicite_convertion(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string()
int32_t SPPRECOMPILE__TestCase__Return__return_implicite_convertion_stub(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Return__return_implicite_convertion(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Return->return_implicite_convertion_stub
  {
    if (SUB_ID_TestCase__Return__return_implicite_convertion_stub < 0) {
      SUB_ID_TestCase__Return__return_implicite_convertion_stub = env->get_sub_id(env, "TestCase::Return", "return_implicite_convertion_stub", "string()");
      if (SUB_ID_TestCase__Return__return_implicite_convertion_stub < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Return return_implicite_convertion_stub");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Return__return_implicite_convertion_stub;
    exception_flag = SPPRECOMPILE__TestCase__Return__return_implicite_convertion_stub(env, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Return";
    const char* sub_name = "return_implicite_convertion";
    const char* file = "TestCase/Return.spvm";
    int32_t line = 4;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x31", 1));
L6: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Return";
    const char* sub_name = "return_implicite_convertion";
    const char* file = "TestCase/Return.spvm";
    int32_t line = 5;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Return__return_implicite_convertion_stub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Return";
    const char* sub_name = "return_implicite_convertion_stub";
    const char* file = "TestCase/Return.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L6: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Return";
    const char* sub_name = "return_implicite_convertion_stub";
    const char* file = "TestCase/Return.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L9: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L10: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L14;
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L13: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[2];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}


