#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Seqop__seqop(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Seqop__seqop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L15: // ADD_INT
  int_vars[4] = int_vars[4] + int_vars[3];
L16: // ADD_INT
  int_vars[5] = int_vars[4] + int_vars[2];
L17: // MOVE_INT
  int_vars[6] = int_vars[5];
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[3];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[5];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[7];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L37: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[3];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[5];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[7];
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L57;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L55: // INIT_INT
  int_vars[6] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L57;
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


