#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Term__evaluate_left_to_right_excpetion = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Term__evaluate_left_to_right(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Term__evaluate_left_to_right_excpetion(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Term__evaluate_left_to_right(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L3: // MULTIPLY_INT
  int_vars[3] = int_vars[1] * int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[4] = 9;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L12: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L13: // CALL_SUB_INT
  // TestCase::Term->evaluate_left_to_right_excpetion
  {
    if (SUB_ID_TestCase__Term__evaluate_left_to_right_excpetion < 0) {
      SUB_ID_TestCase__Term__evaluate_left_to_right_excpetion = env->get_sub_id(env, "TestCase::Term", "evaluate_left_to_right_excpetion", "int()");
      if (SUB_ID_TestCase__Term__evaluate_left_to_right_excpetion < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Term evaluate_left_to_right_excpetion");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Term__evaluate_left_to_right_excpetion;
    exception_flag = SPPRECOMPILE__TestCase__Term__evaluate_left_to_right_excpetion(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Term";
    const char* sub_name = "evaluate_left_to_right";
    const char* file = "TestCase/Term.spvm";
    int32_t line = 15;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L16: // DIVIDE_INT
  if (__builtin_expect(int_vars[1] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[4] = int_vars[3] / int_vars[1];
  } 
L17: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Term";
    const char* sub_name = "evaluate_left_to_right";
    const char* file = "TestCase/Term.spvm";
    int32_t line = 15;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L18: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L20: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_NE_ZERO
  if (int_vars[0]) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L30;
L25: // GOTO
  goto L26;
L26: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Term__evaluate_left_to_right_excpetion(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x45\x72\x72\x6F\x72", 5));
L3: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L4: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Term";
    const char* sub_name = "evaluate_left_to_right_excpetion";
    const char* file = "TestCase/Term.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L11;
  }
L6: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L9: // INIT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L11: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


