package Crypt::LE::Challenge::Simple;
use Data::Dumper;
use strict;
use warnings;

our $VERSION = '0.09';

=head1 NAME

Crypt::LE::Challenge::Simple - A boilerplate for extending Crypt::LE and Crypt::LE client
application (le.pl) with challenge/varification handlers.

=head1 SYNOPSIS

 use Crypt::LE;
 use Crypt::LE::Challenge::Simple;
 ...
 my $le = Crypt::LE->new();
 my $simple_challenge = Crypt::LE::Challenge::Simple->new();
 ..
 $le->accept_challenge($simple_challenge);
 $le->verify_challenge($simple_challenge);

=head1 DESCRIPTION

Crypt::LE provides the functionality necessary to use Let's Encrypt API and generate free SSL certificates for your domains.
This Crypt::LE plugin is an example of how challenge and verification handling can be done by an external module.

B<This module can also be used with the provided Crypt::LE client application - le.pl:>

 le.pl ... --handle-with Crypt::LE::Challenge::Simple --handle-params '{"key1": 1, "key2": 2, "key3": "something"}'

=cut

sub new { bless {}, shift }
 
sub handle_challenge_http {
    my $self = shift;
    my ($challenge, $params) = @_;
    print __PACKAGE__, "\n";
    if ($params) {
        print "Parameters passed: " . Dumper($params);
    }
    print "Domain $challenge->{domain} expects '$challenge->{token}.$challenge->{fingerprint}' text in '$challenge->{token}' file\n";
    print "Press <Enter>";
    <STDIN>;
    return 1;
};

sub handle_challenge_tls {
    # Return 0 to indicate an error
    return 0;
}

sub handle_challenge_dns {
    # Critical error will be treated as a failure too
    die "Oh, this challenge is not supported!\n";
}

sub handle_verification_http {
    my $self = shift;
    my ($verification, $params) = @_;
    print __PACKAGE__, "\n";
    if ($params) {
        print "Parameters passed: " . Dumper($params);
    }
    print "Domain $verification->{domain} " . ($verification->{valid} ? "has been verified successfully." : "has NOT been verified.") . "\n";
    print "You can now delete '$verification->{token}' file\n";
    <STDIN>;
    return 1;
}

sub handle_verification_tls {
    1;
}

sub handle_verification_dns {
    1;
}

=head1 AUTHOR

Alexander Yezhov, C<< <leader at cpan.org> >>
Domain Knowledge Ltd.
L<https://do-know.com/>

=cut

1;
