########################################################################
# housekeeping
########################################################################

package Module::FromPerlVer::Git;
use 5.006;
use strict;
use version;
use parent  qw( Module::FromPerlVer::Extract );

use File::Basename          qw( basename        );
use List::Util              qw( first           );
use Symbol                  qw( qualify_to_ref  );

########################################################################
# package variables & sanity checks
########################################################################

our $VERSION    = version->parse( 'v0.1.0' )->numify;

my $nil         = sub{};

my @checkout    = qw( git checkout          );
my @restore     = qw( git checkout --theirs );

########################################################################
# methods
########################################################################

sub source_prefix
{
    my $extract = shift;

    $extract->value( 'git_prefix' )
}

sub module_sources
{
    my $extract = shift;
    my $prefix  = $extract->value( 'git_prefix' ) . '*';

    # force a list context for qx

    chomp( my @tagz = qx{ git tag --list '$prefix'} )
    or
    die "No tags like '$prefix*' found";

    local $,    = "\n#\t";
    print "# Git tags: '$prefix*'", @tagz;

    @tagz
}

sub source_files
{
    # avoid returning true in scalar context.

    return
}

sub get_files
{
    my $extract = shift;
    my $tag     = $extract->value( 'module_source' );

    # deal with parsing this iff cleanup is called.

    chomp( my $curr = ( qx{ git branch } )[0] );

    print "# Saving: '$curr' for cleanup.";

    $extract->value( restore_branch => $curr );

    # no telling what the tag might look like.
    # quotes protect it from the shell.

    my @status
    = do
    {
        local $,    = ' ';

        qx{ @checkout '$tag' }
    };

    if( $? )
    {
        local $, = "\n@\t";

        chomp @status;

        print 'Checkout result:', @status;

        warn "Non-zero exit: $? from @checkout '$tag'";
    }
    else
    {
        print "# Checkout '$tag' complete.";
    }
}

sub cleanup
{
    my $extract = shift;
    my $branch  = $extract->value( 'restore_branch' );

    system @restore, "'$branch'"
    and
    do
    {
        local $, = ' ';
        warn "Non-zero exit: $? from @restore '$branch'";
    }
}

# keep require happy
1
__END__
