# use "*_t" for basename of this file.
# symlink to *-<perl version string to test>.t.
# e.g.,
#   "20-foo-v5.5.3.t"
#   "20-bar-5.005_003"
#   "20-bar-v5.005003"
# will test varieties of the same perl version string.
########################################################################
# housekeeping
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

use File::Spec::Functions
qw
(
    &catpath
);

########################################################################
# package variables 
########################################################################

my $madness = 'Module::FromPerlVer';

my $wv      = Test::KwikHaks->can( 'write_version_file' );

*output     = Test::KwikHaks->can( 'output' );

my $work_d  = eval { Test::KwikHaks::work_dir }
or BAIL_OUT "Failed create tmpdir: $@";

########################################################################
# test reading version from "use" or "no".
########################################################################

output( 'foobar' );

delete $ENV{ PERL_VERSION };

my ( $base, $perl_v )  
= eval
{
    Test::KwikHaks::perl_v_from_basename()
}
or BAIL_OUT "Missing Perl Version: $@";

my $vers_d   = 't/version';

my $v_file  = $wv->( $perl_v )
or BAIL_OUT "Failed writing version file.", 1;

eval
{
    use_ok $madness => 
    version_dir     => $vers_d,
    version_from    => $v_file,
    dest_dir        => $work_d;

    1
}
or
BAIL_OUT "Un-usable: $madness: $@";

for my $dir ( $madness->version_dir )
{
    is $dir, $vers_d, "Source prefix: '$dir' ($vers_d)";
}

my $found   = $madness->dest_paths;

note "Source files:\n", explain $found;

@$found
? pass 'Found source files in version directory'
: fail 'Missing source files for cleanup'
;

ok -e , "Copied: '$_' ($work_d)"
for @$found;

eval
{
    $madness->cleanup;

    pass "Survived cleanup.";

    ok ! -e , "Removed: '$_' ($work_d)"
    for @$found;

    1
}
or 
fail "Failed cleanup: $@";

done_testing;
__END__
