# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.

package Math::GSL::Sum;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package Math::GSL::Sumc;
bootstrap Math::GSL::Sum;
package Math::GSL::Sum;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package Math::GSL::Sum;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Sum;

*gsl_sum_levin_u_alloc = *Math::GSL::Sumc::gsl_sum_levin_u_alloc;
*gsl_sum_levin_u_free = *Math::GSL::Sumc::gsl_sum_levin_u_free;
*gsl_sum_levin_u_accel = *Math::GSL::Sumc::gsl_sum_levin_u_accel;
*gsl_sum_levin_u_minmax = *Math::GSL::Sumc::gsl_sum_levin_u_minmax;
*gsl_sum_levin_u_step = *Math::GSL::Sumc::gsl_sum_levin_u_step;
*gsl_sum_levin_utrunc_alloc = *Math::GSL::Sumc::gsl_sum_levin_utrunc_alloc;
*gsl_sum_levin_utrunc_free = *Math::GSL::Sumc::gsl_sum_levin_utrunc_free;
*gsl_sum_levin_utrunc_accel = *Math::GSL::Sumc::gsl_sum_levin_utrunc_accel;
*gsl_sum_levin_utrunc_minmax = *Math::GSL::Sumc::gsl_sum_levin_utrunc_minmax;
*gsl_sum_levin_utrunc_step = *Math::GSL::Sumc::gsl_sum_levin_utrunc_step;

############# Class : Math::GSL::Sum::gsl_sum_levin_u_workspace ##############

package Math::GSL::Sum::gsl_sum_levin_u_workspace;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Sum );
%OWNER = ();
%ITERATORS = ();
*swig_size_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_size_get;
*swig_size_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_size_set;
*swig_i_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_i_get;
*swig_i_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_i_set;
*swig_terms_used_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_terms_used_get;
*swig_terms_used_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_terms_used_set;
*swig_sum_plain_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_sum_plain_get;
*swig_sum_plain_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_sum_plain_set;
*swig_q_num_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_q_num_get;
*swig_q_num_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_q_num_set;
*swig_q_den_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_q_den_get;
*swig_q_den_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_q_den_set;
*swig_dq_num_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dq_num_get;
*swig_dq_num_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dq_num_set;
*swig_dq_den_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dq_den_get;
*swig_dq_den_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dq_den_set;
*swig_dsum_get = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dsum_get;
*swig_dsum_set = *Math::GSL::Sumc::gsl_sum_levin_u_workspace_dsum_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Sumc::new_gsl_sum_levin_u_workspace(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Sumc::delete_gsl_sum_levin_u_workspace($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::Sum::gsl_sum_levin_utrunc_workspace ##############

package Math::GSL::Sum::gsl_sum_levin_utrunc_workspace;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Sum );
%OWNER = ();
%ITERATORS = ();
*swig_size_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_size_get;
*swig_size_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_size_set;
*swig_i_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_i_get;
*swig_i_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_i_set;
*swig_terms_used_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_terms_used_get;
*swig_terms_used_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_terms_used_set;
*swig_sum_plain_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_sum_plain_get;
*swig_sum_plain_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_sum_plain_set;
*swig_q_num_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_q_num_get;
*swig_q_num_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_q_num_set;
*swig_q_den_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_q_den_get;
*swig_q_den_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_q_den_set;
*swig_dsum_get = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_dsum_get;
*swig_dsum_set = *Math::GSL::Sumc::gsl_sum_levin_utrunc_workspace_dsum_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Sumc::new_gsl_sum_levin_utrunc_workspace(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Sumc::delete_gsl_sum_levin_utrunc_workspace($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::Sum;


@EXPORT_OK = qw/
               gsl_sum_levin_u_alloc 
               gsl_sum_levin_u_free 
               gsl_sum_levin_u_accel 
               gsl_sum_levin_u_minmax 
               gsl_sum_levin_u_step 
               gsl_sum_levin_utrunc_alloc 
               gsl_sum_levin_utrunc_free 
               gsl_sum_levin_utrunc_accel 
               gsl_sum_levin_utrunc_minmax 
               gsl_sum_levin_utrunc_step 
             /;
%EXPORT_TAGS = ( all => \@EXPORT_OK );

__END__

=head1 NAME

Math::GSL::Sum - Functions to accelerate the convergence of a series using the Levin u-transform.

=head1 SYNOPSIS

    use Math::GSL::Sum qw/:all/;

    my $w = gsl_sum_levin_u_alloc(5);
    $values = [8,2,3,4,6];
    my ($status, $sum_accel, $abserr) = gsl_sum_levin_u_accel($values, 5, $w); 
    gsl_sum_levin_u_free($w);

    my $w2 = gsl_sum_levin_utrunc_alloc(5);
    my ($status2, $sum_accel2, $abserr_trunc) = gsl_sum_levin_utrunc_accel($values, 5, $w2);
    gsl_sum_levin_utrunc_free($w);

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over

=item * gsl_sum_levin_u_alloc($n) - This function allocates a workspace for a Levin u-transform of $n terms.

=item * gsl_sum_levin_u_free($w) - This function frees the memory associated with the workspace $w. 

=item * gsl_sum_levin_u_accel($array, $array_size, $w) - This function takes the terms of a series in the array reference $array of size $array_size and computes the extrapolated limit of the series using a Levin u-transform. Additional working space must be provided in $w. The function returns multiple values in this order : 0 if the operation succeeded, 1 otherwise, the extrapolated sum and an estimate of the absolute error. The actual term-by-term sum is returned in $w->{sum_plain}. The algorithm calculates the truncation error (the difference between two successive extrapolations) and round-off error (propagated from the individual terms) to choose an optimal number of terms for the extrapolation. All the terms of the series passed in through array should be non-zero. 

=item * gsl_sum_levin_u_minmax 

=item * gsl_sum_levin_u_step 

=item * gsl_sum_levin_utrunc_alloc($n) - This function allocates a workspace for a Levin u-transform of $n terms, without error estimation. 

=item * gsl_sum_levin_utrunc_free($w) - This function frees the memory associated with the workspace $w. 

=item * gsl_sum_levin_utrunc_accel($array, $array_size, $w) - This function takes the terms of a series in the array reference $array of size $array_size and computes the extrapolated limit of the series using a Levin u-transform. Additional working space must be provided in $w. The function returns multiple values in this order : 0 if the operation succeeded, 1 otherwise, the extrapolated sum and an estimate of the error. The actual term-by-term sum is returned in $w->{sum_plain}. The algorithm terminates when the difference between two successive extrapolations reaches a minimum or is sufficiently small. To improve the reliability of the algorithm the extrapolated values are replaced by moving averages when calculating the truncation error, smoothing out any fluctuations.

=item * gsl_sum_levin_utrunc_minmax 

=item * gsl_sum_levin_utrunc_step 

=back

=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1;
