#include "EXTERN.h"
#include "perl.h"
#include <pdfio.h> 

SV *
new_rect(char * name, int name_len, double x1, double y1, double x2, double y2) {
		dSP; 
		SV * rect;

		char *rect_pkg = malloc(name_len + 7);
		sprintf(rect_pkg, "%s::Rect", name);
		SV * pkg = newSVpv(rect_pkg, strlen(rect_pkg));
		char *method = malloc(name_len + 12);
		sprintf(method, "%s::Rect::new", name);
		
		ENTER;
		SAVETMPS;

		PUSHMARK(SP);
		XPUSHs(newSVpv(rect_pkg, name_len + 7));
		XPUSHs(newSVnv(x1));
		XPUSHs(newSVnv(y1));
		XPUSHs(newSVnv(x2));
		XPUSHs(newSVnv(y2));
		PUTBACK;
		call_pv(method, G_SCALAR | G_EVAL);
		SPAGAIN;

		if (SvTRUE(ERRSV)) {
			LEAVE;
			PUTBACK;
			croak("%s", SvPV_nolen(ERRSV));
		}

		rect = POPs;
		SvREFCNT_inc(rect);
		PUTBACK;
		FREETMPS;
		LEAVE;

		return rect;
}

pdfio_rect_t rect_to_pdfio_rect(SV * rect_sv) {
	dTHX;
	if (!SvROK(rect_sv) || SvTYPE(SvRV(rect_sv)) != SVt_PVHV) {
		croak("rect must be a PDFio::Architect::Rect object");
	}

	HV * rect_hash = (HV*)SvRV(rect_sv);
	SV *x1_sv = *hv_fetch(rect_hash, "x1", 2, 0);
	SV *y1_sv = *hv_fetch(rect_hash, "y1", 2, 0);
	SV *x2_sv = *hv_fetch(rect_hash, "x2", 2, 0);
	SV *y2_sv = *hv_fetch(rect_hash, "y2", 2, 0);

	pdfio_rect_t rect;
	rect.x1 = SvNV(x1_sv);
	rect.y1 = SvNV(y1_sv);
	rect.x2 = SvNV(x2_sv);
	rect.y2 = SvNV(y2_sv);

	return rect;
}