/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HTMLTestResults {
    private final String result;
    private final String totalTime;
    private final String numTestPasses;
    private final String numTestFailures;
    private final String numCommandPasses;
    private final String numCommandFailures;
    private final String numCommandErrors;
    private final String suite;
    private static final String SUMMARY_HTML = "<html><body>\n<h1>Test suite results </h1>\n\n<table>\n<tr>\n<td>result:</td>\n<td>{0}</td>\n</tr>\n<tr>\n<td>totalTime:</td>\n<td>{1}</td>\n</tr>\n<tr>\n<td>numTestPasses:</td>\n<td>{2}</td>\n</tr>\n<tr>\n<td>numTestFailures:</td>\n<td>{3}</td>\n</tr>\n<tr>\n<td>numCommandPasses:</td>\n<td>{4}</td>\n</tr>\n<tr>\n<td>numCommandFailures:</td>\n<td>{5}</td>\n</tr>\n<tr>\n<td>numCommandErrors:</td>\n<td>{6}</td>\n</tr>\n<tr>\n<td>{7}</td>\n<td>&nbsp;</td>\n</tr>";
    private static final String SUITE_HTML = "<tr>\n<td>{0}</td>\n<td>&nbsp;</td>\n</tr>";
    private final List testTables;

    public HTMLTestResults(String postedResult, String postedTotalTime, String postedNumTestPasses, String postedNumTestFailures, String postedNumCommandPasses, String postedNumCommandFailures, String postedNumCommandErrors, String postedSuite, List postedTestTables) {
        this.result = postedResult;
        this.numCommandFailures = postedNumCommandFailures;
        this.numCommandErrors = postedNumCommandErrors;
        this.suite = postedSuite;
        this.totalTime = postedTotalTime;
        this.numTestPasses = postedNumTestPasses;
        this.numTestFailures = postedNumTestFailures;
        this.numCommandPasses = postedNumCommandPasses;
        this.testTables = postedTestTables;
    }

    public List getTestNames() {
        LinkedList<String> testNames = new LinkedList<String>();
        int testStartIndex = 0;
        int testEndIndex = 0;
        while (this.suite.indexOf(".html\">", testEndIndex) != -1) {
            testStartIndex = this.suite.indexOf(".html\">", testEndIndex) + 7;
            testEndIndex = this.suite.indexOf("</a>", testStartIndex);
            String testName = this.suite.substring(testStartIndex, testEndIndex);
            testNames.add(testName);
        }
        return testNames;
    }

    public String getDecodedTestSuite() {
        return new UrlDecoder().decode(this.suite);
    }

    public List getDecodedTestTables() {
        return new UrlDecoder().decodeListOfStrings(this.testTables);
    }

    public String getResult() {
        return this.result;
    }

    public String getNumCommandErrors() {
        return this.numCommandErrors;
    }

    public String getNumCommandFailures() {
        return this.numCommandFailures;
    }

    public String getNumCommandPasses() {
        return this.numCommandPasses;
    }

    public String getNumTestFailures() {
        return this.numTestFailures;
    }

    public String getNumTestPasses() {
        return this.numTestPasses;
    }

    public String getSuite() {
        return this.suite;
    }

    public Collection getTestTables() {
        return this.testTables;
    }

    public String getTotalTime() {
        return this.totalTime;
    }

    public int getNumTotalTests() {
        return Integer.parseInt(this.numTestPasses) + Integer.parseInt(this.numTestFailures);
    }

    public void write(Writer out) throws IOException {
        Object[] parameters = new Object[]{this.result, this.totalTime, this.numTestPasses, this.numTestFailures, this.numCommandPasses, this.numCommandFailures, this.numCommandErrors, this.suite};
        out.write(MessageFormat.format(SUMMARY_HTML, parameters));
        parameters = new Object[1];
        Iterator i = this.testTables.iterator();
        while (i.hasNext()) {
            String table = (String)i.next();
            parameters[0] = table;
            out.write(MessageFormat.format(SUITE_HTML, parameters));
        }
        out.write("</table></body></html>");
        out.flush();
    }

    class UrlDecoder {
        UrlDecoder() {
        }

        public String decode(String string) {
            try {
                return URLDecoder.decode(string, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException e) {
                return string;
            }
        }

        public List decodeListOfStrings(List list) {
            LinkedList<String> decodedList = new LinkedList<String>();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                decodedList.add(this.decode((String)i.next()));
            }
            return decodedList;
        }
    }
}

