#!/bin/bash

. "$(dirname "$0")"/config.sh

start='env PML_COMPILE=2' # this command can be changed to something that
                          # paralelizes jobs

# Usage: 
#
#  layer1_name=( <flags> )
#  layer2_name=( <flags> )

#  pml_to_db layer1_name $data_dir/your/data/layer1_*.pml
#  pml_to_db layer2_name $data_dir/other/data/layer2_*.pml
#
# Flags provide information about PML references not provided by the
# PML Schema. All flags can be repeated multiple times.
#
#  --data-dir <data_dir_prefix>
#
#    Directory path to be stripped from data file paths when stored in the database.
#    Hint: strip the longest possible directory path that does not
#    make any filename ambiguous, e.g. if your treebank consists of files organized
#    as follows
#
#       /home/someuser/treebank/set[0-9]/file[0-9].pml
#
#    use --data-dir /home/someuser/treebank
#
#  -R <ref_schema_name> 
#
#    define schema used by a referred layer 
#
#  -r <member_type>=[<target_schema_name>:]<target_node_type>
#
#    define target type of a PML reference. If target_schema_name is ommitted,
#    the schema of the current layer is used
#
#  For example,
#
#   -r t-root/atree.rf=adata:a-root
#
#  means that the 'atree.rf' member of a type declared in the current
#  layer's schema as 't-root.type' (or 't-root') as a #PMLREF
#  reference is to be interpreted as a pointer to a layer with schema
#  name 'adata' to nodes of the type 'a-node.type' (or 'a-node').
#  
# Example (PDT 2.0):
#
#   adata=(
#      --data-dir $data_dir/full
#   )
#
#   valency_lexicon=(
#      --data-dir "$data_dir/vallex_pml"
#      -r problem/author=user
#      -r local_event/author=user
#      -r valency_lexicon/owner=user
#   )
#   tdata=(
#      --data-dir "$data_dir/full"
#      -R vallex_schema.xml
#      -R adata_schema.xml
#      -r t-node/val_frame.rf=valency_lexicon:v-frame
#      -r t-a/aux.rf=adata:a-node
#      -r t-a/lex.rf=adata:a-node
#      -r t-root/atree.rf=adata:a-root
#      -r t-node/coref_text.rf=t-node
#      -r t-node/coref_gram.rf=t-node
#      -r t-node/compl.rf=t-node
#   )
#
#   pml_to_db adata "$data_dir"/full/{tamw,amw}/train-*/*.a.gz &
#   pml_to_db valency_lexicon "$data_dir"/vallex_pml/vallex_*.pml &
#   pml_to_db tdata "$data_dir"/full/tamw/train-*/*.t.gz &
#
#   wait %1 %2 %3
#

