
package MyElements::AddCalendarEntry;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://tempuri2.org/' }

__PACKAGE__->__set_name('AddCalendarEntry');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %calendarName_of :ATTR(:get<calendarName>);
my %createData_of :ATTR(:get<createData>);
my %modifyData_of :ATTR(:get<modifyData>);

__PACKAGE__->_factory(
    [ qw(        calendarName
        createData
        modifyData

    ) ],
    {
        'calendarName' => \%calendarName_of,
        'createData' => \%createData_of,
        'modifyData' => \%modifyData_of,
    },
    {
        'calendarName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'createData' => 'MyTypes::CalendarCreateData',
        'modifyData' => 'MyTypes::CalendarModifyData',
    },
    {

        'calendarName' => 'calendarName',
        'createData' => 'createData',
        'modifyData' => 'modifyData',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::AddCalendarEntry

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
AddCalendarEntry from the namespace http://tempuri2.org/.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * calendarName

 $element->set_calendarName($data);
 $element->get_calendarName();




=back
=item * createData

 $element->set_createData($data);
 $element->get_createData();




=back
=item * modifyData

 $element->set_modifyData($data);
 $element->get_modifyData();




=back


=head1 METHODS

=head2 new

 my $element = MyElements::AddCalendarEntry->new($data);

Constructor. The following data structure may be passed to new():

 {
   calendarName =>  $some_value, # string
   createData =>  { # MyTypes::CalendarCreateData
   },
   modifyData =>  { # MyTypes::CalendarModifyData
     Description =>  $some_value, # string
     EventDate =>  $some_value, # dateTime
     EndDate =>  $some_value, # dateTime
     ReminderDate =>  $some_value, # dateTime
     ReminderTemplate =>  $some_value, # string
     FAllDayEvent =>  $some_value, # boolean
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

